import { Construct } from 'constructs';
export interface InstanceBotTags {
    readonly key: string;
    readonly value: string;
}
/**
 * Props for `Configuration` when Configuration is for Lex.
 */
export declare enum LexConfigurationRespondsTo {
    STANDARD_MESSAGES = "STANDARD_MESSAGES"
}
/**
 * Configuration for AppInstanceBot with Lex.
 */
export interface AppInstanceBotLexConfiguration {
    /**
     * Setting for when Lex is invoked.
     */
    readonly respondsTo: LexConfigurationRespondsTo;
    /**
     * Lex `BotAliasArn` from setup Lex Bot.
     */
    readonly lexBotAliasArn: string;
    /**
     * LocaleId to use.  This needs to match one of the localIds that BotAliasArn is configured with.
     */
    readonly localeId: string;
    /**
     * An optional welcome intent to trigger when the Bot is added to the channel.
     */
    readonly welcomeIntent?: string;
}
/**
 * Props for `Configuration`.
 */
export interface AppInstanceBotConfiguration {
    readonly lex: AppInstanceBotLexConfiguration;
}
/**
 * Props for `AppInstance`.
 */
export interface AppInstanceBotProps {
    /**
     * The name of the app instance.
     *
     * @default - None
     */
    readonly name?: string;
    /**
     * The name of the app instance.
     *
     * @default - None
     */
    readonly appInstanceArn: string;
    /**
     * The tags for the creation request.
     *
     * @default - None
     */
    readonly tags?: Array<InstanceBotTags>;
    /**
     * The metadata of the app instance. Limited to a 1KB string in UTF-8.
     *
     * @default - None
     */
    readonly metadata?: string;
    /**
     * The ClientRequestToken of the app instance.  This field is autopopulated if not provided.
     *
     * @default - None
     */
    readonly clientRequestToken?: string;
    /**
     * The configuration of the bot.  This field populates Lex settings.
     */
    readonly configuration: AppInstanceBotConfiguration;
}
export declare class MessagingAppInstanceBot extends Construct {
    readonly appInstanceBotArn: string;
    constructor(scope: Construct, id: string, props: AppInstanceBotProps);
}
