"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingAppInstanceBot = exports.LexConfigurationRespondsTo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const instanceBotValidator_1 = require("./instanceBotValidator");
const messagingCustomResources_1 = require("./messagingCustomResources");
/**
 * Props for `Configuration` when Configuration is for Lex.
 */
var LexConfigurationRespondsTo;
(function (LexConfigurationRespondsTo) {
    LexConfigurationRespondsTo["STANDARD_MESSAGES"] = "STANDARD_MESSAGES";
})(LexConfigurationRespondsTo = exports.LexConfigurationRespondsTo || (exports.LexConfigurationRespondsTo = {}));
class MessagingAppInstanceBot extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, metadata, clientRequestToken, appInstanceArn, tags, configuration, } = props;
        instanceBotValidator_1.instanceBotValidator(props);
        const appInstanceRequest = new messagingCustomResources_1.MessagingResources(this, 'MessagingAppInstance', {
            resourceType: 'AppInstanceBot',
            uid: uid,
            properties: {
                name: name || uid,
                metadata: metadata,
                clientRequestToken: clientRequestToken,
                appInstanceArn: appInstanceArn,
                tags: tags,
                configuration: {
                    lex: {
                        lexBotAliasArn: configuration.lex.lexBotAliasArn,
                        welcomeIntent: configuration.lex.welcomeIntent,
                        localeId: configuration.lex.localeId,
                        respondsTo: configuration.lex.respondsTo,
                    },
                },
            },
        });
        this.appInstanceBotArn =
            appInstanceRequest.messagingCustomResource.getAttString('appInstanceBot');
    }
}
exports.MessagingAppInstanceBot = MessagingAppInstanceBot;
_a = JSII_RTTI_SYMBOL_1;
MessagingAppInstanceBot[_a] = { fqn: "cdk-amazon-chime-resources.MessagingAppInstanceBot", version: "2.4.57" };
//# sourceMappingURL=data:application/json;base64,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