"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.instanceBotValidator = void 0;
var NAME = /^[\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*$/;
var CLIENTREQUESTTOKEN = /^[-_a-zA-Z0-9]*$/;
function instanceBotValidator(props) {
    if (props.name) {
        if (props.name.length < 1 || props.name.length > 256) {
            throw new Error('Name length must be >1 and <256');
        }
        if (!NAME.test(props.name)) {
            throw new Error('Invalid name.  Must fit pattern: [\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*');
        }
    }
    if (props.clientRequestToken) {
        if (props.clientRequestToken.length < 2 ||
            props.clientRequestToken.length > 64) {
            throw new Error('ClientRequestToken length must be >2 and <64');
        }
        if (!CLIENTREQUESTTOKEN.test(props.clientRequestToken)) {
            throw new Error('Invlaid Client Request Token.  Must fit pattern: [-_a-zA-Z0-9]*');
        }
    }
    return true;
}
exports.instanceBotValidator = instanceBotValidator;
//# sourceMappingURL=data:application/json;base64,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