import { CustomResource, ResourceProps } from 'aws-cdk-lib';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface MessagingResourceProps extends ResourceProps {
    readonly properties: {
        [propname: string]: any;
    };
    readonly resourceType: 'AppInstance' | 'ChannelFlow' | 'AppInstanceUser' | 'AppInstanceBot' | 'AppInstanceAdmin' | 'DataRetention' | 'StreamingConfig' | 'AppInstanceStreamingConfigurations';
    readonly uid: string;
}
export declare class MessagingResources extends Construct {
    readonly lambda: IFunction;
    readonly messagingCustomResource: CustomResource;
    constructor(scope: Construct, id: string, props: MessagingResourceProps);
    private ensureLambda;
}
