"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneAssociation = exports.PSTNResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const pstn_function_1 = require("../resources/pstn/pstn-function");
class PSTNResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const PSTNResourceProvider = new custom_resources_1.Provider(this, 'PSTNResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.pstnCustomResource = new aws_cdk_lib_1.CustomResource(this, 'pstnCustomResource', {
            serviceToken: PSTNResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        const constructName = 'PSTNResources';
        const existing = stack.node.tryFindChild(constructName);
        /* istanbul ignore next */
        if (existing) {
            return existing;
        }
        const pstnCustomResourceRole = new aws_iam_1.Role(this, 'pstnCustomResourceRole', {
            description: 'Amazon Chime PSTN Resources',
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:*VoiceProfileDomain*',
                                'kms:CreateGrant',
                                'kms:DescribeKey',
                                'chime:*MediaInsightsPipelineConfiguration*',
                                'chime:CreateSipRule',
                                'chime:DeleteSipRule',
                                'chime:UpdateSipRule',
                                'chime:GetSipRule',
                                'chime:CreateSipMediaApplication',
                                'chime:DeleteSipMediaApplication',
                                'chime:GetPhoneNumberOrder',
                                'chime:SearchAvailablePhoneNumbers',
                                'chime:CreatePhoneNumberOrder',
                                'chime:DeletePhoneNumber',
                                'chime:GetPhoneNumber',
                                'chime:CreateVoiceConnector',
                                'chime:PutVoiceConnectorStreamingConfiguration',
                                'chime:PutVoiceConnectorTermination',
                                'chime:PutVoiceConnectorOrigination',
                                'chime:PutVoiceConnectorLoggingConfiguration',
                                'chime:ListPhoneNumbers',
                                'chime:AssociatePhoneNumbersWithVoiceConnector',
                                'chime:DisassociatePhoneNumbersFromVoiceConnector',
                                'chime:DeleteVoiceConnector',
                                'chime:PutSipMediaApplicationAlexaSkillConfiguration',
                                'chime:PutSipMediaApplicationLoggingConfiguration',
                                'logs:GetLogDelivery',
                                'logs:DeleteLogDelivery',
                                'logs:ListLogDeliveries',
                                'logs:CreateLogGroup',
                                'logs:DescribeResourcePolicies',
                                'logs:PutResourcePolicy',
                                'logs:DescribeLogGroups',
                                'logs:CreateLogDelivery',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                                'kms:CreateGrant',
                                'kms:DescribeKey',
                            ],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new pstn_function_1.PstnFunction(this, 'pstnResourcesFunction', {
            role: pstnCustomResourceRole,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        // const fn = new Function(this, 'pstnResourcesFunction', {
        //   runtime: Runtime.NODEJS_18_X,
        //   architecture: Architecture.ARM_64,
        //   role: pstnCustomResourceRole,
        //   timeout: Duration.seconds(60),
        //   handler: 'index.handler',
        //   code: Code.fromAsset(path.join(__dirname, '../../src/resources/pstn')),
        // });
        return fn;
    }
}
exports.PSTNResources = PSTNResources;
_a = JSII_RTTI_SYMBOL_1;
PSTNResources[_a] = { fqn: "cdk-amazon-chime-resources.PSTNResources", version: "2.4.57" };
class PhoneAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.phoneAssociationResource = new custom_resources_1.AwsCustomResource(this, 'phoneAssociation', {
            onCreate: {
                service: 'Chime',
                action: 'associatePhoneNumbersWithVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                    ForceAssociate: true,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(aws_cdk_lib_1.Names.uniqueId(this)),
            },
            onDelete: {
                service: 'Chime',
                action: 'disassociatePhoneNumbersFromVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(aws_cdk_lib_1.Names.uniqueId(this)),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.PhoneAssociation = PhoneAssociation;
_b = JSII_RTTI_SYMBOL_1;
PhoneAssociation[_b] = { fqn: "cdk-amazon-chime-resources.PhoneAssociation", version: "2.4.57" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHN0bkN1c3RvbVJlc291cmNlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9wc3RuL3BzdG5DdXN0b21SZXNvdXJjZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw4Q0FBOEM7QUFDOUMsNkNBTXFCO0FBQ3JCLGlEQU02QjtBQVE3QixtRUFLc0M7QUFDdEMsMkNBQXVDO0FBQ3ZDLG1FQUErRDtBQWdCL0QsTUFBYSxhQUFjLFNBQVEsc0JBQVM7SUFJMUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QjtRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBRWxDLE1BQU0sb0JBQW9CLEdBQUcsSUFBSSwyQkFBUSxDQUFDLElBQUksRUFBRSxzQkFBc0IsRUFBRTtZQUN0RSxjQUFjLEVBQUUsSUFBSSxDQUFDLE1BQU07U0FDNUIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGtCQUFrQixHQUFHLElBQUksNEJBQWMsQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLEVBQUU7WUFDdkUsWUFBWSxFQUFFLG9CQUFvQixDQUFDLFlBQVk7WUFDL0MsVUFBVSxFQUFFLEVBQUUsR0FBRyxLQUFLLEVBQUU7U0FDekIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVPLFlBQVk7UUFDbEIsTUFBTSxLQUFLLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDN0IsTUFBTSxhQUFhLEdBQUcsZUFBZSxDQUFDO1FBQ3RDLE1BQU0sUUFBUSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3hELDBCQUEwQjtRQUMxQixJQUFJLFFBQVEsRUFBRTtZQUNaLE9BQU8sUUFBb0IsQ0FBQztTQUM3QjtRQUVELE1BQU0sc0JBQXNCLEdBQUcsSUFBSSxjQUFJLENBQUMsSUFBSSxFQUFFLHdCQUF3QixFQUFFO1lBQ3RFLFdBQVcsRUFBRSw2QkFBNkI7WUFDMUMsU0FBUyxFQUFFLElBQUksMEJBQWdCLENBQUMsc0JBQXNCLENBQUM7WUFDdkQsY0FBYyxFQUFFO2dCQUNkLENBQUMsYUFBYSxDQUFDLEVBQUUsSUFBSSx3QkFBYyxDQUFDO29CQUNsQyxVQUFVLEVBQUU7d0JBQ1YsSUFBSSx5QkFBZSxDQUFDOzRCQUNsQixTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7NEJBQ2hCLE9BQU8sRUFBRTtnQ0FDUCw0QkFBNEI7Z0NBQzVCLGlCQUFpQjtnQ0FDakIsaUJBQWlCO2dDQUNqQiw0Q0FBNEM7Z0NBQzVDLHFCQUFxQjtnQ0FDckIscUJBQXFCO2dDQUNyQixxQkFBcUI7Z0NBQ3JCLGtCQUFrQjtnQ0FDbEIsaUNBQWlDO2dDQUNqQyxpQ0FBaUM7Z0NBQ2pDLDJCQUEyQjtnQ0FDM0IsbUNBQW1DO2dDQUNuQyw4QkFBOEI7Z0NBQzlCLHlCQUF5QjtnQ0FDekIsc0JBQXNCO2dDQUN0Qiw0QkFBNEI7Z0NBQzVCLCtDQUErQztnQ0FDL0Msb0NBQW9DO2dDQUNwQyxvQ0FBb0M7Z0NBQ3BDLDZDQUE2QztnQ0FDN0Msd0JBQXdCO2dDQUN4QiwrQ0FBK0M7Z0NBQy9DLGtEQUFrRDtnQ0FDbEQsNEJBQTRCO2dDQUM1QixxREFBcUQ7Z0NBQ3JELGtEQUFrRDtnQ0FDbEQscUJBQXFCO2dDQUNyQix3QkFBd0I7Z0NBQ3hCLHdCQUF3QjtnQ0FDeEIscUJBQXFCO2dDQUNyQiwrQkFBK0I7Z0NBQy9CLHdCQUF3QjtnQ0FDeEIsd0JBQXdCO2dDQUN4Qix3QkFBd0I7Z0NBQ3hCLGtCQUFrQjtnQ0FDbEIsc0JBQXNCO2dDQUN0QixtQkFBbUI7Z0NBQ25CLDZCQUE2QjtnQ0FDN0IsaUJBQWlCO2dDQUNqQixpQkFBaUI7NkJBQ2xCO3lCQUNGLENBQUM7d0JBQ0YsSUFBSSx5QkFBZSxDQUFDOzRCQUNsQixTQUFTLEVBQUU7Z0NBQ1QsZUFBZSxLQUFLLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxPQUFPLG9CQUFvQjs2QkFDakU7NEJBQ0QsT0FBTyxFQUFFO2dDQUNQLGtCQUFrQjtnQ0FDbEIsa0JBQWtCO2dDQUNsQixxQkFBcUI7NkJBQ3RCO3lCQUNGLENBQUM7cUJBQ0g7aUJBQ0YsQ0FBQzthQUNIO1lBQ0QsZUFBZSxFQUFFO2dCQUNmLHVCQUFhLENBQUMsd0JBQXdCLENBQ3BDLDBDQUEwQyxDQUMzQzthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxFQUFFLEdBQUcsSUFBSSw0QkFBWSxDQUFDLElBQUksRUFBRSx1QkFBdUIsRUFBRTtZQUN6RCxJQUFJLEVBQUUsc0JBQXNCO1lBQzVCLE9BQU8sRUFBRSxzQkFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7U0FDOUIsQ0FBQyxDQUFDO1FBQ0gsMkRBQTJEO1FBQzNELGtDQUFrQztRQUNsQyx1Q0FBdUM7UUFDdkMsa0NBQWtDO1FBQ2xDLG1DQUFtQztRQUNuQyw4QkFBOEI7UUFDOUIsNEVBQTRFO1FBQzVFLE1BQU07UUFFTixPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7O0FBaEhILHNDQWlIQzs7O0FBTUQsTUFBYSxnQkFBaUIsU0FBUSxzQkFBUztJQUc3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLHdCQUF3QixHQUFHLElBQUksb0NBQWlCLENBQ25ELElBQUksRUFDSixrQkFBa0IsRUFDbEI7WUFDRSxRQUFRLEVBQUU7Z0JBQ1IsT0FBTyxFQUFFLE9BQU87Z0JBQ2hCLE1BQU0sRUFBRSx5Q0FBeUM7Z0JBQ2pELE1BQU0sRUFBRSxXQUFXO2dCQUNuQixVQUFVLEVBQUU7b0JBQ1YsZ0JBQWdCLEVBQUUsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDO29CQUN6QyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO29CQUN4QyxjQUFjLEVBQUUsSUFBSTtpQkFDckI7Z0JBQ0Qsa0JBQWtCLEVBQUUscUNBQWtCLENBQUMsRUFBRSxDQUFDLG1CQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ2hFO1lBQ0QsUUFBUSxFQUFFO2dCQUNSLE9BQU8sRUFBRSxPQUFPO2dCQUNoQixNQUFNLEVBQUUsNENBQTRDO2dCQUNwRCxNQUFNLEVBQUUsV0FBVztnQkFDbkIsVUFBVSxFQUFFO29CQUNWLGdCQUFnQixFQUFFLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQztvQkFDekMsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtpQkFDekM7Z0JBQ0Qsa0JBQWtCLEVBQUUscUNBQWtCLENBQUMsRUFBRSxDQUFDLG1CQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ2hFO1lBQ0QsTUFBTSxFQUFFLDBDQUF1QixDQUFDLFlBQVksQ0FBQztnQkFDM0MsU0FBUyxFQUFFLDBDQUF1QixDQUFDLFlBQVk7YUFDaEQsQ0FBQztTQUNILENBQ0YsQ0FBQztJQUNKLENBQUM7O0FBcENILDRDQXFDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIEB0eXBlc2NyaXB0LWVzbGludC9pbmRlbnQgKi9cbmltcG9ydCB7XG4gIER1cmF0aW9uLFxuICBDdXN0b21SZXNvdXJjZSxcbiAgUmVzb3VyY2VQcm9wcyxcbiAgU3RhY2ssXG4gIE5hbWVzLFxufSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQge1xuICBTZXJ2aWNlUHJpbmNpcGFsLFxuICBSb2xlLFxuICBNYW5hZ2VkUG9saWN5LFxuICBQb2xpY3lEb2N1bWVudCxcbiAgUG9saWN5U3RhdGVtZW50LFxufSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7XG4gIC8vIEFyY2hpdGVjdHVyZSxcbiAgLy8gUnVudGltZSxcbiAgSUZ1bmN0aW9uLFxuICBGdW5jdGlvbixcbiAgLy8gQ29kZSxcbn0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQge1xuICBBd3NDdXN0b21SZXNvdXJjZSxcbiAgQXdzQ3VzdG9tUmVzb3VyY2VQb2xpY3ksXG4gIFBoeXNpY2FsUmVzb3VyY2VJZCxcbiAgUHJvdmlkZXIsXG59IGZyb20gJ2F3cy1jZGstbGliL2N1c3RvbS1yZXNvdXJjZXMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBQc3RuRnVuY3Rpb24gfSBmcm9tICcuLi9yZXNvdXJjZXMvcHN0bi9wc3RuLWZ1bmN0aW9uJztcblxuZXhwb3J0IGludGVyZmFjZSBQU1ROUmVzb3VyY2VQcm9wcyBleHRlbmRzIFJlc291cmNlUHJvcHMge1xuICByZWFkb25seSBwcm9wZXJ0aWVzOiB7IFtwcm9wbmFtZTogc3RyaW5nXTogYW55IH07XG4gIHJlYWRvbmx5IHJlc291cmNlVHlwZTpcbiAgICB8ICdQaG9uZU51bWJlcidcbiAgICB8ICdWb2ljZUNvbm5lY3RvcidcbiAgICB8ICdTTUEnXG4gICAgfCAnU01BTG9nZ2luZydcbiAgICB8ICdTTUFBbGV4YVNraWxsJ1xuICAgIHwgJ1NNQVJ1bGUnXG4gICAgfCAnUGhvbmVBc3NvY2lhdGlvbidcbiAgICB8ICdWb2ljZVByb2ZpbGVEb21haW4nO1xuICByZWFkb25seSB1aWQ6IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIFBTVE5SZXNvdXJjZXMgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgbGFtYmRhOiBJRnVuY3Rpb247XG4gIHB1YmxpYyByZWFkb25seSBwc3RuQ3VzdG9tUmVzb3VyY2U6IEN1c3RvbVJlc291cmNlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBQU1ROUmVzb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgdGhpcy5sYW1iZGEgPSB0aGlzLmVuc3VyZUxhbWJkYSgpO1xuXG4gICAgY29uc3QgUFNUTlJlc291cmNlUHJvdmlkZXIgPSBuZXcgUHJvdmlkZXIodGhpcywgJ1BTVE5SZXNvdXJjZVByb3ZpZGVyJywge1xuICAgICAgb25FdmVudEhhbmRsZXI6IHRoaXMubGFtYmRhLFxuICAgIH0pO1xuXG4gICAgdGhpcy5wc3RuQ3VzdG9tUmVzb3VyY2UgPSBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ3BzdG5DdXN0b21SZXNvdXJjZScsIHtcbiAgICAgIHNlcnZpY2VUb2tlbjogUFNUTlJlc291cmNlUHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgcHJvcGVydGllczogeyAuLi5wcm9wcyB9LFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBlbnN1cmVMYW1iZGEoKTogRnVuY3Rpb24ge1xuICAgIGNvbnN0IHN0YWNrID0gU3RhY2sub2YodGhpcyk7XG4gICAgY29uc3QgY29uc3RydWN0TmFtZSA9ICdQU1ROUmVzb3VyY2VzJztcbiAgICBjb25zdCBleGlzdGluZyA9IHN0YWNrLm5vZGUudHJ5RmluZENoaWxkKGNvbnN0cnVjdE5hbWUpO1xuICAgIC8qIGlzdGFuYnVsIGlnbm9yZSBuZXh0ICovXG4gICAgaWYgKGV4aXN0aW5nKSB7XG4gICAgICByZXR1cm4gZXhpc3RpbmcgYXMgRnVuY3Rpb247XG4gICAgfVxuXG4gICAgY29uc3QgcHN0bkN1c3RvbVJlc291cmNlUm9sZSA9IG5ldyBSb2xlKHRoaXMsICdwc3RuQ3VzdG9tUmVzb3VyY2VSb2xlJywge1xuICAgICAgZGVzY3JpcHRpb246ICdBbWF6b24gQ2hpbWUgUFNUTiBSZXNvdXJjZXMnLFxuICAgICAgYXNzdW1lZEJ5OiBuZXcgU2VydmljZVByaW5jaXBhbCgnbGFtYmRhLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgIGlubGluZVBvbGljaWVzOiB7XG4gICAgICAgIFsnY2hpbWVQb2xpY3knXTogbmV3IFBvbGljeURvY3VtZW50KHtcbiAgICAgICAgICBzdGF0ZW1lbnRzOiBbXG4gICAgICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgICAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgICAgICAgICdjaGltZToqVm9pY2VQcm9maWxlRG9tYWluKicsXG4gICAgICAgICAgICAgICAgJ2ttczpDcmVhdGVHcmFudCcsXG4gICAgICAgICAgICAgICAgJ2ttczpEZXNjcmliZUtleScsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOipNZWRpYUluc2lnaHRzUGlwZWxpbmVDb25maWd1cmF0aW9uKicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkNyZWF0ZVNpcFJ1bGUnLFxuICAgICAgICAgICAgICAgICdjaGltZTpEZWxldGVTaXBSdWxlJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6VXBkYXRlU2lwUnVsZScsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkdldFNpcFJ1bGUnLFxuICAgICAgICAgICAgICAgICdjaGltZTpDcmVhdGVTaXBNZWRpYUFwcGxpY2F0aW9uJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6RGVsZXRlU2lwTWVkaWFBcHBsaWNhdGlvbicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkdldFBob25lTnVtYmVyT3JkZXInLFxuICAgICAgICAgICAgICAgICdjaGltZTpTZWFyY2hBdmFpbGFibGVQaG9uZU51bWJlcnMnLFxuICAgICAgICAgICAgICAgICdjaGltZTpDcmVhdGVQaG9uZU51bWJlck9yZGVyJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6RGVsZXRlUGhvbmVOdW1iZXInLFxuICAgICAgICAgICAgICAgICdjaGltZTpHZXRQaG9uZU51bWJlcicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkNyZWF0ZVZvaWNlQ29ubmVjdG9yJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6UHV0Vm9pY2VDb25uZWN0b3JTdHJlYW1pbmdDb25maWd1cmF0aW9uJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6UHV0Vm9pY2VDb25uZWN0b3JUZXJtaW5hdGlvbicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOlB1dFZvaWNlQ29ubmVjdG9yT3JpZ2luYXRpb24nLFxuICAgICAgICAgICAgICAgICdjaGltZTpQdXRWb2ljZUNvbm5lY3RvckxvZ2dpbmdDb25maWd1cmF0aW9uJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6TGlzdFBob25lTnVtYmVycycsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkFzc29jaWF0ZVBob25lTnVtYmVyc1dpdGhWb2ljZUNvbm5lY3RvcicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkRpc2Fzc29jaWF0ZVBob25lTnVtYmVyc0Zyb21Wb2ljZUNvbm5lY3RvcicsXG4gICAgICAgICAgICAgICAgJ2NoaW1lOkRlbGV0ZVZvaWNlQ29ubmVjdG9yJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6UHV0U2lwTWVkaWFBcHBsaWNhdGlvbkFsZXhhU2tpbGxDb25maWd1cmF0aW9uJyxcbiAgICAgICAgICAgICAgICAnY2hpbWU6UHV0U2lwTWVkaWFBcHBsaWNhdGlvbkxvZ2dpbmdDb25maWd1cmF0aW9uJyxcbiAgICAgICAgICAgICAgICAnbG9nczpHZXRMb2dEZWxpdmVyeScsXG4gICAgICAgICAgICAgICAgJ2xvZ3M6RGVsZXRlTG9nRGVsaXZlcnknLFxuICAgICAgICAgICAgICAgICdsb2dzOkxpc3RMb2dEZWxpdmVyaWVzJyxcbiAgICAgICAgICAgICAgICAnbG9nczpDcmVhdGVMb2dHcm91cCcsXG4gICAgICAgICAgICAgICAgJ2xvZ3M6RGVzY3JpYmVSZXNvdXJjZVBvbGljaWVzJyxcbiAgICAgICAgICAgICAgICAnbG9nczpQdXRSZXNvdXJjZVBvbGljeScsXG4gICAgICAgICAgICAgICAgJ2xvZ3M6RGVzY3JpYmVMb2dHcm91cHMnLFxuICAgICAgICAgICAgICAgICdsb2dzOkNyZWF0ZUxvZ0RlbGl2ZXJ5JyxcbiAgICAgICAgICAgICAgICAnbGFtYmRhOkdldFBvbGljeScsXG4gICAgICAgICAgICAgICAgJ2xhbWJkYTpBZGRQZXJtaXNzaW9uJyxcbiAgICAgICAgICAgICAgICAnaWFtOlB1dFJvbGVQb2xpY3knLFxuICAgICAgICAgICAgICAgICdpYW06Q3JlYXRlU2VydmljZUxpbmtlZFJvbGUnLFxuICAgICAgICAgICAgICAgICdrbXM6Q3JlYXRlR3JhbnQnLFxuICAgICAgICAgICAgICAgICdrbXM6RGVzY3JpYmVLZXknLFxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgICAgICAgYGFybjphd3M6c3NtOiR7c3RhY2sucmVnaW9ufToke3N0YWNrLmFjY291bnR9OnBhcmFtZXRlci9jaGltZS8qYCxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgICAgICAgICdzc206UHV0UGFyYW1ldGVyJyxcbiAgICAgICAgICAgICAgICAnc3NtOkdldFBhcmFtZXRlcicsXG4gICAgICAgICAgICAgICAgJ3NzbTpEZWxldGVQYXJhbWV0ZXInLFxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgXSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgICAgbWFuYWdlZFBvbGljaWVzOiBbXG4gICAgICAgIE1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKFxuICAgICAgICAgICdzZXJ2aWNlLXJvbGUvQVdTTGFtYmRhQmFzaWNFeGVjdXRpb25Sb2xlJyxcbiAgICAgICAgKSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBjb25zdCBmbiA9IG5ldyBQc3RuRnVuY3Rpb24odGhpcywgJ3BzdG5SZXNvdXJjZXNGdW5jdGlvbicsIHtcbiAgICAgIHJvbGU6IHBzdG5DdXN0b21SZXNvdXJjZVJvbGUsXG4gICAgICB0aW1lb3V0OiBEdXJhdGlvbi5zZWNvbmRzKDYwKSxcbiAgICB9KTtcbiAgICAvLyBjb25zdCBmbiA9IG5ldyBGdW5jdGlvbih0aGlzLCAncHN0blJlc291cmNlc0Z1bmN0aW9uJywge1xuICAgIC8vICAgcnVudGltZTogUnVudGltZS5OT0RFSlNfMThfWCxcbiAgICAvLyAgIGFyY2hpdGVjdHVyZTogQXJjaGl0ZWN0dXJlLkFSTV82NCxcbiAgICAvLyAgIHJvbGU6IHBzdG5DdXN0b21SZXNvdXJjZVJvbGUsXG4gICAgLy8gICB0aW1lb3V0OiBEdXJhdGlvbi5zZWNvbmRzKDYwKSxcbiAgICAvLyAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAvLyAgIGNvZGU6IENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICcuLi8uLi9zcmMvcmVzb3VyY2VzL3BzdG4nKSksXG4gICAgLy8gfSk7XG5cbiAgICByZXR1cm4gZm47XG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBQaG9uZUFzc29jaWF0aW9uUHJvcHMgZXh0ZW5kcyBSZXNvdXJjZVByb3BzIHtcbiAgcmVhZG9ubHkgdm9pY2VDb25uZWN0b3JJZDogc3RyaW5nO1xuICByZWFkb25seSBlMTY0UGhvbmVOdW1iZXI6IHN0cmluZztcbn1cbmV4cG9ydCBjbGFzcyBQaG9uZUFzc29jaWF0aW9uIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHBob25lQXNzb2NpYXRpb25SZXNvdXJjZTogQXdzQ3VzdG9tUmVzb3VyY2U7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFBob25lQXNzb2NpYXRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnBob25lQXNzb2NpYXRpb25SZXNvdXJjZSA9IG5ldyBBd3NDdXN0b21SZXNvdXJjZShcbiAgICAgIHRoaXMsXG4gICAgICAncGhvbmVBc3NvY2lhdGlvbicsXG4gICAgICB7XG4gICAgICAgIG9uQ3JlYXRlOiB7XG4gICAgICAgICAgc2VydmljZTogJ0NoaW1lJyxcbiAgICAgICAgICBhY3Rpb246ICdhc3NvY2lhdGVQaG9uZU51bWJlcnNXaXRoVm9pY2VDb25uZWN0b3InLFxuICAgICAgICAgIHJlZ2lvbjogJ3VzLWVhc3QtMScsXG4gICAgICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAgICAgRTE2NFBob25lTnVtYmVyczogW3Byb3BzLmUxNjRQaG9uZU51bWJlcl0sXG4gICAgICAgICAgICBWb2ljZUNvbm5lY3RvcklkOiBwcm9wcy52b2ljZUNvbm5lY3RvcklkLFxuICAgICAgICAgICAgRm9yY2VBc3NvY2lhdGU6IHRydWUsXG4gICAgICAgICAgfSxcbiAgICAgICAgICBwaHlzaWNhbFJlc291cmNlSWQ6IFBoeXNpY2FsUmVzb3VyY2VJZC5vZihOYW1lcy51bmlxdWVJZCh0aGlzKSksXG4gICAgICAgIH0sXG4gICAgICAgIG9uRGVsZXRlOiB7XG4gICAgICAgICAgc2VydmljZTogJ0NoaW1lJyxcbiAgICAgICAgICBhY3Rpb246ICdkaXNhc3NvY2lhdGVQaG9uZU51bWJlcnNGcm9tVm9pY2VDb25uZWN0b3InLFxuICAgICAgICAgIHJlZ2lvbjogJ3VzLWVhc3QtMScsXG4gICAgICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAgICAgRTE2NFBob25lTnVtYmVyczogW3Byb3BzLmUxNjRQaG9uZU51bWJlcl0sXG4gICAgICAgICAgICBWb2ljZUNvbm5lY3RvcklkOiBwcm9wcy52b2ljZUNvbm5lY3RvcklkLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgcGh5c2ljYWxSZXNvdXJjZUlkOiBQaHlzaWNhbFJlc291cmNlSWQub2YoTmFtZXMudW5pcXVlSWQodGhpcykpLFxuICAgICAgICB9LFxuICAgICAgICBwb2xpY3k6IEF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TZGtDYWxscyh7XG4gICAgICAgICAgcmVzb3VyY2VzOiBBd3NDdXN0b21SZXNvdXJjZVBvbGljeS5BTllfUkVTT1VSQ0UsXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICApO1xuICB9XG59XG4iXX0=