"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeVoiceProfileDomain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// import { Termination } from '@aws-sdk/client-chime-sdk-voice';
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
class ChimeVoiceProfileDomain extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, description, serverSideEncryptionConfiguration, clientRequestToken, tags, } = props;
        const voiceProfileDomainRequest = new pstnCustomResources_1.PSTNResources(this, 'voiceConnectorRequest', {
            resourceType: 'VoiceProfileDomain',
            uid: uid,
            properties: {
                name: name ?? uid,
                description: description,
                serverSideEncryptionConfiguration: serverSideEncryptionConfiguration,
                clientRequestToken: clientRequestToken,
                tags: tags,
            },
        });
        this.voiceProfileDomainId =
            voiceProfileDomainRequest.pstnCustomResource.getAttString('VoiceProfileDomainId');
        this.voiceProfileDomainArn =
            voiceProfileDomainRequest.pstnCustomResource.getAttString('VoiceProfileDomainArn');
        this.voiceProfileDomainName =
            voiceProfileDomainRequest.pstnCustomResource.getAttString('Name');
    }
}
exports.ChimeVoiceProfileDomain = ChimeVoiceProfileDomain;
_a = JSII_RTTI_SYMBOL_1;
ChimeVoiceProfileDomain[_a] = { fqn: "cdk-amazon-chime-resources.ChimeVoiceProfileDomain", version: "2.4.57" };
//# sourceMappingURL=data:application/json;base64,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