"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteMediaInsightsPipelineConfiguration = exports.UpdateMediaInsightsPipelineConfiguration = exports.CreateMediaInsightsPipelineConfiguration = void 0;
const client_chime_sdk_media_pipelines_1 = require("@aws-sdk/client-chime-sdk-media-pipelines");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
const chimeSDKMediaPipelineClient = new client_chime_sdk_media_pipelines_1.ChimeSDKMediaPipelinesClient({
    region: process.env.AWS_REGION,
});
function capitalizeKeys(obj) {
    if (Array.isArray(obj)) {
        return obj.map((item) => capitalizeKeys(item));
    }
    if (typeof obj === 'object') {
        const capitalizedObj = {};
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                const capitalizedKey = key.charAt(0).toUpperCase() + key.slice(1);
                const value = obj[key];
                capitalizedObj[capitalizedKey] =
                    typeof value === 'string' && !isNaN(parseFloat(value))
                        ? parseFloat(value)
                        : capitalizeKeys(value);
            }
        }
        return capitalizedObj;
    }
    return obj;
}
function capitalizeElementsKeys(elements) {
    return capitalizeKeys(elements);
}
let createMediaInsightsPipelineConfigurationResponse;
let createMediaInsightsPipelineConfigurationParams;
const formatProps = (props) => {
    let formattedElements = [];
    let formattedTags = [];
    let formattedRealTimeAlertConfiguration = {};
    let formattedRealTimeAlertRules = [];
    console.info(`Formatting Props: ${JSON.stringify(props)}`);
    if (props.elements) {
        console.info(`Formatting Elements: ${JSON.stringify(props.elements)}`);
        console.log(`Current formattedElements: ${formattedElements}`);
        props.elements.forEach((element) => {
            formattedElements.push(capitalizeElementsKeys(element));
        });
        console.info(`Formatted Elements: ${JSON.stringify(formattedElements)}`);
    }
    console.log(`New formattedElements: ${formattedElements}`);
    console.log(`Current formattedTags: ${formattedTags}`);
    if (props.tags) {
        console.info(`Formatting Tags: ${JSON.stringify(props.tags)}`);
        props.tags.forEach((tag) => {
            formattedTags.push(capitalizeKeys(tag));
        });
        console.info(`Formatted Tags: ${JSON.stringify(formattedTags)}`);
    }
    console.log(`New formattedTags: ${formattedTags}`);
    if (props.realTimeAlertConfiguration) {
        console.info(`Formatting Real Time Alert Configuration: ${JSON.stringify(props.realTimeAlertConfiguration)}`);
        props.realTimeAlertConfiguration.rules.forEach((rule) => {
            formattedRealTimeAlertRules.push(capitalizeKeys(rule));
        });
        formattedRealTimeAlertConfiguration = {
            Disabled: props.realTimeAlertConfiguration.disabled,
            Rules: formattedRealTimeAlertRules,
        };
        console.info(`Formatted Real Time Alert Configuration: ${JSON.stringify(formattedRealTimeAlertConfiguration)}`);
    }
    const mediaInsightsPipelineConfigurationParams = {
        ResourceAccessRoleArn: props.resourceAccessRoleArn,
        MediaInsightsPipelineConfigurationName: props.mediaInsightsPipelineConfigurationName,
        ...(props.tags && { Tags: formattedTags }),
        ...(props.clientRequestToken && {
            ClientRequestToken: props.clientRequestToken,
        }),
        ...(props.elements && {
            Elements: formattedElements,
        }),
        ...(props.realTimeAlertConfiguration && {
            RealTimeAlertConfiguration: formattedRealTimeAlertConfiguration,
        }),
    };
    console.info(`mediaInsightsPipelineConfigurationParams: ${JSON.stringify(mediaInsightsPipelineConfigurationParams)}`);
    return mediaInsightsPipelineConfigurationParams;
};
exports.CreateMediaInsightsPipelineConfiguration = async (uid, props) => {
    console.log(`Creating Media Insights Pipeline Configuration: ${uid}`);
    console.log(`Create Media Insights Pipeline Configuration props: ${JSON.stringify(props)}`);
    createMediaInsightsPipelineConfigurationParams = formatProps(props);
    console.log(`Create Media Insights Pipeline Configuration params: ${JSON.stringify(createMediaInsightsPipelineConfigurationParams)}`);
    try {
        createMediaInsightsPipelineConfigurationResponse =
            await chimeSDKMediaPipelineClient.send(new client_chime_sdk_media_pipelines_1.CreateMediaInsightsPipelineConfigurationCommand(createMediaInsightsPipelineConfigurationParams));
        console.log(`createMediaInsightsPipelineConfigurationResponse: ${JSON.stringify(createMediaInsightsPipelineConfigurationResponse)}`);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: '/chime/MediaInsightsPipelineConfigurationArn' + uid,
            Value: createMediaInsightsPipelineConfigurationResponse.MediaInsightsPipelineConfiguration
                .MediaInsightsPipelineConfigurationArn,
            Description: 'Media Insight Pipeline Configuration ARN' + uid,
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return createMediaInsightsPipelineConfigurationResponse.MediaInsightsPipelineConfiguration;
};
let updateMediaInsightsPipelineConfigurationParams;
let updateMediaInsightsPipelineConfigurationResponse;
let updateMediaInsightsPipelineIdentifier;
let getParameterCommandOutput;
exports.UpdateMediaInsightsPipelineConfiguration = async (uid, props) => {
    console.log(`Updating Media Insights Pipeline Configuration: ${uid}`);
    console.log(`Updating Media Insights Pipeline Configuration props: ${JSON.stringify(props)}`);
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({
            Name: '/chime/MediaInsightsPipelineConfigurationArn' + uid,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    updateMediaInsightsPipelineIdentifier =
        getParameterCommandOutput.Parameter.Value;
    updateMediaInsightsPipelineConfigurationParams = {
        ...formatProps(props),
        Identifier: updateMediaInsightsPipelineIdentifier,
    };
    console.log(`Update Media Insights Pipeline Configuration params: ${JSON.stringify(updateMediaInsightsPipelineConfigurationParams)}`);
    try {
        updateMediaInsightsPipelineConfigurationResponse =
            await chimeSDKMediaPipelineClient.send(new client_chime_sdk_media_pipelines_1.UpdateMediaInsightsPipelineConfigurationCommand(updateMediaInsightsPipelineConfigurationParams));
        console.log(`createMediaInsightsPipelineConfigurationResponse: ${JSON.stringify(createMediaInsightsPipelineConfigurationResponse)}`);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return updateMediaInsightsPipelineConfigurationResponse.MediaInsightsPipelineConfiguration;
};
let deleteMediaInsightsPipelineIdentifier;
exports.DeleteMediaInsightsPipelineConfiguration = async (uid) => {
    console.log(`Deleting Media Insights Pipeline Configuration: ${uid}`);
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({
            Name: '/chime/MediaInsightsPipelineConfigurationArn' + uid,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({
            Name: '/chime/MediaInsightsPipelineConfigurationArn' + uid,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    deleteMediaInsightsPipelineIdentifier =
        getParameterCommandOutput.Parameter.Value;
    console.info(`deleteMediaInsightsPipelineIdentifier: ${deleteMediaInsightsPipelineIdentifier}`);
    try {
        await chimeSDKMediaPipelineClient.send(new client_chime_sdk_media_pipelines_1.DeleteMediaInsightsPipelineConfigurationCommand({
            Identifier: deleteMediaInsightsPipelineIdentifier,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return;
};
//# sourceMappingURL=data:application/json;base64,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