"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteChannelFlow = exports.UpdateChannelFlow = exports.CreateChannelFlow = exports.FallbackAction = exports.InvocationType = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_messaging_1 = require("@aws-sdk/client-chime-sdk-messaging");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeSDKMessagingClient = new client_chime_sdk_messaging_1.ChimeSDKMessagingClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
var InvocationType;
(function (InvocationType) {
    InvocationType["ASYNC"] = "ASYNC";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
var FallbackAction;
(function (FallbackAction) {
    FallbackAction["CONTINUE"] = "CONTINUE";
    FallbackAction["ABORT"] = "ABORT";
})(FallbackAction = exports.FallbackAction || (exports.FallbackAction = {}));
exports.CreateChannelFlow = async (uid, props) => {
    try {
        const createChannelFlowCommandOutput = await chimeSDKMessagingClient.send(new client_chime_sdk_messaging_1.CreateChannelFlowCommand({
            AppInstanceArn: props.appInstanceArn,
            Name: props.name,
            ClientRequestToken: props.clientRequestToken,
            Tags: getUpdatedTags(props.tags),
            Processors: getUpdatedProcessors(props.processors),
        }));
        await saveChannelFlowArnToSsm(uid, createChannelFlowCommandOutput.ChannelFlowArn);
        return {
            channelFlowArn: createChannelFlowCommandOutput.ChannelFlowArn,
        };
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {};
};
exports.UpdateChannelFlow = async (uid, props) => {
    try {
        const channelFlowArn = await getExistingChannelFlowArnFromSsm(uid);
        const updateChannelFlowCommandOutput = await chimeSDKMessagingClient.send(new client_chime_sdk_messaging_1.UpdateChannelFlowCommand({
            ChannelFlowArn: channelFlowArn,
            Name: props.name,
            Processors: getUpdatedProcessors(props.processors),
        }));
        return {
            channelFlowArn: updateChannelFlowCommandOutput.ChannelFlowArn,
        };
    }
    catch (error) {
        console.error(error);
        throw error;
    }
};
exports.DeleteChannelFlow = async (uid) => {
    try {
        const channelFlowArn = await getExistingChannelFlowArnFromSsm(uid);
        await chimeSDKMessagingClient.send(new client_chime_sdk_messaging_1.DeleteChannelFlowCommand({
            ChannelFlowArn: channelFlowArn,
        }));
        await deleteChannelFlowArnFromSsm(uid);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
const saveChannelFlowArnToSsm = async (uid, channelFlowArn) => {
    return ssmClient.send(new client_ssm_1.PutParameterCommand({
        Name: `/chime/channelFlowArn/${uid}`,
        Description: 'channelFlowArn',
        Value: channelFlowArn,
        Overwrite: true,
        Type: 'String',
    }));
};
const getExistingChannelFlowArnFromSsm = async (uid) => {
    const getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: `/chime/channelFlowArn/${uid}` }));
    return getParameterCommandOutput.Parameter?.Value;
};
const deleteChannelFlowArnFromSsm = async (uid) => {
    return ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: `/chime/channelFlowArn/${uid}` }));
};
const getUpdatedProcessors = (processors) => {
    return processors?.map(getUpdatedProcessor) || [];
};
const getUpdatedProcessor = (processor) => {
    return {
        Name: processor.name,
        ExecutionOrder: parseInt(processor.executionOrder),
        FallbackAction: processor.fallbackAction,
        Configuration: {
            Lambda: {
                ResourceArn: processor.configuration.lambda.resourceArn,
                InvocationType: processor.configuration.lambda.invocationType,
            },
        },
    };
};
const getUpdatedTags = (tags) => {
    return tags?.map(getUpdatedTag);
};
const getUpdatedTag = (tag) => {
    return { Key: tag.key, Value: tag.value };
};
//# sourceMappingURL=data:application/json;base64,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