interface Tags {
    key: string;
    value: string;
}
/**
 * Props for `Configuration`.
 */
export interface AppInstanceBotConfiguration {
    readonly lex: AppInstanceBotLexConfiguration;
}
/**
 * Configuration for AppInstanceBot with Lex.
 */
export interface AppInstanceBotLexConfiguration {
    /**
     * Lex `BotAliasArn` from setup Lex Bot.
     */
    readonly lexBotAliasArn: string;
    /**
     * LocaleId to use.  This needs to match one of the localIds that BotAliasArn is configured with.
     */
    readonly localeId: string;
    /**
     * An optional welcome intent to trigger when the Bot is added to the channel.
     */
    readonly welcomeIntent?: string;
}
interface AppInstanceBotProps {
    name?: string;
    metadata?: string;
    clientRequestToken?: string;
    appInstanceArn?: string;
    tags?: Tags[];
    configuration?: AppInstanceBotConfiguration;
}
export declare const CreateAppInstanceBot: (uid: string, props: AppInstanceBotProps) => Promise<{
    appInstanceBot: string | undefined;
}>;
export declare const DeleteAppInstanceBot: (uid: string) => Promise<void>;
export {};
