"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAppInstanceBot = exports.CreateAppInstanceBot = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_identity_1 = require("@aws-sdk/client-chime-sdk-identity");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeClient = new client_chime_sdk_identity_1.ChimeSDKIdentityClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createAppInstanceBotCommandInput;
let createAppInstanceBotCommandOutput;
let updatedTags;
exports.CreateAppInstanceBot = async (uid, props) => {
    updatedTags = [];
    if (props.tags) {
        props.tags.forEach((tag) => {
            updatedTags.push({ Key: tag.key, Value: tag.value });
        });
    }
    createAppInstanceBotCommandInput = {
        Configuration: {
            Lex: {
                LexBotAliasArn: props.configuration?.lex?.lexBotAliasArn,
                LocaleId: props.configuration?.lex?.localeId,
                RespondsTo: 'STANDARD_MESSAGES',
                ...(props.configuration?.lex?.welcomeIntent && {
                    WelcomeIntent: props.configuration?.lex?.welcomeIntent,
                }),
            },
        },
        Name: props.name,
        AppInstanceArn: props.appInstanceArn,
        ...(props.metadata && { Metadata: props.metadata }),
        ...(props.clientRequestToken && {
            ClientRequestToken: props.clientRequestToken,
        }),
        ...(updatedTags.length > 0 && { Tags: updatedTags }),
    };
    try {
        createAppInstanceBotCommandOutput = await chimeClient.send(new client_chime_sdk_identity_1.CreateAppInstanceBotCommand(createAppInstanceBotCommandInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: `/chime/appInstanceBotId/${uid}`,
            Description: 'appInstanceBotId',
            Value: createAppInstanceBotCommandOutput.AppInstanceBotArn,
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        appInstanceBot: createAppInstanceBotCommandOutput.AppInstanceBotArn,
    };
};
exports.DeleteAppInstanceBot = async (uid) => {
    try {
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: `/chime/appInstanceBotId/${uid}` }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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