"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAppInstanceUser = exports.CreateAppInstanceUser = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_1 = require("@aws-sdk/client-chime");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeClient = new client_chime_1.ChimeClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createAppInstanceUserCommandInput;
let createAppInstanceUserCommandOutput;
let updatedTags;
exports.CreateAppInstanceUser = async (uid, props) => {
    updatedTags = [];
    if (props.tags) {
        props.tags.forEach((tag) => {
            updatedTags.push({ Key: tag.key, Value: tag.value });
        });
    }
    createAppInstanceUserCommandInput = {
        Name: props.name,
        AppInstanceArn: props.appInstanceArn,
        AppInstanceUserId: props.appInstanceUserId,
        ...(props.metadata && { Metadata: props.metadata }),
        ...(props.clientRequestToken && {
            ClientRequestToken: props.clientRequestToken,
        }),
        ...(updatedTags.length > 0 && { Tags: updatedTags }),
    };
    try {
        createAppInstanceUserCommandOutput = await chimeClient.send(new client_chime_1.CreateAppInstanceUserCommand(createAppInstanceUserCommandInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: `/chime/appInstanceUserId/${uid}`,
            Description: 'appInstanceUserId',
            Value: createAppInstanceUserCommandOutput.AppInstanceUserArn,
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        appInstanceUser: createAppInstanceUserCommandOutput.AppInstanceUserArn,
    };
};
exports.DeleteAppInstanceUser = async (uid) => {
    try {
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: `/chime/appInstanceUserId/${uid}` }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFuY2VVc2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3Jlc291cmNlcy9tZXNzYWdpbmcvaW5zdGFuY2VVc2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHNEQUFzRDtBQUN0RCx3REFNK0I7QUFFL0Isb0RBSTZCO0FBRTdCLE1BQU0sV0FBVyxHQUFHLElBQUksMEJBQVcsQ0FBQztJQUNsQyxNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxVQUFVO0NBQy9CLENBQUMsQ0FBQztBQUVILE1BQU0sU0FBUyxHQUFHLElBQUksc0JBQVMsQ0FBQyxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7QUFnQnBFLElBQUksaUNBQW9FLENBQUM7QUFDekUsSUFBSSxrQ0FBc0UsQ0FBQztBQUMzRSxJQUFJLFdBQWtCLENBQUM7QUFFVixRQUFBLHFCQUFxQixHQUFHLEtBQUssRUFDeEMsR0FBVyxFQUNYLEtBQTJCLEVBQzNCLEVBQUU7SUFDRixXQUFXLEdBQUcsRUFBRSxDQUFDO0lBQ2pCLElBQUksS0FBSyxDQUFDLElBQUksRUFBRTtRQUNkLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUU7WUFDekIsV0FBVyxDQUFDLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsR0FBRyxFQUFFLEtBQUssRUFBRSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUN2RCxDQUFDLENBQUMsQ0FBQztLQUNKO0lBRUQsaUNBQWlDLEdBQUc7UUFDbEMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1FBQ2hCLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztRQUNwQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1FBQzFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxJQUFJLEVBQUUsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUNuRCxHQUFHLENBQUMsS0FBSyxDQUFDLGtCQUFrQixJQUFJO1lBQzlCLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7U0FDN0MsQ0FBQztRQUNGLEdBQUcsQ0FBQyxXQUFXLENBQUMsTUFBTSxHQUFHLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxXQUFXLEVBQUUsQ0FBQztLQUNyRCxDQUFDO0lBRUYsSUFBSTtRQUNGLGtDQUFrQyxHQUFHLE1BQU0sV0FBVyxDQUFDLElBQUksQ0FDekQsSUFBSSwyQ0FBNEIsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUNwRSxDQUFDO0tBQ0g7SUFBQyxPQUFPLEtBQUssRUFBRTtRQUNkLElBQUksS0FBSyxZQUFZLEtBQUssRUFBRTtZQUMxQixPQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ3JCLE1BQU0sS0FBSyxDQUFDO1NBQ2I7S0FDRjtJQUVELElBQUk7UUFDRixNQUFNLFNBQVMsQ0FBQyxJQUFJLENBQ2xCLElBQUksZ0NBQW1CLENBQUM7WUFDdEIsSUFBSSxFQUFFLDRCQUE0QixHQUFHLEVBQUU7WUFDdkMsV0FBVyxFQUFFLG1CQUFtQjtZQUNoQyxLQUFLLEVBQUUsa0NBQWtDLENBQUMsa0JBQWtCO1lBQzVELFNBQVMsRUFBRSxJQUFJO1lBQ2YsSUFBSSxFQUFFLFFBQVE7U0FDZixDQUFDLENBQ0gsQ0FBQztLQUNIO0lBQUMsT0FBTyxLQUFLLEVBQUU7UUFDZCxJQUFJLEtBQUssWUFBWSxLQUFLLEVBQUU7WUFDMUIsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUNyQixNQUFNLEtBQUssQ0FBQztTQUNiO0tBQ0Y7SUFFRCxPQUFPO1FBQ0wsZUFBZSxFQUFFLGtDQUFrQyxDQUFDLGtCQUFrQjtLQUN2RSxDQUFDO0FBQ0osQ0FBQyxDQUFDO0FBRVcsUUFBQSxxQkFBcUIsR0FBRyxLQUFLLEVBQUUsR0FBVyxFQUFFLEVBQUU7SUFDekQsSUFBSTtRQUNGLE1BQU0sU0FBUyxDQUFDLElBQUksQ0FDbEIsSUFBSSxtQ0FBc0IsQ0FBQyxFQUFFLElBQUksRUFBRSw0QkFBNEIsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUN4RSxDQUFDO0tBQ0g7SUFBQyxPQUFPLEtBQUssRUFBRTtRQUNkLElBQUksS0FBSyxZQUFZLEtBQUssRUFBRTtZQUMxQixPQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ3JCLE1BQU0sS0FBSyxDQUFDO1NBQ2I7S0FDRjtBQUNILENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llcyAqL1xuaW1wb3J0IHtcbiAgQ2hpbWVDbGllbnQsXG4gIENyZWF0ZUFwcEluc3RhbmNlVXNlckNvbW1hbmQsXG4gIENyZWF0ZUFwcEluc3RhbmNlVXNlckNvbW1hbmRJbnB1dCxcbiAgQ3JlYXRlQXBwSW5zdGFuY2VVc2VyQ29tbWFuZE91dHB1dCxcbiAgVGFnLFxufSBmcm9tICdAYXdzLXNkay9jbGllbnQtY2hpbWUnO1xuXG5pbXBvcnQge1xuICBTU01DbGllbnQsXG4gIERlbGV0ZVBhcmFtZXRlckNvbW1hbmQsXG4gIFB1dFBhcmFtZXRlckNvbW1hbmQsXG59IGZyb20gJ0Bhd3Mtc2RrL2NsaWVudC1zc20nO1xuXG5jb25zdCBjaGltZUNsaWVudCA9IG5ldyBDaGltZUNsaWVudCh7XG4gIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQVdTX1JFR0lPTixcbn0pO1xuXG5jb25zdCBzc21DbGllbnQgPSBuZXcgU1NNQ2xpZW50KHsgcmVnaW9uOiBwcm9jZXNzLmVudi5BV1NfUkVHSU9OIH0pO1xuXG5pbnRlcmZhY2UgVGFncyB7XG4gIGtleTogc3RyaW5nO1xuICB2YWx1ZTogc3RyaW5nO1xufVxuXG5pbnRlcmZhY2UgQXBwSW5zdGFuY2VVc2VyUHJvcHMge1xuICBuYW1lPzogc3RyaW5nO1xuICBtZXRhZGF0YT86IHN0cmluZztcbiAgY2xpZW50UmVxdWVzdFRva2VuPzogc3RyaW5nO1xuICBhcHBJbnN0YW5jZUFybj86IHN0cmluZztcbiAgYXBwSW5zdGFuY2VVc2VySWQ/OiBzdHJpbmc7XG4gIHRhZ3M/OiBUYWdzW107XG59XG5cbmxldCBjcmVhdGVBcHBJbnN0YW5jZVVzZXJDb21tYW5kSW5wdXQ6IENyZWF0ZUFwcEluc3RhbmNlVXNlckNvbW1hbmRJbnB1dDtcbmxldCBjcmVhdGVBcHBJbnN0YW5jZVVzZXJDb21tYW5kT3V0cHV0OiBDcmVhdGVBcHBJbnN0YW5jZVVzZXJDb21tYW5kT3V0cHV0O1xubGV0IHVwZGF0ZWRUYWdzOiBUYWdbXTtcblxuZXhwb3J0IGNvbnN0IENyZWF0ZUFwcEluc3RhbmNlVXNlciA9IGFzeW5jIChcbiAgdWlkOiBzdHJpbmcsXG4gIHByb3BzOiBBcHBJbnN0YW5jZVVzZXJQcm9wcyxcbikgPT4ge1xuICB1cGRhdGVkVGFncyA9IFtdO1xuICBpZiAocHJvcHMudGFncykge1xuICAgIHByb3BzLnRhZ3MuZm9yRWFjaCgodGFnKSA9PiB7XG4gICAgICB1cGRhdGVkVGFncy5wdXNoKHsgS2V5OiB0YWcua2V5LCBWYWx1ZTogdGFnLnZhbHVlIH0pO1xuICAgIH0pO1xuICB9XG5cbiAgY3JlYXRlQXBwSW5zdGFuY2VVc2VyQ29tbWFuZElucHV0ID0ge1xuICAgIE5hbWU6IHByb3BzLm5hbWUsXG4gICAgQXBwSW5zdGFuY2VBcm46IHByb3BzLmFwcEluc3RhbmNlQXJuLFxuICAgIEFwcEluc3RhbmNlVXNlcklkOiBwcm9wcy5hcHBJbnN0YW5jZVVzZXJJZCxcbiAgICAuLi4ocHJvcHMubWV0YWRhdGEgJiYgeyBNZXRhZGF0YTogcHJvcHMubWV0YWRhdGEgfSksXG4gICAgLi4uKHByb3BzLmNsaWVudFJlcXVlc3RUb2tlbiAmJiB7XG4gICAgICBDbGllbnRSZXF1ZXN0VG9rZW46IHByb3BzLmNsaWVudFJlcXVlc3RUb2tlbixcbiAgICB9KSxcbiAgICAuLi4odXBkYXRlZFRhZ3MubGVuZ3RoID4gMCAmJiB7IFRhZ3M6IHVwZGF0ZWRUYWdzIH0pLFxuICB9O1xuXG4gIHRyeSB7XG4gICAgY3JlYXRlQXBwSW5zdGFuY2VVc2VyQ29tbWFuZE91dHB1dCA9IGF3YWl0IGNoaW1lQ2xpZW50LnNlbmQoXG4gICAgICBuZXcgQ3JlYXRlQXBwSW5zdGFuY2VVc2VyQ29tbWFuZChjcmVhdGVBcHBJbnN0YW5jZVVzZXJDb21tYW5kSW5wdXQpLFxuICAgICk7XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgaWYgKGVycm9yIGluc3RhbmNlb2YgRXJyb3IpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoZXJyb3IpO1xuICAgICAgdGhyb3cgZXJyb3I7XG4gICAgfVxuICB9XG5cbiAgdHJ5IHtcbiAgICBhd2FpdCBzc21DbGllbnQuc2VuZChcbiAgICAgIG5ldyBQdXRQYXJhbWV0ZXJDb21tYW5kKHtcbiAgICAgICAgTmFtZTogYC9jaGltZS9hcHBJbnN0YW5jZVVzZXJJZC8ke3VpZH1gLFxuICAgICAgICBEZXNjcmlwdGlvbjogJ2FwcEluc3RhbmNlVXNlcklkJyxcbiAgICAgICAgVmFsdWU6IGNyZWF0ZUFwcEluc3RhbmNlVXNlckNvbW1hbmRPdXRwdXQuQXBwSW5zdGFuY2VVc2VyQXJuLFxuICAgICAgICBPdmVyd3JpdGU6IHRydWUsXG4gICAgICAgIFR5cGU6ICdTdHJpbmcnLFxuICAgICAgfSksXG4gICAgKTtcbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICBpZiAoZXJyb3IgaW5zdGFuY2VvZiBFcnJvcikge1xuICAgICAgY29uc29sZS5lcnJvcihlcnJvcik7XG4gICAgICB0aHJvdyBlcnJvcjtcbiAgICB9XG4gIH1cblxuICByZXR1cm4ge1xuICAgIGFwcEluc3RhbmNlVXNlcjogY3JlYXRlQXBwSW5zdGFuY2VVc2VyQ29tbWFuZE91dHB1dC5BcHBJbnN0YW5jZVVzZXJBcm4sXG4gIH07XG59O1xuXG5leHBvcnQgY29uc3QgRGVsZXRlQXBwSW5zdGFuY2VVc2VyID0gYXN5bmMgKHVpZDogc3RyaW5nKSA9PiB7XG4gIHRyeSB7XG4gICAgYXdhaXQgc3NtQ2xpZW50LnNlbmQoXG4gICAgICBuZXcgRGVsZXRlUGFyYW1ldGVyQ29tbWFuZCh7IE5hbWU6IGAvY2hpbWUvYXBwSW5zdGFuY2VVc2VySWQvJHt1aWR9YCB9KSxcbiAgICApO1xuICB9IGNhdGNoIChlcnJvcikge1xuICAgIGlmIChlcnJvciBpbnN0YW5jZW9mIEVycm9yKSB7XG4gICAgICBjb25zb2xlLmVycm9yKGVycm9yKTtcbiAgICAgIHRocm93IGVycm9yO1xuICAgIH1cbiAgfVxufTtcbiJdfQ==