"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const appInstance_1 = require("./appInstance");
const channelFlow_1 = require("./channelFlow");
const dataRetention_1 = require("./dataRetention");
const instanceAdmin_1 = require("./instanceAdmin");
const instanceBot_1 = require("./instanceBot");
const instanceUser_1 = require("./instanceUser");
const streamingConfig_1 = require("./streamingConfig");
const response = {};
let resourcePropertiesUid;
let requestProperties;
exports.handler = async (event, context) => {
    console.info('event: ', event);
    const resourceType = event.ResourceProperties.resourceType;
    const requestType = event.RequestType;
    resourcePropertiesUid = event.ResourceProperties.uid;
    requestProperties = event.ResourceProperties.properties;
    response.StackId = event.StackId;
    response.RequestId = event.RequestId;
    response.LogicalResourceId = event.LogicalResourceId;
    response.PhysicalResourceId = context.logGroupName;
    switch (resourceType) {
        case 'AppInstance':
            switch (requestType) {
                case 'Create':
                    response.Data = await appInstance_1.CreateAppInstance(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateAppInstance successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await appInstance_1.DeleteAppInstance(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteAppInstance successful';
                    break;
            }
            break;
        case 'ChannelFlow':
            switch (requestType) {
                case 'Create':
                    response.Data = await channelFlow_1.CreateChannelFlow(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateChannelFlow successful';
                    break;
                case 'Update':
                    response.Data = await channelFlow_1.UpdateChannelFlow(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'UpdateChannelFlow successful';
                    break;
                case 'Delete':
                    await channelFlow_1.DeleteChannelFlow(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteChannelFlow successful';
                    break;
            }
            break;
        case 'DataRetention':
            switch (requestType) {
                case 'Create':
                    response.Data = await dataRetention_1.PutDataRetention(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutDataRetention successful';
                    break;
                case 'Update':
                    response.Data = await dataRetention_1.PutDataRetention(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutDataRetention successful';
                    break;
            }
            break;
        case 'AppInstanceAdmin':
            switch (requestType) {
                case 'Create':
                    response.Data = await instanceAdmin_1.CreateAppInstanceAdmin(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateAppInstanceAdmin successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await instanceAdmin_1.DeleteAppInstanceAdmin(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteAppInstanceAdmin successful';
                    break;
            }
            break;
        case 'AppInstanceUser':
            switch (requestType) {
                case 'Create':
                    response.Data = await instanceUser_1.CreateAppInstanceUser(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateAppInstanceUser successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await instanceUser_1.DeleteAppInstanceUser(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteAppInstanceUser successful';
                    break;
            }
            break;
        case 'AppInstanceBot':
            switch (requestType) {
                case 'Create':
                    response.Data = await instanceBot_1.CreateAppInstanceBot(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateAppInstanceBot successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await instanceBot_1.DeleteAppInstanceBot(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteAppInstanceUser successful';
                    break;
            }
            break;
        case 'StreamingConfig':
            switch (requestType) {
                case 'Create':
                    response.Data = await streamingConfig_1.PutStreamingConfiguration(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutStreamingConfiguration successful';
                    break;
                case 'Update':
                    response.Data = await streamingConfig_1.PutStreamingConfiguration(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutStreamingConfiguration successful';
                    break;
            }
            break;
    }
    console.log(`Response: ${JSON.stringify(response)}`);
    return response;
};
//# sourceMappingURL=data:application/json;base64,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