"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const phoneNumber_1 = require("./phoneNumber");
const sipMediaApp_1 = require("./sipMediaApp");
const sipRule_1 = require("./sipRule");
const voiceConnector_1 = require("./voiceConnector");
const voiceProfileDomain_1 = require("./voiceProfileDomain");
const response = {};
let resourcePropertiesUid;
let requestProperties;
exports.handler = async (event, context) => {
    console.info('event: ', event);
    const resourceType = event.ResourceProperties.resourceType;
    const requestType = event.RequestType;
    resourcePropertiesUid = event.ResourceProperties.uid;
    requestProperties = event.ResourceProperties.properties;
    response.StackId = event.StackId;
    response.RequestId = event.RequestId;
    response.LogicalResourceId = event.LogicalResourceId;
    response.PhysicalResourceId = context.logGroupName;
    switch (resourceType) {
        case 'PhoneNumber':
            switch (requestType) {
                case 'Create':
                    response.Data = await phoneNumber_1.CreatePhoneNumber(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreatePhoneNumber successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await phoneNumber_1.DeletePhoneNumber(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeletePhoneNumber successful';
                    break;
            }
            break;
        case 'SMARule':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipRule_1.CreateSIPRule(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateSMARule successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await sipRule_1.DeleteSIPRule(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteSMARule successful';
                    break;
            }
            break;
        case 'SMA':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.CreateSipMediaApplication(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Create SMA successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await sipMediaApp_1.DeleteSipMediaApplication(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Delete SMA successful';
                    break;
            }
            break;
        case 'SMALogging':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationLogging(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging successful';
                    break;
                case 'Update':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationLogging(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging successful';
                    break;
                case 'Delete':
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging Delete NoOP';
                    break;
            }
            break;
        case 'SMAAlexaSkill':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationAlexaSkill(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill successful';
                    break;
                case 'Update':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationAlexaSkill(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill successful';
                    break;
                case 'Delete':
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill Delete NoOP';
                    break;
            }
            break;
        case 'VoiceConnector':
            switch (requestType) {
                case 'Create':
                    response.Data = await voiceConnector_1.CreateVoiceConnector(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Create VC successful';
                    break;
                case 'Update':
                    response.Data = await voiceConnector_1.UpdateVoiceConnector(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Update VC successful';
                    break;
                case 'Delete':
                    await voiceConnector_1.DeleteVoiceConnector(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Delete VC successful';
                    break;
            }
            break;
        case 'VoiceProfileDomain':
            switch (requestType) {
                case 'Create':
                    response.Data = await voiceProfileDomain_1.CreateVoiceProfileDomain(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Create Voice Profile Domain successful';
                    break;
                case 'Update':
                    await voiceProfileDomain_1.UpdateVoiceProfileDomain(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await voiceProfileDomain_1.DeleteVoiceProfileDomain(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Delete VC successful';
                    break;
            }
            break;
    }
    console.log(`Response: ${JSON.stringify(response)}`);
    return response;
};
//# sourceMappingURL=data:application/json;base64,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