"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PutSipMediaApplicationAlexaSkill = exports.PutSipMediaApplicationLogging = exports.DeleteSipMediaApplication = exports.CreateSipMediaApplication = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_voice_1 = require("@aws-sdk/client-chime-sdk-voice");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeSDKVoiceClient = new client_chime_sdk_voice_1.ChimeSDKVoiceClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createSipMediaApplicationResponse;
let createSipMediaApplicationParams;
let getParameterCommandOutput;
let putSipMediaApplicationAlexaSkillInput;
let putSipMediaApplicationLoggingInput;
let putSipMediaApplicationAlexaSkillOutput;
let putSipMediaApplicationLoggingOutput;
exports.CreateSipMediaApplication = async (uid, props) => {
    console.log(`Creating SIP media application rule: ${uid}`);
    console.log(`Create SIP media application props: ${JSON.stringify(props)}`);
    createSipMediaApplicationParams = {
        Name: props.name,
        AwsRegion: props.region,
        Endpoints: [{ LambdaArn: props.endpoint }],
    };
    console.log(`Create SIP media application params: ${JSON.stringify(createSipMediaApplicationParams)}`);
    try {
        createSipMediaApplicationResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.CreateSipMediaApplicationCommand(createSipMediaApplicationParams));
        console.log(`createSipMediaApplicationResponse: ${JSON.stringify(createSipMediaApplicationResponse)}`);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: '/chime/sipMediaApp' + uid,
            Value: createSipMediaApplicationResponse.SipMediaApplication
                ?.SipMediaApplicationId,
            Description: 'SIP Media Application ID',
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        sipMediaAppId: createSipMediaApplicationResponse.SipMediaApplication
            ?.SipMediaApplicationId,
    };
};
exports.DeleteSipMediaApplication = async (uid) => {
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/sipMediaApp' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.DeleteSipMediaApplicationCommand({
            SipMediaApplicationId: getParameterCommandOutput.Parameter?.Value,
        }));
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: '/chime/sipMediaApp' + uid }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
exports.PutSipMediaApplicationLogging = async (props) => {
    console.log(`Put SIP media application logging configuration: ${JSON.stringify(props)}`);
    putSipMediaApplicationLoggingInput = {
        SipMediaApplicationId: props.sipMediaAppId,
        SipMediaApplicationLoggingConfiguration: {
            EnableSipMediaApplicationMessageLogs: props.sipMediaApplicationLoggingConfiguration
                ?.sipMediaApplicationLoggingConfiguration
                ?.enableSipMediaApplicationMessageLogs,
        },
    };
    try {
        putSipMediaApplicationLoggingOutput = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.PutSipMediaApplicationLoggingConfigurationCommand(putSipMediaApplicationLoggingInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        putSipMediaApplicationLoggingConfiguration: putSipMediaApplicationLoggingOutput.SipMediaApplicationLoggingConfiguration,
    };
};
var AlexaSkillStatus;
(function (AlexaSkillStatus) {
    AlexaSkillStatus["ACTIVE"] = "ACTIVE";
    AlexaSkillStatus["INACTIVE"] = "INACTIVE";
})(AlexaSkillStatus || (AlexaSkillStatus = {}));
exports.PutSipMediaApplicationAlexaSkill = async (props) => {
    console.log(`Put SIP media application Alexa skill configuration: ${JSON.stringify(props)}`);
    putSipMediaApplicationAlexaSkillInput = {
        SipMediaApplicationId: props.sipMediaAppId,
        SipMediaApplicationAlexaSkillConfiguration: {
            AlexaSkillIds: props.sipMediaApplicationAlexaSkillConfiguration?.alexaSkillIds,
            AlexaSkillStatus: props.sipMediaApplicationAlexaSkillConfiguration?.alexaSkillStatus,
        },
    };
    try {
        putSipMediaApplicationAlexaSkillOutput = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.PutSipMediaApplicationAlexaSkillConfigurationCommand(putSipMediaApplicationAlexaSkillInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        putSipMediaApplicationAlexaSkillConfiguration: putSipMediaApplicationAlexaSkillOutput.SipMediaApplicationAlexaSkillConfiguration,
    };
};
//# sourceMappingURL=data:application/json;base64,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