"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteVoiceProfileDomain = exports.UpdateVoiceProfileDomain = exports.CreateVoiceProfileDomain = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_voice_1 = require("@aws-sdk/client-chime-sdk-voice");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeSDKVoiceClient = new client_chime_sdk_voice_1.ChimeSDKVoiceClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let formattedCreateVoiceProfileDomainParams;
let createVoiceProfileDomainResponse;
let getParameterCommandOutput;
let voiceProfileDomainId;
let updateVoiceProfileDomainParams;
let updateVoiceProfileDomainResponse;
let deleteVoiceProfileDomainResponse;
let formattedTags = [];
function capitalizeKeys(obj) {
    if (Array.isArray(obj)) {
        return obj.map((item) => capitalizeKeys(item));
    }
    if (typeof obj === 'object') {
        const capitalizedObj = {};
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                const capitalizedKey = key.charAt(0).toUpperCase() + key.slice(1);
                const value = obj[key];
                capitalizedObj[capitalizedKey] =
                    typeof value === 'string' && !isNaN(parseFloat(value))
                        ? parseFloat(value)
                        : capitalizeKeys(value);
            }
        }
        return capitalizedObj;
    }
    return obj;
}
const formatProps = (props) => {
    console.info(`Formatting Props: ${JSON.stringify(props)}`);
    if (props.tags) {
        console.info(`Formatting Tags: ${JSON.stringify(props.tags)}`);
        props.tags.forEach((tag) => {
            formattedTags.push(capitalizeKeys(tag));
        });
        console.info(`Formatted Tags: ${JSON.stringify(formattedTags)}`);
    }
    formattedCreateVoiceProfileDomainParams = {
        Name: props.name,
        ...(props.tags && { Tags: formattedTags }),
        ...(props.clientRequestToken && {
            ClientRequestToken: props.clientRequestToken,
        }),
        ...(props.description && { Description: props.description }),
        ...(props.serverSideEncryptionConfiguration && {
            ServerSideEncryptionConfiguration: {
                KmsKeyArn: props.serverSideEncryptionConfiguration.kmsKeyArn,
            },
        }),
    };
    return formattedCreateVoiceProfileDomainParams;
};
exports.CreateVoiceProfileDomain = async (uid, props) => {
    console.log(`Creating Voice Profile Domain: ${uid}`);
    console.log(`Create Voice Profile DomainProps: ${JSON.stringify(props)}`);
    formattedCreateVoiceProfileDomainParams = formatProps(props);
    console.log(`Create Voice Profile Domain params: ${JSON.stringify(formattedCreateVoiceProfileDomainParams)}`);
    console.log(`createVoiceProfileDomainParams: ${JSON.stringify(formattedCreateVoiceProfileDomainParams)}`);
    try {
        createVoiceProfileDomainResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.CreateVoiceProfileDomainCommand(formattedCreateVoiceProfileDomainParams));
        console.log(`createVoiceConnectorResponse: ${JSON.stringify(createVoiceProfileDomainResponse)}`);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: '/chime/voiceProfileDomain' + uid,
            Value: createVoiceProfileDomainResponse.VoiceProfileDomain
                .VoiceProfileDomainId,
            Description: 'Voice Profile Domain ID',
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return createVoiceProfileDomainResponse.VoiceProfileDomain;
};
exports.UpdateVoiceProfileDomain = async (uid, props) => {
    console.log(`Updating Voice Profile Domain: ${uid}`);
    console.log(`Update Voice Profile DomainProps: ${JSON.stringify(props)}`);
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/voiceProfileDomain' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
            voiceProfileDomainId = getParameterCommandOutput.Parameter.Value;
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    updateVoiceProfileDomainParams = {
        Name: props.name,
        Description: props.description,
        VoiceProfileDomainId: voiceProfileDomainId,
    };
    console.log(`updateVoiceConnectorParams: ${JSON.stringify(updateVoiceProfileDomainParams)}`);
    try {
        updateVoiceProfileDomainResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.UpdateVoiceProfileDomainCommand(updateVoiceProfileDomainParams));
        console.log(`updateVoiceProfileDomainResponse: ${JSON.stringify(updateVoiceProfileDomainResponse)}`);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        voiceProfileDomain: updateVoiceProfileDomainResponse.VoiceProfileDomain,
    };
};
exports.DeleteVoiceProfileDomain = async (uid) => {
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/voiceProfileDomain' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
            voiceProfileDomainId = getParameterCommandOutput.Parameter.Value;
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    console.log(`Deleting voiceProfileDomainId: ${voiceProfileDomainId}`);
    try {
        deleteVoiceProfileDomainResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.DeleteVoiceProfileDomainCommand({
            VoiceProfileDomainId: voiceProfileDomainId,
        }));
        console.log(`Delete Voice Profile Domain Response: ${deleteVoiceProfileDomainResponse}`);
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: '/chime/voiceProfileDomain' + uid }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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