"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListAppInstanceUsers = void 0;
const ChimeSDKIdentityClient_1 = require("../ChimeSDKIdentityClient");
const ListAppInstanceUsersCommand_1 = require("../commands/ListAppInstanceUsersCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListAppInstanceUsersCommand_1.ListAppInstanceUsersCommand(input), ...args);
};
async function* paginateListAppInstanceUsers(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKIdentityClient_1.ChimeSDKIdentityClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKIdentity | ChimeSDKIdentityClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListAppInstanceUsers = paginateListAppInstanceUsers;
