"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListAppInstances = void 0;
const ChimeSDKIdentityClient_1 = require("../ChimeSDKIdentityClient");
const ListAppInstancesCommand_1 = require("../commands/ListAppInstancesCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListAppInstancesCommand_1.ListAppInstancesCommand(input), ...args);
};
async function* paginateListAppInstances(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKIdentityClient_1.ChimeSDKIdentityClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKIdentity | ChimeSDKIdentityClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListAppInstances = paginateListAppInstances;
