import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { ChimeSDKIdentityServiceException as __BaseException } from "./ChimeSDKIdentityServiceException";
export const AllowMessages = {
    ALL: "ALL",
    NONE: "NONE",
};
export const StandardMessages = {
    ALL: "ALL",
    AUTO: "AUTO",
    MENTIONS: "MENTIONS",
    NONE: "NONE",
};
export const TargetedMessages = {
    ALL: "ALL",
    NONE: "NONE",
};
export const RespondsTo = {
    STANDARD_MESSAGES: "STANDARD_MESSAGES",
};
export const ExpirationCriterion = {
    CREATED_TIMESTAMP: "CREATED_TIMESTAMP",
};
export const EndpointStatus = {
    ACTIVE: "ACTIVE",
    INACTIVE: "INACTIVE",
};
export const EndpointStatusReason = {
    INVALID_DEVICE_TOKEN: "INVALID_DEVICE_TOKEN",
    INVALID_PINPOINT_ARN: "INVALID_PINPOINT_ARN",
};
export const AppInstanceUserEndpointType = {
    APNS: "APNS",
    APNS_SANDBOX: "APNS_SANDBOX",
    GCM: "GCM",
};
export const ErrorCode = {
    AccessDenied: "AccessDenied",
    BadRequest: "BadRequest",
    Conflict: "Conflict",
    Forbidden: "Forbidden",
    NotFound: "NotFound",
    PhoneNumberAssociationsExist: "PhoneNumberAssociationsExist",
    PreconditionFailed: "PreconditionFailed",
    ResourceLimitExceeded: "ResourceLimitExceeded",
    ServiceFailure: "ServiceFailure",
    ServiceUnavailable: "ServiceUnavailable",
    Throttled: "Throttled",
    Throttling: "Throttling",
    Unauthorized: "Unauthorized",
    Unprocessable: "Unprocessable",
    VoiceConnectorGroupAssociationsExist: "VoiceConnectorGroupAssociationsExist",
};
export class BadRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "BadRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BadRequestException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ForbiddenException extends __BaseException {
    constructor(opts) {
        super({
            name: "ForbiddenException",
            $fault: "client",
            ...opts,
        });
        this.name = "ForbiddenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ForbiddenException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ResourceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceFailureException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ThrottledClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "ThrottledClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottledClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottledClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class UnauthorizedClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnauthorizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnauthorizedClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class NotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "NotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NotFoundException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export const AppInstanceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const IdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const AppInstanceAdminFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: IdentityFilterSensitiveLog(obj.Admin) }),
});
export const AppInstanceAdminSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: IdentityFilterSensitiveLog(obj.Admin) }),
});
export const AppInstanceBotFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AppInstanceBotSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AppInstanceSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AppInstanceUserFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const EndpointAttributesFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DeviceToken && { DeviceToken: SENSITIVE_STRING }),
    ...(obj.VoipDeviceToken && { VoipDeviceToken: SENSITIVE_STRING }),
});
export const AppInstanceUserEndpointFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.EndpointAttributes && { EndpointAttributes: EndpointAttributesFilterSensitiveLog(obj.EndpointAttributes) }),
});
export const AppInstanceUserEndpointSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const AppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const TagFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Key && { Key: SENSITIVE_STRING }),
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const CreateAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: IdentityFilterSensitiveLog(obj.AppInstanceAdmin) }),
});
export const CreateAppInstanceBotRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserId && { AppInstanceUserId: SENSITIVE_STRING }),
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const DescribeAppInstanceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstance && { AppInstance: AppInstanceFilterSensitiveLog(obj.AppInstance) }),
});
export const DescribeAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: AppInstanceAdminFilterSensitiveLog(obj.AppInstanceAdmin) }),
});
export const DescribeAppInstanceBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceBot && { AppInstanceBot: AppInstanceBotFilterSensitiveLog(obj.AppInstanceBot) }),
});
export const DescribeAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUser && { AppInstanceUser: AppInstanceUserFilterSensitiveLog(obj.AppInstanceUser) }),
});
export const DescribeAppInstanceUserEndpointResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserEndpoint && {
        AppInstanceUserEndpoint: AppInstanceUserEndpointFilterSensitiveLog(obj.AppInstanceUserEndpoint),
    }),
});
export const ListAppInstanceAdminsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceAdminsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmins && {
        AppInstanceAdmins: obj.AppInstanceAdmins.map((item) => AppInstanceAdminSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceBotsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceBotsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceBots && {
        AppInstanceBots: obj.AppInstanceBots.map((item) => AppInstanceBotSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstancesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstancesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstances && { AppInstances: obj.AppInstances.map((item) => AppInstanceSummaryFilterSensitiveLog(item)) }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceUserEndpointsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserArn && { AppInstanceUserArn: SENSITIVE_STRING }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceUserEndpointsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserEndpoints && {
        AppInstanceUserEndpoints: obj.AppInstanceUserEndpoints.map((item) => AppInstanceUserEndpointSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceUsersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceUsersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUsers && {
        AppInstanceUsers: obj.AppInstanceUsers.map((item) => AppInstanceUserSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListTagsForResourceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const RegisterAppInstanceUserEndpointRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserArn && { AppInstanceUserArn: SENSITIVE_STRING }),
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.EndpointAttributes && { EndpointAttributes: EndpointAttributesFilterSensitiveLog(obj.EndpointAttributes) }),
});
export const TagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const UntagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TagKeys && { TagKeys: SENSITIVE_STRING }),
});
export const UpdateAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const UpdateAppInstanceBotRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const UpdateAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const UpdateAppInstanceUserEndpointRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
