import { ChimeSDKIdentityClient } from "../ChimeSDKIdentityClient";
import { ListAppInstanceBotsCommand, } from "../commands/ListAppInstanceBotsCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListAppInstanceBotsCommand(input), ...args);
};
export async function* paginateListAppInstanceBots(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKIdentityClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKIdentity | ChimeSDKIdentityClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
