import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { ChimeSDKIdentityClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKIdentityClient";
import { RegisterAppInstanceUserEndpointRequest, RegisterAppInstanceUserEndpointResponse } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link RegisterAppInstanceUserEndpointCommand}.
 */
export interface RegisterAppInstanceUserEndpointCommandInput extends RegisterAppInstanceUserEndpointRequest {
}
/**
 * @public
 *
 * The output of {@link RegisterAppInstanceUserEndpointCommand}.
 */
export interface RegisterAppInstanceUserEndpointCommandOutput extends RegisterAppInstanceUserEndpointResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Registers an endpoint under an Amazon Chime <code>AppInstanceUser</code>. The endpoint receives messages for a user. For push notifications, the endpoint is a mobile device used to receive mobile push notifications for a user.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKIdentityClient, RegisterAppInstanceUserEndpointCommand } from "@aws-sdk/client-chime-sdk-identity"; // ES Modules import
 * // const { ChimeSDKIdentityClient, RegisterAppInstanceUserEndpointCommand } = require("@aws-sdk/client-chime-sdk-identity"); // CommonJS import
 * const client = new ChimeSDKIdentityClient(config);
 * const input = { // RegisterAppInstanceUserEndpointRequest
 *   AppInstanceUserArn: "STRING_VALUE", // required
 *   Name: "STRING_VALUE",
 *   Type: "APNS" || "APNS_SANDBOX" || "GCM", // required
 *   ResourceArn: "STRING_VALUE", // required
 *   EndpointAttributes: { // EndpointAttributes
 *     DeviceToken: "STRING_VALUE", // required
 *     VoipDeviceToken: "STRING_VALUE",
 *   },
 *   ClientRequestToken: "STRING_VALUE", // required
 *   AllowMessages: "ALL" || "NONE",
 * };
 * const command = new RegisterAppInstanceUserEndpointCommand(input);
 * const response = await client.send(command);
 * // { // RegisterAppInstanceUserEndpointResponse
 * //   AppInstanceUserArn: "STRING_VALUE",
 * //   EndpointId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param RegisterAppInstanceUserEndpointCommandInput - {@link RegisterAppInstanceUserEndpointCommandInput}
 * @returns {@link RegisterAppInstanceUserEndpointCommandOutput}
 * @see {@link RegisterAppInstanceUserEndpointCommandInput} for command's `input` shape.
 * @see {@link RegisterAppInstanceUserEndpointCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKIdentityClientResolvedConfig | config} for ChimeSDKIdentityClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ResourceLimitExceededException} (client fault)
 *  <p>The request exceeds the resource limit.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 * @throws {@link ChimeSDKIdentityServiceException}
 * <p>Base exception class for all service exceptions from ChimeSDKIdentity service.</p>
 *
 */
export declare class RegisterAppInstanceUserEndpointCommand extends $Command<RegisterAppInstanceUserEndpointCommandInput, RegisterAppInstanceUserEndpointCommandOutput, ChimeSDKIdentityClientResolvedConfig> {
    readonly input: RegisterAppInstanceUserEndpointCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: RegisterAppInstanceUserEndpointCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKIdentityClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RegisterAppInstanceUserEndpointCommandInput, RegisterAppInstanceUserEndpointCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
