import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { ChimeSDKIdentityClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKIdentityClient";
import { UpdateAppInstanceBotRequest, UpdateAppInstanceBotResponse } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link UpdateAppInstanceBotCommand}.
 */
export interface UpdateAppInstanceBotCommandInput extends UpdateAppInstanceBotRequest {
}
/**
 * @public
 *
 * The output of {@link UpdateAppInstanceBotCommand}.
 */
export interface UpdateAppInstanceBotCommandOutput extends UpdateAppInstanceBotResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Updates the name and metadata of an <code>AppInstanceBot</code>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKIdentityClient, UpdateAppInstanceBotCommand } from "@aws-sdk/client-chime-sdk-identity"; // ES Modules import
 * // const { ChimeSDKIdentityClient, UpdateAppInstanceBotCommand } = require("@aws-sdk/client-chime-sdk-identity"); // CommonJS import
 * const client = new ChimeSDKIdentityClient(config);
 * const input = { // UpdateAppInstanceBotRequest
 *   AppInstanceBotArn: "STRING_VALUE", // required
 *   Name: "STRING_VALUE", // required
 *   Metadata: "STRING_VALUE", // required
 *   Configuration: { // Configuration
 *     Lex: { // LexConfiguration
 *       RespondsTo: "STANDARD_MESSAGES",
 *       InvokedBy: { // InvokedBy
 *         StandardMessages: "AUTO" || "ALL" || "MENTIONS" || "NONE", // required
 *         TargetedMessages: "ALL" || "NONE", // required
 *       },
 *       LexBotAliasArn: "STRING_VALUE", // required
 *       LocaleId: "STRING_VALUE", // required
 *       WelcomeIntent: "STRING_VALUE",
 *     },
 *   },
 * };
 * const command = new UpdateAppInstanceBotCommand(input);
 * const response = await client.send(command);
 * // { // UpdateAppInstanceBotResponse
 * //   AppInstanceBotArn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param UpdateAppInstanceBotCommandInput - {@link UpdateAppInstanceBotCommandInput}
 * @returns {@link UpdateAppInstanceBotCommandOutput}
 * @see {@link UpdateAppInstanceBotCommandInput} for command's `input` shape.
 * @see {@link UpdateAppInstanceBotCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKIdentityClientResolvedConfig | config} for ChimeSDKIdentityClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ResourceLimitExceededException} (client fault)
 *  <p>The request exceeds the resource limit.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 * @throws {@link ChimeSDKIdentityServiceException}
 * <p>Base exception class for all service exceptions from ChimeSDKIdentity service.</p>
 *
 */
export declare class UpdateAppInstanceBotCommand extends $Command<UpdateAppInstanceBotCommandInput, UpdateAppInstanceBotCommandOutput, ChimeSDKIdentityClientResolvedConfig> {
    readonly input: UpdateAppInstanceBotCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: UpdateAppInstanceBotCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKIdentityClientResolvedConfig, options?: __HttpHandlerOptions): Handler<UpdateAppInstanceBotCommandInput, UpdateAppInstanceBotCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
