import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { ChimeSDKIdentityServiceException as __BaseException } from "./ChimeSDKIdentityServiceException";
export declare const AllowMessages: {
  readonly ALL: "ALL";
  readonly NONE: "NONE";
};
export type AllowMessages = (typeof AllowMessages)[keyof typeof AllowMessages];
export interface AppInstance {
  AppInstanceArn?: string;
  Name?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  Metadata?: string;
}
export interface Identity {
  Arn?: string;
  Name?: string;
}
export interface AppInstanceAdmin {
  Admin?: Identity;
  AppInstanceArn?: string;
  CreatedTimestamp?: Date;
}
export interface AppInstanceAdminSummary {
  Admin?: Identity;
}
export declare const StandardMessages: {
  readonly ALL: "ALL";
  readonly AUTO: "AUTO";
  readonly MENTIONS: "MENTIONS";
  readonly NONE: "NONE";
};
export type StandardMessages =
  (typeof StandardMessages)[keyof typeof StandardMessages];
export declare const TargetedMessages: {
  readonly ALL: "ALL";
  readonly NONE: "NONE";
};
export type TargetedMessages =
  (typeof TargetedMessages)[keyof typeof TargetedMessages];
export interface InvokedBy {
  StandardMessages: StandardMessages | string | undefined;
  TargetedMessages: TargetedMessages | string | undefined;
}
export declare const RespondsTo: {
  readonly STANDARD_MESSAGES: "STANDARD_MESSAGES";
};
export type RespondsTo = (typeof RespondsTo)[keyof typeof RespondsTo];
export interface LexConfiguration {
  RespondsTo?: RespondsTo | string;
  InvokedBy?: InvokedBy;
  LexBotAliasArn: string | undefined;
  LocaleId: string | undefined;
  WelcomeIntent?: string;
}
export interface Configuration {
  Lex: LexConfiguration | undefined;
}
export interface AppInstanceBot {
  AppInstanceBotArn?: string;
  Name?: string;
  Configuration?: Configuration;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  Metadata?: string;
}
export interface AppInstanceBotSummary {
  AppInstanceBotArn?: string;
  Name?: string;
  Metadata?: string;
}
export interface AppInstanceSummary {
  AppInstanceArn?: string;
  Name?: string;
  Metadata?: string;
}
export interface ChannelRetentionSettings {
  RetentionDays?: number;
}
export interface AppInstanceRetentionSettings {
  ChannelRetentionSettings?: ChannelRetentionSettings;
}
export declare const ExpirationCriterion: {
  readonly CREATED_TIMESTAMP: "CREATED_TIMESTAMP";
};
export type ExpirationCriterion =
  (typeof ExpirationCriterion)[keyof typeof ExpirationCriterion];
export interface ExpirationSettings {
  ExpirationDays: number | undefined;
  ExpirationCriterion: ExpirationCriterion | string | undefined;
}
export interface AppInstanceUser {
  AppInstanceUserArn?: string;
  Name?: string;
  Metadata?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  ExpirationSettings?: ExpirationSettings;
}
export interface EndpointAttributes {
  DeviceToken: string | undefined;
  VoipDeviceToken?: string;
}
export declare const EndpointStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly INACTIVE: "INACTIVE";
};
export type EndpointStatus =
  (typeof EndpointStatus)[keyof typeof EndpointStatus];
export declare const EndpointStatusReason: {
  readonly INVALID_DEVICE_TOKEN: "INVALID_DEVICE_TOKEN";
  readonly INVALID_PINPOINT_ARN: "INVALID_PINPOINT_ARN";
};
export type EndpointStatusReason =
  (typeof EndpointStatusReason)[keyof typeof EndpointStatusReason];
export interface EndpointState {
  Status: EndpointStatus | string | undefined;
  StatusReason?: EndpointStatusReason | string;
}
export declare const AppInstanceUserEndpointType: {
  readonly APNS: "APNS";
  readonly APNS_SANDBOX: "APNS_SANDBOX";
  readonly GCM: "GCM";
};
export type AppInstanceUserEndpointType =
  (typeof AppInstanceUserEndpointType)[keyof typeof AppInstanceUserEndpointType];
export interface AppInstanceUserEndpoint {
  AppInstanceUserArn?: string;
  EndpointId?: string;
  Name?: string;
  Type?: AppInstanceUserEndpointType | string;
  ResourceArn?: string;
  EndpointAttributes?: EndpointAttributes;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  AllowMessages?: AllowMessages | string;
  EndpointState?: EndpointState;
}
export interface AppInstanceUserEndpointSummary {
  AppInstanceUserArn?: string;
  EndpointId?: string;
  Name?: string;
  Type?: AppInstanceUserEndpointType | string;
  AllowMessages?: AllowMessages | string;
  EndpointState?: EndpointState;
}
export interface AppInstanceUserSummary {
  AppInstanceUserArn?: string;
  Name?: string;
  Metadata?: string;
}
export declare const ErrorCode: {
  readonly AccessDenied: "AccessDenied";
  readonly BadRequest: "BadRequest";
  readonly Conflict: "Conflict";
  readonly Forbidden: "Forbidden";
  readonly NotFound: "NotFound";
  readonly PhoneNumberAssociationsExist: "PhoneNumberAssociationsExist";
  readonly PreconditionFailed: "PreconditionFailed";
  readonly ResourceLimitExceeded: "ResourceLimitExceeded";
  readonly ServiceFailure: "ServiceFailure";
  readonly ServiceUnavailable: "ServiceUnavailable";
  readonly Throttled: "Throttled";
  readonly Throttling: "Throttling";
  readonly Unauthorized: "Unauthorized";
  readonly Unprocessable: "Unprocessable";
  readonly VoiceConnectorGroupAssociationsExist: "VoiceConnectorGroupAssociationsExist";
};
export type ErrorCode = (typeof ErrorCode)[keyof typeof ErrorCode];
export declare class BadRequestException extends __BaseException {
  readonly name: "BadRequestException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<BadRequestException, __BaseException>
  );
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateAppInstanceRequest {
  Name: string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface CreateAppInstanceResponse {
  AppInstanceArn?: string;
}
export declare class ForbiddenException extends __BaseException {
  readonly name: "ForbiddenException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export declare class ServiceFailureException extends __BaseException {
  readonly name: "ServiceFailureException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceFailureException, __BaseException>
  );
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export declare class ThrottledClientException extends __BaseException {
  readonly name: "ThrottledClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ThrottledClientException, __BaseException>
  );
}
export declare class UnauthorizedClientException extends __BaseException {
  readonly name: "UnauthorizedClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>
  );
}
export interface CreateAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface CreateAppInstanceAdminResponse {
  AppInstanceAdmin?: Identity;
  AppInstanceArn?: string;
}
export interface CreateAppInstanceBotRequest {
  AppInstanceArn: string | undefined;
  Name?: string;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
  Configuration: Configuration | undefined;
}
export interface CreateAppInstanceBotResponse {
  AppInstanceBotArn?: string;
}
export interface CreateAppInstanceUserRequest {
  AppInstanceArn: string | undefined;
  AppInstanceUserId: string | undefined;
  Name: string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
  ExpirationSettings?: ExpirationSettings;
}
export interface CreateAppInstanceUserResponse {
  AppInstanceUserArn?: string;
}
export interface DeleteAppInstanceRequest {
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceBotRequest {
  AppInstanceBotArn: string | undefined;
}
export interface DeleteAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
}
export interface DeregisterAppInstanceUserEndpointRequest {
  AppInstanceUserArn: string | undefined;
  EndpointId: string | undefined;
}
export interface DescribeAppInstanceRequest {
  AppInstanceArn: string | undefined;
}
export interface DescribeAppInstanceResponse {
  AppInstance?: AppInstance;
}
export interface DescribeAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface DescribeAppInstanceAdminResponse {
  AppInstanceAdmin?: AppInstanceAdmin;
}
export interface DescribeAppInstanceBotRequest {
  AppInstanceBotArn: string | undefined;
}
export interface DescribeAppInstanceBotResponse {
  AppInstanceBot?: AppInstanceBot;
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export interface DescribeAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
}
export interface DescribeAppInstanceUserResponse {
  AppInstanceUser?: AppInstanceUser;
}
export interface DescribeAppInstanceUserEndpointRequest {
  AppInstanceUserArn: string | undefined;
  EndpointId: string | undefined;
}
export interface DescribeAppInstanceUserEndpointResponse {
  AppInstanceUserEndpoint?: AppInstanceUserEndpoint;
}
export interface GetAppInstanceRetentionSettingsRequest {
  AppInstanceArn: string | undefined;
}
export interface GetAppInstanceRetentionSettingsResponse {
  AppInstanceRetentionSettings?: AppInstanceRetentionSettings;
  InitiateDeletionTimestamp?: Date;
}
export interface ListAppInstanceAdminsRequest {
  AppInstanceArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstanceAdminsResponse {
  AppInstanceArn?: string;
  AppInstanceAdmins?: AppInstanceAdminSummary[];
  NextToken?: string;
}
export interface ListAppInstanceBotsRequest {
  AppInstanceArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstanceBotsResponse {
  AppInstanceArn?: string;
  AppInstanceBots?: AppInstanceBotSummary[];
  NextToken?: string;
}
export interface ListAppInstancesRequest {
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstancesResponse {
  AppInstances?: AppInstanceSummary[];
  NextToken?: string;
}
export interface ListAppInstanceUserEndpointsRequest {
  AppInstanceUserArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstanceUserEndpointsResponse {
  AppInstanceUserEndpoints?: AppInstanceUserEndpointSummary[];
  NextToken?: string;
}
export interface ListAppInstanceUsersRequest {
  AppInstanceArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListAppInstanceUsersResponse {
  AppInstanceArn?: string;
  AppInstanceUsers?: AppInstanceUserSummary[];
  NextToken?: string;
}
export interface ListTagsForResourceRequest {
  ResourceARN: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Tag[];
}
export interface PutAppInstanceRetentionSettingsRequest {
  AppInstanceArn: string | undefined;
  AppInstanceRetentionSettings: AppInstanceRetentionSettings | undefined;
}
export interface PutAppInstanceRetentionSettingsResponse {
  AppInstanceRetentionSettings?: AppInstanceRetentionSettings;
  InitiateDeletionTimestamp?: Date;
}
export interface PutAppInstanceUserExpirationSettingsRequest {
  AppInstanceUserArn: string | undefined;
  ExpirationSettings?: ExpirationSettings;
}
export interface PutAppInstanceUserExpirationSettingsResponse {
  AppInstanceUserArn?: string;
  ExpirationSettings?: ExpirationSettings;
}
export interface RegisterAppInstanceUserEndpointRequest {
  AppInstanceUserArn: string | undefined;
  Name?: string;
  Type: AppInstanceUserEndpointType | string | undefined;
  ResourceArn: string | undefined;
  EndpointAttributes: EndpointAttributes | undefined;
  ClientRequestToken?: string;
  AllowMessages?: AllowMessages | string;
}
export interface RegisterAppInstanceUserEndpointResponse {
  AppInstanceUserArn?: string;
  EndpointId?: string;
}
export interface TagResourceRequest {
  ResourceARN: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagResourceRequest {
  ResourceARN: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UpdateAppInstanceRequest {
  AppInstanceArn: string | undefined;
  Name: string | undefined;
  Metadata: string | undefined;
}
export interface UpdateAppInstanceResponse {
  AppInstanceArn?: string;
}
export interface UpdateAppInstanceBotRequest {
  AppInstanceBotArn: string | undefined;
  Name: string | undefined;
  Metadata: string | undefined;
  Configuration?: Configuration;
}
export interface UpdateAppInstanceBotResponse {
  AppInstanceBotArn?: string;
}
export interface UpdateAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
  Name: string | undefined;
  Metadata: string | undefined;
}
export interface UpdateAppInstanceUserResponse {
  AppInstanceUserArn?: string;
}
export interface UpdateAppInstanceUserEndpointRequest {
  AppInstanceUserArn: string | undefined;
  EndpointId: string | undefined;
  Name?: string;
  AllowMessages?: AllowMessages | string;
}
export interface UpdateAppInstanceUserEndpointResponse {
  AppInstanceUserArn?: string;
  EndpointId?: string;
}
export declare const AppInstanceFilterSensitiveLog: (obj: AppInstance) => any;
export declare const IdentityFilterSensitiveLog: (obj: Identity) => any;
export declare const AppInstanceAdminFilterSensitiveLog: (
  obj: AppInstanceAdmin
) => any;
export declare const AppInstanceAdminSummaryFilterSensitiveLog: (
  obj: AppInstanceAdminSummary
) => any;
export declare const AppInstanceBotFilterSensitiveLog: (
  obj: AppInstanceBot
) => any;
export declare const AppInstanceBotSummaryFilterSensitiveLog: (
  obj: AppInstanceBotSummary
) => any;
export declare const AppInstanceSummaryFilterSensitiveLog: (
  obj: AppInstanceSummary
) => any;
export declare const AppInstanceUserFilterSensitiveLog: (
  obj: AppInstanceUser
) => any;
export declare const EndpointAttributesFilterSensitiveLog: (
  obj: EndpointAttributes
) => any;
export declare const AppInstanceUserEndpointFilterSensitiveLog: (
  obj: AppInstanceUserEndpoint
) => any;
export declare const AppInstanceUserEndpointSummaryFilterSensitiveLog: (
  obj: AppInstanceUserEndpointSummary
) => any;
export declare const AppInstanceUserSummaryFilterSensitiveLog: (
  obj: AppInstanceUserSummary
) => any;
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const CreateAppInstanceRequestFilterSensitiveLog: (
  obj: CreateAppInstanceRequest
) => any;
export declare const CreateAppInstanceAdminResponseFilterSensitiveLog: (
  obj: CreateAppInstanceAdminResponse
) => any;
export declare const CreateAppInstanceBotRequestFilterSensitiveLog: (
  obj: CreateAppInstanceBotRequest
) => any;
export declare const CreateAppInstanceUserRequestFilterSensitiveLog: (
  obj: CreateAppInstanceUserRequest
) => any;
export declare const DescribeAppInstanceResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceResponse
) => any;
export declare const DescribeAppInstanceAdminResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceAdminResponse
) => any;
export declare const DescribeAppInstanceBotResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceBotResponse
) => any;
export declare const DescribeAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceUserResponse
) => any;
export declare const DescribeAppInstanceUserEndpointResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceUserEndpointResponse
) => any;
export declare const ListAppInstanceAdminsRequestFilterSensitiveLog: (
  obj: ListAppInstanceAdminsRequest
) => any;
export declare const ListAppInstanceAdminsResponseFilterSensitiveLog: (
  obj: ListAppInstanceAdminsResponse
) => any;
export declare const ListAppInstanceBotsRequestFilterSensitiveLog: (
  obj: ListAppInstanceBotsRequest
) => any;
export declare const ListAppInstanceBotsResponseFilterSensitiveLog: (
  obj: ListAppInstanceBotsResponse
) => any;
export declare const ListAppInstancesRequestFilterSensitiveLog: (
  obj: ListAppInstancesRequest
) => any;
export declare const ListAppInstancesResponseFilterSensitiveLog: (
  obj: ListAppInstancesResponse
) => any;
export declare const ListAppInstanceUserEndpointsRequestFilterSensitiveLog: (
  obj: ListAppInstanceUserEndpointsRequest
) => any;
export declare const ListAppInstanceUserEndpointsResponseFilterSensitiveLog: (
  obj: ListAppInstanceUserEndpointsResponse
) => any;
export declare const ListAppInstanceUsersRequestFilterSensitiveLog: (
  obj: ListAppInstanceUsersRequest
) => any;
export declare const ListAppInstanceUsersResponseFilterSensitiveLog: (
  obj: ListAppInstanceUsersResponse
) => any;
export declare const ListTagsForResourceResponseFilterSensitiveLog: (
  obj: ListTagsForResourceResponse
) => any;
export declare const RegisterAppInstanceUserEndpointRequestFilterSensitiveLog: (
  obj: RegisterAppInstanceUserEndpointRequest
) => any;
export declare const TagResourceRequestFilterSensitiveLog: (
  obj: TagResourceRequest
) => any;
export declare const UntagResourceRequestFilterSensitiveLog: (
  obj: UntagResourceRequest
) => any;
export declare const UpdateAppInstanceRequestFilterSensitiveLog: (
  obj: UpdateAppInstanceRequest
) => any;
export declare const UpdateAppInstanceBotRequestFilterSensitiveLog: (
  obj: UpdateAppInstanceBotRequest
) => any;
export declare const UpdateAppInstanceUserRequestFilterSensitiveLog: (
  obj: UpdateAppInstanceUserRequest
) => any;
export declare const UpdateAppInstanceUserEndpointRequestFilterSensitiveLog: (
  obj: UpdateAppInstanceUserEndpointRequest
) => any;
