"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaPipelineStatusUpdate = exports.ConflictException = exports.LiveConnectorSourceType = exports.LiveConnectorMuxType = exports.LiveConnectorSinkType = exports.RealTimeAlertRuleType = exports.SentimentType = exports.VoiceAnalyticsConfigurationStatus = exports.MediaInsightsPipelineConfigurationElementType = exports.NotFoundException = exports.RecordingFileFormat = exports.MediaEncoding = exports.FragmentSelectorType = exports.ConcatenationSourceType = exports.ConcatenationSinkType = exports.UnauthorizedClientException = exports.ThrottledClientException = exports.ServiceUnavailableException = exports.ServiceFailureException = exports.ResourceLimitExceededException = exports.ForbiddenException = exports.MediaPipelineStatus = exports.MediaPipelineSourceType = exports.MediaPipelineSinkType = exports.ParticipantRole = exports.BadRequestException = exports.ErrorCode = exports.AudioChannelsOption = exports.VideoMuxType = exports.ArtifactsState = exports.ContentMuxType = exports.ResolutionOption = exports.LayoutOption = exports.HighlightColor = exports.BorderColor = exports.VerticalTilePosition = exports.PresenterPosition = exports.HorizontalTilePosition = exports.TileOrder = exports.ContentShareLayoutOption = exports.CanvasOrientation = exports.AudioMuxType = exports.ArtifactsConcatenationState = exports.AudioArtifactsConcatenationState = exports.VocabularyFilterMethod = exports.ContentRedactionOutput = exports.PartialResultsStability = exports.CallAnalyticsLanguageCode = exports.ContentType = exports.ActiveSpeakerPosition = void 0;
exports.UpdateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = exports.UpdateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = exports.ListMediaInsightsPipelineConfigurationsResponseFilterSensitiveLog = exports.MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog = exports.GetMediaPipelineResponseFilterSensitiveLog = exports.MediaPipelineFilterSensitiveLog = exports.GetMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = exports.GetMediaCapturePipelineResponseFilterSensitiveLog = exports.CreateMediaLiveConnectorPipelineResponseFilterSensitiveLog = exports.MediaLiveConnectorPipelineFilterSensitiveLog = exports.CreateMediaLiveConnectorPipelineRequestFilterSensitiveLog = exports.LiveConnectorSourceConfigurationFilterSensitiveLog = exports.ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog = exports.LiveConnectorSinkConfigurationFilterSensitiveLog = exports.LiveConnectorRTMPConfigurationFilterSensitiveLog = exports.CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = exports.MediaInsightsPipelineConfigurationFilterSensitiveLog = exports.CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = exports.MediaInsightsPipelineConfigurationElementFilterSensitiveLog = exports.SqsQueueSinkConfigurationFilterSensitiveLog = exports.SnsTopicSinkConfigurationFilterSensitiveLog = exports.S3RecordingSinkConfigurationFilterSensitiveLog = exports.LambdaFunctionSinkConfigurationFilterSensitiveLog = exports.KinesisDataStreamSinkConfigurationFilterSensitiveLog = exports.CreateMediaInsightsPipelineResponseFilterSensitiveLog = exports.MediaInsightsPipelineFilterSensitiveLog = exports.CreateMediaInsightsPipelineRequestFilterSensitiveLog = exports.S3RecordingSinkRuntimeConfigurationFilterSensitiveLog = exports.CreateMediaConcatenationPipelineResponseFilterSensitiveLog = exports.MediaConcatenationPipelineFilterSensitiveLog = exports.CreateMediaConcatenationPipelineRequestFilterSensitiveLog = exports.ConcatenationSourceFilterSensitiveLog = exports.MediaCapturePipelineSourceConfigurationFilterSensitiveLog = exports.ConcatenationSinkFilterSensitiveLog = exports.S3BucketSinkConfigurationFilterSensitiveLog = exports.CreateMediaCapturePipelineResponseFilterSensitiveLog = exports.MediaCapturePipelineFilterSensitiveLog = exports.CreateMediaCapturePipelineRequestFilterSensitiveLog = exports.ChimeSdkMeetingConfigurationFilterSensitiveLog = exports.SourceConfigurationFilterSensitiveLog = exports.SelectedVideoStreamsFilterSensitiveLog = void 0;
const smithy_client_1 = require("@smithy/smithy-client");
const ChimeSDKMediaPipelinesServiceException_1 = require("./ChimeSDKMediaPipelinesServiceException");
exports.ActiveSpeakerPosition = {
    BottomLeft: "BottomLeft",
    BottomRight: "BottomRight",
    TopLeft: "TopLeft",
    TopRight: "TopRight",
};
exports.ContentType = {
    PII: "PII",
};
exports.CallAnalyticsLanguageCode = {
    DE_DE: "de-DE",
    EN_AU: "en-AU",
    EN_GB: "en-GB",
    EN_US: "en-US",
    ES_US: "es-US",
    FR_CA: "fr-CA",
    FR_FR: "fr-FR",
    IT_IT: "it-IT",
    PT_BR: "pt-BR",
};
exports.PartialResultsStability = {
    HIGH: "high",
    LOW: "low",
    MEDIUM: "medium",
};
exports.ContentRedactionOutput = {
    REDACTED: "redacted",
    REDACTED_AND_UNREDACTED: "redacted_and_unredacted",
};
exports.VocabularyFilterMethod = {
    MASK: "mask",
    REMOVE: "remove",
    TAG: "tag",
};
exports.AudioArtifactsConcatenationState = {
    Enabled: "Enabled",
};
exports.ArtifactsConcatenationState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
exports.AudioMuxType = {
    AudioOnly: "AudioOnly",
    AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo",
    AudioWithCompositedVideo: "AudioWithCompositedVideo",
};
exports.CanvasOrientation = {
    Landscape: "Landscape",
    Portrait: "Portrait",
};
exports.ContentShareLayoutOption = {
    ActiveSpeakerOnly: "ActiveSpeakerOnly",
    Horizontal: "Horizontal",
    PresenterOnly: "PresenterOnly",
    Vertical: "Vertical",
};
exports.TileOrder = {
    JoinSequence: "JoinSequence",
    SpeakerSequence: "SpeakerSequence",
};
exports.HorizontalTilePosition = {
    Bottom: "Bottom",
    Top: "Top",
};
exports.PresenterPosition = {
    BottomLeft: "BottomLeft",
    BottomRight: "BottomRight",
    TopLeft: "TopLeft",
    TopRight: "TopRight",
};
exports.VerticalTilePosition = {
    Left: "Left",
    Right: "Right",
};
exports.BorderColor = {
    Black: "Black",
    Blue: "Blue",
    Green: "Green",
    Red: "Red",
    White: "White",
    Yellow: "Yellow",
};
exports.HighlightColor = {
    Black: "Black",
    Blue: "Blue",
    Green: "Green",
    Red: "Red",
    White: "White",
    Yellow: "Yellow",
};
exports.LayoutOption = {
    GridView: "GridView",
};
exports.ResolutionOption = {
    FHD: "FHD",
    HD: "HD",
};
exports.ContentMuxType = {
    ContentOnly: "ContentOnly",
};
exports.ArtifactsState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
exports.VideoMuxType = {
    VideoOnly: "VideoOnly",
};
exports.AudioChannelsOption = {
    Mono: "Mono",
    Stereo: "Stereo",
};
exports.ErrorCode = {
    BadRequest: "BadRequest",
    Forbidden: "Forbidden",
    NotFound: "NotFound",
    ResourceLimitExceeded: "ResourceLimitExceeded",
    ServiceFailure: "ServiceFailure",
    ServiceUnavailable: "ServiceUnavailable",
    Throttling: "Throttling",
};
class BadRequestException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "BadRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BadRequestException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.BadRequestException = BadRequestException;
exports.ParticipantRole = {
    AGENT: "AGENT",
    CUSTOMER: "CUSTOMER",
};
exports.MediaPipelineSinkType = {
    S3Bucket: "S3Bucket",
};
exports.MediaPipelineSourceType = {
    ChimeSdkMeeting: "ChimeSdkMeeting",
};
exports.MediaPipelineStatus = {
    Failed: "Failed",
    InProgress: "InProgress",
    Initializing: "Initializing",
    Paused: "Paused",
    Stopped: "Stopped",
    Stopping: "Stopping",
};
class ForbiddenException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "ForbiddenException",
            $fault: "client",
            ...opts,
        });
        this.name = "ForbiddenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ForbiddenException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.ForbiddenException = ForbiddenException;
class ResourceLimitExceededException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.ResourceLimitExceededException = ResourceLimitExceededException;
class ServiceFailureException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.ServiceFailureException = ServiceFailureException;
class ServiceUnavailableException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.ServiceUnavailableException = ServiceUnavailableException;
class ThrottledClientException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "ThrottledClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottledClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottledClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.ThrottledClientException = ThrottledClientException;
class UnauthorizedClientException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "UnauthorizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnauthorizedClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.UnauthorizedClientException = UnauthorizedClientException;
exports.ConcatenationSinkType = {
    S3Bucket: "S3Bucket",
};
exports.ConcatenationSourceType = {
    MediaCapturePipeline: "MediaCapturePipeline",
};
exports.FragmentSelectorType = {
    ProducerTimestamp: "ProducerTimestamp",
    ServerTimestamp: "ServerTimestamp",
};
exports.MediaEncoding = {
    PCM: "pcm",
};
exports.RecordingFileFormat = {
    Opus: "Opus",
    Wav: "Wav",
};
class NotFoundException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "NotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NotFoundException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.NotFoundException = NotFoundException;
exports.MediaInsightsPipelineConfigurationElementType = {
    AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR: "AmazonTranscribeCallAnalyticsProcessor",
    AMAZON_TRANSCRIBE_PROCESSOR: "AmazonTranscribeProcessor",
    KINESIS_DATA_STREAM_SINK: "KinesisDataStreamSink",
    LAMBDA_FUNCTION_SINK: "LambdaFunctionSink",
    S3_RECORDING_SINK: "S3RecordingSink",
    SNS_TOPIC_SINK: "SnsTopicSink",
    SQS_QUEUE_SINK: "SqsQueueSink",
    VOICE_ANALYTICS_PROCESSOR: "VoiceAnalyticsProcessor",
};
exports.VoiceAnalyticsConfigurationStatus = {
    DISABLED: "Disabled",
    ENABLED: "Enabled",
};
exports.SentimentType = {
    NEGATIVE: "NEGATIVE",
};
exports.RealTimeAlertRuleType = {
    IssueDetection: "IssueDetection",
    KeywordMatch: "KeywordMatch",
    Sentiment: "Sentiment",
};
exports.LiveConnectorSinkType = {
    RTMP: "RTMP",
};
exports.LiveConnectorMuxType = {
    AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo",
    AudioWithCompositedVideo: "AudioWithCompositedVideo",
};
exports.LiveConnectorSourceType = {
    ChimeSdkMeeting: "ChimeSdkMeeting",
};
class ConflictException extends ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException {
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
exports.ConflictException = ConflictException;
exports.MediaPipelineStatusUpdate = {
    Pause: "Pause",
    Resume: "Resume",
};
const SelectedVideoStreamsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserIds && { ExternalUserIds: smithy_client_1.SENSITIVE_STRING }),
});
exports.SelectedVideoStreamsFilterSensitiveLog = SelectedVideoStreamsFilterSensitiveLog;
const SourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SelectedVideoStreams && {
        SelectedVideoStreams: (0, exports.SelectedVideoStreamsFilterSensitiveLog)(obj.SelectedVideoStreams),
    }),
});
exports.SourceConfigurationFilterSensitiveLog = SourceConfigurationFilterSensitiveLog;
const ChimeSdkMeetingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceConfiguration && {
        SourceConfiguration: (0, exports.SourceConfigurationFilterSensitiveLog)(obj.SourceConfiguration),
    }),
});
exports.ChimeSdkMeetingConfigurationFilterSensitiveLog = ChimeSdkMeetingConfigurationFilterSensitiveLog;
const CreateMediaCapturePipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: (0, exports.ChimeSdkMeetingConfigurationFilterSensitiveLog)(obj.ChimeSdkMeetingConfiguration),
    }),
});
exports.CreateMediaCapturePipelineRequestFilterSensitiveLog = CreateMediaCapturePipelineRequestFilterSensitiveLog;
const MediaCapturePipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: (0, exports.ChimeSdkMeetingConfigurationFilterSensitiveLog)(obj.ChimeSdkMeetingConfiguration),
    }),
});
exports.MediaCapturePipelineFilterSensitiveLog = MediaCapturePipelineFilterSensitiveLog;
const CreateMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: (0, exports.MediaCapturePipelineFilterSensitiveLog)(obj.MediaCapturePipeline),
    }),
});
exports.CreateMediaCapturePipelineResponseFilterSensitiveLog = CreateMediaCapturePipelineResponseFilterSensitiveLog;
const S3BucketSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Destination && { Destination: smithy_client_1.SENSITIVE_STRING }),
});
exports.S3BucketSinkConfigurationFilterSensitiveLog = S3BucketSinkConfigurationFilterSensitiveLog;
const ConcatenationSinkFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.S3BucketSinkConfiguration && {
        S3BucketSinkConfiguration: (0, exports.S3BucketSinkConfigurationFilterSensitiveLog)(obj.S3BucketSinkConfiguration),
    }),
});
exports.ConcatenationSinkFilterSensitiveLog = ConcatenationSinkFilterSensitiveLog;
const MediaCapturePipelineSourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaPipelineArn && { MediaPipelineArn: smithy_client_1.SENSITIVE_STRING }),
});
exports.MediaCapturePipelineSourceConfigurationFilterSensitiveLog = MediaCapturePipelineSourceConfigurationFilterSensitiveLog;
const ConcatenationSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipelineSourceConfiguration && {
        MediaCapturePipelineSourceConfiguration: (0, exports.MediaCapturePipelineSourceConfigurationFilterSensitiveLog)(obj.MediaCapturePipelineSourceConfiguration),
    }),
});
exports.ConcatenationSourceFilterSensitiveLog = ConcatenationSourceFilterSensitiveLog;
const CreateMediaConcatenationPipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, exports.ConcatenationSourceFilterSensitiveLog)(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => (0, exports.ConcatenationSinkFilterSensitiveLog)(item)) }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateMediaConcatenationPipelineRequestFilterSensitiveLog = CreateMediaConcatenationPipelineRequestFilterSensitiveLog;
const MediaConcatenationPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, exports.ConcatenationSourceFilterSensitiveLog)(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => (0, exports.ConcatenationSinkFilterSensitiveLog)(item)) }),
});
exports.MediaConcatenationPipelineFilterSensitiveLog = MediaConcatenationPipelineFilterSensitiveLog;
const CreateMediaConcatenationPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaConcatenationPipeline && {
        MediaConcatenationPipeline: (0, exports.MediaConcatenationPipelineFilterSensitiveLog)(obj.MediaConcatenationPipeline),
    }),
});
exports.CreateMediaConcatenationPipelineResponseFilterSensitiveLog = CreateMediaConcatenationPipelineResponseFilterSensitiveLog;
const S3RecordingSinkRuntimeConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Destination && { Destination: smithy_client_1.SENSITIVE_STRING }),
});
exports.S3RecordingSinkRuntimeConfigurationFilterSensitiveLog = S3RecordingSinkRuntimeConfigurationFilterSensitiveLog;
const CreateMediaInsightsPipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.MediaInsightsRuntimeMetadata && { MediaInsightsRuntimeMetadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.S3RecordingSinkRuntimeConfiguration && {
        S3RecordingSinkRuntimeConfiguration: (0, exports.S3RecordingSinkRuntimeConfigurationFilterSensitiveLog)(obj.S3RecordingSinkRuntimeConfiguration),
    }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateMediaInsightsPipelineRequestFilterSensitiveLog = CreateMediaInsightsPipelineRequestFilterSensitiveLog;
const MediaInsightsPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaPipelineArn && { MediaPipelineArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.MediaInsightsRuntimeMetadata && { MediaInsightsRuntimeMetadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.S3RecordingSinkRuntimeConfiguration && {
        S3RecordingSinkRuntimeConfiguration: (0, exports.S3RecordingSinkRuntimeConfigurationFilterSensitiveLog)(obj.S3RecordingSinkRuntimeConfiguration),
    }),
});
exports.MediaInsightsPipelineFilterSensitiveLog = MediaInsightsPipelineFilterSensitiveLog;
const CreateMediaInsightsPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipeline && {
        MediaInsightsPipeline: (0, exports.MediaInsightsPipelineFilterSensitiveLog)(obj.MediaInsightsPipeline),
    }),
});
exports.CreateMediaInsightsPipelineResponseFilterSensitiveLog = CreateMediaInsightsPipelineResponseFilterSensitiveLog;
const KinesisDataStreamSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: smithy_client_1.SENSITIVE_STRING }),
});
exports.KinesisDataStreamSinkConfigurationFilterSensitiveLog = KinesisDataStreamSinkConfigurationFilterSensitiveLog;
const LambdaFunctionSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: smithy_client_1.SENSITIVE_STRING }),
});
exports.LambdaFunctionSinkConfigurationFilterSensitiveLog = LambdaFunctionSinkConfigurationFilterSensitiveLog;
const S3RecordingSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Destination && { Destination: smithy_client_1.SENSITIVE_STRING }),
});
exports.S3RecordingSinkConfigurationFilterSensitiveLog = S3RecordingSinkConfigurationFilterSensitiveLog;
const SnsTopicSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: smithy_client_1.SENSITIVE_STRING }),
});
exports.SnsTopicSinkConfigurationFilterSensitiveLog = SnsTopicSinkConfigurationFilterSensitiveLog;
const SqsQueueSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: smithy_client_1.SENSITIVE_STRING }),
});
exports.SqsQueueSinkConfigurationFilterSensitiveLog = SqsQueueSinkConfigurationFilterSensitiveLog;
const MediaInsightsPipelineConfigurationElementFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.KinesisDataStreamSinkConfiguration && {
        KinesisDataStreamSinkConfiguration: (0, exports.KinesisDataStreamSinkConfigurationFilterSensitiveLog)(obj.KinesisDataStreamSinkConfiguration),
    }),
    ...(obj.S3RecordingSinkConfiguration && {
        S3RecordingSinkConfiguration: (0, exports.S3RecordingSinkConfigurationFilterSensitiveLog)(obj.S3RecordingSinkConfiguration),
    }),
    ...(obj.LambdaFunctionSinkConfiguration && {
        LambdaFunctionSinkConfiguration: (0, exports.LambdaFunctionSinkConfigurationFilterSensitiveLog)(obj.LambdaFunctionSinkConfiguration),
    }),
    ...(obj.SqsQueueSinkConfiguration && {
        SqsQueueSinkConfiguration: (0, exports.SqsQueueSinkConfigurationFilterSensitiveLog)(obj.SqsQueueSinkConfiguration),
    }),
    ...(obj.SnsTopicSinkConfiguration && {
        SnsTopicSinkConfiguration: (0, exports.SnsTopicSinkConfigurationFilterSensitiveLog)(obj.SnsTopicSinkConfiguration),
    }),
});
exports.MediaInsightsPipelineConfigurationElementFilterSensitiveLog = MediaInsightsPipelineConfigurationElementFilterSensitiveLog;
const CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceAccessRoleArn && { ResourceAccessRoleArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Elements && {
        Elements: obj.Elements.map((item) => (0, exports.MediaInsightsPipelineConfigurationElementFilterSensitiveLog)(item)),
    }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog;
const MediaInsightsPipelineConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ResourceAccessRoleArn && { ResourceAccessRoleArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Elements && {
        Elements: obj.Elements.map((item) => (0, exports.MediaInsightsPipelineConfigurationElementFilterSensitiveLog)(item)),
    }),
});
exports.MediaInsightsPipelineConfigurationFilterSensitiveLog = MediaInsightsPipelineConfigurationFilterSensitiveLog;
const CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfiguration && {
        MediaInsightsPipelineConfiguration: (0, exports.MediaInsightsPipelineConfigurationFilterSensitiveLog)(obj.MediaInsightsPipelineConfiguration),
    }),
});
exports.CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog;
const LiveConnectorRTMPConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: smithy_client_1.SENSITIVE_STRING }),
});
exports.LiveConnectorRTMPConfigurationFilterSensitiveLog = LiveConnectorRTMPConfigurationFilterSensitiveLog;
const LiveConnectorSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RTMPConfiguration && {
        RTMPConfiguration: (0, exports.LiveConnectorRTMPConfigurationFilterSensitiveLog)(obj.RTMPConfiguration),
    }),
});
exports.LiveConnectorSinkConfigurationFilterSensitiveLog = LiveConnectorSinkConfigurationFilterSensitiveLog;
const ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Arn && { Arn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SourceConfiguration && {
        SourceConfiguration: (0, exports.SourceConfigurationFilterSensitiveLog)(obj.SourceConfiguration),
    }),
});
exports.ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog = ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog;
const LiveConnectorSourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChimeSdkMeetingLiveConnectorConfiguration && {
        ChimeSdkMeetingLiveConnectorConfiguration: (0, exports.ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog)(obj.ChimeSdkMeetingLiveConnectorConfiguration),
    }),
});
exports.LiveConnectorSourceConfigurationFilterSensitiveLog = LiveConnectorSourceConfigurationFilterSensitiveLog;
const CreateMediaLiveConnectorPipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, exports.LiveConnectorSourceConfigurationFilterSensitiveLog)(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => (0, exports.LiveConnectorSinkConfigurationFilterSensitiveLog)(item)) }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateMediaLiveConnectorPipelineRequestFilterSensitiveLog = CreateMediaLiveConnectorPipelineRequestFilterSensitiveLog;
const MediaLiveConnectorPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, exports.LiveConnectorSourceConfigurationFilterSensitiveLog)(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => (0, exports.LiveConnectorSinkConfigurationFilterSensitiveLog)(item)) }),
});
exports.MediaLiveConnectorPipelineFilterSensitiveLog = MediaLiveConnectorPipelineFilterSensitiveLog;
const CreateMediaLiveConnectorPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaLiveConnectorPipeline && {
        MediaLiveConnectorPipeline: (0, exports.MediaLiveConnectorPipelineFilterSensitiveLog)(obj.MediaLiveConnectorPipeline),
    }),
});
exports.CreateMediaLiveConnectorPipelineResponseFilterSensitiveLog = CreateMediaLiveConnectorPipelineResponseFilterSensitiveLog;
const GetMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: (0, exports.MediaCapturePipelineFilterSensitiveLog)(obj.MediaCapturePipeline),
    }),
});
exports.GetMediaCapturePipelineResponseFilterSensitiveLog = GetMediaCapturePipelineResponseFilterSensitiveLog;
const GetMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfiguration && {
        MediaInsightsPipelineConfiguration: (0, exports.MediaInsightsPipelineConfigurationFilterSensitiveLog)(obj.MediaInsightsPipelineConfiguration),
    }),
});
exports.GetMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = GetMediaInsightsPipelineConfigurationResponseFilterSensitiveLog;
const MediaPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: (0, exports.MediaCapturePipelineFilterSensitiveLog)(obj.MediaCapturePipeline),
    }),
    ...(obj.MediaLiveConnectorPipeline && {
        MediaLiveConnectorPipeline: (0, exports.MediaLiveConnectorPipelineFilterSensitiveLog)(obj.MediaLiveConnectorPipeline),
    }),
    ...(obj.MediaConcatenationPipeline && {
        MediaConcatenationPipeline: (0, exports.MediaConcatenationPipelineFilterSensitiveLog)(obj.MediaConcatenationPipeline),
    }),
    ...(obj.MediaInsightsPipeline && {
        MediaInsightsPipeline: (0, exports.MediaInsightsPipelineFilterSensitiveLog)(obj.MediaInsightsPipeline),
    }),
});
exports.MediaPipelineFilterSensitiveLog = MediaPipelineFilterSensitiveLog;
const GetMediaPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaPipeline && { MediaPipeline: (0, exports.MediaPipelineFilterSensitiveLog)(obj.MediaPipeline) }),
});
exports.GetMediaPipelineResponseFilterSensitiveLog = GetMediaPipelineResponseFilterSensitiveLog;
const MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: smithy_client_1.SENSITIVE_STRING }),
});
exports.MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog = MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog;
const ListMediaInsightsPipelineConfigurationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurations && {
        MediaInsightsPipelineConfigurations: obj.MediaInsightsPipelineConfigurations.map((item) => (0, exports.MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog)(item)),
    }),
});
exports.ListMediaInsightsPipelineConfigurationsResponseFilterSensitiveLog = ListMediaInsightsPipelineConfigurationsResponseFilterSensitiveLog;
const UpdateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceAccessRoleArn && { ResourceAccessRoleArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Elements && {
        Elements: obj.Elements.map((item) => (0, exports.MediaInsightsPipelineConfigurationElementFilterSensitiveLog)(item)),
    }),
});
exports.UpdateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = UpdateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog;
const UpdateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfiguration && {
        MediaInsightsPipelineConfiguration: (0, exports.MediaInsightsPipelineConfigurationFilterSensitiveLog)(obj.MediaInsightsPipelineConfiguration),
    }),
});
exports.UpdateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = UpdateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog;
