"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListMediaCapturePipelines = void 0;
const ChimeSDKMediaPipelinesClient_1 = require("../ChimeSDKMediaPipelinesClient");
const ListMediaCapturePipelinesCommand_1 = require("../commands/ListMediaCapturePipelinesCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListMediaCapturePipelinesCommand_1.ListMediaCapturePipelinesCommand(input), ...args);
};
async function* paginateListMediaCapturePipelines(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMediaPipelinesClient_1.ChimeSDKMediaPipelinesClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMediaPipelines | ChimeSDKMediaPipelinesClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListMediaCapturePipelines = paginateListMediaCapturePipelines;
