"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListMediaInsightsPipelineConfigurations = void 0;
const ChimeSDKMediaPipelinesClient_1 = require("../ChimeSDKMediaPipelinesClient");
const ListMediaInsightsPipelineConfigurationsCommand_1 = require("../commands/ListMediaInsightsPipelineConfigurationsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListMediaInsightsPipelineConfigurationsCommand_1.ListMediaInsightsPipelineConfigurationsCommand(input), ...args);
};
async function* paginateListMediaInsightsPipelineConfigurations(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMediaPipelinesClient_1.ChimeSDKMediaPipelinesClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMediaPipelines | ChimeSDKMediaPipelinesClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListMediaInsightsPipelineConfigurations = paginateListMediaInsightsPipelineConfigurations;
