"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListMediaPipelines = void 0;
const ChimeSDKMediaPipelinesClient_1 = require("../ChimeSDKMediaPipelinesClient");
const ListMediaPipelinesCommand_1 = require("../commands/ListMediaPipelinesCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListMediaPipelinesCommand_1.ListMediaPipelinesCommand(input), ...args);
};
async function* paginateListMediaPipelines(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMediaPipelinesClient_1.ChimeSDKMediaPipelinesClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMediaPipelines | ChimeSDKMediaPipelinesClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListMediaPipelines = paginateListMediaPipelines;
