"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.de_UpdateMediaInsightsPipelineStatusCommand = exports.de_UpdateMediaInsightsPipelineConfigurationCommand = exports.de_UntagResourceCommand = exports.de_TagResourceCommand = exports.de_ListTagsForResourceCommand = exports.de_ListMediaPipelinesCommand = exports.de_ListMediaInsightsPipelineConfigurationsCommand = exports.de_ListMediaCapturePipelinesCommand = exports.de_GetMediaPipelineCommand = exports.de_GetMediaInsightsPipelineConfigurationCommand = exports.de_GetMediaCapturePipelineCommand = exports.de_DeleteMediaPipelineCommand = exports.de_DeleteMediaInsightsPipelineConfigurationCommand = exports.de_DeleteMediaCapturePipelineCommand = exports.de_CreateMediaLiveConnectorPipelineCommand = exports.de_CreateMediaInsightsPipelineConfigurationCommand = exports.de_CreateMediaInsightsPipelineCommand = exports.de_CreateMediaConcatenationPipelineCommand = exports.de_CreateMediaCapturePipelineCommand = exports.se_UpdateMediaInsightsPipelineStatusCommand = exports.se_UpdateMediaInsightsPipelineConfigurationCommand = exports.se_UntagResourceCommand = exports.se_TagResourceCommand = exports.se_ListTagsForResourceCommand = exports.se_ListMediaPipelinesCommand = exports.se_ListMediaInsightsPipelineConfigurationsCommand = exports.se_ListMediaCapturePipelinesCommand = exports.se_GetMediaPipelineCommand = exports.se_GetMediaInsightsPipelineConfigurationCommand = exports.se_GetMediaCapturePipelineCommand = exports.se_DeleteMediaPipelineCommand = exports.se_DeleteMediaInsightsPipelineConfigurationCommand = exports.se_DeleteMediaCapturePipelineCommand = exports.se_CreateMediaLiveConnectorPipelineCommand = exports.se_CreateMediaInsightsPipelineConfigurationCommand = exports.se_CreateMediaInsightsPipelineCommand = exports.se_CreateMediaConcatenationPipelineCommand = exports.se_CreateMediaCapturePipelineCommand = void 0;
const protocol_http_1 = require("@smithy/protocol-http");
const smithy_client_1 = require("@smithy/smithy-client");
const uuid_1 = require("uuid");
const ChimeSDKMediaPipelinesServiceException_1 = require("../models/ChimeSDKMediaPipelinesServiceException");
const models_0_1 = require("../models/models_0");
const se_CreateMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-capture-pipelines";
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ChimeSdkMeetingConfiguration: (_) => (0, smithy_client_1._json)(_),
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        SinkArn: [],
        SinkType: [],
        SourceArn: [],
        SourceType: [],
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateMediaCapturePipelineCommand = se_CreateMediaCapturePipelineCommand;
const se_CreateMediaConcatenationPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-concatenation-pipelines";
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        Sinks: (_) => (0, smithy_client_1._json)(_),
        Sources: (_) => (0, smithy_client_1._json)(_),
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateMediaConcatenationPipelineCommand = se_CreateMediaConcatenationPipelineCommand;
const se_CreateMediaInsightsPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipelines";
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        KinesisVideoStreamRecordingSourceRuntimeConfiguration: (_) => se_KinesisVideoStreamRecordingSourceRuntimeConfiguration(_, context),
        KinesisVideoStreamSourceRuntimeConfiguration: (_) => (0, smithy_client_1._json)(_),
        MediaInsightsPipelineConfigurationArn: [],
        MediaInsightsRuntimeMetadata: (_) => (0, smithy_client_1._json)(_),
        S3RecordingSinkRuntimeConfiguration: (_) => (0, smithy_client_1._json)(_),
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateMediaInsightsPipelineCommand = se_CreateMediaInsightsPipelineCommand;
const se_CreateMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipeline-configurations";
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        Elements: (_) => (0, smithy_client_1._json)(_),
        MediaInsightsPipelineConfigurationName: [],
        RealTimeAlertConfiguration: (_) => (0, smithy_client_1._json)(_),
        ResourceAccessRoleArn: [],
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateMediaInsightsPipelineConfigurationCommand = se_CreateMediaInsightsPipelineConfigurationCommand;
const se_CreateMediaLiveConnectorPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-live-connector-pipelines";
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        Sinks: (_) => (0, smithy_client_1._json)(_),
        Sources: (_) => (0, smithy_client_1._json)(_),
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateMediaLiveConnectorPipelineCommand = se_CreateMediaLiveConnectorPipelineCommand;
const se_DeleteMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sdk-media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteMediaCapturePipelineCommand = se_DeleteMediaCapturePipelineCommand;
const se_DeleteMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteMediaInsightsPipelineConfigurationCommand = se_DeleteMediaInsightsPipelineConfigurationCommand;
const se_DeleteMediaPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteMediaPipelineCommand = se_DeleteMediaPipelineCommand;
const se_GetMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sdk-media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_GetMediaCapturePipelineCommand = se_GetMediaCapturePipelineCommand;
const se_GetMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_GetMediaInsightsPipelineConfigurationCommand = se_GetMediaInsightsPipelineConfigurationCommand;
const se_GetMediaPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines/{MediaPipelineId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_GetMediaPipelineCommand = se_GetMediaPipelineCommand;
const se_ListMediaCapturePipelinesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-capture-pipelines";
    const query = (0, smithy_client_1.map)({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListMediaCapturePipelinesCommand = se_ListMediaCapturePipelinesCommand;
const se_ListMediaInsightsPipelineConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipeline-configurations";
    const query = (0, smithy_client_1.map)({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListMediaInsightsPipelineConfigurationsCommand = se_ListMediaInsightsPipelineConfigurationsCommand;
const se_ListMediaPipelinesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines";
    const query = (0, smithy_client_1.map)({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListMediaPipelinesCommand = se_ListMediaPipelinesCommand;
const se_ListTagsForResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = (0, smithy_client_1.map)({
        arn: [, (0, smithy_client_1.expectNonNull)(input.ResourceARN, `ResourceARN`)],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListTagsForResourceCommand = se_ListTagsForResourceCommand;
const se_TagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = (0, smithy_client_1.map)({
        operation: [, "tag-resource"],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ResourceARN: [],
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_TagResourceCommand = se_TagResourceCommand;
const se_UntagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = (0, smithy_client_1.map)({
        operation: [, "untag-resource"],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ResourceARN: [],
        TagKeys: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_UntagResourceCommand = se_UntagResourceCommand;
const se_UpdateMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        Elements: (_) => (0, smithy_client_1._json)(_),
        RealTimeAlertConfiguration: (_) => (0, smithy_client_1._json)(_),
        ResourceAccessRoleArn: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_UpdateMediaInsightsPipelineConfigurationCommand = se_UpdateMediaInsightsPipelineConfigurationCommand;
const se_UpdateMediaInsightsPipelineStatusCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-status/{Identifier}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        UpdateStatus: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_UpdateMediaInsightsPipelineStatusCommand = se_UpdateMediaInsightsPipelineStatusCommand;
const de_CreateMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaCapturePipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaCapturePipeline: (_) => de_MediaCapturePipeline(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateMediaCapturePipelineCommand = de_CreateMediaCapturePipelineCommand;
const de_CreateMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateMediaConcatenationPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaConcatenationPipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaConcatenationPipeline: (_) => de_MediaConcatenationPipeline(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateMediaConcatenationPipelineCommand = de_CreateMediaConcatenationPipelineCommand;
const de_CreateMediaConcatenationPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateMediaInsightsPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaInsightsPipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaInsightsPipeline: (_) => de_MediaInsightsPipeline(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateMediaInsightsPipelineCommand = de_CreateMediaInsightsPipelineCommand;
const de_CreateMediaInsightsPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaInsightsPipelineConfiguration: (_) => de_MediaInsightsPipelineConfiguration(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateMediaInsightsPipelineConfigurationCommand = de_CreateMediaInsightsPipelineConfigurationCommand;
const de_CreateMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateMediaLiveConnectorPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaLiveConnectorPipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaLiveConnectorPipeline: (_) => de_MediaLiveConnectorPipeline(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateMediaLiveConnectorPipelineCommand = de_CreateMediaLiveConnectorPipelineCommand;
const de_CreateMediaLiveConnectorPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteMediaCapturePipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteMediaCapturePipelineCommand = de_DeleteMediaCapturePipelineCommand;
const de_DeleteMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteMediaInsightsPipelineConfigurationCommand = de_DeleteMediaInsightsPipelineConfigurationCommand;
const de_DeleteMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteMediaPipelineCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteMediaPipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteMediaPipelineCommand = de_DeleteMediaPipelineCommand;
const de_DeleteMediaPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMediaCapturePipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaCapturePipeline: (_) => de_MediaCapturePipeline(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetMediaCapturePipelineCommand = de_GetMediaCapturePipelineCommand;
const de_GetMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaInsightsPipelineConfiguration: (_) => de_MediaInsightsPipelineConfiguration(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetMediaInsightsPipelineConfigurationCommand = de_GetMediaInsightsPipelineConfigurationCommand;
const de_GetMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetMediaPipelineCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMediaPipelineCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaPipeline: (_) => de_MediaPipeline(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetMediaPipelineCommand = de_GetMediaPipelineCommand;
const de_GetMediaPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListMediaCapturePipelinesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListMediaCapturePipelinesCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaCapturePipelines: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListMediaCapturePipelinesCommand = de_ListMediaCapturePipelinesCommand;
const de_ListMediaCapturePipelinesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListMediaInsightsPipelineConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListMediaInsightsPipelineConfigurationsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaInsightsPipelineConfigurations: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListMediaInsightsPipelineConfigurationsCommand = de_ListMediaInsightsPipelineConfigurationsCommand;
const de_ListMediaInsightsPipelineConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListMediaPipelinesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListMediaPipelinesCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaPipelines: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListMediaPipelinesCommand = de_ListMediaPipelinesCommand;
const de_ListMediaPipelinesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListTagsForResourceCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Tags: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListTagsForResourceCommand = de_ListTagsForResourceCommand;
const de_ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_TagResourceCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_TagResourceCommand = de_TagResourceCommand;
const de_TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_UntagResourceCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_UntagResourceCommand = de_UntagResourceCommand;
const de_UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UpdateMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        MediaInsightsPipelineConfiguration: (_) => de_MediaInsightsPipelineConfiguration(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_UpdateMediaInsightsPipelineConfigurationCommand = de_UpdateMediaInsightsPipelineConfigurationCommand;
const de_UpdateMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UpdateMediaInsightsPipelineStatusCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateMediaInsightsPipelineStatusCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_UpdateMediaInsightsPipelineStatusCommand = de_UpdateMediaInsightsPipelineStatusCommand;
const de_UpdateMediaInsightsPipelineStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const throwDefaultError = (0, smithy_client_1.withBaseException)(ChimeSDKMediaPipelinesServiceException_1.ChimeSDKMediaPipelinesServiceException);
const de_BadRequestExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ConflictExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ForbiddenExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ForbiddenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_NotFoundExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ResourceLimitExceededExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ServiceFailureExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ServiceFailureException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ServiceUnavailableExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ThrottledClientExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ThrottledClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_UnauthorizedClientExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
        RequestId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const se_FragmentSelector = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        FragmentSelectorType: [],
        TimestampRange: (_) => se_TimestampRange(_, context),
    });
};
const se_KinesisVideoStreamRecordingSourceRuntimeConfiguration = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        FragmentSelector: (_) => se_FragmentSelector(_, context),
        Streams: smithy_client_1._json,
    });
};
const se_TimestampRange = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        EndTimestamp: (_) => Math.round(_.getTime() / 1000),
        StartTimestamp: (_) => Math.round(_.getTime() / 1000),
    });
};
const de_FragmentSelector = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        FragmentSelectorType: smithy_client_1.expectString,
        TimestampRange: (_) => de_TimestampRange(_, context),
    });
};
const de_KinesisVideoStreamRecordingSourceRuntimeConfiguration = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        FragmentSelector: (_) => de_FragmentSelector(_, context),
        Streams: smithy_client_1._json,
    });
};
const de_MediaCapturePipeline = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChimeSdkMeetingConfiguration: smithy_client_1._json,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
        MediaPipelineArn: smithy_client_1.expectString,
        MediaPipelineId: smithy_client_1.expectString,
        SinkArn: smithy_client_1.expectString,
        SinkType: smithy_client_1.expectString,
        SourceArn: smithy_client_1.expectString,
        SourceType: smithy_client_1.expectString,
        Status: smithy_client_1.expectString,
        UpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
    });
};
const de_MediaConcatenationPipeline = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
        MediaPipelineArn: smithy_client_1.expectString,
        MediaPipelineId: smithy_client_1.expectString,
        Sinks: smithy_client_1._json,
        Sources: smithy_client_1._json,
        Status: smithy_client_1.expectString,
        UpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
    });
};
const de_MediaInsightsPipeline = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
        KinesisVideoStreamRecordingSourceRuntimeConfiguration: (_) => de_KinesisVideoStreamRecordingSourceRuntimeConfiguration(_, context),
        KinesisVideoStreamSourceRuntimeConfiguration: smithy_client_1._json,
        MediaInsightsPipelineConfigurationArn: smithy_client_1.expectString,
        MediaInsightsRuntimeMetadata: smithy_client_1._json,
        MediaPipelineArn: smithy_client_1.expectString,
        MediaPipelineId: smithy_client_1.expectString,
        S3RecordingSinkRuntimeConfiguration: smithy_client_1._json,
        Status: smithy_client_1.expectString,
    });
};
const de_MediaInsightsPipelineConfiguration = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
        Elements: smithy_client_1._json,
        MediaInsightsPipelineConfigurationArn: smithy_client_1.expectString,
        MediaInsightsPipelineConfigurationId: smithy_client_1.expectString,
        MediaInsightsPipelineConfigurationName: smithy_client_1.expectString,
        RealTimeAlertConfiguration: smithy_client_1._json,
        ResourceAccessRoleArn: smithy_client_1.expectString,
        UpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
    });
};
const de_MediaLiveConnectorPipeline = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
        MediaPipelineArn: smithy_client_1.expectString,
        MediaPipelineId: smithy_client_1.expectString,
        Sinks: smithy_client_1._json,
        Sources: smithy_client_1._json,
        Status: smithy_client_1.expectString,
        UpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(_)),
    });
};
const de_MediaPipeline = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        MediaCapturePipeline: (_) => de_MediaCapturePipeline(_, context),
        MediaConcatenationPipeline: (_) => de_MediaConcatenationPipeline(_, context),
        MediaInsightsPipeline: (_) => de_MediaInsightsPipeline(_, context),
        MediaLiveConnectorPipeline: (_) => de_MediaLiveConnectorPipeline(_, context),
    });
};
const de_TimestampRange = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        EndTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        StartTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => (0, smithy_client_1.collectBody)(streamBody, context).then((body) => context.utf8Encoder(body));
const isSerializableHeaderValue = (value) => value !== undefined &&
    value !== null &&
    value !== "" &&
    (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) &&
    (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
