import { createAggregatedClient } from "@smithy/smithy-client";
import { ChimeSDKMediaPipelinesClient } from "./ChimeSDKMediaPipelinesClient";
import { CreateMediaCapturePipelineCommand, } from "./commands/CreateMediaCapturePipelineCommand";
import { CreateMediaConcatenationPipelineCommand, } from "./commands/CreateMediaConcatenationPipelineCommand";
import { CreateMediaInsightsPipelineCommand, } from "./commands/CreateMediaInsightsPipelineCommand";
import { CreateMediaInsightsPipelineConfigurationCommand, } from "./commands/CreateMediaInsightsPipelineConfigurationCommand";
import { CreateMediaLiveConnectorPipelineCommand, } from "./commands/CreateMediaLiveConnectorPipelineCommand";
import { DeleteMediaCapturePipelineCommand, } from "./commands/DeleteMediaCapturePipelineCommand";
import { DeleteMediaInsightsPipelineConfigurationCommand, } from "./commands/DeleteMediaInsightsPipelineConfigurationCommand";
import { DeleteMediaPipelineCommand, } from "./commands/DeleteMediaPipelineCommand";
import { GetMediaCapturePipelineCommand, } from "./commands/GetMediaCapturePipelineCommand";
import { GetMediaInsightsPipelineConfigurationCommand, } from "./commands/GetMediaInsightsPipelineConfigurationCommand";
import { GetMediaPipelineCommand, } from "./commands/GetMediaPipelineCommand";
import { ListMediaCapturePipelinesCommand, } from "./commands/ListMediaCapturePipelinesCommand";
import { ListMediaInsightsPipelineConfigurationsCommand, } from "./commands/ListMediaInsightsPipelineConfigurationsCommand";
import { ListMediaPipelinesCommand, } from "./commands/ListMediaPipelinesCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateMediaInsightsPipelineConfigurationCommand, } from "./commands/UpdateMediaInsightsPipelineConfigurationCommand";
import { UpdateMediaInsightsPipelineStatusCommand, } from "./commands/UpdateMediaInsightsPipelineStatusCommand";
const commands = {
    CreateMediaCapturePipelineCommand,
    CreateMediaConcatenationPipelineCommand,
    CreateMediaInsightsPipelineCommand,
    CreateMediaInsightsPipelineConfigurationCommand,
    CreateMediaLiveConnectorPipelineCommand,
    DeleteMediaCapturePipelineCommand,
    DeleteMediaInsightsPipelineConfigurationCommand,
    DeleteMediaPipelineCommand,
    GetMediaCapturePipelineCommand,
    GetMediaInsightsPipelineConfigurationCommand,
    GetMediaPipelineCommand,
    ListMediaCapturePipelinesCommand,
    ListMediaInsightsPipelineConfigurationsCommand,
    ListMediaPipelinesCommand,
    ListTagsForResourceCommand,
    TagResourceCommand,
    UntagResourceCommand,
    UpdateMediaInsightsPipelineConfigurationCommand,
    UpdateMediaInsightsPipelineStatusCommand,
};
export class ChimeSDKMediaPipelines extends ChimeSDKMediaPipelinesClient {
}
createAggregatedClient(commands, ChimeSDKMediaPipelines);
