import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { CreateMediaInsightsPipelineRequestFilterSensitiveLog, CreateMediaInsightsPipelineResponseFilterSensitiveLog, } from "../models/models_0";
import { de_CreateMediaInsightsPipelineCommand, se_CreateMediaInsightsPipelineCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class CreateMediaInsightsPipelineCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, CreateMediaInsightsPipelineCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeSDKMediaPipelinesClient";
        const commandName = "CreateMediaInsightsPipelineCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: CreateMediaInsightsPipelineRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CreateMediaInsightsPipelineResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return se_CreateMediaInsightsPipelineCommand(input, context);
    }
    deserialize(output, context) {
        return de_CreateMediaInsightsPipelineCommand(output, context);
    }
}
