import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog, CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog, } from "../models/models_0";
import { de_CreateMediaInsightsPipelineConfigurationCommand, se_CreateMediaInsightsPipelineConfigurationCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class CreateMediaInsightsPipelineConfigurationCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, CreateMediaInsightsPipelineConfigurationCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeSDKMediaPipelinesClient";
        const commandName = "CreateMediaInsightsPipelineConfigurationCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return se_CreateMediaInsightsPipelineConfigurationCommand(input, context);
    }
    deserialize(output, context) {
        return de_CreateMediaInsightsPipelineConfigurationCommand(output, context);
    }
}
