import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { ChimeSDKMediaPipelinesServiceException as __BaseException } from "./ChimeSDKMediaPipelinesServiceException";
export const ActiveSpeakerPosition = {
    BottomLeft: "BottomLeft",
    BottomRight: "BottomRight",
    TopLeft: "TopLeft",
    TopRight: "TopRight",
};
export const ContentType = {
    PII: "PII",
};
export const CallAnalyticsLanguageCode = {
    DE_DE: "de-DE",
    EN_AU: "en-AU",
    EN_GB: "en-GB",
    EN_US: "en-US",
    ES_US: "es-US",
    FR_CA: "fr-CA",
    FR_FR: "fr-FR",
    IT_IT: "it-IT",
    PT_BR: "pt-BR",
};
export const PartialResultsStability = {
    HIGH: "high",
    LOW: "low",
    MEDIUM: "medium",
};
export const ContentRedactionOutput = {
    REDACTED: "redacted",
    REDACTED_AND_UNREDACTED: "redacted_and_unredacted",
};
export const VocabularyFilterMethod = {
    MASK: "mask",
    REMOVE: "remove",
    TAG: "tag",
};
export const AudioArtifactsConcatenationState = {
    Enabled: "Enabled",
};
export const ArtifactsConcatenationState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
export const AudioMuxType = {
    AudioOnly: "AudioOnly",
    AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo",
    AudioWithCompositedVideo: "AudioWithCompositedVideo",
};
export const CanvasOrientation = {
    Landscape: "Landscape",
    Portrait: "Portrait",
};
export const ContentShareLayoutOption = {
    ActiveSpeakerOnly: "ActiveSpeakerOnly",
    Horizontal: "Horizontal",
    PresenterOnly: "PresenterOnly",
    Vertical: "Vertical",
};
export const TileOrder = {
    JoinSequence: "JoinSequence",
    SpeakerSequence: "SpeakerSequence",
};
export const HorizontalTilePosition = {
    Bottom: "Bottom",
    Top: "Top",
};
export const PresenterPosition = {
    BottomLeft: "BottomLeft",
    BottomRight: "BottomRight",
    TopLeft: "TopLeft",
    TopRight: "TopRight",
};
export const VerticalTilePosition = {
    Left: "Left",
    Right: "Right",
};
export const BorderColor = {
    Black: "Black",
    Blue: "Blue",
    Green: "Green",
    Red: "Red",
    White: "White",
    Yellow: "Yellow",
};
export const HighlightColor = {
    Black: "Black",
    Blue: "Blue",
    Green: "Green",
    Red: "Red",
    White: "White",
    Yellow: "Yellow",
};
export const LayoutOption = {
    GridView: "GridView",
};
export const ResolutionOption = {
    FHD: "FHD",
    HD: "HD",
};
export const ContentMuxType = {
    ContentOnly: "ContentOnly",
};
export const ArtifactsState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
export const VideoMuxType = {
    VideoOnly: "VideoOnly",
};
export const AudioChannelsOption = {
    Mono: "Mono",
    Stereo: "Stereo",
};
export const ErrorCode = {
    BadRequest: "BadRequest",
    Forbidden: "Forbidden",
    NotFound: "NotFound",
    ResourceLimitExceeded: "ResourceLimitExceeded",
    ServiceFailure: "ServiceFailure",
    ServiceUnavailable: "ServiceUnavailable",
    Throttling: "Throttling",
};
export class BadRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "BadRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BadRequestException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export const ParticipantRole = {
    AGENT: "AGENT",
    CUSTOMER: "CUSTOMER",
};
export const MediaPipelineSinkType = {
    S3Bucket: "S3Bucket",
};
export const MediaPipelineSourceType = {
    ChimeSdkMeeting: "ChimeSdkMeeting",
};
export const MediaPipelineStatus = {
    Failed: "Failed",
    InProgress: "InProgress",
    Initializing: "Initializing",
    Paused: "Paused",
    Stopped: "Stopped",
    Stopping: "Stopping",
};
export class ForbiddenException extends __BaseException {
    constructor(opts) {
        super({
            name: "ForbiddenException",
            $fault: "client",
            ...opts,
        });
        this.name = "ForbiddenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ForbiddenException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export class ResourceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export class ServiceFailureException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export class ServiceUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export class ThrottledClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "ThrottledClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottledClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottledClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export class UnauthorizedClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnauthorizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnauthorizedClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export const ConcatenationSinkType = {
    S3Bucket: "S3Bucket",
};
export const ConcatenationSourceType = {
    MediaCapturePipeline: "MediaCapturePipeline",
};
export const FragmentSelectorType = {
    ProducerTimestamp: "ProducerTimestamp",
    ServerTimestamp: "ServerTimestamp",
};
export const MediaEncoding = {
    PCM: "pcm",
};
export const RecordingFileFormat = {
    Opus: "Opus",
    Wav: "Wav",
};
export class NotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "NotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NotFoundException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export const MediaInsightsPipelineConfigurationElementType = {
    AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR: "AmazonTranscribeCallAnalyticsProcessor",
    AMAZON_TRANSCRIBE_PROCESSOR: "AmazonTranscribeProcessor",
    KINESIS_DATA_STREAM_SINK: "KinesisDataStreamSink",
    LAMBDA_FUNCTION_SINK: "LambdaFunctionSink",
    S3_RECORDING_SINK: "S3RecordingSink",
    SNS_TOPIC_SINK: "SnsTopicSink",
    SQS_QUEUE_SINK: "SqsQueueSink",
    VOICE_ANALYTICS_PROCESSOR: "VoiceAnalyticsProcessor",
};
export const VoiceAnalyticsConfigurationStatus = {
    DISABLED: "Disabled",
    ENABLED: "Enabled",
};
export const SentimentType = {
    NEGATIVE: "NEGATIVE",
};
export const RealTimeAlertRuleType = {
    IssueDetection: "IssueDetection",
    KeywordMatch: "KeywordMatch",
    Sentiment: "Sentiment",
};
export const LiveConnectorSinkType = {
    RTMP: "RTMP",
};
export const LiveConnectorMuxType = {
    AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo",
    AudioWithCompositedVideo: "AudioWithCompositedVideo",
};
export const LiveConnectorSourceType = {
    ChimeSdkMeeting: "ChimeSdkMeeting",
};
export class ConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
        this.RequestId = opts.RequestId;
    }
}
export const MediaPipelineStatusUpdate = {
    Pause: "Pause",
    Resume: "Resume",
};
export const SelectedVideoStreamsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserIds && { ExternalUserIds: SENSITIVE_STRING }),
});
export const SourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SelectedVideoStreams && {
        SelectedVideoStreams: SelectedVideoStreamsFilterSensitiveLog(obj.SelectedVideoStreams),
    }),
});
export const ChimeSdkMeetingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceConfiguration && {
        SourceConfiguration: SourceConfigurationFilterSensitiveLog(obj.SourceConfiguration),
    }),
});
export const CreateMediaCapturePipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: ChimeSdkMeetingConfigurationFilterSensitiveLog(obj.ChimeSdkMeetingConfiguration),
    }),
});
export const MediaCapturePipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: ChimeSdkMeetingConfigurationFilterSensitiveLog(obj.ChimeSdkMeetingConfiguration),
    }),
});
export const CreateMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: MediaCapturePipelineFilterSensitiveLog(obj.MediaCapturePipeline),
    }),
});
export const S3BucketSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Destination && { Destination: SENSITIVE_STRING }),
});
export const ConcatenationSinkFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.S3BucketSinkConfiguration && {
        S3BucketSinkConfiguration: S3BucketSinkConfigurationFilterSensitiveLog(obj.S3BucketSinkConfiguration),
    }),
});
export const MediaCapturePipelineSourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaPipelineArn && { MediaPipelineArn: SENSITIVE_STRING }),
});
export const ConcatenationSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipelineSourceConfiguration && {
        MediaCapturePipelineSourceConfiguration: MediaCapturePipelineSourceConfigurationFilterSensitiveLog(obj.MediaCapturePipelineSourceConfiguration),
    }),
});
export const CreateMediaConcatenationPipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => ConcatenationSourceFilterSensitiveLog(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => ConcatenationSinkFilterSensitiveLog(item)) }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
});
export const MediaConcatenationPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => ConcatenationSourceFilterSensitiveLog(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => ConcatenationSinkFilterSensitiveLog(item)) }),
});
export const CreateMediaConcatenationPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaConcatenationPipeline && {
        MediaConcatenationPipeline: MediaConcatenationPipelineFilterSensitiveLog(obj.MediaConcatenationPipeline),
    }),
});
export const S3RecordingSinkRuntimeConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Destination && { Destination: SENSITIVE_STRING }),
});
export const CreateMediaInsightsPipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: SENSITIVE_STRING }),
    ...(obj.MediaInsightsRuntimeMetadata && { MediaInsightsRuntimeMetadata: SENSITIVE_STRING }),
    ...(obj.S3RecordingSinkRuntimeConfiguration && {
        S3RecordingSinkRuntimeConfiguration: S3RecordingSinkRuntimeConfigurationFilterSensitiveLog(obj.S3RecordingSinkRuntimeConfiguration),
    }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
});
export const MediaInsightsPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaPipelineArn && { MediaPipelineArn: SENSITIVE_STRING }),
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: SENSITIVE_STRING }),
    ...(obj.MediaInsightsRuntimeMetadata && { MediaInsightsRuntimeMetadata: SENSITIVE_STRING }),
    ...(obj.S3RecordingSinkRuntimeConfiguration && {
        S3RecordingSinkRuntimeConfiguration: S3RecordingSinkRuntimeConfigurationFilterSensitiveLog(obj.S3RecordingSinkRuntimeConfiguration),
    }),
});
export const CreateMediaInsightsPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipeline && {
        MediaInsightsPipeline: MediaInsightsPipelineFilterSensitiveLog(obj.MediaInsightsPipeline),
    }),
});
export const KinesisDataStreamSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: SENSITIVE_STRING }),
});
export const LambdaFunctionSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: SENSITIVE_STRING }),
});
export const S3RecordingSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Destination && { Destination: SENSITIVE_STRING }),
});
export const SnsTopicSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: SENSITIVE_STRING }),
});
export const SqsQueueSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InsightsTarget && { InsightsTarget: SENSITIVE_STRING }),
});
export const MediaInsightsPipelineConfigurationElementFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.KinesisDataStreamSinkConfiguration && {
        KinesisDataStreamSinkConfiguration: KinesisDataStreamSinkConfigurationFilterSensitiveLog(obj.KinesisDataStreamSinkConfiguration),
    }),
    ...(obj.S3RecordingSinkConfiguration && {
        S3RecordingSinkConfiguration: S3RecordingSinkConfigurationFilterSensitiveLog(obj.S3RecordingSinkConfiguration),
    }),
    ...(obj.LambdaFunctionSinkConfiguration && {
        LambdaFunctionSinkConfiguration: LambdaFunctionSinkConfigurationFilterSensitiveLog(obj.LambdaFunctionSinkConfiguration),
    }),
    ...(obj.SqsQueueSinkConfiguration && {
        SqsQueueSinkConfiguration: SqsQueueSinkConfigurationFilterSensitiveLog(obj.SqsQueueSinkConfiguration),
    }),
    ...(obj.SnsTopicSinkConfiguration && {
        SnsTopicSinkConfiguration: SnsTopicSinkConfigurationFilterSensitiveLog(obj.SnsTopicSinkConfiguration),
    }),
});
export const CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceAccessRoleArn && { ResourceAccessRoleArn: SENSITIVE_STRING }),
    ...(obj.Elements && {
        Elements: obj.Elements.map((item) => MediaInsightsPipelineConfigurationElementFilterSensitiveLog(item)),
    }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
});
export const MediaInsightsPipelineConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: SENSITIVE_STRING }),
    ...(obj.ResourceAccessRoleArn && { ResourceAccessRoleArn: SENSITIVE_STRING }),
    ...(obj.Elements && {
        Elements: obj.Elements.map((item) => MediaInsightsPipelineConfigurationElementFilterSensitiveLog(item)),
    }),
});
export const CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfiguration && {
        MediaInsightsPipelineConfiguration: MediaInsightsPipelineConfigurationFilterSensitiveLog(obj.MediaInsightsPipelineConfiguration),
    }),
});
export const LiveConnectorRTMPConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: SENSITIVE_STRING }),
});
export const LiveConnectorSinkConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RTMPConfiguration && {
        RTMPConfiguration: LiveConnectorRTMPConfigurationFilterSensitiveLog(obj.RTMPConfiguration),
    }),
});
export const ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Arn && { Arn: SENSITIVE_STRING }),
    ...(obj.SourceConfiguration && {
        SourceConfiguration: SourceConfigurationFilterSensitiveLog(obj.SourceConfiguration),
    }),
});
export const LiveConnectorSourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChimeSdkMeetingLiveConnectorConfiguration && {
        ChimeSdkMeetingLiveConnectorConfiguration: ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog(obj.ChimeSdkMeetingLiveConnectorConfiguration),
    }),
});
export const CreateMediaLiveConnectorPipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => LiveConnectorSourceConfigurationFilterSensitiveLog(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => LiveConnectorSinkConfigurationFilterSensitiveLog(item)) }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
});
export const MediaLiveConnectorPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => LiveConnectorSourceConfigurationFilterSensitiveLog(item)) }),
    ...(obj.Sinks && { Sinks: obj.Sinks.map((item) => LiveConnectorSinkConfigurationFilterSensitiveLog(item)) }),
});
export const CreateMediaLiveConnectorPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaLiveConnectorPipeline && {
        MediaLiveConnectorPipeline: MediaLiveConnectorPipelineFilterSensitiveLog(obj.MediaLiveConnectorPipeline),
    }),
});
export const GetMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: MediaCapturePipelineFilterSensitiveLog(obj.MediaCapturePipeline),
    }),
});
export const GetMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfiguration && {
        MediaInsightsPipelineConfiguration: MediaInsightsPipelineConfigurationFilterSensitiveLog(obj.MediaInsightsPipelineConfiguration),
    }),
});
export const MediaPipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: MediaCapturePipelineFilterSensitiveLog(obj.MediaCapturePipeline),
    }),
    ...(obj.MediaLiveConnectorPipeline && {
        MediaLiveConnectorPipeline: MediaLiveConnectorPipelineFilterSensitiveLog(obj.MediaLiveConnectorPipeline),
    }),
    ...(obj.MediaConcatenationPipeline && {
        MediaConcatenationPipeline: MediaConcatenationPipelineFilterSensitiveLog(obj.MediaConcatenationPipeline),
    }),
    ...(obj.MediaInsightsPipeline && {
        MediaInsightsPipeline: MediaInsightsPipelineFilterSensitiveLog(obj.MediaInsightsPipeline),
    }),
});
export const GetMediaPipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaPipeline && { MediaPipeline: MediaPipelineFilterSensitiveLog(obj.MediaPipeline) }),
});
export const MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurationArn && { MediaInsightsPipelineConfigurationArn: SENSITIVE_STRING }),
});
export const ListMediaInsightsPipelineConfigurationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfigurations && {
        MediaInsightsPipelineConfigurations: obj.MediaInsightsPipelineConfigurations.map((item) => MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog(item)),
    }),
});
export const UpdateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceAccessRoleArn && { ResourceAccessRoleArn: SENSITIVE_STRING }),
    ...(obj.Elements && {
        Elements: obj.Elements.map((item) => MediaInsightsPipelineConfigurationElementFilterSensitiveLog(item)),
    }),
});
export const UpdateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaInsightsPipelineConfiguration && {
        MediaInsightsPipelineConfiguration: MediaInsightsPipelineConfigurationFilterSensitiveLog(obj.MediaInsightsPipelineConfiguration),
    }),
});
