import { ChimeSDKMediaPipelinesClient } from "../ChimeSDKMediaPipelinesClient";
import { ListMediaPipelinesCommand, } from "../commands/ListMediaPipelinesCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListMediaPipelinesCommand(input), ...args);
};
export async function* paginateListMediaPipelines(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMediaPipelinesClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMediaPipelines | ChimeSDKMediaPipelinesClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
