import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { ChimeSDKMediaPipelinesServiceException as __BaseException } from "./ChimeSDKMediaPipelinesServiceException";
export declare const ActiveSpeakerPosition: {
  readonly BottomLeft: "BottomLeft";
  readonly BottomRight: "BottomRight";
  readonly TopLeft: "TopLeft";
  readonly TopRight: "TopRight";
};
export type ActiveSpeakerPosition =
  (typeof ActiveSpeakerPosition)[keyof typeof ActiveSpeakerPosition];
export interface ActiveSpeakerOnlyConfiguration {
  ActiveSpeakerPosition?: ActiveSpeakerPosition | string;
}
export declare const ContentType: {
  readonly PII: "PII";
};
export type ContentType = (typeof ContentType)[keyof typeof ContentType];
export declare const CallAnalyticsLanguageCode: {
  readonly DE_DE: "de-DE";
  readonly EN_AU: "en-AU";
  readonly EN_GB: "en-GB";
  readonly EN_US: "en-US";
  readonly ES_US: "es-US";
  readonly FR_CA: "fr-CA";
  readonly FR_FR: "fr-FR";
  readonly IT_IT: "it-IT";
  readonly PT_BR: "pt-BR";
};
export type CallAnalyticsLanguageCode =
  (typeof CallAnalyticsLanguageCode)[keyof typeof CallAnalyticsLanguageCode];
export declare const PartialResultsStability: {
  readonly HIGH: "high";
  readonly LOW: "low";
  readonly MEDIUM: "medium";
};
export type PartialResultsStability =
  (typeof PartialResultsStability)[keyof typeof PartialResultsStability];
export declare const ContentRedactionOutput: {
  readonly REDACTED: "redacted";
  readonly REDACTED_AND_UNREDACTED: "redacted_and_unredacted";
};
export type ContentRedactionOutput =
  (typeof ContentRedactionOutput)[keyof typeof ContentRedactionOutput];
export interface PostCallAnalyticsSettings {
  OutputLocation: string | undefined;
  DataAccessRoleArn: string | undefined;
  ContentRedactionOutput?: ContentRedactionOutput | string;
  OutputEncryptionKMSKeyId?: string;
}
export declare const VocabularyFilterMethod: {
  readonly MASK: "mask";
  readonly REMOVE: "remove";
  readonly TAG: "tag";
};
export type VocabularyFilterMethod =
  (typeof VocabularyFilterMethod)[keyof typeof VocabularyFilterMethod];
export interface AmazonTranscribeCallAnalyticsProcessorConfiguration {
  LanguageCode: CallAnalyticsLanguageCode | string | undefined;
  VocabularyName?: string;
  VocabularyFilterName?: string;
  VocabularyFilterMethod?: VocabularyFilterMethod | string;
  LanguageModelName?: string;
  EnablePartialResultsStabilization?: boolean;
  PartialResultsStability?: PartialResultsStability | string;
  ContentIdentificationType?: ContentType | string;
  ContentRedactionType?: ContentType | string;
  PiiEntityTypes?: string;
  FilterPartialResults?: boolean;
  PostCallAnalyticsSettings?: PostCallAnalyticsSettings;
  CallAnalyticsStreamCategories?: string[];
}
export interface AmazonTranscribeProcessorConfiguration {
  LanguageCode?: CallAnalyticsLanguageCode | string;
  VocabularyName?: string;
  VocabularyFilterName?: string;
  VocabularyFilterMethod?: VocabularyFilterMethod | string;
  ShowSpeakerLabel?: boolean;
  EnablePartialResultsStabilization?: boolean;
  PartialResultsStability?: PartialResultsStability | string;
  ContentIdentificationType?: ContentType | string;
  ContentRedactionType?: ContentType | string;
  PiiEntityTypes?: string;
  LanguageModelName?: string;
  FilterPartialResults?: boolean;
  IdentifyLanguage?: boolean;
  LanguageOptions?: string;
  PreferredLanguage?: CallAnalyticsLanguageCode | string;
  VocabularyNames?: string;
  VocabularyFilterNames?: string;
}
export declare const AudioArtifactsConcatenationState: {
  readonly Enabled: "Enabled";
};
export type AudioArtifactsConcatenationState =
  (typeof AudioArtifactsConcatenationState)[keyof typeof AudioArtifactsConcatenationState];
export interface AudioConcatenationConfiguration {
  State: AudioArtifactsConcatenationState | string | undefined;
}
export declare const ArtifactsConcatenationState: {
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
};
export type ArtifactsConcatenationState =
  (typeof ArtifactsConcatenationState)[keyof typeof ArtifactsConcatenationState];
export interface CompositedVideoConcatenationConfiguration {
  State: ArtifactsConcatenationState | string | undefined;
}
export interface ContentConcatenationConfiguration {
  State: ArtifactsConcatenationState | string | undefined;
}
export interface DataChannelConcatenationConfiguration {
  State: ArtifactsConcatenationState | string | undefined;
}
export interface MeetingEventsConcatenationConfiguration {
  State: ArtifactsConcatenationState | string | undefined;
}
export interface TranscriptionMessagesConcatenationConfiguration {
  State: ArtifactsConcatenationState | string | undefined;
}
export interface VideoConcatenationConfiguration {
  State: ArtifactsConcatenationState | string | undefined;
}
export interface ArtifactsConcatenationConfiguration {
  Audio: AudioConcatenationConfiguration | undefined;
  Video: VideoConcatenationConfiguration | undefined;
  Content: ContentConcatenationConfiguration | undefined;
  DataChannel: DataChannelConcatenationConfiguration | undefined;
  TranscriptionMessages:
    | TranscriptionMessagesConcatenationConfiguration
    | undefined;
  MeetingEvents: MeetingEventsConcatenationConfiguration | undefined;
  CompositedVideo: CompositedVideoConcatenationConfiguration | undefined;
}
export declare const AudioMuxType: {
  readonly AudioOnly: "AudioOnly";
  readonly AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo";
  readonly AudioWithCompositedVideo: "AudioWithCompositedVideo";
};
export type AudioMuxType = (typeof AudioMuxType)[keyof typeof AudioMuxType];
export interface AudioArtifactsConfiguration {
  MuxType: AudioMuxType | string | undefined;
}
export declare const CanvasOrientation: {
  readonly Landscape: "Landscape";
  readonly Portrait: "Portrait";
};
export type CanvasOrientation =
  (typeof CanvasOrientation)[keyof typeof CanvasOrientation];
export declare const ContentShareLayoutOption: {
  readonly ActiveSpeakerOnly: "ActiveSpeakerOnly";
  readonly Horizontal: "Horizontal";
  readonly PresenterOnly: "PresenterOnly";
  readonly Vertical: "Vertical";
};
export type ContentShareLayoutOption =
  (typeof ContentShareLayoutOption)[keyof typeof ContentShareLayoutOption];
export declare const TileOrder: {
  readonly JoinSequence: "JoinSequence";
  readonly SpeakerSequence: "SpeakerSequence";
};
export type TileOrder = (typeof TileOrder)[keyof typeof TileOrder];
export declare const HorizontalTilePosition: {
  readonly Bottom: "Bottom";
  readonly Top: "Top";
};
export type HorizontalTilePosition =
  (typeof HorizontalTilePosition)[keyof typeof HorizontalTilePosition];
export interface HorizontalLayoutConfiguration {
  TileOrder?: TileOrder | string;
  TilePosition?: HorizontalTilePosition | string;
  TileCount?: number;
  TileAspectRatio?: string;
}
export declare const PresenterPosition: {
  readonly BottomLeft: "BottomLeft";
  readonly BottomRight: "BottomRight";
  readonly TopLeft: "TopLeft";
  readonly TopRight: "TopRight";
};
export type PresenterPosition =
  (typeof PresenterPosition)[keyof typeof PresenterPosition];
export interface PresenterOnlyConfiguration {
  PresenterPosition?: PresenterPosition | string;
}
export declare const VerticalTilePosition: {
  readonly Left: "Left";
  readonly Right: "Right";
};
export type VerticalTilePosition =
  (typeof VerticalTilePosition)[keyof typeof VerticalTilePosition];
export interface VerticalLayoutConfiguration {
  TileOrder?: TileOrder | string;
  TilePosition?: VerticalTilePosition | string;
  TileCount?: number;
  TileAspectRatio?: string;
}
export declare const BorderColor: {
  readonly Black: "Black";
  readonly Blue: "Blue";
  readonly Green: "Green";
  readonly Red: "Red";
  readonly White: "White";
  readonly Yellow: "Yellow";
};
export type BorderColor = (typeof BorderColor)[keyof typeof BorderColor];
export declare const HighlightColor: {
  readonly Black: "Black";
  readonly Blue: "Blue";
  readonly Green: "Green";
  readonly Red: "Red";
  readonly White: "White";
  readonly Yellow: "Yellow";
};
export type HighlightColor =
  (typeof HighlightColor)[keyof typeof HighlightColor];
export interface VideoAttribute {
  CornerRadius?: number;
  BorderColor?: BorderColor | string;
  HighlightColor?: HighlightColor | string;
  BorderThickness?: number;
}
export interface GridViewConfiguration {
  ContentShareLayout: ContentShareLayoutOption | string | undefined;
  PresenterOnlyConfiguration?: PresenterOnlyConfiguration;
  ActiveSpeakerOnlyConfiguration?: ActiveSpeakerOnlyConfiguration;
  HorizontalLayoutConfiguration?: HorizontalLayoutConfiguration;
  VerticalLayoutConfiguration?: VerticalLayoutConfiguration;
  VideoAttribute?: VideoAttribute;
  CanvasOrientation?: CanvasOrientation | string;
}
export declare const LayoutOption: {
  readonly GridView: "GridView";
};
export type LayoutOption = (typeof LayoutOption)[keyof typeof LayoutOption];
export declare const ResolutionOption: {
  readonly FHD: "FHD";
  readonly HD: "HD";
};
export type ResolutionOption =
  (typeof ResolutionOption)[keyof typeof ResolutionOption];
export interface CompositedVideoArtifactsConfiguration {
  Layout?: LayoutOption | string;
  Resolution?: ResolutionOption | string;
  GridViewConfiguration: GridViewConfiguration | undefined;
}
export declare const ContentMuxType: {
  readonly ContentOnly: "ContentOnly";
};
export type ContentMuxType =
  (typeof ContentMuxType)[keyof typeof ContentMuxType];
export declare const ArtifactsState: {
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
};
export type ArtifactsState =
  (typeof ArtifactsState)[keyof typeof ArtifactsState];
export interface ContentArtifactsConfiguration {
  State: ArtifactsState | string | undefined;
  MuxType?: ContentMuxType | string;
}
export declare const VideoMuxType: {
  readonly VideoOnly: "VideoOnly";
};
export type VideoMuxType = (typeof VideoMuxType)[keyof typeof VideoMuxType];
export interface VideoArtifactsConfiguration {
  State: ArtifactsState | string | undefined;
  MuxType?: VideoMuxType | string;
}
export interface ArtifactsConfiguration {
  Audio: AudioArtifactsConfiguration | undefined;
  Video: VideoArtifactsConfiguration | undefined;
  Content: ContentArtifactsConfiguration | undefined;
  CompositedVideo?: CompositedVideoArtifactsConfiguration;
}
export declare const AudioChannelsOption: {
  readonly Mono: "Mono";
  readonly Stereo: "Stereo";
};
export type AudioChannelsOption =
  (typeof AudioChannelsOption)[keyof typeof AudioChannelsOption];
export declare const ErrorCode: {
  readonly BadRequest: "BadRequest";
  readonly Forbidden: "Forbidden";
  readonly NotFound: "NotFound";
  readonly ResourceLimitExceeded: "ResourceLimitExceeded";
  readonly ServiceFailure: "ServiceFailure";
  readonly ServiceUnavailable: "ServiceUnavailable";
  readonly Throttling: "Throttling";
};
export type ErrorCode = (typeof ErrorCode)[keyof typeof ErrorCode];
export declare class BadRequestException extends __BaseException {
  readonly name: "BadRequestException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(
    opts: __ExceptionOptionType<BadRequestException, __BaseException>
  );
}
export declare const ParticipantRole: {
  readonly AGENT: "AGENT";
  readonly CUSTOMER: "CUSTOMER";
};
export type ParticipantRole =
  (typeof ParticipantRole)[keyof typeof ParticipantRole];
export interface ChannelDefinition {
  ChannelId: number | undefined;
  ParticipantRole?: ParticipantRole | string;
}
export interface SelectedVideoStreams {
  AttendeeIds?: string[];
  ExternalUserIds?: string[];
}
export interface SourceConfiguration {
  SelectedVideoStreams?: SelectedVideoStreams;
}
export interface ChimeSdkMeetingConfiguration {
  SourceConfiguration?: SourceConfiguration;
  ArtifactsConfiguration?: ArtifactsConfiguration;
}
export declare const MediaPipelineSinkType: {
  readonly S3Bucket: "S3Bucket";
};
export type MediaPipelineSinkType =
  (typeof MediaPipelineSinkType)[keyof typeof MediaPipelineSinkType];
export declare const MediaPipelineSourceType: {
  readonly ChimeSdkMeeting: "ChimeSdkMeeting";
};
export type MediaPipelineSourceType =
  (typeof MediaPipelineSourceType)[keyof typeof MediaPipelineSourceType];
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateMediaCapturePipelineRequest {
  SourceType: MediaPipelineSourceType | string | undefined;
  SourceArn: string | undefined;
  SinkType: MediaPipelineSinkType | string | undefined;
  SinkArn: string | undefined;
  ClientRequestToken?: string;
  ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
  Tags?: Tag[];
}
export declare const MediaPipelineStatus: {
  readonly Failed: "Failed";
  readonly InProgress: "InProgress";
  readonly Initializing: "Initializing";
  readonly Paused: "Paused";
  readonly Stopped: "Stopped";
  readonly Stopping: "Stopping";
};
export type MediaPipelineStatus =
  (typeof MediaPipelineStatus)[keyof typeof MediaPipelineStatus];
export interface MediaCapturePipeline {
  MediaPipelineId?: string;
  MediaPipelineArn?: string;
  SourceType?: MediaPipelineSourceType | string;
  SourceArn?: string;
  Status?: MediaPipelineStatus | string;
  SinkType?: MediaPipelineSinkType | string;
  SinkArn?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
}
export interface CreateMediaCapturePipelineResponse {
  MediaCapturePipeline?: MediaCapturePipeline;
}
export declare class ForbiddenException extends __BaseException {
  readonly name: "ForbiddenException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export declare class ServiceFailureException extends __BaseException {
  readonly name: "ServiceFailureException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceFailureException, __BaseException>
  );
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export declare class ThrottledClientException extends __BaseException {
  readonly name: "ThrottledClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(
    opts: __ExceptionOptionType<ThrottledClientException, __BaseException>
  );
}
export declare class UnauthorizedClientException extends __BaseException {
  readonly name: "UnauthorizedClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(
    opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>
  );
}
export interface S3BucketSinkConfiguration {
  Destination: string | undefined;
}
export declare const ConcatenationSinkType: {
  readonly S3Bucket: "S3Bucket";
};
export type ConcatenationSinkType =
  (typeof ConcatenationSinkType)[keyof typeof ConcatenationSinkType];
export interface ConcatenationSink {
  Type: ConcatenationSinkType | string | undefined;
  S3BucketSinkConfiguration: S3BucketSinkConfiguration | undefined;
}
export interface ChimeSdkMeetingConcatenationConfiguration {
  ArtifactsConfiguration: ArtifactsConcatenationConfiguration | undefined;
}
export interface MediaCapturePipelineSourceConfiguration {
  MediaPipelineArn: string | undefined;
  ChimeSdkMeetingConfiguration:
    | ChimeSdkMeetingConcatenationConfiguration
    | undefined;
}
export declare const ConcatenationSourceType: {
  readonly MediaCapturePipeline: "MediaCapturePipeline";
};
export type ConcatenationSourceType =
  (typeof ConcatenationSourceType)[keyof typeof ConcatenationSourceType];
export interface ConcatenationSource {
  Type: ConcatenationSourceType | string | undefined;
  MediaCapturePipelineSourceConfiguration:
    | MediaCapturePipelineSourceConfiguration
    | undefined;
}
export interface CreateMediaConcatenationPipelineRequest {
  Sources: ConcatenationSource[] | undefined;
  Sinks: ConcatenationSink[] | undefined;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface MediaConcatenationPipeline {
  MediaPipelineId?: string;
  MediaPipelineArn?: string;
  Sources?: ConcatenationSource[];
  Sinks?: ConcatenationSink[];
  Status?: MediaPipelineStatus | string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateMediaConcatenationPipelineResponse {
  MediaConcatenationPipeline?: MediaConcatenationPipeline;
}
export declare const FragmentSelectorType: {
  readonly ProducerTimestamp: "ProducerTimestamp";
  readonly ServerTimestamp: "ServerTimestamp";
};
export type FragmentSelectorType =
  (typeof FragmentSelectorType)[keyof typeof FragmentSelectorType];
export interface TimestampRange {
  StartTimestamp: Date | undefined;
  EndTimestamp: Date | undefined;
}
export interface FragmentSelector {
  FragmentSelectorType: FragmentSelectorType | string | undefined;
  TimestampRange: TimestampRange | undefined;
}
export interface RecordingStreamConfiguration {
  StreamArn?: string;
}
export interface KinesisVideoStreamRecordingSourceRuntimeConfiguration {
  Streams: RecordingStreamConfiguration[] | undefined;
  FragmentSelector: FragmentSelector | undefined;
}
export declare const MediaEncoding: {
  readonly PCM: "pcm";
};
export type MediaEncoding = (typeof MediaEncoding)[keyof typeof MediaEncoding];
export interface StreamChannelDefinition {
  NumberOfChannels: number | undefined;
  ChannelDefinitions?: ChannelDefinition[];
}
export interface StreamConfiguration {
  StreamArn: string | undefined;
  FragmentNumber?: string;
  StreamChannelDefinition: StreamChannelDefinition | undefined;
}
export interface KinesisVideoStreamSourceRuntimeConfiguration {
  Streams: StreamConfiguration[] | undefined;
  MediaEncoding: MediaEncoding | string | undefined;
  MediaSampleRate: number | undefined;
}
export declare const RecordingFileFormat: {
  readonly Opus: "Opus";
  readonly Wav: "Wav";
};
export type RecordingFileFormat =
  (typeof RecordingFileFormat)[keyof typeof RecordingFileFormat];
export interface S3RecordingSinkRuntimeConfiguration {
  Destination: string | undefined;
  RecordingFileFormat: RecordingFileFormat | string | undefined;
}
export interface CreateMediaInsightsPipelineRequest {
  MediaInsightsPipelineConfigurationArn: string | undefined;
  KinesisVideoStreamSourceRuntimeConfiguration?: KinesisVideoStreamSourceRuntimeConfiguration;
  MediaInsightsRuntimeMetadata?: Record<string, string>;
  KinesisVideoStreamRecordingSourceRuntimeConfiguration?: KinesisVideoStreamRecordingSourceRuntimeConfiguration;
  S3RecordingSinkRuntimeConfiguration?: S3RecordingSinkRuntimeConfiguration;
  Tags?: Tag[];
  ClientRequestToken?: string;
}
export interface MediaInsightsPipeline {
  MediaPipelineId?: string;
  MediaPipelineArn?: string;
  MediaInsightsPipelineConfigurationArn?: string;
  Status?: MediaPipelineStatus | string;
  KinesisVideoStreamSourceRuntimeConfiguration?: KinesisVideoStreamSourceRuntimeConfiguration;
  MediaInsightsRuntimeMetadata?: Record<string, string>;
  KinesisVideoStreamRecordingSourceRuntimeConfiguration?: KinesisVideoStreamRecordingSourceRuntimeConfiguration;
  S3RecordingSinkRuntimeConfiguration?: S3RecordingSinkRuntimeConfiguration;
  CreatedTimestamp?: Date;
}
export interface CreateMediaInsightsPipelineResponse {
  MediaInsightsPipeline: MediaInsightsPipeline | undefined;
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export interface KinesisDataStreamSinkConfiguration {
  InsightsTarget?: string;
}
export interface LambdaFunctionSinkConfiguration {
  InsightsTarget?: string;
}
export interface S3RecordingSinkConfiguration {
  Destination?: string;
  RecordingFileFormat?: RecordingFileFormat | string;
}
export interface SnsTopicSinkConfiguration {
  InsightsTarget?: string;
}
export interface SqsQueueSinkConfiguration {
  InsightsTarget?: string;
}
export declare const MediaInsightsPipelineConfigurationElementType: {
  readonly AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR: "AmazonTranscribeCallAnalyticsProcessor";
  readonly AMAZON_TRANSCRIBE_PROCESSOR: "AmazonTranscribeProcessor";
  readonly KINESIS_DATA_STREAM_SINK: "KinesisDataStreamSink";
  readonly LAMBDA_FUNCTION_SINK: "LambdaFunctionSink";
  readonly S3_RECORDING_SINK: "S3RecordingSink";
  readonly SNS_TOPIC_SINK: "SnsTopicSink";
  readonly SQS_QUEUE_SINK: "SqsQueueSink";
  readonly VOICE_ANALYTICS_PROCESSOR: "VoiceAnalyticsProcessor";
};
export type MediaInsightsPipelineConfigurationElementType =
  (typeof MediaInsightsPipelineConfigurationElementType)[keyof typeof MediaInsightsPipelineConfigurationElementType];
export declare const VoiceAnalyticsConfigurationStatus: {
  readonly DISABLED: "Disabled";
  readonly ENABLED: "Enabled";
};
export type VoiceAnalyticsConfigurationStatus =
  (typeof VoiceAnalyticsConfigurationStatus)[keyof typeof VoiceAnalyticsConfigurationStatus];
export interface VoiceAnalyticsProcessorConfiguration {
  SpeakerSearchStatus?: VoiceAnalyticsConfigurationStatus | string;
  VoiceToneAnalysisStatus?: VoiceAnalyticsConfigurationStatus | string;
}
export interface MediaInsightsPipelineConfigurationElement {
  Type: MediaInsightsPipelineConfigurationElementType | string | undefined;
  AmazonTranscribeCallAnalyticsProcessorConfiguration?: AmazonTranscribeCallAnalyticsProcessorConfiguration;
  AmazonTranscribeProcessorConfiguration?: AmazonTranscribeProcessorConfiguration;
  KinesisDataStreamSinkConfiguration?: KinesisDataStreamSinkConfiguration;
  S3RecordingSinkConfiguration?: S3RecordingSinkConfiguration;
  VoiceAnalyticsProcessorConfiguration?: VoiceAnalyticsProcessorConfiguration;
  LambdaFunctionSinkConfiguration?: LambdaFunctionSinkConfiguration;
  SqsQueueSinkConfiguration?: SqsQueueSinkConfiguration;
  SnsTopicSinkConfiguration?: SnsTopicSinkConfiguration;
}
export interface IssueDetectionConfiguration {
  RuleName: string | undefined;
}
export interface KeywordMatchConfiguration {
  RuleName: string | undefined;
  Keywords: string[] | undefined;
  Negate?: boolean;
}
export declare const SentimentType: {
  readonly NEGATIVE: "NEGATIVE";
};
export type SentimentType = (typeof SentimentType)[keyof typeof SentimentType];
export interface SentimentConfiguration {
  RuleName: string | undefined;
  SentimentType: SentimentType | string | undefined;
  TimePeriod: number | undefined;
}
export declare const RealTimeAlertRuleType: {
  readonly IssueDetection: "IssueDetection";
  readonly KeywordMatch: "KeywordMatch";
  readonly Sentiment: "Sentiment";
};
export type RealTimeAlertRuleType =
  (typeof RealTimeAlertRuleType)[keyof typeof RealTimeAlertRuleType];
export interface RealTimeAlertRule {
  Type: RealTimeAlertRuleType | string | undefined;
  KeywordMatchConfiguration?: KeywordMatchConfiguration;
  SentimentConfiguration?: SentimentConfiguration;
  IssueDetectionConfiguration?: IssueDetectionConfiguration;
}
export interface RealTimeAlertConfiguration {
  Disabled?: boolean;
  Rules?: RealTimeAlertRule[];
}
export interface CreateMediaInsightsPipelineConfigurationRequest {
  MediaInsightsPipelineConfigurationName: string | undefined;
  ResourceAccessRoleArn: string | undefined;
  RealTimeAlertConfiguration?: RealTimeAlertConfiguration;
  Elements: MediaInsightsPipelineConfigurationElement[] | undefined;
  Tags?: Tag[];
  ClientRequestToken?: string;
}
export interface MediaInsightsPipelineConfiguration {
  MediaInsightsPipelineConfigurationName?: string;
  MediaInsightsPipelineConfigurationArn?: string;
  ResourceAccessRoleArn?: string;
  RealTimeAlertConfiguration?: RealTimeAlertConfiguration;
  Elements?: MediaInsightsPipelineConfigurationElement[];
  MediaInsightsPipelineConfigurationId?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateMediaInsightsPipelineConfigurationResponse {
  MediaInsightsPipelineConfiguration?: MediaInsightsPipelineConfiguration;
}
export interface LiveConnectorRTMPConfiguration {
  Url: string | undefined;
  AudioChannels?: AudioChannelsOption | string;
  AudioSampleRate?: string;
}
export declare const LiveConnectorSinkType: {
  readonly RTMP: "RTMP";
};
export type LiveConnectorSinkType =
  (typeof LiveConnectorSinkType)[keyof typeof LiveConnectorSinkType];
export interface LiveConnectorSinkConfiguration {
  SinkType: LiveConnectorSinkType | string | undefined;
  RTMPConfiguration: LiveConnectorRTMPConfiguration | undefined;
}
export declare const LiveConnectorMuxType: {
  readonly AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo";
  readonly AudioWithCompositedVideo: "AudioWithCompositedVideo";
};
export type LiveConnectorMuxType =
  (typeof LiveConnectorMuxType)[keyof typeof LiveConnectorMuxType];
export interface ChimeSdkMeetingLiveConnectorConfiguration {
  Arn: string | undefined;
  MuxType: LiveConnectorMuxType | string | undefined;
  CompositedVideo?: CompositedVideoArtifactsConfiguration;
  SourceConfiguration?: SourceConfiguration;
}
export declare const LiveConnectorSourceType: {
  readonly ChimeSdkMeeting: "ChimeSdkMeeting";
};
export type LiveConnectorSourceType =
  (typeof LiveConnectorSourceType)[keyof typeof LiveConnectorSourceType];
export interface LiveConnectorSourceConfiguration {
  SourceType: LiveConnectorSourceType | string | undefined;
  ChimeSdkMeetingLiveConnectorConfiguration:
    | ChimeSdkMeetingLiveConnectorConfiguration
    | undefined;
}
export interface CreateMediaLiveConnectorPipelineRequest {
  Sources: LiveConnectorSourceConfiguration[] | undefined;
  Sinks: LiveConnectorSinkConfiguration[] | undefined;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface MediaLiveConnectorPipeline {
  Sources?: LiveConnectorSourceConfiguration[];
  Sinks?: LiveConnectorSinkConfiguration[];
  MediaPipelineId?: string;
  MediaPipelineArn?: string;
  Status?: MediaPipelineStatus | string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateMediaLiveConnectorPipelineResponse {
  MediaLiveConnectorPipeline?: MediaLiveConnectorPipeline;
}
export interface DeleteMediaCapturePipelineRequest {
  MediaPipelineId: string | undefined;
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  RequestId?: string;
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface DeleteMediaInsightsPipelineConfigurationRequest {
  Identifier: string | undefined;
}
export interface DeleteMediaPipelineRequest {
  MediaPipelineId: string | undefined;
}
export interface GetMediaCapturePipelineRequest {
  MediaPipelineId: string | undefined;
}
export interface GetMediaCapturePipelineResponse {
  MediaCapturePipeline?: MediaCapturePipeline;
}
export interface GetMediaInsightsPipelineConfigurationRequest {
  Identifier: string | undefined;
}
export interface GetMediaInsightsPipelineConfigurationResponse {
  MediaInsightsPipelineConfiguration?: MediaInsightsPipelineConfiguration;
}
export interface GetMediaPipelineRequest {
  MediaPipelineId: string | undefined;
}
export interface MediaPipeline {
  MediaCapturePipeline?: MediaCapturePipeline;
  MediaLiveConnectorPipeline?: MediaLiveConnectorPipeline;
  MediaConcatenationPipeline?: MediaConcatenationPipeline;
  MediaInsightsPipeline?: MediaInsightsPipeline;
}
export interface GetMediaPipelineResponse {
  MediaPipeline?: MediaPipeline;
}
export interface ListMediaCapturePipelinesRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface MediaCapturePipelineSummary {
  MediaPipelineId?: string;
  MediaPipelineArn?: string;
}
export interface ListMediaCapturePipelinesResponse {
  MediaCapturePipelines?: MediaCapturePipelineSummary[];
  NextToken?: string;
}
export interface ListMediaInsightsPipelineConfigurationsRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface MediaInsightsPipelineConfigurationSummary {
  MediaInsightsPipelineConfigurationName?: string;
  MediaInsightsPipelineConfigurationId?: string;
  MediaInsightsPipelineConfigurationArn?: string;
}
export interface ListMediaInsightsPipelineConfigurationsResponse {
  MediaInsightsPipelineConfigurations?: MediaInsightsPipelineConfigurationSummary[];
  NextToken?: string;
}
export interface ListMediaPipelinesRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface MediaPipelineSummary {
  MediaPipelineId?: string;
  MediaPipelineArn?: string;
}
export interface ListMediaPipelinesResponse {
  MediaPipelines?: MediaPipelineSummary[];
  NextToken?: string;
}
export interface ListTagsForResourceRequest {
  ResourceARN: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Tag[];
}
export interface TagResourceRequest {
  ResourceARN: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  ResourceARN: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface UpdateMediaInsightsPipelineConfigurationRequest {
  Identifier: string | undefined;
  ResourceAccessRoleArn: string | undefined;
  RealTimeAlertConfiguration?: RealTimeAlertConfiguration;
  Elements: MediaInsightsPipelineConfigurationElement[] | undefined;
}
export interface UpdateMediaInsightsPipelineConfigurationResponse {
  MediaInsightsPipelineConfiguration?: MediaInsightsPipelineConfiguration;
}
export declare const MediaPipelineStatusUpdate: {
  readonly Pause: "Pause";
  readonly Resume: "Resume";
};
export type MediaPipelineStatusUpdate =
  (typeof MediaPipelineStatusUpdate)[keyof typeof MediaPipelineStatusUpdate];
export interface UpdateMediaInsightsPipelineStatusRequest {
  Identifier: string | undefined;
  UpdateStatus: MediaPipelineStatusUpdate | string | undefined;
}
export declare const SelectedVideoStreamsFilterSensitiveLog: (
  obj: SelectedVideoStreams
) => any;
export declare const SourceConfigurationFilterSensitiveLog: (
  obj: SourceConfiguration
) => any;
export declare const ChimeSdkMeetingConfigurationFilterSensitiveLog: (
  obj: ChimeSdkMeetingConfiguration
) => any;
export declare const CreateMediaCapturePipelineRequestFilterSensitiveLog: (
  obj: CreateMediaCapturePipelineRequest
) => any;
export declare const MediaCapturePipelineFilterSensitiveLog: (
  obj: MediaCapturePipeline
) => any;
export declare const CreateMediaCapturePipelineResponseFilterSensitiveLog: (
  obj: CreateMediaCapturePipelineResponse
) => any;
export declare const S3BucketSinkConfigurationFilterSensitiveLog: (
  obj: S3BucketSinkConfiguration
) => any;
export declare const ConcatenationSinkFilterSensitiveLog: (
  obj: ConcatenationSink
) => any;
export declare const MediaCapturePipelineSourceConfigurationFilterSensitiveLog: (
  obj: MediaCapturePipelineSourceConfiguration
) => any;
export declare const ConcatenationSourceFilterSensitiveLog: (
  obj: ConcatenationSource
) => any;
export declare const CreateMediaConcatenationPipelineRequestFilterSensitiveLog: (
  obj: CreateMediaConcatenationPipelineRequest
) => any;
export declare const MediaConcatenationPipelineFilterSensitiveLog: (
  obj: MediaConcatenationPipeline
) => any;
export declare const CreateMediaConcatenationPipelineResponseFilterSensitiveLog: (
  obj: CreateMediaConcatenationPipelineResponse
) => any;
export declare const S3RecordingSinkRuntimeConfigurationFilterSensitiveLog: (
  obj: S3RecordingSinkRuntimeConfiguration
) => any;
export declare const CreateMediaInsightsPipelineRequestFilterSensitiveLog: (
  obj: CreateMediaInsightsPipelineRequest
) => any;
export declare const MediaInsightsPipelineFilterSensitiveLog: (
  obj: MediaInsightsPipeline
) => any;
export declare const CreateMediaInsightsPipelineResponseFilterSensitiveLog: (
  obj: CreateMediaInsightsPipelineResponse
) => any;
export declare const KinesisDataStreamSinkConfigurationFilterSensitiveLog: (
  obj: KinesisDataStreamSinkConfiguration
) => any;
export declare const LambdaFunctionSinkConfigurationFilterSensitiveLog: (
  obj: LambdaFunctionSinkConfiguration
) => any;
export declare const S3RecordingSinkConfigurationFilterSensitiveLog: (
  obj: S3RecordingSinkConfiguration
) => any;
export declare const SnsTopicSinkConfigurationFilterSensitiveLog: (
  obj: SnsTopicSinkConfiguration
) => any;
export declare const SqsQueueSinkConfigurationFilterSensitiveLog: (
  obj: SqsQueueSinkConfiguration
) => any;
export declare const MediaInsightsPipelineConfigurationElementFilterSensitiveLog: (
  obj: MediaInsightsPipelineConfigurationElement
) => any;
export declare const CreateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog: (
  obj: CreateMediaInsightsPipelineConfigurationRequest
) => any;
export declare const MediaInsightsPipelineConfigurationFilterSensitiveLog: (
  obj: MediaInsightsPipelineConfiguration
) => any;
export declare const CreateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog: (
  obj: CreateMediaInsightsPipelineConfigurationResponse
) => any;
export declare const LiveConnectorRTMPConfigurationFilterSensitiveLog: (
  obj: LiveConnectorRTMPConfiguration
) => any;
export declare const LiveConnectorSinkConfigurationFilterSensitiveLog: (
  obj: LiveConnectorSinkConfiguration
) => any;
export declare const ChimeSdkMeetingLiveConnectorConfigurationFilterSensitiveLog: (
  obj: ChimeSdkMeetingLiveConnectorConfiguration
) => any;
export declare const LiveConnectorSourceConfigurationFilterSensitiveLog: (
  obj: LiveConnectorSourceConfiguration
) => any;
export declare const CreateMediaLiveConnectorPipelineRequestFilterSensitiveLog: (
  obj: CreateMediaLiveConnectorPipelineRequest
) => any;
export declare const MediaLiveConnectorPipelineFilterSensitiveLog: (
  obj: MediaLiveConnectorPipeline
) => any;
export declare const CreateMediaLiveConnectorPipelineResponseFilterSensitiveLog: (
  obj: CreateMediaLiveConnectorPipelineResponse
) => any;
export declare const GetMediaCapturePipelineResponseFilterSensitiveLog: (
  obj: GetMediaCapturePipelineResponse
) => any;
export declare const GetMediaInsightsPipelineConfigurationResponseFilterSensitiveLog: (
  obj: GetMediaInsightsPipelineConfigurationResponse
) => any;
export declare const MediaPipelineFilterSensitiveLog: (
  obj: MediaPipeline
) => any;
export declare const GetMediaPipelineResponseFilterSensitiveLog: (
  obj: GetMediaPipelineResponse
) => any;
export declare const MediaInsightsPipelineConfigurationSummaryFilterSensitiveLog: (
  obj: MediaInsightsPipelineConfigurationSummary
) => any;
export declare const ListMediaInsightsPipelineConfigurationsResponseFilterSensitiveLog: (
  obj: ListMediaInsightsPipelineConfigurationsResponse
) => any;
export declare const UpdateMediaInsightsPipelineConfigurationRequestFilterSensitiveLog: (
  obj: UpdateMediaInsightsPipelineConfigurationRequest
) => any;
export declare const UpdateMediaInsightsPipelineConfigurationResponseFilterSensitiveLog: (
  obj: UpdateMediaInsightsPipelineConfigurationResponse
) => any;
