"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListChannelMemberships = void 0;
const ChimeSDKMessagingClient_1 = require("../ChimeSDKMessagingClient");
const ListChannelMembershipsCommand_1 = require("../commands/ListChannelMembershipsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListChannelMembershipsCommand_1.ListChannelMembershipsCommand(input), ...args);
};
async function* paginateListChannelMemberships(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMessagingClient_1.ChimeSDKMessagingClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMessaging | ChimeSDKMessagingClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListChannelMemberships = paginateListChannelMemberships;
