"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.se_UpdateChannelMessageCommand = exports.se_UpdateChannelFlowCommand = exports.se_UpdateChannelCommand = exports.se_UntagResourceCommand = exports.se_TagResourceCommand = exports.se_SendChannelMessageCommand = exports.se_SearchChannelsCommand = exports.se_RedactChannelMessageCommand = exports.se_PutMessagingStreamingConfigurationsCommand = exports.se_PutChannelMembershipPreferencesCommand = exports.se_PutChannelExpirationSettingsCommand = exports.se_ListTagsForResourceCommand = exports.se_ListSubChannelsCommand = exports.se_ListChannelsModeratedByAppInstanceUserCommand = exports.se_ListChannelsAssociatedWithChannelFlowCommand = exports.se_ListChannelsCommand = exports.se_ListChannelModeratorsCommand = exports.se_ListChannelMessagesCommand = exports.se_ListChannelMembershipsForAppInstanceUserCommand = exports.se_ListChannelMembershipsCommand = exports.se_ListChannelFlowsCommand = exports.se_ListChannelBansCommand = exports.se_GetMessagingStreamingConfigurationsCommand = exports.se_GetMessagingSessionEndpointCommand = exports.se_GetChannelMessageStatusCommand = exports.se_GetChannelMessageCommand = exports.se_GetChannelMembershipPreferencesCommand = exports.se_DisassociateChannelFlowCommand = exports.se_DescribeChannelModeratorCommand = exports.se_DescribeChannelModeratedByAppInstanceUserCommand = exports.se_DescribeChannelMembershipForAppInstanceUserCommand = exports.se_DescribeChannelMembershipCommand = exports.se_DescribeChannelFlowCommand = exports.se_DescribeChannelBanCommand = exports.se_DescribeChannelCommand = exports.se_DeleteMessagingStreamingConfigurationsCommand = exports.se_DeleteChannelModeratorCommand = exports.se_DeleteChannelMessageCommand = exports.se_DeleteChannelMembershipCommand = exports.se_DeleteChannelFlowCommand = exports.se_DeleteChannelBanCommand = exports.se_DeleteChannelCommand = exports.se_CreateChannelModeratorCommand = exports.se_CreateChannelMembershipCommand = exports.se_CreateChannelFlowCommand = exports.se_CreateChannelBanCommand = exports.se_CreateChannelCommand = exports.se_ChannelFlowCallbackCommand = exports.se_BatchCreateChannelMembershipCommand = exports.se_AssociateChannelFlowCommand = void 0;
exports.de_UpdateChannelFlowCommand = exports.de_UpdateChannelCommand = exports.de_UntagResourceCommand = exports.de_TagResourceCommand = exports.de_SendChannelMessageCommand = exports.de_SearchChannelsCommand = exports.de_RedactChannelMessageCommand = exports.de_PutMessagingStreamingConfigurationsCommand = exports.de_PutChannelMembershipPreferencesCommand = exports.de_PutChannelExpirationSettingsCommand = exports.de_ListTagsForResourceCommand = exports.de_ListSubChannelsCommand = exports.de_ListChannelsModeratedByAppInstanceUserCommand = exports.de_ListChannelsAssociatedWithChannelFlowCommand = exports.de_ListChannelsCommand = exports.de_ListChannelModeratorsCommand = exports.de_ListChannelMessagesCommand = exports.de_ListChannelMembershipsForAppInstanceUserCommand = exports.de_ListChannelMembershipsCommand = exports.de_ListChannelFlowsCommand = exports.de_ListChannelBansCommand = exports.de_GetMessagingStreamingConfigurationsCommand = exports.de_GetMessagingSessionEndpointCommand = exports.de_GetChannelMessageStatusCommand = exports.de_GetChannelMessageCommand = exports.de_GetChannelMembershipPreferencesCommand = exports.de_DisassociateChannelFlowCommand = exports.de_DescribeChannelModeratorCommand = exports.de_DescribeChannelModeratedByAppInstanceUserCommand = exports.de_DescribeChannelMembershipForAppInstanceUserCommand = exports.de_DescribeChannelMembershipCommand = exports.de_DescribeChannelFlowCommand = exports.de_DescribeChannelBanCommand = exports.de_DescribeChannelCommand = exports.de_DeleteMessagingStreamingConfigurationsCommand = exports.de_DeleteChannelModeratorCommand = exports.de_DeleteChannelMessageCommand = exports.de_DeleteChannelMembershipCommand = exports.de_DeleteChannelFlowCommand = exports.de_DeleteChannelBanCommand = exports.de_DeleteChannelCommand = exports.de_CreateChannelModeratorCommand = exports.de_CreateChannelMembershipCommand = exports.de_CreateChannelFlowCommand = exports.de_CreateChannelBanCommand = exports.de_CreateChannelCommand = exports.de_ChannelFlowCallbackCommand = exports.de_BatchCreateChannelMembershipCommand = exports.de_AssociateChannelFlowCommand = exports.se_UpdateChannelReadMarkerCommand = void 0;
exports.de_UpdateChannelReadMarkerCommand = exports.de_UpdateChannelMessageCommand = void 0;
const protocol_http_1 = require("@smithy/protocol-http");
const smithy_client_1 = require("@smithy/smithy-client");
const uuid_1 = require("uuid");
const ChimeSDKMessagingServiceException_1 = require("../models/ChimeSDKMessagingServiceException");
const models_0_1 = require("../models/models_0");
const se_AssociateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/channel-flow";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ChannelFlowArn: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_AssociateChannelFlowCommand = se_AssociateChannelFlowCommand;
const se_BatchCreateChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        operation: [, "batch-create"],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        MemberArns: (_) => (0, smithy_client_1._json)(_),
        SubChannelId: [],
        Type: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_BatchCreateChannelMembershipCommand = se_BatchCreateChannelMembershipCommand;
const se_ChannelFlowCallbackCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        operation: [, "channel-flow-callback"],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        CallbackId: [true, (_) => _ ?? (0, uuid_1.v4)()],
        ChannelMessage: (_) => (0, smithy_client_1._json)(_),
        DeleteResource: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ChannelFlowCallbackCommand = se_ChannelFlowCallbackCommand;
const se_CreateChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        AppInstanceArn: [],
        ChannelId: [],
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        ElasticChannelConfiguration: (_) => (0, smithy_client_1._json)(_),
        ExpirationSettings: (_) => (0, smithy_client_1._json)(_),
        MemberArns: (_) => (0, smithy_client_1._json)(_),
        Metadata: [],
        Mode: [],
        ModeratorArns: (_) => (0, smithy_client_1._json)(_),
        Name: [],
        Privacy: [],
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateChannelCommand = se_CreateChannelCommand;
const se_CreateChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        MemberArn: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateChannelBanCommand = se_CreateChannelBanCommand;
const se_CreateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows";
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        AppInstanceArn: [],
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        Name: [],
        Processors: (_) => (0, smithy_client_1._json)(_),
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateChannelFlowCommand = se_CreateChannelFlowCommand;
const se_CreateChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        MemberArn: [],
        SubChannelId: [],
        Type: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateChannelMembershipCommand = se_CreateChannelMembershipCommand;
const se_CreateChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/moderators";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ChannelModeratorArn: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_CreateChannelModeratorCommand = se_CreateChannelModeratorCommand;
const se_DeleteChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteChannelCommand = se_DeleteChannelCommand;
const se_DeleteChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans/{MemberArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteChannelBanCommand = se_DeleteChannelBanCommand;
const se_DeleteChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows/{ChannelFlowArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteChannelFlowCommand = se_DeleteChannelFlowCommand;
const se_DeleteChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    const query = (0, smithy_client_1.map)({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_DeleteChannelMembershipCommand = se_DeleteChannelMembershipCommand;
const se_DeleteChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = (0, smithy_client_1.map)({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_DeleteChannelMessageCommand = se_DeleteChannelMessageCommand;
const se_DeleteChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelModeratorArn", () => input.ChannelModeratorArn, "{ChannelModeratorArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteChannelModeratorCommand = se_DeleteChannelModeratorCommand;
const se_DeleteMessagingStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DeleteMessagingStreamingConfigurationsCommand = se_DeleteMessagingStreamingConfigurationsCommand;
const se_DescribeChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DescribeChannelCommand = se_DescribeChannelCommand;
const se_DescribeChannelBanCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans/{MemberArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DescribeChannelBanCommand = se_DescribeChannelBanCommand;
const se_DescribeChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows/{ChannelFlowArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DescribeChannelFlowCommand = se_DescribeChannelFlowCommand;
const se_DescribeChannelMembershipCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    const query = (0, smithy_client_1.map)({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_DescribeChannelMembershipCommand = se_DescribeChannelMembershipCommand;
const se_DescribeChannelMembershipForAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        scope: [, "app-instance-user-membership"],
        "app-instance-user-arn": [, (0, smithy_client_1.expectNonNull)(input.AppInstanceUserArn, `AppInstanceUserArn`)],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_DescribeChannelMembershipForAppInstanceUserCommand = se_DescribeChannelMembershipForAppInstanceUserCommand;
const se_DescribeChannelModeratedByAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        scope: [, "app-instance-user-moderated-channel"],
        "app-instance-user-arn": [, (0, smithy_client_1.expectNonNull)(input.AppInstanceUserArn, `AppInstanceUserArn`)],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_DescribeChannelModeratedByAppInstanceUserCommand = se_DescribeChannelModeratedByAppInstanceUserCommand;
const se_DescribeChannelModeratorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/moderators/{ChannelModeratorArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelModeratorArn", () => input.ChannelModeratorArn, "{ChannelModeratorArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DescribeChannelModeratorCommand = se_DescribeChannelModeratorCommand;
const se_DisassociateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/channel-flow/{ChannelFlowArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_DisassociateChannelFlowCommand = se_DisassociateChannelFlowCommand;
const se_GetChannelMembershipPreferencesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}/preferences";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_GetChannelMembershipPreferencesCommand = se_GetChannelMembershipPreferencesCommand;
const se_GetChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = (0, smithy_client_1.map)({
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_GetChannelMessageCommand = se_GetChannelMessageCommand;
const se_GetChannelMessageStatusCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = (0, smithy_client_1.map)({
        scope: [, "message-status"],
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_GetChannelMessageStatusCommand = se_GetChannelMessageStatusCommand;
const se_GetMessagingSessionEndpointCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/endpoints/messaging-session";
    let body;
    body = "";
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_GetMessagingSessionEndpointCommand = se_GetMessagingSessionEndpointCommand;
const se_GetMessagingStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_GetMessagingStreamingConfigurationsCommand = se_GetMessagingStreamingConfigurationsCommand;
const se_ListChannelBansCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/bans";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelBansCommand = se_ListChannelBansCommand;
const se_ListChannelFlowsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows";
    const query = (0, smithy_client_1.map)({
        "app-instance-arn": [, (0, smithy_client_1.expectNonNull)(input.AppInstanceArn, `AppInstanceArn`)],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelFlowsCommand = se_ListChannelFlowsCommand;
const se_ListChannelMembershipsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/memberships";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        type: [, input.Type],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelMembershipsCommand = se_ListChannelMembershipsCommand;
const se_ListChannelMembershipsForAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = (0, smithy_client_1.map)({
        scope: [, "app-instance-user-memberships"],
        "app-instance-user-arn": [, input.AppInstanceUserArn],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelMembershipsForAppInstanceUserCommand = se_ListChannelMembershipsForAppInstanceUserCommand;
const se_ListChannelMessagesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/messages";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        "sort-order": [, input.SortOrder],
        "not-before": [
            () => input.NotBefore !== void 0,
            () => (input.NotBefore.toISOString().split(".")[0] + "Z").toString(),
        ],
        "not-after": [
            () => input.NotAfter !== void 0,
            () => (input.NotAfter.toISOString().split(".")[0] + "Z").toString(),
        ],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
        "sub-channel-id": [, input.SubChannelId],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelMessagesCommand = se_ListChannelMessagesCommand;
const se_ListChannelModeratorsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/moderators";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelModeratorsCommand = se_ListChannelModeratorsCommand;
const se_ListChannelsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = (0, smithy_client_1.map)({
        "app-instance-arn": [, (0, smithy_client_1.expectNonNull)(input.AppInstanceArn, `AppInstanceArn`)],
        privacy: [, input.Privacy],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelsCommand = se_ListChannelsCommand;
const se_ListChannelsAssociatedWithChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = (0, smithy_client_1.map)({
        scope: [, "channel-flow-associations"],
        "channel-flow-arn": [, (0, smithy_client_1.expectNonNull)(input.ChannelFlowArn, `ChannelFlowArn`)],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelsAssociatedWithChannelFlowCommand = se_ListChannelsAssociatedWithChannelFlowCommand;
const se_ListChannelsModeratedByAppInstanceUserCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = (0, smithy_client_1.map)({
        scope: [, "app-instance-user-moderated-channels"],
        "app-instance-user-arn": [, input.AppInstanceUserArn],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListChannelsModeratedByAppInstanceUserCommand = se_ListChannelsModeratedByAppInstanceUserCommand;
const se_ListSubChannelsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/subchannels";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    const query = (0, smithy_client_1.map)({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListSubChannelsCommand = se_ListSubChannelsCommand;
const se_ListTagsForResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = (0, smithy_client_1.map)({
        arn: [, (0, smithy_client_1.expectNonNull)(input.ResourceARN, `ResourceARN`)],
    });
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_ListTagsForResourceCommand = se_ListTagsForResourceCommand;
const se_PutChannelExpirationSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/expiration-settings";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ExpirationSettings: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_PutChannelExpirationSettingsCommand = se_PutChannelExpirationSettingsCommand;
const se_PutChannelMembershipPreferencesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/memberships/{MemberArn}/preferences";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MemberArn", () => input.MemberArn, "{MemberArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        Preferences: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_PutChannelMembershipPreferencesCommand = se_PutChannelMembershipPreferencesCommand;
const se_PutMessagingStreamingConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/app-instances/{AppInstanceArn}/streaming-configurations";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "AppInstanceArn", () => input.AppInstanceArn, "{AppInstanceArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        StreamingConfigurations: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_PutMessagingStreamingConfigurationsCommand = se_PutMessagingStreamingConfigurationsCommand;
const se_RedactChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    const query = (0, smithy_client_1.map)({
        operation: [, "redact"],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        SubChannelId: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_RedactChannelMessageCommand = se_RedactChannelMessageCommand;
const se_SearchChannelsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels";
    const query = (0, smithy_client_1.map)({
        operation: [, "search"],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        Fields: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_SearchChannelsCommand = se_SearchChannelsCommand;
const se_SendChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/messages";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ClientRequestToken: [true, (_) => _ ?? (0, uuid_1.v4)()],
        Content: [],
        ContentType: [],
        MessageAttributes: (_) => (0, smithy_client_1._json)(_),
        Metadata: [],
        Persistence: [],
        PushNotification: (_) => (0, smithy_client_1._json)(_),
        SubChannelId: [],
        Target: (_) => (0, smithy_client_1._json)(_),
        Type: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_SendChannelMessageCommand = se_SendChannelMessageCommand;
const se_TagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = (0, smithy_client_1.map)({
        operation: [, "tag-resource"],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ResourceARN: [],
        Tags: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_TagResourceCommand = se_TagResourceCommand;
const se_UntagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = (0, smithy_client_1.map)({
        operation: [, "untag-resource"],
    });
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        ResourceARN: [],
        TagKeys: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
exports.se_UntagResourceCommand = se_UntagResourceCommand;
const se_UpdateChannelCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        Metadata: [],
        Mode: [],
        Name: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_UpdateChannelCommand = se_UpdateChannelCommand;
const se_UpdateChannelFlowCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channel-flows/{ChannelFlowArn}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelFlowArn", () => input.ChannelFlowArn, "{ChannelFlowArn}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        Name: [],
        Processors: (_) => (0, smithy_client_1._json)(_),
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_UpdateChannelFlowCommand = se_UpdateChannelFlowCommand;
const se_UpdateChannelMessageCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "content-type": "application/json",
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/channels/{ChannelArn}/messages/{MessageId}";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "MessageId", () => input.MessageId, "{MessageId}", false);
    let body;
    body = JSON.stringify((0, smithy_client_1.take)(input, {
        Content: [],
        ContentType: [],
        Metadata: [],
        SubChannelId: [],
    }));
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_UpdateChannelMessageCommand = se_UpdateChannelMessageCommand;
const se_UpdateChannelReadMarkerCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-chime-bearer": input.ChimeBearer,
    });
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/channels/{ChannelArn}/readMarker";
    resolvedPath = (0, smithy_client_1.resolvedPath)(resolvedPath, input, "ChannelArn", () => input.ChannelArn, "{ChannelArn}", false);
    let body;
    return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
exports.se_UpdateChannelReadMarkerCommand = se_UpdateChannelReadMarkerCommand;
const de_AssociateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_AssociateChannelFlowCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_AssociateChannelFlowCommand = de_AssociateChannelFlowCommand;
const de_AssociateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_BatchCreateChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_BatchCreateChannelMembershipCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        BatchChannelMemberships: smithy_client_1._json,
        Errors: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_BatchCreateChannelMembershipCommand = de_BatchCreateChannelMembershipCommand;
const de_BatchCreateChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ChannelFlowCallbackCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ChannelFlowCallbackCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        CallbackId: smithy_client_1.expectString,
        ChannelArn: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ChannelFlowCallbackCommand = de_ChannelFlowCallbackCommand;
const de_ChannelFlowCallbackCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateChannelCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateChannelCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateChannelCommand = de_CreateChannelCommand;
const de_CreateChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateChannelBanCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        Member: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateChannelBanCommand = de_CreateChannelBanCommand;
const de_CreateChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateChannelFlowCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelFlowArn: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateChannelFlowCommand = de_CreateChannelFlowCommand;
const de_CreateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateChannelMembershipCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        Member: smithy_client_1._json,
        SubChannelId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateChannelMembershipCommand = de_CreateChannelMembershipCommand;
const de_CreateChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateChannelModeratorCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        ChannelModerator: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_CreateChannelModeratorCommand = de_CreateChannelModeratorCommand;
const de_CreateChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteChannelCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteChannelCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteChannelCommand = de_DeleteChannelCommand;
const de_DeleteChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteChannelBanCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteChannelBanCommand = de_DeleteChannelBanCommand;
const de_DeleteChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteChannelFlowCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteChannelFlowCommand = de_DeleteChannelFlowCommand;
const de_DeleteChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteChannelMembershipCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteChannelMembershipCommand = de_DeleteChannelMembershipCommand;
const de_DeleteChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteChannelMessageCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteChannelMessageCommand = de_DeleteChannelMessageCommand;
const de_DeleteChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteChannelModeratorCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteChannelModeratorCommand = de_DeleteChannelModeratorCommand;
const de_DeleteChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteMessagingStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteMessagingStreamingConfigurationsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DeleteMessagingStreamingConfigurationsCommand = de_DeleteMessagingStreamingConfigurationsCommand;
const de_DeleteMessagingStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DescribeChannelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DescribeChannelCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Channel: (_) => de_Channel(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_DescribeChannelCommand = de_DescribeChannelCommand;
const de_DescribeChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DescribeChannelBanCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DescribeChannelBanCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelBan: (_) => de_ChannelBan(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_DescribeChannelBanCommand = de_DescribeChannelBanCommand;
const de_DescribeChannelBanCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DescribeChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DescribeChannelFlowCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelFlow: (_) => de_ChannelFlow(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_DescribeChannelFlowCommand = de_DescribeChannelFlowCommand;
const de_DescribeChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DescribeChannelMembershipCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DescribeChannelMembershipCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelMembership: (_) => de_ChannelMembership(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_DescribeChannelMembershipCommand = de_DescribeChannelMembershipCommand;
const de_DescribeChannelMembershipCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DescribeChannelMembershipForAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DescribeChannelMembershipForAppInstanceUserCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelMembership: (_) => de_ChannelMembershipForAppInstanceUserSummary(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_DescribeChannelMembershipForAppInstanceUserCommand = de_DescribeChannelMembershipForAppInstanceUserCommand;
const de_DescribeChannelMembershipForAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DescribeChannelModeratedByAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DescribeChannelModeratedByAppInstanceUserCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Channel: (_) => de_ChannelModeratedByAppInstanceUserSummary(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_DescribeChannelModeratedByAppInstanceUserCommand = de_DescribeChannelModeratedByAppInstanceUserCommand;
const de_DescribeChannelModeratedByAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DescribeChannelModeratorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DescribeChannelModeratorCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelModerator: (_) => de_ChannelModerator(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_DescribeChannelModeratorCommand = de_DescribeChannelModeratorCommand;
const de_DescribeChannelModeratorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DisassociateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DisassociateChannelFlowCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_DisassociateChannelFlowCommand = de_DisassociateChannelFlowCommand;
const de_DisassociateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetChannelMembershipPreferencesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetChannelMembershipPreferencesCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        Member: smithy_client_1._json,
        Preferences: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetChannelMembershipPreferencesCommand = de_GetChannelMembershipPreferencesCommand;
const de_GetChannelMembershipPreferencesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetChannelMessageCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelMessage: (_) => de_ChannelMessage(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetChannelMessageCommand = de_GetChannelMessageCommand;
const de_GetChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetChannelMessageStatusCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetChannelMessageStatusCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Status: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetChannelMessageStatusCommand = de_GetChannelMessageStatusCommand;
const de_GetChannelMessageStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetMessagingSessionEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMessagingSessionEndpointCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Endpoint: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetMessagingSessionEndpointCommand = de_GetMessagingSessionEndpointCommand;
const de_GetMessagingSessionEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetMessagingStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMessagingStreamingConfigurationsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        StreamingConfigurations: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_GetMessagingStreamingConfigurationsCommand = de_GetMessagingStreamingConfigurationsCommand;
const de_GetMessagingStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelBansCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelBansCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        ChannelBans: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelBansCommand = de_ListChannelBansCommand;
const de_ListChannelBansCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelFlowsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelFlowsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelFlows: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelFlowsCommand = de_ListChannelFlowsCommand;
const de_ListChannelFlowsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelMembershipsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelMembershipsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        ChannelMemberships: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelMembershipsCommand = de_ListChannelMembershipsCommand;
const de_ListChannelMembershipsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelMembershipsForAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelMembershipsForAppInstanceUserCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelMemberships: (_) => de_ChannelMembershipForAppInstanceUserSummaryList(_, context),
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelMembershipsForAppInstanceUserCommand = de_ListChannelMembershipsForAppInstanceUserCommand;
const de_ListChannelMembershipsForAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelMessagesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelMessagesCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        ChannelMessages: (_) => de_ChannelMessageSummaryList(_, context),
        NextToken: smithy_client_1.expectString,
        SubChannelId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelMessagesCommand = de_ListChannelMessagesCommand;
const de_ListChannelMessagesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelModeratorsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelModeratorsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        ChannelModerators: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelModeratorsCommand = de_ListChannelModeratorsCommand;
const de_ListChannelModeratorsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Channels: (_) => de_ChannelSummaryList(_, context),
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelsCommand = de_ListChannelsCommand;
const de_ListChannelsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelsAssociatedWithChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelsAssociatedWithChannelFlowCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Channels: smithy_client_1._json,
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelsAssociatedWithChannelFlowCommand = de_ListChannelsAssociatedWithChannelFlowCommand;
const de_ListChannelsAssociatedWithChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListChannelsModeratedByAppInstanceUserCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListChannelsModeratedByAppInstanceUserCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Channels: (_) => de_ChannelModeratedByAppInstanceUserSummaryList(_, context),
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListChannelsModeratedByAppInstanceUserCommand = de_ListChannelsModeratedByAppInstanceUserCommand;
const de_ListChannelsModeratedByAppInstanceUserCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListSubChannelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListSubChannelsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        NextToken: smithy_client_1.expectString,
        SubChannels: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListSubChannelsCommand = de_ListSubChannelsCommand;
const de_ListSubChannelsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListTagsForResourceCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Tags: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_ListTagsForResourceCommand = de_ListTagsForResourceCommand;
const de_ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_PutChannelExpirationSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutChannelExpirationSettingsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        ExpirationSettings: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_PutChannelExpirationSettingsCommand = de_PutChannelExpirationSettingsCommand;
const de_PutChannelExpirationSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_PutChannelMembershipPreferencesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutChannelMembershipPreferencesCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        Member: smithy_client_1._json,
        Preferences: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_PutChannelMembershipPreferencesCommand = de_PutChannelMembershipPreferencesCommand;
const de_PutChannelMembershipPreferencesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_PutMessagingStreamingConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutMessagingStreamingConfigurationsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        StreamingConfigurations: smithy_client_1._json,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_PutMessagingStreamingConfigurationsCommand = de_PutMessagingStreamingConfigurationsCommand;
const de_PutMessagingStreamingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmessaging#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_RedactChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_RedactChannelMessageCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        MessageId: smithy_client_1.expectString,
        SubChannelId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_RedactChannelMessageCommand = de_RedactChannelMessageCommand;
const de_RedactChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_SearchChannelsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_SearchChannelsCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        Channels: (_) => de_ChannelSummaryList(_, context),
        NextToken: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_SearchChannelsCommand = de_SearchChannelsCommand;
const de_SearchChannelsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_SendChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_SendChannelMessageCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        MessageId: smithy_client_1.expectString,
        Status: smithy_client_1._json,
        SubChannelId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_SendChannelMessageCommand = de_SendChannelMessageCommand;
const de_SendChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_TagResourceCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_TagResourceCommand = de_TagResourceCommand;
const de_TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmessaging#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_UntagResourceCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    await (0, smithy_client_1.collectBody)(output.body, context);
    return contents;
};
exports.de_UntagResourceCommand = de_UntagResourceCommand;
const de_UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UpdateChannelCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateChannelCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_UpdateChannelCommand = de_UpdateChannelCommand;
const de_UpdateChannelCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UpdateChannelFlowCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateChannelFlowCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelFlowArn: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_UpdateChannelFlowCommand = de_UpdateChannelFlowCommand;
const de_UpdateChannelFlowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UpdateChannelMessageCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateChannelMessageCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
        MessageId: smithy_client_1.expectString,
        Status: smithy_client_1._json,
        SubChannelId: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_UpdateChannelMessageCommand = de_UpdateChannelMessageCommand;
const de_UpdateChannelMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UpdateChannelReadMarkerCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateChannelReadMarkerCommandError(output, context);
    }
    const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output),
    });
    const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
    const doc = (0, smithy_client_1.take)(data, {
        ChannelArn: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
exports.de_UpdateChannelReadMarkerCommand = de_UpdateChannelReadMarkerCommand;
const de_UpdateChannelReadMarkerCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmessaging#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmessaging#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmessaging#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmessaging#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmessaging#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmessaging#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmessaging#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const throwDefaultError = (0, smithy_client_1.withBaseException)(ChimeSDKMessagingServiceException_1.ChimeSDKMessagingServiceException);
const de_BadRequestExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ConflictExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ForbiddenExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ForbiddenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_NotFoundExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ResourceLimitExceededExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ServiceFailureExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ServiceFailureException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ServiceUnavailableExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_ThrottledClientExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.ThrottledClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_UnauthorizedClientExceptionRes = async (parsedOutput, context) => {
    const contents = (0, smithy_client_1.map)({});
    const data = parsedOutput.body;
    const doc = (0, smithy_client_1.take)(data, {
        Code: smithy_client_1.expectString,
        Message: smithy_client_1.expectString,
    });
    Object.assign(contents, doc);
    const exception = new models_0_1.UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
};
const de_AppInstanceUserMembershipSummary = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ReadMarkerTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        SubChannelId: smithy_client_1.expectString,
        Type: smithy_client_1.expectString,
    });
};
const de_Channel = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelArn: smithy_client_1.expectString,
        ChannelFlowArn: smithy_client_1.expectString,
        CreatedBy: smithy_client_1._json,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        ElasticChannelConfiguration: smithy_client_1._json,
        ExpirationSettings: smithy_client_1._json,
        LastMessageTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        LastUpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        Metadata: smithy_client_1.expectString,
        Mode: smithy_client_1.expectString,
        Name: smithy_client_1.expectString,
        Privacy: smithy_client_1.expectString,
    });
};
const de_ChannelBan = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelArn: smithy_client_1.expectString,
        CreatedBy: smithy_client_1._json,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        Member: smithy_client_1._json,
    });
};
const de_ChannelFlow = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelFlowArn: smithy_client_1.expectString,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        LastUpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        Name: smithy_client_1.expectString,
        Processors: smithy_client_1._json,
    });
};
const de_ChannelMembership = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelArn: smithy_client_1.expectString,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        InvitedBy: smithy_client_1._json,
        LastUpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        Member: smithy_client_1._json,
        SubChannelId: smithy_client_1.expectString,
        Type: smithy_client_1.expectString,
    });
};
const de_ChannelMembershipForAppInstanceUserSummary = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        AppInstanceUserMembershipSummary: (_) => de_AppInstanceUserMembershipSummary(_, context),
        ChannelSummary: (_) => de_ChannelSummary(_, context),
    });
};
const de_ChannelMembershipForAppInstanceUserSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ChannelMembershipForAppInstanceUserSummary(entry, context);
    });
    return retVal;
};
const de_ChannelMessage = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelArn: smithy_client_1.expectString,
        Content: smithy_client_1.expectString,
        ContentType: smithy_client_1.expectString,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        LastEditedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        LastUpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        MessageAttributes: smithy_client_1._json,
        MessageId: smithy_client_1.expectString,
        Metadata: smithy_client_1.expectString,
        Persistence: smithy_client_1.expectString,
        Redacted: smithy_client_1.expectBoolean,
        Sender: smithy_client_1._json,
        Status: smithy_client_1._json,
        SubChannelId: smithy_client_1.expectString,
        Target: smithy_client_1._json,
        Type: smithy_client_1.expectString,
    });
};
const de_ChannelMessageSummary = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        Content: smithy_client_1.expectString,
        ContentType: smithy_client_1.expectString,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        LastEditedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        LastUpdatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        MessageAttributes: smithy_client_1._json,
        MessageId: smithy_client_1.expectString,
        Metadata: smithy_client_1.expectString,
        Redacted: smithy_client_1.expectBoolean,
        Sender: smithy_client_1._json,
        Status: smithy_client_1._json,
        Target: smithy_client_1._json,
        Type: smithy_client_1.expectString,
    });
};
const de_ChannelMessageSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ChannelMessageSummary(entry, context);
    });
    return retVal;
};
const de_ChannelModeratedByAppInstanceUserSummary = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelSummary: (_) => de_ChannelSummary(_, context),
    });
};
const de_ChannelModeratedByAppInstanceUserSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ChannelModeratedByAppInstanceUserSummary(entry, context);
    });
    return retVal;
};
const de_ChannelModerator = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelArn: smithy_client_1.expectString,
        CreatedBy: smithy_client_1._json,
        CreatedTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        Moderator: smithy_client_1._json,
    });
};
const de_ChannelSummary = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        ChannelArn: smithy_client_1.expectString,
        LastMessageTimestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        Metadata: smithy_client_1.expectString,
        Mode: smithy_client_1.expectString,
        Name: smithy_client_1.expectString,
        Privacy: smithy_client_1.expectString,
    });
};
const de_ChannelSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ChannelSummary(entry, context);
    });
    return retVal;
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => (0, smithy_client_1.collectBody)(streamBody, context).then((body) => context.utf8Encoder(body));
const isSerializableHeaderValue = (value) => value !== undefined &&
    value !== null &&
    value !== "" &&
    (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) &&
    (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
