import { ChimeSDKMessagingClient } from "../ChimeSDKMessagingClient";
import { ListChannelsCommand, } from "../commands/ListChannelsCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListChannelsCommand(input), ...args);
};
export async function* paginateListChannels(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMessagingClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMessaging | ChimeSDKMessagingClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
