import { HostHeaderInputConfig, HostHeaderResolvedConfig } from "@aws-sdk/middleware-host-header";
import { AwsAuthInputConfig, AwsAuthResolvedConfig } from "@aws-sdk/middleware-signing";
import { UserAgentInputConfig, UserAgentResolvedConfig } from "@aws-sdk/middleware-user-agent";
import { Credentials as __Credentials } from "@aws-sdk/types";
import { RegionInputConfig, RegionResolvedConfig } from "@smithy/config-resolver";
import { EndpointInputConfig, EndpointResolvedConfig } from "@smithy/middleware-endpoint";
import { RetryInputConfig, RetryResolvedConfig } from "@smithy/middleware-retry";
import { HttpHandler as __HttpHandler } from "@smithy/protocol-http";
import { Client as __Client, DefaultsMode as __DefaultsMode, SmithyConfiguration as __SmithyConfiguration, SmithyResolvedConfiguration as __SmithyResolvedConfiguration } from "@smithy/smithy-client";
import { BodyLengthCalculator as __BodyLengthCalculator, ChecksumConstructor as __ChecksumConstructor, Decoder as __Decoder, Encoder as __Encoder, HashConstructor as __HashConstructor, HttpHandlerOptions as __HttpHandlerOptions, Logger as __Logger, Provider as __Provider, Provider, StreamCollector as __StreamCollector, UrlParser as __UrlParser, UserAgent as __UserAgent } from "@smithy/types";
import { AssociateChannelFlowCommandInput, AssociateChannelFlowCommandOutput } from "./commands/AssociateChannelFlowCommand";
import { BatchCreateChannelMembershipCommandInput, BatchCreateChannelMembershipCommandOutput } from "./commands/BatchCreateChannelMembershipCommand";
import { ChannelFlowCallbackCommandInput, ChannelFlowCallbackCommandOutput } from "./commands/ChannelFlowCallbackCommand";
import { CreateChannelBanCommandInput, CreateChannelBanCommandOutput } from "./commands/CreateChannelBanCommand";
import { CreateChannelCommandInput, CreateChannelCommandOutput } from "./commands/CreateChannelCommand";
import { CreateChannelFlowCommandInput, CreateChannelFlowCommandOutput } from "./commands/CreateChannelFlowCommand";
import { CreateChannelMembershipCommandInput, CreateChannelMembershipCommandOutput } from "./commands/CreateChannelMembershipCommand";
import { CreateChannelModeratorCommandInput, CreateChannelModeratorCommandOutput } from "./commands/CreateChannelModeratorCommand";
import { DeleteChannelBanCommandInput, DeleteChannelBanCommandOutput } from "./commands/DeleteChannelBanCommand";
import { DeleteChannelCommandInput, DeleteChannelCommandOutput } from "./commands/DeleteChannelCommand";
import { DeleteChannelFlowCommandInput, DeleteChannelFlowCommandOutput } from "./commands/DeleteChannelFlowCommand";
import { DeleteChannelMembershipCommandInput, DeleteChannelMembershipCommandOutput } from "./commands/DeleteChannelMembershipCommand";
import { DeleteChannelMessageCommandInput, DeleteChannelMessageCommandOutput } from "./commands/DeleteChannelMessageCommand";
import { DeleteChannelModeratorCommandInput, DeleteChannelModeratorCommandOutput } from "./commands/DeleteChannelModeratorCommand";
import { DeleteMessagingStreamingConfigurationsCommandInput, DeleteMessagingStreamingConfigurationsCommandOutput } from "./commands/DeleteMessagingStreamingConfigurationsCommand";
import { DescribeChannelBanCommandInput, DescribeChannelBanCommandOutput } from "./commands/DescribeChannelBanCommand";
import { DescribeChannelCommandInput, DescribeChannelCommandOutput } from "./commands/DescribeChannelCommand";
import { DescribeChannelFlowCommandInput, DescribeChannelFlowCommandOutput } from "./commands/DescribeChannelFlowCommand";
import { DescribeChannelMembershipCommandInput, DescribeChannelMembershipCommandOutput } from "./commands/DescribeChannelMembershipCommand";
import { DescribeChannelMembershipForAppInstanceUserCommandInput, DescribeChannelMembershipForAppInstanceUserCommandOutput } from "./commands/DescribeChannelMembershipForAppInstanceUserCommand";
import { DescribeChannelModeratedByAppInstanceUserCommandInput, DescribeChannelModeratedByAppInstanceUserCommandOutput } from "./commands/DescribeChannelModeratedByAppInstanceUserCommand";
import { DescribeChannelModeratorCommandInput, DescribeChannelModeratorCommandOutput } from "./commands/DescribeChannelModeratorCommand";
import { DisassociateChannelFlowCommandInput, DisassociateChannelFlowCommandOutput } from "./commands/DisassociateChannelFlowCommand";
import { GetChannelMembershipPreferencesCommandInput, GetChannelMembershipPreferencesCommandOutput } from "./commands/GetChannelMembershipPreferencesCommand";
import { GetChannelMessageCommandInput, GetChannelMessageCommandOutput } from "./commands/GetChannelMessageCommand";
import { GetChannelMessageStatusCommandInput, GetChannelMessageStatusCommandOutput } from "./commands/GetChannelMessageStatusCommand";
import { GetMessagingSessionEndpointCommandInput, GetMessagingSessionEndpointCommandOutput } from "./commands/GetMessagingSessionEndpointCommand";
import { GetMessagingStreamingConfigurationsCommandInput, GetMessagingStreamingConfigurationsCommandOutput } from "./commands/GetMessagingStreamingConfigurationsCommand";
import { ListChannelBansCommandInput, ListChannelBansCommandOutput } from "./commands/ListChannelBansCommand";
import { ListChannelFlowsCommandInput, ListChannelFlowsCommandOutput } from "./commands/ListChannelFlowsCommand";
import { ListChannelMembershipsCommandInput, ListChannelMembershipsCommandOutput } from "./commands/ListChannelMembershipsCommand";
import { ListChannelMembershipsForAppInstanceUserCommandInput, ListChannelMembershipsForAppInstanceUserCommandOutput } from "./commands/ListChannelMembershipsForAppInstanceUserCommand";
import { ListChannelMessagesCommandInput, ListChannelMessagesCommandOutput } from "./commands/ListChannelMessagesCommand";
import { ListChannelModeratorsCommandInput, ListChannelModeratorsCommandOutput } from "./commands/ListChannelModeratorsCommand";
import { ListChannelsAssociatedWithChannelFlowCommandInput, ListChannelsAssociatedWithChannelFlowCommandOutput } from "./commands/ListChannelsAssociatedWithChannelFlowCommand";
import { ListChannelsCommandInput, ListChannelsCommandOutput } from "./commands/ListChannelsCommand";
import { ListChannelsModeratedByAppInstanceUserCommandInput, ListChannelsModeratedByAppInstanceUserCommandOutput } from "./commands/ListChannelsModeratedByAppInstanceUserCommand";
import { ListSubChannelsCommandInput, ListSubChannelsCommandOutput } from "./commands/ListSubChannelsCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { PutChannelExpirationSettingsCommandInput, PutChannelExpirationSettingsCommandOutput } from "./commands/PutChannelExpirationSettingsCommand";
import { PutChannelMembershipPreferencesCommandInput, PutChannelMembershipPreferencesCommandOutput } from "./commands/PutChannelMembershipPreferencesCommand";
import { PutMessagingStreamingConfigurationsCommandInput, PutMessagingStreamingConfigurationsCommandOutput } from "./commands/PutMessagingStreamingConfigurationsCommand";
import { RedactChannelMessageCommandInput, RedactChannelMessageCommandOutput } from "./commands/RedactChannelMessageCommand";
import { SearchChannelsCommandInput, SearchChannelsCommandOutput } from "./commands/SearchChannelsCommand";
import { SendChannelMessageCommandInput, SendChannelMessageCommandOutput } from "./commands/SendChannelMessageCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateChannelCommandInput, UpdateChannelCommandOutput } from "./commands/UpdateChannelCommand";
import { UpdateChannelFlowCommandInput, UpdateChannelFlowCommandOutput } from "./commands/UpdateChannelFlowCommand";
import { UpdateChannelMessageCommandInput, UpdateChannelMessageCommandOutput } from "./commands/UpdateChannelMessageCommand";
import { UpdateChannelReadMarkerCommandInput, UpdateChannelReadMarkerCommandOutput } from "./commands/UpdateChannelReadMarkerCommand";
import { ClientInputEndpointParameters, ClientResolvedEndpointParameters, EndpointParameters } from "./endpoint/EndpointParameters";
export { __Client };
/**
 * @public
 */
export type ServiceInputTypes = AssociateChannelFlowCommandInput | BatchCreateChannelMembershipCommandInput | ChannelFlowCallbackCommandInput | CreateChannelBanCommandInput | CreateChannelCommandInput | CreateChannelFlowCommandInput | CreateChannelMembershipCommandInput | CreateChannelModeratorCommandInput | DeleteChannelBanCommandInput | DeleteChannelCommandInput | DeleteChannelFlowCommandInput | DeleteChannelMembershipCommandInput | DeleteChannelMessageCommandInput | DeleteChannelModeratorCommandInput | DeleteMessagingStreamingConfigurationsCommandInput | DescribeChannelBanCommandInput | DescribeChannelCommandInput | DescribeChannelFlowCommandInput | DescribeChannelMembershipCommandInput | DescribeChannelMembershipForAppInstanceUserCommandInput | DescribeChannelModeratedByAppInstanceUserCommandInput | DescribeChannelModeratorCommandInput | DisassociateChannelFlowCommandInput | GetChannelMembershipPreferencesCommandInput | GetChannelMessageCommandInput | GetChannelMessageStatusCommandInput | GetMessagingSessionEndpointCommandInput | GetMessagingStreamingConfigurationsCommandInput | ListChannelBansCommandInput | ListChannelFlowsCommandInput | ListChannelMembershipsCommandInput | ListChannelMembershipsForAppInstanceUserCommandInput | ListChannelMessagesCommandInput | ListChannelModeratorsCommandInput | ListChannelsAssociatedWithChannelFlowCommandInput | ListChannelsCommandInput | ListChannelsModeratedByAppInstanceUserCommandInput | ListSubChannelsCommandInput | ListTagsForResourceCommandInput | PutChannelExpirationSettingsCommandInput | PutChannelMembershipPreferencesCommandInput | PutMessagingStreamingConfigurationsCommandInput | RedactChannelMessageCommandInput | SearchChannelsCommandInput | SendChannelMessageCommandInput | TagResourceCommandInput | UntagResourceCommandInput | UpdateChannelCommandInput | UpdateChannelFlowCommandInput | UpdateChannelMessageCommandInput | UpdateChannelReadMarkerCommandInput;
/**
 * @public
 */
export type ServiceOutputTypes = AssociateChannelFlowCommandOutput | BatchCreateChannelMembershipCommandOutput | ChannelFlowCallbackCommandOutput | CreateChannelBanCommandOutput | CreateChannelCommandOutput | CreateChannelFlowCommandOutput | CreateChannelMembershipCommandOutput | CreateChannelModeratorCommandOutput | DeleteChannelBanCommandOutput | DeleteChannelCommandOutput | DeleteChannelFlowCommandOutput | DeleteChannelMembershipCommandOutput | DeleteChannelMessageCommandOutput | DeleteChannelModeratorCommandOutput | DeleteMessagingStreamingConfigurationsCommandOutput | DescribeChannelBanCommandOutput | DescribeChannelCommandOutput | DescribeChannelFlowCommandOutput | DescribeChannelMembershipCommandOutput | DescribeChannelMembershipForAppInstanceUserCommandOutput | DescribeChannelModeratedByAppInstanceUserCommandOutput | DescribeChannelModeratorCommandOutput | DisassociateChannelFlowCommandOutput | GetChannelMembershipPreferencesCommandOutput | GetChannelMessageCommandOutput | GetChannelMessageStatusCommandOutput | GetMessagingSessionEndpointCommandOutput | GetMessagingStreamingConfigurationsCommandOutput | ListChannelBansCommandOutput | ListChannelFlowsCommandOutput | ListChannelMembershipsCommandOutput | ListChannelMembershipsForAppInstanceUserCommandOutput | ListChannelMessagesCommandOutput | ListChannelModeratorsCommandOutput | ListChannelsAssociatedWithChannelFlowCommandOutput | ListChannelsCommandOutput | ListChannelsModeratedByAppInstanceUserCommandOutput | ListSubChannelsCommandOutput | ListTagsForResourceCommandOutput | PutChannelExpirationSettingsCommandOutput | PutChannelMembershipPreferencesCommandOutput | PutMessagingStreamingConfigurationsCommandOutput | RedactChannelMessageCommandOutput | SearchChannelsCommandOutput | SendChannelMessageCommandOutput | TagResourceCommandOutput | UntagResourceCommandOutput | UpdateChannelCommandOutput | UpdateChannelFlowCommandOutput | UpdateChannelMessageCommandOutput | UpdateChannelReadMarkerCommandOutput;
/**
 * @public
 */
export interface ClientDefaults extends Partial<__SmithyResolvedConfiguration<__HttpHandlerOptions>> {
    /**
     * The HTTP handler to use. Fetch in browser and Https in Nodejs.
     */
    requestHandler?: __HttpHandler;
    /**
     * A constructor for a class implementing the {@link @smithy/types#ChecksumConstructor} interface
     * that computes the SHA-256 HMAC or checksum of a string or binary buffer.
     * @internal
     */
    sha256?: __ChecksumConstructor | __HashConstructor;
    /**
     * The function that will be used to convert strings into HTTP endpoints.
     * @internal
     */
    urlParser?: __UrlParser;
    /**
     * A function that can calculate the length of a request body.
     * @internal
     */
    bodyLengthChecker?: __BodyLengthCalculator;
    /**
     * A function that converts a stream into an array of bytes.
     * @internal
     */
    streamCollector?: __StreamCollector;
    /**
     * The function that will be used to convert a base64-encoded string to a byte array.
     * @internal
     */
    base64Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a base64-encoded string.
     * @internal
     */
    base64Encoder?: __Encoder;
    /**
     * The function that will be used to convert a UTF8-encoded string to a byte array.
     * @internal
     */
    utf8Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a UTF-8 encoded string.
     * @internal
     */
    utf8Encoder?: __Encoder;
    /**
     * The runtime environment.
     * @internal
     */
    runtime?: string;
    /**
     * Disable dynamically changing the endpoint of the client based on the hostPrefix
     * trait of an operation.
     */
    disableHostPrefix?: boolean;
    /**
     * Unique service identifier.
     * @internal
     */
    serviceId?: string;
    /**
     * Enables IPv6/IPv4 dualstack endpoint.
     */
    useDualstackEndpoint?: boolean | __Provider<boolean>;
    /**
     * Enables FIPS compatible endpoints.
     */
    useFipsEndpoint?: boolean | __Provider<boolean>;
    /**
     * The AWS region to which this client will send requests
     */
    region?: string | __Provider<string>;
    /**
     * Default credentials provider; Not available in browser runtime.
     * @internal
     */
    credentialDefaultProvider?: (input: any) => __Provider<__Credentials>;
    /**
     * The provider populating default tracking information to be sent with `user-agent`, `x-amz-user-agent` header
     * @internal
     */
    defaultUserAgentProvider?: Provider<__UserAgent>;
    /**
     * Value for how many times a request will be made at most in case of retry.
     */
    maxAttempts?: number | __Provider<number>;
    /**
     * Specifies which retry algorithm to use.
     */
    retryMode?: string | __Provider<string>;
    /**
     * Optional logger for logging debug/info/warn/error.
     */
    logger?: __Logger;
    /**
     * The {@link @smithy/smithy-client#DefaultsMode} that will be used to determine how certain default configuration options are resolved in the SDK.
     */
    defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
/**
 * @public
 */
export type ChimeSDKMessagingClientConfigType = Partial<__SmithyConfiguration<__HttpHandlerOptions>> & ClientDefaults & RegionInputConfig & EndpointInputConfig<EndpointParameters> & RetryInputConfig & HostHeaderInputConfig & AwsAuthInputConfig & UserAgentInputConfig & ClientInputEndpointParameters;
/**
 * @public
 *
 *  The configuration interface of ChimeSDKMessagingClient class constructor that set the region, credentials and other options.
 */
export interface ChimeSDKMessagingClientConfig extends ChimeSDKMessagingClientConfigType {
}
/**
 * @public
 */
export type ChimeSDKMessagingClientResolvedConfigType = __SmithyResolvedConfiguration<__HttpHandlerOptions> & Required<ClientDefaults> & RegionResolvedConfig & EndpointResolvedConfig<EndpointParameters> & RetryResolvedConfig & HostHeaderResolvedConfig & AwsAuthResolvedConfig & UserAgentResolvedConfig & ClientResolvedEndpointParameters;
/**
 * @public
 *
 *  The resolved configuration interface of ChimeSDKMessagingClient class. This is resolved and normalized from the {@link ChimeSDKMessagingClientConfig | constructor configuration interface}.
 */
export interface ChimeSDKMessagingClientResolvedConfig extends ChimeSDKMessagingClientResolvedConfigType {
}
/**
 * @public
 * <p>The Amazon Chime SDK messaging APIs in this section allow software developers to send
 *          and receive messages in custom messaging applications. These APIs depend on the frameworks
 *          provided by the Amazon Chime SDK identity APIs. For more information about the messaging
 *          APIs, see <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Messaging.html">Amazon Chime SDK messaging</a>.</p>
 */
export declare class ChimeSDKMessagingClient extends __Client<__HttpHandlerOptions, ServiceInputTypes, ServiceOutputTypes, ChimeSDKMessagingClientResolvedConfig> {
    /**
     * The resolved configuration of ChimeSDKMessagingClient class. This is resolved and normalized from the {@link ChimeSDKMessagingClientConfig | constructor configuration interface}.
     */
    readonly config: ChimeSDKMessagingClientResolvedConfig;
    constructor(configuration: ChimeSDKMessagingClientConfig);
    /**
     * Destroy underlying resources, like sockets. It's usually not necessary to do this.
     * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
     * Otherwise, sockets might stay open for quite a long time before the server terminates them.
     */
    destroy(): void;
}
