"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListVoiceProfiles = void 0;
const ChimeSDKVoiceClient_1 = require("../ChimeSDKVoiceClient");
const ListVoiceProfilesCommand_1 = require("../commands/ListVoiceProfilesCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListVoiceProfilesCommand_1.ListVoiceProfilesCommand(input), ...args);
};
async function* paginateListVoiceProfiles(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKVoiceClient_1.ChimeSDKVoiceClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKVoice | ChimeSDKVoiceClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListVoiceProfiles = paginateListVoiceProfiles;
