import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { BatchUpdatePhoneNumberRequestFilterSensitiveLog, BatchUpdatePhoneNumberResponseFilterSensitiveLog, } from "../models/models_0";
import { de_BatchUpdatePhoneNumberCommand, se_BatchUpdatePhoneNumberCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class BatchUpdatePhoneNumberCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, BatchUpdatePhoneNumberCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeSDKVoiceClient";
        const commandName = "BatchUpdatePhoneNumberCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: BatchUpdatePhoneNumberRequestFilterSensitiveLog,
            outputFilterSensitiveLog: BatchUpdatePhoneNumberResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return se_BatchUpdatePhoneNumberCommand(input, context);
    }
    deserialize(output, context) {
        return de_BatchUpdatePhoneNumberCommand(output, context);
    }
}
