import { HttpRequest as __HttpRequest } from "@smithy/protocol-http";
import { _json, collectBody, decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectInt32 as __expectInt32, expectNonNull as __expectNonNull, expectObject as __expectObject, expectString as __expectString, limitedParseFloat32 as __limitedParseFloat32, map, parseRfc3339DateTimeWithOffset as __parseRfc3339DateTimeWithOffset, resolvedPath as __resolvedPath, take, withBaseException, } from "@smithy/smithy-client";
import { ChimeSDKVoiceServiceException as __BaseException } from "../models/ChimeSDKVoiceServiceException";
import { AccessDeniedException, BadRequestException, ConflictException, ForbiddenException, GoneException, NotFoundException, ResourceLimitExceededException, ServiceFailureException, ServiceUnavailableException, ThrottledClientException, UnauthorizedClientException, UnprocessableEntityException, } from "../models/models_0";
export const se_AssociatePhoneNumbersWithVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "associate-phone-numbers"],
    });
    let body;
    body = JSON.stringify(take(input, {
        E164PhoneNumbers: (_) => _json(_),
        ForceAssociate: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_AssociatePhoneNumbersWithVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    const query = map({
        operation: [, "associate-phone-numbers"],
    });
    let body;
    body = JSON.stringify(take(input, {
        E164PhoneNumbers: (_) => _json(_),
        ForceAssociate: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_BatchDeletePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers";
    const query = map({
        operation: [, "batch-delete"],
    });
    let body;
    body = JSON.stringify(take(input, {
        PhoneNumberIds: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_BatchUpdatePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers";
    const query = map({
        operation: [, "batch-update"],
    });
    let body;
    body = JSON.stringify(take(input, {
        UpdatePhoneNumberRequestItems: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_CreatePhoneNumberOrderCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-orders";
    let body;
    body = JSON.stringify(take(input, {
        E164PhoneNumbers: (_) => _json(_),
        ProductType: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Capabilities: (_) => _json(_),
        ExpiryMinutes: [],
        GeoMatchLevel: [],
        GeoMatchParams: (_) => _json(_),
        Name: [],
        NumberSelectionBehavior: [],
        ParticipantPhoneNumbers: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-media-applications";
    let body;
    body = JSON.stringify(take(input, {
        AwsRegion: [],
        Endpoints: (_) => _json(_),
        Name: [],
        Tags: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateSipMediaApplicationCallCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/calls";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    body = JSON.stringify(take(input, {
        ArgumentsMap: (_) => _json(_),
        FromPhoneNumber: [],
        SipHeaders: (_) => _json(_),
        ToPhoneNumber: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules";
    let body;
    body = JSON.stringify(take(input, {
        Disabled: [],
        Name: [],
        TargetApplications: (_) => _json(_),
        TriggerType: [],
        TriggerValue: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors";
    let body;
    body = JSON.stringify(take(input, {
        AwsRegion: [],
        Name: [],
        RequireEncryption: [],
        Tags: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connector-groups";
    let body;
    body = JSON.stringify(take(input, {
        Name: [],
        VoiceConnectorItems: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateVoiceProfileCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-profiles";
    let body;
    body = JSON.stringify(take(input, {
        SpeakerSearchTaskId: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateVoiceProfileDomainCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-profile-domains";
    let body;
    body = JSON.stringify(take(input, {
        ClientRequestToken: [],
        Description: [],
        Name: [],
        ServerSideEncryptionConfiguration: (_) => _json(_),
        Tags: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeletePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ProxySessionId", () => input.ProxySessionId, "{ProxySessionId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules/{SipRuleId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipRuleId", () => input.SipRuleId, "{SipRuleId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorEmergencyCallingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorOriginationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/origination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorProxyCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorStreamingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/streaming-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorTerminationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceConnectorTerminationCredentialsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/credentials";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "delete"],
    });
    let body;
    body = JSON.stringify(take(input, {
        Usernames: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_DeleteVoiceProfileCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-profiles/{VoiceProfileId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceProfileId", () => input.VoiceProfileId, "{VoiceProfileId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteVoiceProfileDomainCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-profile-domains/{VoiceProfileDomainId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceProfileDomainId", () => input.VoiceProfileDomainId, "{VoiceProfileDomainId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DisassociatePhoneNumbersFromVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "disassociate-phone-numbers"],
    });
    let body;
    body = JSON.stringify(take(input, {
        E164PhoneNumbers: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_DisassociatePhoneNumbersFromVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    const query = map({
        operation: [, "disassociate-phone-numbers"],
    });
    let body;
    body = JSON.stringify(take(input, {
        E164PhoneNumbers: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_GetGlobalSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings";
    let body;
    body = "";
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetPhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetPhoneNumberOrderCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-orders/{PhoneNumberOrderId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberOrderId", () => input.PhoneNumberOrderId, "{PhoneNumberOrderId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetPhoneNumberSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings/phone-number";
    let body;
    body = "";
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ProxySessionId", () => input.ProxySessionId, "{ProxySessionId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetSipMediaApplicationAlexaSkillConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/alexa-skill-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetSipMediaApplicationLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules/{SipRuleId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipRuleId", () => input.SipRuleId, "{SipRuleId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetSpeakerSearchTaskCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/speaker-search-tasks/{SpeakerSearchTaskId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "SpeakerSearchTaskId", () => input.SpeakerSearchTaskId, "{SpeakerSearchTaskId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorEmergencyCallingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorOriginationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/origination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorProxyCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorStreamingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/streaming-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorTerminationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceConnectorTerminationHealthCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/health";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceProfileCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-profiles/{VoiceProfileId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceProfileId", () => input.VoiceProfileId, "{VoiceProfileId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceProfileDomainCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-profile-domains/{VoiceProfileDomainId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceProfileDomainId", () => input.VoiceProfileDomainId, "{VoiceProfileDomainId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetVoiceToneAnalysisTaskCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/voice-tone-analysis-tasks/{VoiceToneAnalysisTaskId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceToneAnalysisTaskId", () => input.VoiceToneAnalysisTaskId, "{VoiceToneAnalysisTaskId}", false);
    const query = map({
        isCaller: [__expectNonNull(input.IsCaller, `IsCaller`) != null, () => input.IsCaller.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListAvailableVoiceConnectorRegionsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connector-regions";
    let body;
    body = "";
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_ListPhoneNumberOrdersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-orders";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListPhoneNumbersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers";
    const query = map({
        status: [, input.Status],
        "product-type": [, input.ProductType],
        "filter-name": [, input.FilterName],
        "filter-value": [, input.FilterValue],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListProxySessionsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        status: [, input.Status],
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListSipMediaApplicationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-media-applications";
    const query = map({
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListSipRulesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules";
    const query = map({
        "sip-media-application": [, input.SipMediaApplicationId],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListSupportedPhoneNumberCountriesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-number-countries";
    const query = map({
        "product-type": [, __expectNonNull(input.ProductType, `ProductType`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        arn: [, __expectNonNull(input.ResourceARN, `ResourceARN`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListVoiceConnectorGroupsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connector-groups";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListVoiceConnectorsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListVoiceConnectorTerminationCredentialsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/credentials";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_ListVoiceProfileDomainsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-profile-domains";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListVoiceProfilesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-profiles";
    const query = map({
        "voice-profile-domain-id": [, __expectNonNull(input.VoiceProfileDomainId, `VoiceProfileDomainId`)],
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_PutSipMediaApplicationAlexaSkillConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/alexa-skill-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    body = JSON.stringify(take(input, {
        SipMediaApplicationAlexaSkillConfiguration: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutSipMediaApplicationLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    body = JSON.stringify(take(input, {
        SipMediaApplicationLoggingConfiguration: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutVoiceConnectorEmergencyCallingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/emergency-calling-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        EmergencyCallingConfiguration: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutVoiceConnectorLoggingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/logging-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        LoggingConfiguration: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutVoiceConnectorOriginationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/origination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Origination: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutVoiceConnectorProxyCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/programmable-numbers/proxy";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        DefaultSessionExpiryMinutes: [],
        Disabled: [],
        FallBackPhoneNumber: [],
        PhoneNumberPoolCountries: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutVoiceConnectorStreamingConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/streaming-configuration";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        StreamingConfiguration: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutVoiceConnectorTerminationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Termination: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_PutVoiceConnectorTerminationCredentialsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/termination/credentials";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    const query = map({
        operation: [, "put"],
    });
    let body;
    body = JSON.stringify(take(input, {
        Credentials: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_RestorePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    const query = map({
        operation: [, "restore"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_SearchAvailablePhoneNumbersCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/search";
    const query = map({
        type: [, "phone-numbers"],
        "area-code": [, input.AreaCode],
        city: [, input.City],
        country: [, input.Country],
        state: [, input.State],
        "toll-free-prefix": [, input.TollFreePrefix],
        "phone-number-type": [, input.PhoneNumberType],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
        "next-token": [, input.NextToken],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_StartSpeakerSearchTaskCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/speaker-search-tasks";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        CallLeg: [],
        ClientRequestToken: [],
        TransactionId: [],
        VoiceProfileDomainId: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_StartVoiceToneAnalysisTaskCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/voice-tone-analysis-tasks";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        ClientRequestToken: [],
        LanguageCode: [],
        TransactionId: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_StopSpeakerSearchTaskCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/speaker-search-tasks/{SpeakerSearchTaskId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "SpeakerSearchTaskId", () => input.SpeakerSearchTaskId, "{SpeakerSearchTaskId}", false);
    const query = map({
        operation: [, "stop"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_StopVoiceToneAnalysisTaskCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/voice-tone-analysis-tasks/{VoiceToneAnalysisTaskId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceToneAnalysisTaskId", () => input.VoiceToneAnalysisTaskId, "{VoiceToneAnalysisTaskId}", false);
    const query = map({
        operation: [, "stop"],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_TagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "tag-resource"],
    });
    let body;
    body = JSON.stringify(take(input, {
        ResourceARN: [],
        Tags: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_UntagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "untag-resource"],
    });
    let body;
    body = JSON.stringify(take(input, {
        ResourceARN: [],
        TagKeys: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_UpdateGlobalSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings";
    let body;
    body = JSON.stringify(take(input, {
        VoiceConnector: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdatePhoneNumberCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/phone-numbers/{PhoneNumberId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "PhoneNumberId", () => input.PhoneNumberId, "{PhoneNumberId}", false);
    let body;
    body = JSON.stringify(take(input, {
        CallingName: [],
        ProductType: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdatePhoneNumberSettingsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/settings/phone-number";
    let body;
    body = JSON.stringify(take(input, {
        CallingName: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateProxySessionCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connectors/{VoiceConnectorId}/proxy-sessions/{ProxySessionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "ProxySessionId", () => input.ProxySessionId, "{ProxySessionId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Capabilities: (_) => _json(_),
        ExpiryMinutes: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateSipMediaApplicationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Endpoints: (_) => _json(_),
        Name: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateSipMediaApplicationCallCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sip-media-applications/{SipMediaApplicationId}/calls/{TransactionId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipMediaApplicationId", () => input.SipMediaApplicationId, "{SipMediaApplicationId}", false);
    resolvedPath = __resolvedPath(resolvedPath, input, "TransactionId", () => input.TransactionId, "{TransactionId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Arguments: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateSipRuleCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sip-rules/{SipRuleId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "SipRuleId", () => input.SipRuleId, "{SipRuleId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Disabled: [],
        Name: [],
        TargetApplications: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateVoiceConnectorCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-connectors/{VoiceConnectorId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorId", () => input.VoiceConnectorId, "{VoiceConnectorId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Name: [],
        RequireEncryption: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateVoiceConnectorGroupCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-connector-groups/{VoiceConnectorGroupId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceConnectorGroupId", () => input.VoiceConnectorGroupId, "{VoiceConnectorGroupId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Name: [],
        VoiceConnectorItems: (_) => _json(_),
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateVoiceProfileCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/voice-profiles/{VoiceProfileId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceProfileId", () => input.VoiceProfileId, "{VoiceProfileId}", false);
    let body;
    body = JSON.stringify(take(input, {
        SpeakerSearchTaskId: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateVoiceProfileDomainCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/voice-profile-domains/{VoiceProfileDomainId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "VoiceProfileDomainId", () => input.VoiceProfileDomainId, "{VoiceProfileDomainId}", false);
    let body;
    body = JSON.stringify(take(input, {
        Description: [],
        Name: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_ValidateE911AddressCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/emergency-calling/address";
    let body;
    body = JSON.stringify(take(input, {
        AwsAccountId: [],
        City: [],
        Country: [],
        PostalCode: [],
        State: [],
        StreetInfo: [],
        StreetNumber: [],
    }));
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const de_AssociatePhoneNumbersWithVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_AssociatePhoneNumbersWithVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberErrors: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_AssociatePhoneNumbersWithVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_AssociatePhoneNumbersWithVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_AssociatePhoneNumbersWithVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberErrors: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_AssociatePhoneNumbersWithVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchDeletePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_BatchDeletePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberErrors: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_BatchDeletePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchUpdatePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_BatchUpdatePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberErrors: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_BatchUpdatePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreatePhoneNumberOrderCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreatePhoneNumberOrderCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberOrder: (_) => de_PhoneNumberOrder(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreatePhoneNumberOrderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        ProxySession: (_) => de_ProxySession(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplication: (_) => de_SipMediaApplication(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateSipMediaApplicationCallCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateSipMediaApplicationCallCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplicationCall: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateSipMediaApplicationCallCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipRule: (_) => de_SipRule(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnector: (_) => de_VoiceConnector(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnectorGroup: (_) => de_VoiceConnectorGroup(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateVoiceProfileCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateVoiceProfileCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceProfile: (_) => de_VoiceProfile(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateVoiceProfileCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "GoneException":
        case "com.amazonaws.chimesdkvoice#GoneException":
            throw await de_GoneExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateVoiceProfileDomainCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateVoiceProfileDomainCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceProfileDomain: (_) => de_VoiceProfileDomain(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_CreateVoiceProfileDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeletePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeletePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeletePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorEmergencyCallingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorEmergencyCallingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorEmergencyCallingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorOriginationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorOriginationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorOriginationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorProxyCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorProxyCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorProxyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorStreamingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorStreamingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorStreamingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorTerminationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorTerminationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorTerminationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceConnectorTerminationCredentialsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceConnectorTerminationCredentialsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceConnectorTerminationCredentialsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceProfileCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceProfileCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceProfileCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteVoiceProfileDomainCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteVoiceProfileDomainCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteVoiceProfileDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DisassociatePhoneNumbersFromVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DisassociatePhoneNumbersFromVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberErrors: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_DisassociatePhoneNumbersFromVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DisassociatePhoneNumbersFromVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_DisassociatePhoneNumbersFromVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberErrors: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_DisassociatePhoneNumbersFromVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetGlobalSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetGlobalSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnector: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetGlobalSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetPhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetPhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumber: (_) => de_PhoneNumber(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetPhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetPhoneNumberOrderCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetPhoneNumberOrderCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberOrder: (_) => de_PhoneNumberOrder(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetPhoneNumberOrderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetPhoneNumberSettingsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetPhoneNumberSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        CallingName: __expectString,
        CallingNameUpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetPhoneNumberSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        ProxySession: (_) => de_ProxySession(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplication: (_) => de_SipMediaApplication(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetSipMediaApplicationAlexaSkillConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetSipMediaApplicationAlexaSkillConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplicationAlexaSkillConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetSipMediaApplicationAlexaSkillConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetSipMediaApplicationLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetSipMediaApplicationLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplicationLoggingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetSipMediaApplicationLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipRule: (_) => de_SipRule(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetSpeakerSearchTaskCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetSpeakerSearchTaskCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SpeakerSearchTask: (_) => de_SpeakerSearchTask(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetSpeakerSearchTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnector: (_) => de_VoiceConnector(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorEmergencyCallingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorEmergencyCallingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        EmergencyCallingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorEmergencyCallingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnectorGroup: (_) => de_VoiceConnectorGroup(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        LoggingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorOriginationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorOriginationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Origination: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorOriginationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorProxyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorProxyCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Proxy: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorProxyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorStreamingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorStreamingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        StreamingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorStreamingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorTerminationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorTerminationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Termination: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorTerminationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceConnectorTerminationHealthCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceConnectorTerminationHealthCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        TerminationHealth: (_) => de_TerminationHealth(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceConnectorTerminationHealthCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceProfileCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceProfile: (_) => de_VoiceProfile(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceProfileCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceProfileDomainCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceProfileDomainCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceProfileDomain: (_) => de_VoiceProfileDomain(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceProfileDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetVoiceToneAnalysisTaskCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetVoiceToneAnalysisTaskCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceToneAnalysisTask: (_) => de_VoiceToneAnalysisTask(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_GetVoiceToneAnalysisTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListAvailableVoiceConnectorRegionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListAvailableVoiceConnectorRegionsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnectorRegions: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListAvailableVoiceConnectorRegionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListPhoneNumberOrdersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListPhoneNumberOrdersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        PhoneNumberOrders: (_) => de_PhoneNumberOrderList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListPhoneNumberOrdersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListPhoneNumbersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListPhoneNumbersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        PhoneNumbers: (_) => de_PhoneNumberList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListPhoneNumbersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListProxySessionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListProxySessionsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        ProxySessions: (_) => de_ProxySessions(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListProxySessionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListSipMediaApplicationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListSipMediaApplicationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        SipMediaApplications: (_) => de_SipMediaApplicationList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListSipMediaApplicationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListSipRulesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListSipRulesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        SipRules: (_) => de_SipRuleList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListSipRulesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListSupportedPhoneNumberCountriesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListSupportedPhoneNumberCountriesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumberCountries: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListSupportedPhoneNumberCountriesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListTagsForResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Tags: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListVoiceConnectorGroupsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListVoiceConnectorGroupsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        VoiceConnectorGroups: (_) => de_VoiceConnectorGroupList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListVoiceConnectorGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListVoiceConnectorsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListVoiceConnectorsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        VoiceConnectors: (_) => de_VoiceConnectorList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListVoiceConnectorsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListVoiceConnectorTerminationCredentialsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListVoiceConnectorTerminationCredentialsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Usernames: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListVoiceConnectorTerminationCredentialsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListVoiceProfileDomainsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListVoiceProfileDomainsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        VoiceProfileDomains: (_) => de_VoiceProfileDomainSummaryList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListVoiceProfileDomainsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListVoiceProfilesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListVoiceProfilesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        NextToken: __expectString,
        VoiceProfiles: (_) => de_VoiceProfileSummaryList(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ListVoiceProfilesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutSipMediaApplicationAlexaSkillConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutSipMediaApplicationAlexaSkillConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplicationAlexaSkillConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutSipMediaApplicationAlexaSkillConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutSipMediaApplicationLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutSipMediaApplicationLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplicationLoggingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutSipMediaApplicationLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutVoiceConnectorEmergencyCallingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutVoiceConnectorEmergencyCallingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        EmergencyCallingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutVoiceConnectorEmergencyCallingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutVoiceConnectorLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutVoiceConnectorLoggingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        LoggingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutVoiceConnectorLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutVoiceConnectorOriginationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutVoiceConnectorOriginationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Origination: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutVoiceConnectorOriginationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutVoiceConnectorProxyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutVoiceConnectorProxyCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Proxy: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutVoiceConnectorProxyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutVoiceConnectorStreamingConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutVoiceConnectorStreamingConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        StreamingConfiguration: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutVoiceConnectorStreamingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutVoiceConnectorTerminationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_PutVoiceConnectorTerminationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Termination: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_PutVoiceConnectorTerminationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutVoiceConnectorTerminationCredentialsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_PutVoiceConnectorTerminationCredentialsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_PutVoiceConnectorTerminationCredentialsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_RestorePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_RestorePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumber: (_) => de_PhoneNumber(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_RestorePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_SearchAvailablePhoneNumbersCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_SearchAvailablePhoneNumbersCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        E164PhoneNumbers: _json,
        NextToken: __expectString,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_SearchAvailablePhoneNumbersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_StartSpeakerSearchTaskCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_StartSpeakerSearchTaskCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SpeakerSearchTask: (_) => de_SpeakerSearchTask(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_StartSpeakerSearchTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "GoneException":
        case "com.amazonaws.chimesdkvoice#GoneException":
            throw await de_GoneExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        case "UnprocessableEntityException":
        case "com.amazonaws.chimesdkvoice#UnprocessableEntityException":
            throw await de_UnprocessableEntityExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_StartVoiceToneAnalysisTaskCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_StartVoiceToneAnalysisTaskCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceToneAnalysisTask: (_) => de_VoiceToneAnalysisTask(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_StartVoiceToneAnalysisTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "GoneException":
        case "com.amazonaws.chimesdkvoice#GoneException":
            throw await de_GoneExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        case "UnprocessableEntityException":
        case "com.amazonaws.chimesdkvoice#UnprocessableEntityException":
            throw await de_UnprocessableEntityExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_StopSpeakerSearchTaskCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_StopSpeakerSearchTaskCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_StopSpeakerSearchTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        case "UnprocessableEntityException":
        case "com.amazonaws.chimesdkvoice#UnprocessableEntityException":
            throw await de_UnprocessableEntityExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_StopVoiceToneAnalysisTaskCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_StopVoiceToneAnalysisTaskCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_StopVoiceToneAnalysisTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        case "UnprocessableEntityException":
        case "com.amazonaws.chimesdkvoice#UnprocessableEntityException":
            throw await de_UnprocessableEntityExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_TagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_UntagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateGlobalSettingsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_UpdateGlobalSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_UpdateGlobalSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdatePhoneNumberCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdatePhoneNumberCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        PhoneNumber: (_) => de_PhoneNumber(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdatePhoneNumberCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdatePhoneNumberSettingsCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_UpdatePhoneNumberSettingsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_UpdatePhoneNumberSettingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateProxySessionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_UpdateProxySessionCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        ProxySession: (_) => de_ProxySession(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateProxySessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateSipMediaApplicationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateSipMediaApplicationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplication: (_) => de_SipMediaApplication(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateSipMediaApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateSipMediaApplicationCallCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_UpdateSipMediaApplicationCallCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipMediaApplicationCall: _json,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateSipMediaApplicationCallCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateSipRuleCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_UpdateSipRuleCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        SipRule: (_) => de_SipRule(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateSipRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkvoice#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateVoiceConnectorCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateVoiceConnectorCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnector: (_) => de_VoiceConnector(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateVoiceConnectorCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateVoiceConnectorGroupCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_UpdateVoiceConnectorGroupCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceConnectorGroup: (_) => de_VoiceConnectorGroup(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateVoiceConnectorGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateVoiceProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateVoiceProfileCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceProfile: (_) => de_VoiceProfile(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateVoiceProfileCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkvoice#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "GoneException":
        case "com.amazonaws.chimesdkvoice#GoneException":
            throw await de_GoneExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateVoiceProfileDomainCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateVoiceProfileDomainCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        VoiceProfileDomain: (_) => de_VoiceProfileDomain(_, context),
    });
    Object.assign(contents, doc);
    return contents;
};
const de_UpdateVoiceProfileDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.chimesdkvoice#AccessDeniedException":
            throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ValidateE911AddressCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_ValidateE911AddressCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    const doc = take(data, {
        Address: _json,
        AddressExternalId: __expectString,
        CandidateAddressList: _json,
        ValidationResult: __expectInt32,
    });
    Object.assign(contents, doc);
    return contents;
};
const de_ValidateE911AddressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkvoice#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkvoice#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkvoice#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkvoice#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkvoice#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkvoice#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkvoice#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const throwDefaultError = withBaseException(__BaseException);
const de_AccessDeniedExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new AccessDeniedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_BadRequestExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ConflictExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ForbiddenExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ForbiddenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_GoneExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new GoneException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_NotFoundExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ResourceLimitExceededExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ServiceFailureExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ServiceFailureException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ServiceUnavailableExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ThrottledClientExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new ThrottledClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_UnauthorizedClientExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_UnprocessableEntityExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    const doc = take(data, {
        Code: __expectString,
        Message: __expectString,
    });
    Object.assign(contents, doc);
    const exception = new UnprocessableEntityException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_PhoneNumber = (output, context) => {
    return take(output, {
        Associations: (_) => de_PhoneNumberAssociationList(_, context),
        CallingName: __expectString,
        CallingNameStatus: __expectString,
        Capabilities: _json,
        Country: __expectString,
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        DeletionTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        E164PhoneNumber: __expectString,
        OrderId: __expectString,
        PhoneNumberId: __expectString,
        ProductType: __expectString,
        Status: __expectString,
        Type: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_PhoneNumberAssociation = (output, context) => {
    return take(output, {
        AssociatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        Name: __expectString,
        Value: __expectString,
    });
};
const de_PhoneNumberAssociationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PhoneNumberAssociation(entry, context);
    });
    return retVal;
};
const de_PhoneNumberList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PhoneNumber(entry, context);
    });
    return retVal;
};
const de_PhoneNumberOrder = (output, context) => {
    return take(output, {
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        OrderType: __expectString,
        OrderedPhoneNumbers: _json,
        PhoneNumberOrderId: __expectString,
        ProductType: __expectString,
        Status: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_PhoneNumberOrderList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PhoneNumberOrder(entry, context);
    });
    return retVal;
};
const de_ProxySession = (output, context) => {
    return take(output, {
        Capabilities: _json,
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        EndedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        ExpiryMinutes: __expectInt32,
        GeoMatchLevel: __expectString,
        GeoMatchParams: _json,
        Name: __expectString,
        NumberSelectionBehavior: __expectString,
        Participants: _json,
        ProxySessionId: __expectString,
        Status: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceConnectorId: __expectString,
    });
};
const de_ProxySessions = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ProxySession(entry, context);
    });
    return retVal;
};
const de_SipMediaApplication = (output, context) => {
    return take(output, {
        AwsRegion: __expectString,
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        Endpoints: _json,
        Name: __expectString,
        SipMediaApplicationArn: __expectString,
        SipMediaApplicationId: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_SipMediaApplicationList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_SipMediaApplication(entry, context);
    });
    return retVal;
};
const de_SipRule = (output, context) => {
    return take(output, {
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        Disabled: __expectBoolean,
        Name: __expectString,
        SipRuleId: __expectString,
        TargetApplications: _json,
        TriggerType: __expectString,
        TriggerValue: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_SipRuleList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_SipRule(entry, context);
    });
    return retVal;
};
const de_SpeakerSearchDetails = (output, context) => {
    return take(output, {
        Results: (_) => de_SpeakerSearchResultList(_, context),
        VoiceprintGenerationStatus: __expectString,
    });
};
const de_SpeakerSearchResult = (output, context) => {
    return take(output, {
        ConfidenceScore: __limitedParseFloat32,
        VoiceProfileId: __expectString,
    });
};
const de_SpeakerSearchResultList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_SpeakerSearchResult(entry, context);
    });
    return retVal;
};
const de_SpeakerSearchTask = (output, context) => {
    return take(output, {
        CallDetails: _json,
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        SpeakerSearchDetails: (_) => de_SpeakerSearchDetails(_, context),
        SpeakerSearchTaskId: __expectString,
        SpeakerSearchTaskStatus: __expectString,
        StartedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        StatusMessage: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_TerminationHealth = (output, context) => {
    return take(output, {
        Source: __expectString,
        Timestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
    });
};
const de_VoiceConnector = (output, context) => {
    return take(output, {
        AwsRegion: __expectString,
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        Name: __expectString,
        OutboundHostName: __expectString,
        RequireEncryption: __expectBoolean,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceConnectorArn: __expectString,
        VoiceConnectorId: __expectString,
    });
};
const de_VoiceConnectorGroup = (output, context) => {
    return take(output, {
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        Name: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceConnectorGroupArn: __expectString,
        VoiceConnectorGroupId: __expectString,
        VoiceConnectorItems: _json,
    });
};
const de_VoiceConnectorGroupList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_VoiceConnectorGroup(entry, context);
    });
    return retVal;
};
const de_VoiceConnectorList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_VoiceConnector(entry, context);
    });
    return retVal;
};
const de_VoiceProfile = (output, context) => {
    return take(output, {
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        ExpirationTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceProfileArn: __expectString,
        VoiceProfileDomainId: __expectString,
        VoiceProfileId: __expectString,
    });
};
const de_VoiceProfileDomain = (output, context) => {
    return take(output, {
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        Description: __expectString,
        Name: __expectString,
        ServerSideEncryptionConfiguration: _json,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceProfileDomainArn: __expectString,
        VoiceProfileDomainId: __expectString,
    });
};
const de_VoiceProfileDomainSummary = (output, context) => {
    return take(output, {
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        Description: __expectString,
        Name: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceProfileDomainArn: __expectString,
        VoiceProfileDomainId: __expectString,
    });
};
const de_VoiceProfileDomainSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_VoiceProfileDomainSummary(entry, context);
    });
    return retVal;
};
const de_VoiceProfileSummary = (output, context) => {
    return take(output, {
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        ExpirationTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceProfileArn: __expectString,
        VoiceProfileDomainId: __expectString,
        VoiceProfileId: __expectString,
    });
};
const de_VoiceProfileSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_VoiceProfileSummary(entry, context);
    });
    return retVal;
};
const de_VoiceToneAnalysisTask = (output, context) => {
    return take(output, {
        CallDetails: _json,
        CreatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        StartedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        StatusMessage: __expectString,
        UpdatedTimestamp: (_) => __expectNonNull(__parseRfc3339DateTimeWithOffset(_)),
        VoiceToneAnalysisTaskId: __expectString,
        VoiceToneAnalysisTaskStatus: __expectString,
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const isSerializableHeaderValue = (value) => value !== undefined &&
    value !== null &&
    value !== "" &&
    (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) &&
    (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
