import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { ChimeSDKVoiceServiceException as __BaseException } from "./ChimeSDKVoiceServiceException";
export declare const ErrorCode: {
  readonly AccessDenied: "AccessDenied";
  readonly BadRequest: "BadRequest";
  readonly Conflict: "Conflict";
  readonly Forbidden: "Forbidden";
  readonly Gone: "Gone";
  readonly NotFound: "NotFound";
  readonly PhoneNumberAssociationsExist: "PhoneNumberAssociationsExist";
  readonly PreconditionFailed: "PreconditionFailed";
  readonly ResourceLimitExceeded: "ResourceLimitExceeded";
  readonly ServiceFailure: "ServiceFailure";
  readonly ServiceUnavailable: "ServiceUnavailable";
  readonly Throttled: "Throttled";
  readonly Throttling: "Throttling";
  readonly Unauthorized: "Unauthorized";
  readonly Unprocessable: "Unprocessable";
  readonly VoiceConnectorGroupAssociationsExist: "VoiceConnectorGroupAssociationsExist";
};
export type ErrorCode = (typeof ErrorCode)[keyof typeof ErrorCode];
export declare class AccessDeniedException extends __BaseException {
  readonly name: "AccessDeniedException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<AccessDeniedException, __BaseException>
  );
}
export interface Address {
  streetName?: string;
  streetSuffix?: string;
  postDirectional?: string;
  preDirectional?: string;
  streetNumber?: string;
  city?: string;
  state?: string;
  postalCode?: string;
  postalCodePlus4?: string;
  country?: string;
}
export declare const AlexaSkillStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly INACTIVE: "INACTIVE";
};
export type AlexaSkillStatus =
  (typeof AlexaSkillStatus)[keyof typeof AlexaSkillStatus];
export interface AssociatePhoneNumbersWithVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
  ForceAssociate?: boolean;
}
export interface PhoneNumberError {
  PhoneNumberId?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface AssociatePhoneNumbersWithVoiceConnectorResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export declare class BadRequestException extends __BaseException {
  readonly name: "BadRequestException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<BadRequestException, __BaseException>
  );
}
export declare class ForbiddenException extends __BaseException {
  readonly name: "ForbiddenException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export declare class ServiceFailureException extends __BaseException {
  readonly name: "ServiceFailureException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceFailureException, __BaseException>
  );
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export declare class ThrottledClientException extends __BaseException {
  readonly name: "ThrottledClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ThrottledClientException, __BaseException>
  );
}
export declare class UnauthorizedClientException extends __BaseException {
  readonly name: "UnauthorizedClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>
  );
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
  ForceAssociate?: boolean;
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface BatchDeletePhoneNumberRequest {
  PhoneNumberIds: string[] | undefined;
}
export interface BatchDeletePhoneNumberResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export declare const PhoneNumberProductType: {
  readonly SipMediaApplicationDialIn: "SipMediaApplicationDialIn";
  readonly VoiceConnector: "VoiceConnector";
};
export type PhoneNumberProductType =
  (typeof PhoneNumberProductType)[keyof typeof PhoneNumberProductType];
export interface UpdatePhoneNumberRequestItem {
  PhoneNumberId: string | undefined;
  ProductType?: PhoneNumberProductType | string;
  CallingName?: string;
}
export interface BatchUpdatePhoneNumberRequest {
  UpdatePhoneNumberRequestItems: UpdatePhoneNumberRequestItem[] | undefined;
}
export interface BatchUpdatePhoneNumberResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface CallDetails {
  VoiceConnectorId?: string;
  TransactionId?: string;
  IsCaller?: boolean;
}
export declare const CallingNameStatus: {
  readonly Unassigned: "Unassigned";
  readonly UpdateFailed: "UpdateFailed";
  readonly UpdateInProgress: "UpdateInProgress";
  readonly UpdateSucceeded: "UpdateSucceeded";
};
export type CallingNameStatus =
  (typeof CallingNameStatus)[keyof typeof CallingNameStatus];
export declare const CallLegType: {
  readonly CALLEE: "Callee";
  readonly CALLER: "Caller";
};
export type CallLegType = (typeof CallLegType)[keyof typeof CallLegType];
export interface CandidateAddress {
  streetInfo?: string;
  streetNumber?: string;
  city?: string;
  state?: string;
  postalCode?: string;
  postalCodePlus4?: string;
  country?: string;
}
export declare const Capability: {
  readonly SMS: "SMS";
  readonly Voice: "Voice";
};
export type Capability = (typeof Capability)[keyof typeof Capability];
export interface CreatePhoneNumberOrderRequest {
  ProductType: PhoneNumberProductType | string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export declare const OrderedPhoneNumberStatus: {
  readonly Acquired: "Acquired";
  readonly Failed: "Failed";
  readonly Processing: "Processing";
};
export type OrderedPhoneNumberStatus =
  (typeof OrderedPhoneNumberStatus)[keyof typeof OrderedPhoneNumberStatus];
export interface OrderedPhoneNumber {
  E164PhoneNumber?: string;
  Status?: OrderedPhoneNumberStatus | string;
}
export declare const PhoneNumberOrderType: {
  readonly New: "New";
  readonly Porting: "Porting";
};
export type PhoneNumberOrderType =
  (typeof PhoneNumberOrderType)[keyof typeof PhoneNumberOrderType];
export declare const PhoneNumberOrderStatus: {
  readonly CancelRequested: "CancelRequested";
  readonly Cancelled: "Cancelled";
  readonly ChangeRequested: "ChangeRequested";
  readonly Exception: "Exception";
  readonly FOC: "FOC";
  readonly Failed: "Failed";
  readonly Partial: "Partial";
  readonly PendingDocuments: "PendingDocuments";
  readonly Processing: "Processing";
  readonly Submitted: "Submitted";
  readonly Successful: "Successful";
};
export type PhoneNumberOrderStatus =
  (typeof PhoneNumberOrderStatus)[keyof typeof PhoneNumberOrderStatus];
export interface PhoneNumberOrder {
  PhoneNumberOrderId?: string;
  ProductType?: PhoneNumberProductType | string;
  Status?: PhoneNumberOrderStatus | string;
  OrderType?: PhoneNumberOrderType | string;
  OrderedPhoneNumbers?: OrderedPhoneNumber[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreatePhoneNumberOrderResponse {
  PhoneNumberOrder?: PhoneNumberOrder;
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export declare const GeoMatchLevel: {
  readonly AreaCode: "AreaCode";
  readonly Country: "Country";
};
export type GeoMatchLevel = (typeof GeoMatchLevel)[keyof typeof GeoMatchLevel];
export interface GeoMatchParams {
  Country: string | undefined;
  AreaCode: string | undefined;
}
export declare const NumberSelectionBehavior: {
  readonly AvoidSticky: "AvoidSticky";
  readonly PreferSticky: "PreferSticky";
};
export type NumberSelectionBehavior =
  (typeof NumberSelectionBehavior)[keyof typeof NumberSelectionBehavior];
export interface CreateProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ParticipantPhoneNumbers: string[] | undefined;
  Name?: string;
  ExpiryMinutes?: number;
  Capabilities: (Capability | string)[] | undefined;
  NumberSelectionBehavior?: NumberSelectionBehavior | string;
  GeoMatchLevel?: GeoMatchLevel | string;
  GeoMatchParams?: GeoMatchParams;
}
export interface Participant {
  PhoneNumber?: string;
  ProxyPhoneNumber?: string;
}
export declare const ProxySessionStatus: {
  readonly Closed: "Closed";
  readonly InProgress: "InProgress";
  readonly Open: "Open";
};
export type ProxySessionStatus =
  (typeof ProxySessionStatus)[keyof typeof ProxySessionStatus];
export interface ProxySession {
  VoiceConnectorId?: string;
  ProxySessionId?: string;
  Name?: string;
  Status?: ProxySessionStatus | string;
  ExpiryMinutes?: number;
  Capabilities?: (Capability | string)[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  EndedTimestamp?: Date;
  Participants?: Participant[];
  NumberSelectionBehavior?: NumberSelectionBehavior | string;
  GeoMatchLevel?: GeoMatchLevel | string;
  GeoMatchParams?: GeoMatchParams;
}
export interface CreateProxySessionResponse {
  ProxySession?: ProxySession;
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface SipMediaApplicationEndpoint {
  LambdaArn?: string;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateSipMediaApplicationRequest {
  AwsRegion: string | undefined;
  Name: string | undefined;
  Endpoints: SipMediaApplicationEndpoint[] | undefined;
  Tags?: Tag[];
}
export interface SipMediaApplication {
  SipMediaApplicationId?: string;
  AwsRegion?: string;
  Name?: string;
  Endpoints?: SipMediaApplicationEndpoint[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  SipMediaApplicationArn?: string;
}
export interface CreateSipMediaApplicationResponse {
  SipMediaApplication?: SipMediaApplication;
}
export interface CreateSipMediaApplicationCallRequest {
  FromPhoneNumber: string | undefined;
  ToPhoneNumber: string | undefined;
  SipMediaApplicationId: string | undefined;
  SipHeaders?: Record<string, string>;
  ArgumentsMap?: Record<string, string>;
}
export interface SipMediaApplicationCall {
  TransactionId?: string;
}
export interface CreateSipMediaApplicationCallResponse {
  SipMediaApplicationCall?: SipMediaApplicationCall;
}
export interface SipRuleTargetApplication {
  SipMediaApplicationId?: string;
  Priority?: number;
  AwsRegion?: string;
}
export declare const SipRuleTriggerType: {
  readonly RequestUriHostname: "RequestUriHostname";
  readonly ToPhoneNumber: "ToPhoneNumber";
};
export type SipRuleTriggerType =
  (typeof SipRuleTriggerType)[keyof typeof SipRuleTriggerType];
export interface CreateSipRuleRequest {
  Name: string | undefined;
  TriggerType: SipRuleTriggerType | string | undefined;
  TriggerValue: string | undefined;
  Disabled?: boolean;
  TargetApplications?: SipRuleTargetApplication[];
}
export interface SipRule {
  SipRuleId?: string;
  Name?: string;
  Disabled?: boolean;
  TriggerType?: SipRuleTriggerType | string;
  TriggerValue?: string;
  TargetApplications?: SipRuleTargetApplication[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateSipRuleResponse {
  SipRule?: SipRule;
}
export declare const VoiceConnectorAwsRegion: {
  readonly AP_NORTHEAST_1: "ap-northeast-1";
  readonly AP_NORTHEAST_2: "ap-northeast-2";
  readonly AP_SOUTHEAST_1: "ap-southeast-1";
  readonly AP_SOUTHEAST_2: "ap-southeast-2";
  readonly CA_CENTRAL_1: "ca-central-1";
  readonly EU_CENTRAL_1: "eu-central-1";
  readonly EU_WEST_1: "eu-west-1";
  readonly EU_WEST_2: "eu-west-2";
  readonly US_EAST_1: "us-east-1";
  readonly US_WEST_2: "us-west-2";
};
export type VoiceConnectorAwsRegion =
  (typeof VoiceConnectorAwsRegion)[keyof typeof VoiceConnectorAwsRegion];
export interface CreateVoiceConnectorRequest {
  Name: string | undefined;
  AwsRegion?: VoiceConnectorAwsRegion | string;
  RequireEncryption: boolean | undefined;
  Tags?: Tag[];
}
export interface VoiceConnector {
  VoiceConnectorId?: string;
  AwsRegion?: VoiceConnectorAwsRegion | string;
  Name?: string;
  OutboundHostName?: string;
  RequireEncryption?: boolean;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  VoiceConnectorArn?: string;
}
export interface CreateVoiceConnectorResponse {
  VoiceConnector?: VoiceConnector;
}
export interface VoiceConnectorItem {
  VoiceConnectorId: string | undefined;
  Priority: number | undefined;
}
export interface CreateVoiceConnectorGroupRequest {
  Name: string | undefined;
  VoiceConnectorItems?: VoiceConnectorItem[];
}
export interface VoiceConnectorGroup {
  VoiceConnectorGroupId?: string;
  Name?: string;
  VoiceConnectorItems?: VoiceConnectorItem[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  VoiceConnectorGroupArn?: string;
}
export interface CreateVoiceConnectorGroupResponse {
  VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface CreateVoiceProfileRequest {
  SpeakerSearchTaskId: string | undefined;
}
export interface VoiceProfile {
  VoiceProfileId?: string;
  VoiceProfileArn?: string;
  VoiceProfileDomainId?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  ExpirationTimestamp?: Date;
}
export interface CreateVoiceProfileResponse {
  VoiceProfile?: VoiceProfile;
}
export declare class GoneException extends __BaseException {
  readonly name: "GoneException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<GoneException, __BaseException>);
}
export interface ServerSideEncryptionConfiguration {
  KmsKeyArn: string | undefined;
}
export interface CreateVoiceProfileDomainRequest {
  Name: string | undefined;
  Description?: string;
  ServerSideEncryptionConfiguration:
    | ServerSideEncryptionConfiguration
    | undefined;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface VoiceProfileDomain {
  VoiceProfileDomainId?: string;
  VoiceProfileDomainArn?: string;
  Name?: string;
  Description?: string;
  ServerSideEncryptionConfiguration?: ServerSideEncryptionConfiguration;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateVoiceProfileDomainResponse {
  VoiceProfileDomain?: VoiceProfileDomain;
}
export interface DeletePhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export interface DeleteProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
}
export interface DeleteSipMediaApplicationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface DeleteSipRuleRequest {
  SipRuleId: string | undefined;
}
export interface DeleteVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
}
export interface DeleteVoiceConnectorOriginationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorProxyRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorStreamingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationCredentialsRequest {
  VoiceConnectorId: string | undefined;
  Usernames: string[] | undefined;
}
export interface DeleteVoiceProfileRequest {
  VoiceProfileId: string | undefined;
}
export interface DeleteVoiceProfileDomainRequest {
  VoiceProfileDomainId: string | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface VoiceConnectorSettings {
  CdrBucket?: string;
}
export interface GetGlobalSettingsResponse {
  VoiceConnector?: VoiceConnectorSettings;
}
export interface GetPhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export declare const PhoneNumberAssociationName: {
  readonly SipRuleId: "SipRuleId";
  readonly VoiceConnectorGroupId: "VoiceConnectorGroupId";
  readonly VoiceConnectorId: "VoiceConnectorId";
};
export type PhoneNumberAssociationName =
  (typeof PhoneNumberAssociationName)[keyof typeof PhoneNumberAssociationName];
export interface PhoneNumberAssociation {
  Value?: string;
  Name?: PhoneNumberAssociationName | string;
  AssociatedTimestamp?: Date;
}
export interface PhoneNumberCapabilities {
  InboundCall?: boolean;
  OutboundCall?: boolean;
  InboundSMS?: boolean;
  OutboundSMS?: boolean;
  InboundMMS?: boolean;
  OutboundMMS?: boolean;
}
export declare const PhoneNumberStatus: {
  readonly AcquireFailed: "AcquireFailed";
  readonly AcquireInProgress: "AcquireInProgress";
  readonly Assigned: "Assigned";
  readonly Cancelled: "Cancelled";
  readonly DeleteFailed: "DeleteFailed";
  readonly DeleteInProgress: "DeleteInProgress";
  readonly PortinCancelRequested: "PortinCancelRequested";
  readonly PortinInProgress: "PortinInProgress";
  readonly ReleaseFailed: "ReleaseFailed";
  readonly ReleaseInProgress: "ReleaseInProgress";
  readonly Unassigned: "Unassigned";
};
export type PhoneNumberStatus =
  (typeof PhoneNumberStatus)[keyof typeof PhoneNumberStatus];
export declare const PhoneNumberType: {
  readonly Local: "Local";
  readonly TollFree: "TollFree";
};
export type PhoneNumberType =
  (typeof PhoneNumberType)[keyof typeof PhoneNumberType];
export interface PhoneNumber {
  PhoneNumberId?: string;
  E164PhoneNumber?: string;
  Country?: string;
  Type?: PhoneNumberType | string;
  ProductType?: PhoneNumberProductType | string;
  Status?: PhoneNumberStatus | string;
  Capabilities?: PhoneNumberCapabilities;
  Associations?: PhoneNumberAssociation[];
  CallingName?: string;
  CallingNameStatus?: CallingNameStatus | string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  DeletionTimestamp?: Date;
  OrderId?: string;
}
export interface GetPhoneNumberResponse {
  PhoneNumber?: PhoneNumber;
}
export interface GetPhoneNumberOrderRequest {
  PhoneNumberOrderId: string | undefined;
}
export interface GetPhoneNumberOrderResponse {
  PhoneNumberOrder?: PhoneNumberOrder;
}
export interface GetPhoneNumberSettingsResponse {
  CallingName?: string;
  CallingNameUpdatedTimestamp?: Date;
}
export interface GetProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
}
export interface GetProxySessionResponse {
  ProxySession?: ProxySession;
}
export interface GetSipMediaApplicationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface GetSipMediaApplicationResponse {
  SipMediaApplication?: SipMediaApplication;
}
export interface GetSipMediaApplicationAlexaSkillConfigurationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface SipMediaApplicationAlexaSkillConfiguration {
  AlexaSkillStatus: AlexaSkillStatus | string | undefined;
  AlexaSkillIds: string[] | undefined;
}
export interface GetSipMediaApplicationAlexaSkillConfigurationResponse {
  SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
export interface GetSipMediaApplicationLoggingConfigurationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface SipMediaApplicationLoggingConfiguration {
  EnableSipMediaApplicationMessageLogs?: boolean;
}
export interface GetSipMediaApplicationLoggingConfigurationResponse {
  SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface GetSipRuleRequest {
  SipRuleId: string | undefined;
}
export interface GetSipRuleResponse {
  SipRule?: SipRule;
}
export interface GetSpeakerSearchTaskRequest {
  VoiceConnectorId: string | undefined;
  SpeakerSearchTaskId: string | undefined;
}
export interface SpeakerSearchResult {
  ConfidenceScore?: number;
  VoiceProfileId?: string;
}
export interface SpeakerSearchDetails {
  Results?: SpeakerSearchResult[];
  VoiceprintGenerationStatus?: string;
}
export interface SpeakerSearchTask {
  SpeakerSearchTaskId?: string;
  SpeakerSearchTaskStatus?: string;
  CallDetails?: CallDetails;
  SpeakerSearchDetails?: SpeakerSearchDetails;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  StartedTimestamp?: Date;
  StatusMessage?: string;
}
export interface GetSpeakerSearchTaskResponse {
  SpeakerSearchTask?: SpeakerSearchTask;
}
export interface GetVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
}
export interface GetVoiceConnectorResponse {
  VoiceConnector?: VoiceConnector;
}
export interface GetVoiceConnectorEmergencyCallingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DNISEmergencyCallingConfiguration {
  EmergencyPhoneNumber: string | undefined;
  TestPhoneNumber?: string;
  CallingCountry: string | undefined;
}
export interface EmergencyCallingConfiguration {
  DNIS?: DNISEmergencyCallingConfiguration[];
}
export interface GetVoiceConnectorEmergencyCallingConfigurationResponse {
  EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
export interface GetVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
}
export interface GetVoiceConnectorGroupResponse {
  VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface GetVoiceConnectorLoggingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface LoggingConfiguration {
  EnableSIPLogs?: boolean;
  EnableMediaMetricLogs?: boolean;
}
export interface GetVoiceConnectorLoggingConfigurationResponse {
  LoggingConfiguration?: LoggingConfiguration;
}
export interface GetVoiceConnectorOriginationRequest {
  VoiceConnectorId: string | undefined;
}
export declare const OriginationRouteProtocol: {
  readonly TCP: "TCP";
  readonly UDP: "UDP";
};
export type OriginationRouteProtocol =
  (typeof OriginationRouteProtocol)[keyof typeof OriginationRouteProtocol];
export interface OriginationRoute {
  Host?: string;
  Port?: number;
  Protocol?: OriginationRouteProtocol | string;
  Priority?: number;
  Weight?: number;
}
export interface Origination {
  Routes?: OriginationRoute[];
  Disabled?: boolean;
}
export interface GetVoiceConnectorOriginationResponse {
  Origination?: Origination;
}
export interface GetVoiceConnectorProxyRequest {
  VoiceConnectorId: string | undefined;
}
export interface Proxy {
  DefaultSessionExpiryMinutes?: number;
  Disabled?: boolean;
  FallBackPhoneNumber?: string;
  PhoneNumberCountries?: string[];
}
export interface GetVoiceConnectorProxyResponse {
  Proxy?: Proxy;
}
export interface GetVoiceConnectorStreamingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface MediaInsightsConfiguration {
  Disabled?: boolean;
  ConfigurationArn?: string;
}
export declare const NotificationTarget: {
  readonly EventBridge: "EventBridge";
  readonly SNS: "SNS";
  readonly SQS: "SQS";
};
export type NotificationTarget =
  (typeof NotificationTarget)[keyof typeof NotificationTarget];
export interface StreamingNotificationTarget {
  NotificationTarget?: NotificationTarget | string;
}
export interface StreamingConfiguration {
  DataRetentionInHours: number | undefined;
  Disabled: boolean | undefined;
  StreamingNotificationTargets?: StreamingNotificationTarget[];
  MediaInsightsConfiguration?: MediaInsightsConfiguration;
}
export interface GetVoiceConnectorStreamingConfigurationResponse {
  StreamingConfiguration?: StreamingConfiguration;
}
export interface GetVoiceConnectorTerminationRequest {
  VoiceConnectorId: string | undefined;
}
export interface Termination {
  CpsLimit?: number;
  DefaultPhoneNumber?: string;
  CallingRegions?: string[];
  CidrAllowedList?: string[];
  Disabled?: boolean;
}
export interface GetVoiceConnectorTerminationResponse {
  Termination?: Termination;
}
export interface GetVoiceConnectorTerminationHealthRequest {
  VoiceConnectorId: string | undefined;
}
export interface TerminationHealth {
  Timestamp?: Date;
  Source?: string;
}
export interface GetVoiceConnectorTerminationHealthResponse {
  TerminationHealth?: TerminationHealth;
}
export interface GetVoiceProfileRequest {
  VoiceProfileId: string | undefined;
}
export interface GetVoiceProfileResponse {
  VoiceProfile?: VoiceProfile;
}
export interface GetVoiceProfileDomainRequest {
  VoiceProfileDomainId: string | undefined;
}
export interface GetVoiceProfileDomainResponse {
  VoiceProfileDomain?: VoiceProfileDomain;
}
export interface GetVoiceToneAnalysisTaskRequest {
  VoiceConnectorId: string | undefined;
  VoiceToneAnalysisTaskId: string | undefined;
  IsCaller: boolean | undefined;
}
export interface VoiceToneAnalysisTask {
  VoiceToneAnalysisTaskId?: string;
  VoiceToneAnalysisTaskStatus?: string;
  CallDetails?: CallDetails;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  StartedTimestamp?: Date;
  StatusMessage?: string;
}
export interface GetVoiceToneAnalysisTaskResponse {
  VoiceToneAnalysisTask?: VoiceToneAnalysisTask;
}
export interface ListAvailableVoiceConnectorRegionsResponse {
  VoiceConnectorRegions?: (VoiceConnectorAwsRegion | string)[];
}
export interface ListPhoneNumberOrdersRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListPhoneNumberOrdersResponse {
  PhoneNumberOrders?: PhoneNumberOrder[];
  NextToken?: string;
}
export interface ListPhoneNumbersRequest {
  Status?: string;
  ProductType?: PhoneNumberProductType | string;
  FilterName?: PhoneNumberAssociationName | string;
  FilterValue?: string;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListPhoneNumbersResponse {
  PhoneNumbers?: PhoneNumber[];
  NextToken?: string;
}
export interface ListProxySessionsRequest {
  VoiceConnectorId: string | undefined;
  Status?: ProxySessionStatus | string;
  NextToken?: string;
  MaxResults?: number;
}
export interface ListProxySessionsResponse {
  ProxySessions?: ProxySession[];
  NextToken?: string;
}
export interface ListSipMediaApplicationsRequest {
  MaxResults?: number;
  NextToken?: string;
}
export interface ListSipMediaApplicationsResponse {
  SipMediaApplications?: SipMediaApplication[];
  NextToken?: string;
}
export interface ListSipRulesRequest {
  SipMediaApplicationId?: string;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListSipRulesResponse {
  SipRules?: SipRule[];
  NextToken?: string;
}
export interface ListSupportedPhoneNumberCountriesRequest {
  ProductType: PhoneNumberProductType | string | undefined;
}
export interface PhoneNumberCountry {
  CountryCode?: string;
  SupportedPhoneNumberTypes?: (PhoneNumberType | string)[];
}
export interface ListSupportedPhoneNumberCountriesResponse {
  PhoneNumberCountries?: PhoneNumberCountry[];
}
export interface ListTagsForResourceRequest {
  ResourceARN: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Tag[];
}
export interface ListVoiceConnectorGroupsRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListVoiceConnectorGroupsResponse {
  VoiceConnectorGroups?: VoiceConnectorGroup[];
  NextToken?: string;
}
export interface ListVoiceConnectorsRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface ListVoiceConnectorsResponse {
  VoiceConnectors?: VoiceConnector[];
  NextToken?: string;
}
export interface ListVoiceConnectorTerminationCredentialsRequest {
  VoiceConnectorId: string | undefined;
}
export interface ListVoiceConnectorTerminationCredentialsResponse {
  Usernames?: string[];
}
export interface ListVoiceProfileDomainsRequest {
  NextToken?: string;
  MaxResults?: number;
}
export interface VoiceProfileDomainSummary {
  VoiceProfileDomainId?: string;
  VoiceProfileDomainArn?: string;
  Name?: string;
  Description?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface ListVoiceProfileDomainsResponse {
  VoiceProfileDomains?: VoiceProfileDomainSummary[];
  NextToken?: string;
}
export interface ListVoiceProfilesRequest {
  VoiceProfileDomainId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
}
export interface VoiceProfileSummary {
  VoiceProfileId?: string;
  VoiceProfileArn?: string;
  VoiceProfileDomainId?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  ExpirationTimestamp?: Date;
}
export interface ListVoiceProfilesResponse {
  VoiceProfiles?: VoiceProfileSummary[];
  NextToken?: string;
}
export interface PutSipMediaApplicationAlexaSkillConfigurationRequest {
  SipMediaApplicationId: string | undefined;
  SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
export interface PutSipMediaApplicationAlexaSkillConfigurationResponse {
  SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
export interface PutSipMediaApplicationLoggingConfigurationRequest {
  SipMediaApplicationId: string | undefined;
  SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface PutSipMediaApplicationLoggingConfigurationResponse {
  SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface PutVoiceConnectorEmergencyCallingConfigurationRequest {
  VoiceConnectorId: string | undefined;
  EmergencyCallingConfiguration: EmergencyCallingConfiguration | undefined;
}
export interface PutVoiceConnectorEmergencyCallingConfigurationResponse {
  EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
export interface PutVoiceConnectorLoggingConfigurationRequest {
  VoiceConnectorId: string | undefined;
  LoggingConfiguration: LoggingConfiguration | undefined;
}
export interface PutVoiceConnectorLoggingConfigurationResponse {
  LoggingConfiguration?: LoggingConfiguration;
}
export interface PutVoiceConnectorOriginationRequest {
  VoiceConnectorId: string | undefined;
  Origination: Origination | undefined;
}
export interface PutVoiceConnectorOriginationResponse {
  Origination?: Origination;
}
export interface PutVoiceConnectorProxyRequest {
  VoiceConnectorId: string | undefined;
  DefaultSessionExpiryMinutes: number | undefined;
  PhoneNumberPoolCountries: string[] | undefined;
  FallBackPhoneNumber?: string;
  Disabled?: boolean;
}
export interface PutVoiceConnectorProxyResponse {
  Proxy?: Proxy;
}
export interface PutVoiceConnectorStreamingConfigurationRequest {
  VoiceConnectorId: string | undefined;
  StreamingConfiguration: StreamingConfiguration | undefined;
}
export interface PutVoiceConnectorStreamingConfigurationResponse {
  StreamingConfiguration?: StreamingConfiguration;
}
export interface PutVoiceConnectorTerminationRequest {
  VoiceConnectorId: string | undefined;
  Termination: Termination | undefined;
}
export interface PutVoiceConnectorTerminationResponse {
  Termination?: Termination;
}
export interface Credential {
  Username?: string;
  Password?: string;
}
export interface PutVoiceConnectorTerminationCredentialsRequest {
  VoiceConnectorId: string | undefined;
  Credentials?: Credential[];
}
export interface RestorePhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export interface RestorePhoneNumberResponse {
  PhoneNumber?: PhoneNumber;
}
export interface SearchAvailablePhoneNumbersRequest {
  AreaCode?: string;
  City?: string;
  Country?: string;
  State?: string;
  TollFreePrefix?: string;
  PhoneNumberType?: PhoneNumberType | string;
  MaxResults?: number;
  NextToken?: string;
}
export interface SearchAvailablePhoneNumbersResponse {
  E164PhoneNumbers?: string[];
  NextToken?: string;
}
export interface StartSpeakerSearchTaskRequest {
  VoiceConnectorId: string | undefined;
  TransactionId: string | undefined;
  VoiceProfileDomainId: string | undefined;
  ClientRequestToken?: string;
  CallLeg?: CallLegType | string;
}
export interface StartSpeakerSearchTaskResponse {
  SpeakerSearchTask?: SpeakerSearchTask;
}
export declare class UnprocessableEntityException extends __BaseException {
  readonly name: "UnprocessableEntityException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnprocessableEntityException, __BaseException>
  );
}
export declare const LanguageCode: {
  readonly EN_US: "en-US";
};
export type LanguageCode = (typeof LanguageCode)[keyof typeof LanguageCode];
export interface StartVoiceToneAnalysisTaskRequest {
  VoiceConnectorId: string | undefined;
  TransactionId: string | undefined;
  LanguageCode: LanguageCode | string | undefined;
  ClientRequestToken?: string;
}
export interface StartVoiceToneAnalysisTaskResponse {
  VoiceToneAnalysisTask?: VoiceToneAnalysisTask;
}
export interface StopSpeakerSearchTaskRequest {
  VoiceConnectorId: string | undefined;
  SpeakerSearchTaskId: string | undefined;
}
export interface StopVoiceToneAnalysisTaskRequest {
  VoiceConnectorId: string | undefined;
  VoiceToneAnalysisTaskId: string | undefined;
}
export interface TagResourceRequest {
  ResourceARN: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagResourceRequest {
  ResourceARN: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UpdateGlobalSettingsRequest {
  VoiceConnector?: VoiceConnectorSettings;
}
export interface UpdatePhoneNumberRequest {
  PhoneNumberId: string | undefined;
  ProductType?: PhoneNumberProductType | string;
  CallingName?: string;
}
export interface UpdatePhoneNumberResponse {
  PhoneNumber?: PhoneNumber;
}
export interface UpdatePhoneNumberSettingsRequest {
  CallingName: string | undefined;
}
export interface UpdateProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
  Capabilities: (Capability | string)[] | undefined;
  ExpiryMinutes?: number;
}
export interface UpdateProxySessionResponse {
  ProxySession?: ProxySession;
}
export interface UpdateSipMediaApplicationRequest {
  SipMediaApplicationId: string | undefined;
  Name?: string;
  Endpoints?: SipMediaApplicationEndpoint[];
}
export interface UpdateSipMediaApplicationResponse {
  SipMediaApplication?: SipMediaApplication;
}
export interface UpdateSipMediaApplicationCallRequest {
  SipMediaApplicationId: string | undefined;
  TransactionId: string | undefined;
  Arguments: Record<string, string> | undefined;
}
export interface UpdateSipMediaApplicationCallResponse {
  SipMediaApplicationCall?: SipMediaApplicationCall;
}
export interface UpdateSipRuleRequest {
  SipRuleId: string | undefined;
  Name: string | undefined;
  Disabled?: boolean;
  TargetApplications?: SipRuleTargetApplication[];
}
export interface UpdateSipRuleResponse {
  SipRule?: SipRule;
}
export interface UpdateVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  Name: string | undefined;
  RequireEncryption: boolean | undefined;
}
export interface UpdateVoiceConnectorResponse {
  VoiceConnector?: VoiceConnector;
}
export interface UpdateVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  Name: string | undefined;
  VoiceConnectorItems: VoiceConnectorItem[] | undefined;
}
export interface UpdateVoiceConnectorGroupResponse {
  VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface UpdateVoiceProfileRequest {
  VoiceProfileId: string | undefined;
  SpeakerSearchTaskId: string | undefined;
}
export interface UpdateVoiceProfileResponse {
  VoiceProfile?: VoiceProfile;
}
export interface UpdateVoiceProfileDomainRequest {
  VoiceProfileDomainId: string | undefined;
  Name?: string;
  Description?: string;
}
export interface UpdateVoiceProfileDomainResponse {
  VoiceProfileDomain?: VoiceProfileDomain;
}
export interface ValidateE911AddressRequest {
  AwsAccountId: string | undefined;
  StreetNumber: string | undefined;
  StreetInfo: string | undefined;
  City: string | undefined;
  State: string | undefined;
  Country: string | undefined;
  PostalCode: string | undefined;
}
export interface ValidateE911AddressResponse {
  ValidationResult?: number;
  AddressExternalId?: string;
  Address?: Address;
  CandidateAddressList?: CandidateAddress[];
}
export declare const AddressFilterSensitiveLog: (obj: Address) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorRequest
) => any;
export declare const PhoneNumberErrorFilterSensitiveLog: (
  obj: PhoneNumberError
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorResponseFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorResponse
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupResponseFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorGroupResponse
) => any;
export declare const BatchDeletePhoneNumberResponseFilterSensitiveLog: (
  obj: BatchDeletePhoneNumberResponse
) => any;
export declare const UpdatePhoneNumberRequestItemFilterSensitiveLog: (
  obj: UpdatePhoneNumberRequestItem
) => any;
export declare const BatchUpdatePhoneNumberRequestFilterSensitiveLog: (
  obj: BatchUpdatePhoneNumberRequest
) => any;
export declare const BatchUpdatePhoneNumberResponseFilterSensitiveLog: (
  obj: BatchUpdatePhoneNumberResponse
) => any;
export declare const CandidateAddressFilterSensitiveLog: (
  obj: CandidateAddress
) => any;
export declare const CreatePhoneNumberOrderRequestFilterSensitiveLog: (
  obj: CreatePhoneNumberOrderRequest
) => any;
export declare const OrderedPhoneNumberFilterSensitiveLog: (
  obj: OrderedPhoneNumber
) => any;
export declare const PhoneNumberOrderFilterSensitiveLog: (
  obj: PhoneNumberOrder
) => any;
export declare const CreatePhoneNumberOrderResponseFilterSensitiveLog: (
  obj: CreatePhoneNumberOrderResponse
) => any;
export declare const CreateProxySessionRequestFilterSensitiveLog: (
  obj: CreateProxySessionRequest
) => any;
export declare const ParticipantFilterSensitiveLog: (obj: Participant) => any;
export declare const ProxySessionFilterSensitiveLog: (obj: ProxySession) => any;
export declare const CreateProxySessionResponseFilterSensitiveLog: (
  obj: CreateProxySessionResponse
) => any;
export declare const SipMediaApplicationEndpointFilterSensitiveLog: (
  obj: SipMediaApplicationEndpoint
) => any;
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const CreateSipMediaApplicationRequestFilterSensitiveLog: (
  obj: CreateSipMediaApplicationRequest
) => any;
export declare const SipMediaApplicationFilterSensitiveLog: (
  obj: SipMediaApplication
) => any;
export declare const CreateSipMediaApplicationResponseFilterSensitiveLog: (
  obj: CreateSipMediaApplicationResponse
) => any;
export declare const CreateSipMediaApplicationCallRequestFilterSensitiveLog: (
  obj: CreateSipMediaApplicationCallRequest
) => any;
export declare const CreateVoiceConnectorRequestFilterSensitiveLog: (
  obj: CreateVoiceConnectorRequest
) => any;
export declare const VoiceProfileFilterSensitiveLog: (obj: VoiceProfile) => any;
export declare const CreateVoiceProfileResponseFilterSensitiveLog: (
  obj: CreateVoiceProfileResponse
) => any;
export declare const ServerSideEncryptionConfigurationFilterSensitiveLog: (
  obj: ServerSideEncryptionConfiguration
) => any;
export declare const CreateVoiceProfileDomainRequestFilterSensitiveLog: (
  obj: CreateVoiceProfileDomainRequest
) => any;
export declare const VoiceProfileDomainFilterSensitiveLog: (
  obj: VoiceProfileDomain
) => any;
export declare const CreateVoiceProfileDomainResponseFilterSensitiveLog: (
  obj: CreateVoiceProfileDomainResponse
) => any;
export declare const DeletePhoneNumberRequestFilterSensitiveLog: (
  obj: DeletePhoneNumberRequest
) => any;
export declare const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorTerminationCredentialsRequest
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorRequest
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorResponseFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorResponse
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
) => any;
export declare const GetPhoneNumberRequestFilterSensitiveLog: (
  obj: GetPhoneNumberRequest
) => any;
export declare const PhoneNumberFilterSensitiveLog: (obj: PhoneNumber) => any;
export declare const GetPhoneNumberResponseFilterSensitiveLog: (
  obj: GetPhoneNumberResponse
) => any;
export declare const GetPhoneNumberOrderResponseFilterSensitiveLog: (
  obj: GetPhoneNumberOrderResponse
) => any;
export declare const GetPhoneNumberSettingsResponseFilterSensitiveLog: (
  obj: GetPhoneNumberSettingsResponse
) => any;
export declare const GetProxySessionResponseFilterSensitiveLog: (
  obj: GetProxySessionResponse
) => any;
export declare const GetSipMediaApplicationResponseFilterSensitiveLog: (
  obj: GetSipMediaApplicationResponse
) => any;
export declare const SipMediaApplicationAlexaSkillConfigurationFilterSensitiveLog: (
  obj: SipMediaApplicationAlexaSkillConfiguration
) => any;
export declare const GetSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog: (
  obj: GetSipMediaApplicationAlexaSkillConfigurationResponse
) => any;
export declare const DNISEmergencyCallingConfigurationFilterSensitiveLog: (
  obj: DNISEmergencyCallingConfiguration
) => any;
export declare const EmergencyCallingConfigurationFilterSensitiveLog: (
  obj: EmergencyCallingConfiguration
) => any;
export declare const GetVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (
  obj: GetVoiceConnectorEmergencyCallingConfigurationResponse
) => any;
export declare const ProxyFilterSensitiveLog: (obj: Proxy) => any;
export declare const GetVoiceConnectorProxyResponseFilterSensitiveLog: (
  obj: GetVoiceConnectorProxyResponse
) => any;
export declare const MediaInsightsConfigurationFilterSensitiveLog: (
  obj: MediaInsightsConfiguration
) => any;
export declare const StreamingConfigurationFilterSensitiveLog: (
  obj: StreamingConfiguration
) => any;
export declare const GetVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog: (
  obj: GetVoiceConnectorStreamingConfigurationResponse
) => any;
export declare const TerminationFilterSensitiveLog: (obj: Termination) => any;
export declare const GetVoiceConnectorTerminationResponseFilterSensitiveLog: (
  obj: GetVoiceConnectorTerminationResponse
) => any;
export declare const GetVoiceProfileResponseFilterSensitiveLog: (
  obj: GetVoiceProfileResponse
) => any;
export declare const GetVoiceProfileDomainResponseFilterSensitiveLog: (
  obj: GetVoiceProfileDomainResponse
) => any;
export declare const ListPhoneNumberOrdersResponseFilterSensitiveLog: (
  obj: ListPhoneNumberOrdersResponse
) => any;
export declare const ListPhoneNumbersResponseFilterSensitiveLog: (
  obj: ListPhoneNumbersResponse
) => any;
export declare const ListProxySessionsResponseFilterSensitiveLog: (
  obj: ListProxySessionsResponse
) => any;
export declare const ListSipMediaApplicationsResponseFilterSensitiveLog: (
  obj: ListSipMediaApplicationsResponse
) => any;
export declare const ListTagsForResourceRequestFilterSensitiveLog: (
  obj: ListTagsForResourceRequest
) => any;
export declare const ListTagsForResourceResponseFilterSensitiveLog: (
  obj: ListTagsForResourceResponse
) => any;
export declare const ListVoiceConnectorTerminationCredentialsResponseFilterSensitiveLog: (
  obj: ListVoiceConnectorTerminationCredentialsResponse
) => any;
export declare const VoiceProfileDomainSummaryFilterSensitiveLog: (
  obj: VoiceProfileDomainSummary
) => any;
export declare const ListVoiceProfileDomainsResponseFilterSensitiveLog: (
  obj: ListVoiceProfileDomainsResponse
) => any;
export declare const VoiceProfileSummaryFilterSensitiveLog: (
  obj: VoiceProfileSummary
) => any;
export declare const ListVoiceProfilesResponseFilterSensitiveLog: (
  obj: ListVoiceProfilesResponse
) => any;
export declare const PutSipMediaApplicationAlexaSkillConfigurationRequestFilterSensitiveLog: (
  obj: PutSipMediaApplicationAlexaSkillConfigurationRequest
) => any;
export declare const PutSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog: (
  obj: PutSipMediaApplicationAlexaSkillConfigurationResponse
) => any;
export declare const PutVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorEmergencyCallingConfigurationRequest
) => any;
export declare const PutVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (
  obj: PutVoiceConnectorEmergencyCallingConfigurationResponse
) => any;
export declare const PutVoiceConnectorProxyRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorProxyRequest
) => any;
export declare const PutVoiceConnectorProxyResponseFilterSensitiveLog: (
  obj: PutVoiceConnectorProxyResponse
) => any;
export declare const PutVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorStreamingConfigurationRequest
) => any;
export declare const PutVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog: (
  obj: PutVoiceConnectorStreamingConfigurationResponse
) => any;
export declare const PutVoiceConnectorTerminationRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorTerminationRequest
) => any;
export declare const PutVoiceConnectorTerminationResponseFilterSensitiveLog: (
  obj: PutVoiceConnectorTerminationResponse
) => any;
export declare const CredentialFilterSensitiveLog: (obj: Credential) => any;
export declare const PutVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (
  obj: PutVoiceConnectorTerminationCredentialsRequest
) => any;
export declare const RestorePhoneNumberRequestFilterSensitiveLog: (
  obj: RestorePhoneNumberRequest
) => any;
export declare const RestorePhoneNumberResponseFilterSensitiveLog: (
  obj: RestorePhoneNumberResponse
) => any;
export declare const SearchAvailablePhoneNumbersResponseFilterSensitiveLog: (
  obj: SearchAvailablePhoneNumbersResponse
) => any;
export declare const TagResourceRequestFilterSensitiveLog: (
  obj: TagResourceRequest
) => any;
export declare const UntagResourceRequestFilterSensitiveLog: (
  obj: UntagResourceRequest
) => any;
export declare const UpdatePhoneNumberRequestFilterSensitiveLog: (
  obj: UpdatePhoneNumberRequest
) => any;
export declare const UpdatePhoneNumberResponseFilterSensitiveLog: (
  obj: UpdatePhoneNumberResponse
) => any;
export declare const UpdatePhoneNumberSettingsRequestFilterSensitiveLog: (
  obj: UpdatePhoneNumberSettingsRequest
) => any;
export declare const UpdateProxySessionResponseFilterSensitiveLog: (
  obj: UpdateProxySessionResponse
) => any;
export declare const UpdateSipMediaApplicationRequestFilterSensitiveLog: (
  obj: UpdateSipMediaApplicationRequest
) => any;
export declare const UpdateSipMediaApplicationResponseFilterSensitiveLog: (
  obj: UpdateSipMediaApplicationResponse
) => any;
export declare const UpdateSipMediaApplicationCallRequestFilterSensitiveLog: (
  obj: UpdateSipMediaApplicationCallRequest
) => any;
export declare const UpdateVoiceProfileResponseFilterSensitiveLog: (
  obj: UpdateVoiceProfileResponse
) => any;
export declare const UpdateVoiceProfileDomainResponseFilterSensitiveLog: (
  obj: UpdateVoiceProfileDomainResponse
) => any;
export declare const ValidateE911AddressRequestFilterSensitiveLog: (
  obj: ValidateE911AddressRequest
) => any;
export declare const ValidateE911AddressResponseFilterSensitiveLog: (
  obj: ValidateE911AddressResponse
) => any;
