"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TranscribeMedicalType = exports.TranscribeMedicalSpecialty = exports.TranscribeMedicalRegion = exports.TranscribeMedicalLanguageCode = exports.TranscribeMedicalContentIdentificationType = exports.EmailStatus = exports.UnprocessableEntityException = exports.VoiceConnectorAwsRegion = exports.RegistrationStatus = exports.InviteStatus = exports.SipRuleTriggerType = exports.MemberType = exports.ProxySessionStatus = exports.NumberSelectionBehavior = exports.GeoMatchLevel = exports.PhoneNumberOrderStatus = exports.OrderedPhoneNumberStatus = exports.MediaPipelineStatus = exports.MediaPipelineSourceType = exports.MediaPipelineSinkType = exports.ConflictException = exports.ChannelMessageType = exports.ChannelMessagePersistenceType = exports.ChannelPrivacy = exports.ChannelMode = exports.Capability = exports.CallingNameStatus = exports.BotType = exports.UserType = exports.PhoneNumberProductType = exports.RoomMembershipRole = exports.ResourceLimitExceededException = exports.UnauthorizedClientException = exports.ThrottledClientException = exports.ServiceUnavailableException = exports.ServiceFailureException = exports.NotFoundException = exports.ForbiddenException = exports.BadRequestException = exports.VideoMuxType = exports.ArtifactsState = exports.ContentMuxType = exports.AudioMuxType = exports.ChannelMembershipType = exports.AppInstanceDataType = exports.License = exports.AccountType = exports.AccountStatus = exports.AccessDeniedException = exports.ErrorCode = void 0;
exports.SourceConfigurationFilterSensitiveLog = exports.SelectedVideoStreamsFilterSensitiveLog = exports.ChannelModeratorSummaryFilterSensitiveLog = exports.ChannelModeratorFilterSensitiveLog = exports.ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog = exports.ChannelMessageSummaryFilterSensitiveLog = exports.ChannelMessageFilterSensitiveLog = exports.ChannelMembershipSummaryFilterSensitiveLog = exports.ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog = exports.ChannelSummaryFilterSensitiveLog = exports.ChannelMembershipFilterSensitiveLog = exports.ChannelBanSummaryFilterSensitiveLog = exports.ChannelBanFilterSensitiveLog = exports.ChannelFilterSensitiveLog = exports.CandidateAddressFilterSensitiveLog = exports.BotFilterSensitiveLog = exports.BatchUpdateUserRequestFilterSensitiveLog = exports.UpdateUserRequestItemFilterSensitiveLog = exports.BatchUpdatePhoneNumberRequestFilterSensitiveLog = exports.UpdatePhoneNumberRequestItemFilterSensitiveLog = exports.BatchCreateChannelMembershipResponseFilterSensitiveLog = exports.BatchCreateAttendeeResponseFilterSensitiveLog = exports.CreateAttendeeErrorFilterSensitiveLog = exports.BatchCreateAttendeeRequestFilterSensitiveLog = exports.CreateAttendeeRequestItemFilterSensitiveLog = exports.BatchChannelMembershipsFilterSensitiveLog = exports.TagFilterSensitiveLog = exports.AttendeeFilterSensitiveLog = exports.AssociatePhoneNumberWithUserRequestFilterSensitiveLog = exports.AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog = exports.AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog = exports.AppInstanceUserSummaryFilterSensitiveLog = exports.AppInstanceUserFilterSensitiveLog = exports.AppInstanceStreamingConfigurationFilterSensitiveLog = exports.AppInstanceSummaryFilterSensitiveLog = exports.AppInstanceAdminSummaryFilterSensitiveLog = exports.AppInstanceAdminFilterSensitiveLog = exports.IdentityFilterSensitiveLog = exports.AppInstanceFilterSensitiveLog = exports.AlexaForBusinessMetadataFilterSensitiveLog = exports.AddressFilterSensitiveLog = exports.PhoneNumberType = exports.PhoneNumberStatus = exports.PhoneNumberAssociationName = exports.TranscribeVocabularyFilterMethod = exports.TranscribeRegion = exports.TranscribePartialResultsStability = exports.TranscribeLanguageCode = exports.TranscribeContentRedactionType = exports.TranscribeContentIdentificationType = void 0;
exports.DescribeChannelResponseFilterSensitiveLog = exports.DescribeAppInstanceUserResponseFilterSensitiveLog = exports.DescribeAppInstanceAdminResponseFilterSensitiveLog = exports.DescribeAppInstanceResponseFilterSensitiveLog = exports.DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = exports.CredentialFilterSensitiveLog = exports.CreateUserResponseFilterSensitiveLog = exports.UserFilterSensitiveLog = exports.CreateUserRequestFilterSensitiveLog = exports.CreateSipMediaApplicationCallRequestFilterSensitiveLog = exports.CreateSipMediaApplicationResponseFilterSensitiveLog = exports.SipMediaApplicationFilterSensitiveLog = exports.CreateSipMediaApplicationRequestFilterSensitiveLog = exports.SipMediaApplicationEndpointFilterSensitiveLog = exports.CreateRoomMembershipResponseFilterSensitiveLog = exports.RoomMembershipFilterSensitiveLog = exports.MemberFilterSensitiveLog = exports.CreateRoomResponseFilterSensitiveLog = exports.RoomFilterSensitiveLog = exports.CreateRoomRequestFilterSensitiveLog = exports.CreateProxySessionResponseFilterSensitiveLog = exports.ProxySessionFilterSensitiveLog = exports.ParticipantFilterSensitiveLog = exports.CreateProxySessionRequestFilterSensitiveLog = exports.CreatePhoneNumberOrderResponseFilterSensitiveLog = exports.PhoneNumberOrderFilterSensitiveLog = exports.OrderedPhoneNumberFilterSensitiveLog = exports.CreatePhoneNumberOrderRequestFilterSensitiveLog = exports.CreateMeetingWithAttendeesResponseFilterSensitiveLog = exports.CreateMeetingWithAttendeesRequestFilterSensitiveLog = exports.CreateMeetingDialOutRequestFilterSensitiveLog = exports.CreateMeetingResponseFilterSensitiveLog = exports.MeetingFilterSensitiveLog = exports.CreateMeetingRequestFilterSensitiveLog = exports.MeetingNotificationConfigurationFilterSensitiveLog = exports.CreateMediaCapturePipelineResponseFilterSensitiveLog = exports.MediaCapturePipelineFilterSensitiveLog = exports.CreateMediaCapturePipelineRequestFilterSensitiveLog = exports.CreateChannelModeratorResponseFilterSensitiveLog = exports.CreateChannelMembershipResponseFilterSensitiveLog = exports.CreateChannelBanResponseFilterSensitiveLog = exports.CreateChannelRequestFilterSensitiveLog = exports.CreateBotResponseFilterSensitiveLog = exports.CreateBotRequestFilterSensitiveLog = exports.CreateAttendeeResponseFilterSensitiveLog = exports.CreateAttendeeRequestFilterSensitiveLog = exports.CreateAppInstanceUserRequestFilterSensitiveLog = exports.CreateAppInstanceAdminResponseFilterSensitiveLog = exports.CreateAppInstanceRequestFilterSensitiveLog = exports.ChimeSdkMeetingConfigurationFilterSensitiveLog = void 0;
exports.GetProxySessionResponseFilterSensitiveLog = exports.GetPhoneNumberSettingsResponseFilterSensitiveLog = exports.GetPhoneNumberOrderResponseFilterSensitiveLog = exports.GetPhoneNumberResponseFilterSensitiveLog = exports.PhoneNumberFilterSensitiveLog = exports.GetMeetingResponseFilterSensitiveLog = exports.GetMediaCapturePipelineResponseFilterSensitiveLog = exports.GetEventsConfigurationResponseFilterSensitiveLog = exports.GetChannelMessageResponseFilterSensitiveLog = exports.GetBotResponseFilterSensitiveLog = exports.GetAttendeeResponseFilterSensitiveLog = exports.GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog = exports.EventsConfigurationFilterSensitiveLog = exports.EmergencyCallingConfigurationFilterSensitiveLog = exports.DNISEmergencyCallingConfigurationFilterSensitiveLog = exports.DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog = exports.DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog = exports.DescribeChannelModeratorResponseFilterSensitiveLog = exports.DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog = exports.DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog = exports.DescribeChannelMembershipResponseFilterSensitiveLog = exports.DescribeChannelBanResponseFilterSensitiveLog = void 0;
const smithy_client_1 = require("@smithy/smithy-client");
const ChimeServiceException_1 = require("./ChimeServiceException");
exports.ErrorCode = {
    AccessDenied: "AccessDenied",
    BadRequest: "BadRequest",
    Conflict: "Conflict",
    Forbidden: "Forbidden",
    NotFound: "NotFound",
    PhoneNumberAssociationsExist: "PhoneNumberAssociationsExist",
    PreconditionFailed: "PreconditionFailed",
    ResourceLimitExceeded: "ResourceLimitExceeded",
    ServiceFailure: "ServiceFailure",
    ServiceUnavailable: "ServiceUnavailable",
    Throttled: "Throttled",
    Throttling: "Throttling",
    Unauthorized: "Unauthorized",
    Unprocessable: "Unprocessable",
    VoiceConnectorGroupAssociationsExist: "VoiceConnectorGroupAssociationsExist",
};
class AccessDeniedException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.AccessDeniedException = AccessDeniedException;
exports.AccountStatus = {
    Active: "Active",
    Suspended: "Suspended",
};
exports.AccountType = {
    EnterpriseDirectory: "EnterpriseDirectory",
    EnterpriseLWA: "EnterpriseLWA",
    EnterpriseOIDC: "EnterpriseOIDC",
    Team: "Team",
};
exports.License = {
    Basic: "Basic",
    Plus: "Plus",
    Pro: "Pro",
    ProTrial: "ProTrial",
};
exports.AppInstanceDataType = {
    Channel: "Channel",
    ChannelMessage: "ChannelMessage",
};
exports.ChannelMembershipType = {
    DEFAULT: "DEFAULT",
    HIDDEN: "HIDDEN",
};
exports.AudioMuxType = {
    AudioOnly: "AudioOnly",
    AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo",
};
exports.ContentMuxType = {
    ContentOnly: "ContentOnly",
};
exports.ArtifactsState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
exports.VideoMuxType = {
    VideoOnly: "VideoOnly",
};
class BadRequestException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "BadRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BadRequestException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.BadRequestException = BadRequestException;
class ForbiddenException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "ForbiddenException",
            $fault: "client",
            ...opts,
        });
        this.name = "ForbiddenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ForbiddenException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.ForbiddenException = ForbiddenException;
class NotFoundException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "NotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NotFoundException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.NotFoundException = NotFoundException;
class ServiceFailureException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.ServiceFailureException = ServiceFailureException;
class ServiceUnavailableException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.ServiceUnavailableException = ServiceUnavailableException;
class ThrottledClientException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "ThrottledClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottledClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottledClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.ThrottledClientException = ThrottledClientException;
class UnauthorizedClientException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "UnauthorizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnauthorizedClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.UnauthorizedClientException = UnauthorizedClientException;
class ResourceLimitExceededException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.ResourceLimitExceededException = ResourceLimitExceededException;
exports.RoomMembershipRole = {
    Administrator: "Administrator",
    Member: "Member",
};
exports.PhoneNumberProductType = {
    BusinessCalling: "BusinessCalling",
    SipMediaApplicationDialIn: "SipMediaApplicationDialIn",
    VoiceConnector: "VoiceConnector",
};
exports.UserType = {
    PrivateUser: "PrivateUser",
    SharedDevice: "SharedDevice",
};
exports.BotType = {
    ChatBot: "ChatBot",
};
exports.CallingNameStatus = {
    Unassigned: "Unassigned",
    UpdateFailed: "UpdateFailed",
    UpdateInProgress: "UpdateInProgress",
    UpdateSucceeded: "UpdateSucceeded",
};
exports.Capability = {
    SMS: "SMS",
    Voice: "Voice",
};
exports.ChannelMode = {
    RESTRICTED: "RESTRICTED",
    UNRESTRICTED: "UNRESTRICTED",
};
exports.ChannelPrivacy = {
    PRIVATE: "PRIVATE",
    PUBLIC: "PUBLIC",
};
exports.ChannelMessagePersistenceType = {
    NON_PERSISTENT: "NON_PERSISTENT",
    PERSISTENT: "PERSISTENT",
};
exports.ChannelMessageType = {
    CONTROL: "CONTROL",
    STANDARD: "STANDARD",
};
class ConflictException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.ConflictException = ConflictException;
exports.MediaPipelineSinkType = {
    S3Bucket: "S3Bucket",
};
exports.MediaPipelineSourceType = {
    ChimeSdkMeeting: "ChimeSdkMeeting",
};
exports.MediaPipelineStatus = {
    Failed: "Failed",
    InProgress: "InProgress",
    Initializing: "Initializing",
    Stopped: "Stopped",
    Stopping: "Stopping",
};
exports.OrderedPhoneNumberStatus = {
    Acquired: "Acquired",
    Failed: "Failed",
    Processing: "Processing",
};
exports.PhoneNumberOrderStatus = {
    Failed: "Failed",
    Partial: "Partial",
    Processing: "Processing",
    Successful: "Successful",
};
exports.GeoMatchLevel = {
    AreaCode: "AreaCode",
    Country: "Country",
};
exports.NumberSelectionBehavior = {
    AvoidSticky: "AvoidSticky",
    PreferSticky: "PreferSticky",
};
exports.ProxySessionStatus = {
    Closed: "Closed",
    InProgress: "InProgress",
    Open: "Open",
};
exports.MemberType = {
    Bot: "Bot",
    User: "User",
    Webhook: "Webhook",
};
exports.SipRuleTriggerType = {
    RequestUriHostname: "RequestUriHostname",
    ToPhoneNumber: "ToPhoneNumber",
};
exports.InviteStatus = {
    Accepted: "Accepted",
    Failed: "Failed",
    Pending: "Pending",
};
exports.RegistrationStatus = {
    Registered: "Registered",
    Suspended: "Suspended",
    Unregistered: "Unregistered",
};
exports.VoiceConnectorAwsRegion = {
    US_EAST_1: "us-east-1",
    US_WEST_2: "us-west-2",
};
class UnprocessableEntityException extends ChimeServiceException_1.ChimeServiceException {
    constructor(opts) {
        super({
            name: "UnprocessableEntityException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnprocessableEntityException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnprocessableEntityException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
exports.UnprocessableEntityException = UnprocessableEntityException;
exports.EmailStatus = {
    Failed: "Failed",
    NotSent: "NotSent",
    Sent: "Sent",
};
exports.TranscribeMedicalContentIdentificationType = {
    PHI: "PHI",
};
exports.TranscribeMedicalLanguageCode = {
    EN_US: "en-US",
};
exports.TranscribeMedicalRegion = {
    AP_SOUTHEAST_2: "ap-southeast-2",
    AUTO: "auto",
    CA_CENTRAL_1: "ca-central-1",
    EU_WEST_1: "eu-west-1",
    US_EAST_1: "us-east-1",
    US_EAST_2: "us-east-2",
    US_WEST_2: "us-west-2",
};
exports.TranscribeMedicalSpecialty = {
    Cardiology: "CARDIOLOGY",
    Neurology: "NEUROLOGY",
    Oncology: "ONCOLOGY",
    PrimaryCare: "PRIMARYCARE",
    Radiology: "RADIOLOGY",
    Urology: "UROLOGY",
};
exports.TranscribeMedicalType = {
    Conversation: "CONVERSATION",
    Dictation: "DICTATION",
};
exports.TranscribeContentIdentificationType = {
    PII: "PII",
};
exports.TranscribeContentRedactionType = {
    PII: "PII",
};
exports.TranscribeLanguageCode = {
    DE_DE: "de-DE",
    EN_AU: "en-AU",
    EN_GB: "en-GB",
    EN_US: "en-US",
    ES_US: "es-US",
    FR_CA: "fr-CA",
    FR_FR: "fr-FR",
    HI_IN: "hi-IN",
    IT_IT: "it-IT",
    JA_JP: "ja-JP",
    KO_KR: "ko-KR",
    PT_BR: "pt-BR",
    TH_TH: "th-TH",
    ZH_CN: "zh-CN",
};
exports.TranscribePartialResultsStability = {
    HIGH: "high",
    LOW: "low",
    MEDIUM: "medium",
};
exports.TranscribeRegion = {
    AP_NORTHEAST_1: "ap-northeast-1",
    AP_NORTHEAST_2: "ap-northeast-2",
    AP_SOUTHEAST_2: "ap-southeast-2",
    AUTO: "auto",
    CA_CENTRAL_1: "ca-central-1",
    EU_CENTRAL_1: "eu-central-1",
    EU_WEST_1: "eu-west-1",
    EU_WEST_2: "eu-west-2",
    SA_EAST_1: "sa-east-1",
    US_EAST_1: "us-east-1",
    US_EAST_2: "us-east-2",
    US_WEST_2: "us-west-2",
};
exports.TranscribeVocabularyFilterMethod = {
    Mask: "mask",
    Remove: "remove",
    Tag: "tag",
};
exports.PhoneNumberAssociationName = {
    AccountId: "AccountId",
    SipRuleId: "SipRuleId",
    UserId: "UserId",
    VoiceConnectorGroupId: "VoiceConnectorGroupId",
    VoiceConnectorId: "VoiceConnectorId",
};
exports.PhoneNumberStatus = {
    AcquireFailed: "AcquireFailed",
    AcquireInProgress: "AcquireInProgress",
    Assigned: "Assigned",
    DeleteFailed: "DeleteFailed",
    DeleteInProgress: "DeleteInProgress",
    ReleaseFailed: "ReleaseFailed",
    ReleaseInProgress: "ReleaseInProgress",
    Unassigned: "Unassigned",
};
exports.PhoneNumberType = {
    Local: "Local",
    TollFree: "TollFree",
};
const AddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetName && { streetName: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.streetSuffix && { streetSuffix: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.postDirectional && { postDirectional: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.preDirectional && { preDirectional: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.city && { city: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.state && { state: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.country && { country: smithy_client_1.SENSITIVE_STRING }),
});
exports.AddressFilterSensitiveLog = AddressFilterSensitiveLog;
const AlexaForBusinessMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaForBusinessRoomArn && { AlexaForBusinessRoomArn: smithy_client_1.SENSITIVE_STRING }),
});
exports.AlexaForBusinessMetadataFilterSensitiveLog = AlexaForBusinessMetadataFilterSensitiveLog;
const AppInstanceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
});
exports.AppInstanceFilterSensitiveLog = AppInstanceFilterSensitiveLog;
const IdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
});
exports.IdentityFilterSensitiveLog = IdentityFilterSensitiveLog;
const AppInstanceAdminFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: (0, exports.IdentityFilterSensitiveLog)(obj.Admin) }),
});
exports.AppInstanceAdminFilterSensitiveLog = AppInstanceAdminFilterSensitiveLog;
const AppInstanceAdminSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: (0, exports.IdentityFilterSensitiveLog)(obj.Admin) }),
});
exports.AppInstanceAdminSummaryFilterSensitiveLog = AppInstanceAdminSummaryFilterSensitiveLog;
const AppInstanceSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
});
exports.AppInstanceSummaryFilterSensitiveLog = AppInstanceSummaryFilterSensitiveLog;
const AppInstanceStreamingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceArn && { ResourceArn: smithy_client_1.SENSITIVE_STRING }),
});
exports.AppInstanceStreamingConfigurationFilterSensitiveLog = AppInstanceStreamingConfigurationFilterSensitiveLog;
const AppInstanceUserFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
});
exports.AppInstanceUserFilterSensitiveLog = AppInstanceUserFilterSensitiveLog;
const AppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
});
exports.AppInstanceUserSummaryFilterSensitiveLog = AppInstanceUserSummaryFilterSensitiveLog;
const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: smithy_client_1.SENSITIVE_STRING }),
});
exports.AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog = AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog;
const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: smithy_client_1.SENSITIVE_STRING }),
});
exports.AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog = AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog;
const AssociatePhoneNumberWithUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: smithy_client_1.SENSITIVE_STRING }),
});
exports.AssociatePhoneNumberWithUserRequestFilterSensitiveLog = AssociatePhoneNumberWithUserRequestFilterSensitiveLog;
const AttendeeFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.JoinToken && { JoinToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.AttendeeFilterSensitiveLog = AttendeeFilterSensitiveLog;
const TagFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Key && { Key: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Value && { Value: smithy_client_1.SENSITIVE_STRING }),
});
exports.TagFilterSensitiveLog = TagFilterSensitiveLog;
const BatchChannelMembershipsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InvitedBy && { InvitedBy: (0, exports.IdentityFilterSensitiveLog)(obj.InvitedBy) }),
    ...(obj.Members && { Members: obj.Members.map((item) => (0, exports.IdentityFilterSensitiveLog)(item)) }),
});
exports.BatchChannelMembershipsFilterSensitiveLog = BatchChannelMembershipsFilterSensitiveLog;
const CreateAttendeeRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => (0, exports.TagFilterSensitiveLog)(item)) }),
});
exports.CreateAttendeeRequestItemFilterSensitiveLog = CreateAttendeeRequestItemFilterSensitiveLog;
const BatchCreateAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => (0, exports.CreateAttendeeRequestItemFilterSensitiveLog)(item)) }),
});
exports.BatchCreateAttendeeRequestFilterSensitiveLog = BatchCreateAttendeeRequestFilterSensitiveLog;
const CreateAttendeeErrorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateAttendeeErrorFilterSensitiveLog = CreateAttendeeErrorFilterSensitiveLog;
const BatchCreateAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => (0, exports.AttendeeFilterSensitiveLog)(item)) }),
    ...(obj.Errors && { Errors: obj.Errors.map((item) => (0, exports.CreateAttendeeErrorFilterSensitiveLog)(item)) }),
});
exports.BatchCreateAttendeeResponseFilterSensitiveLog = BatchCreateAttendeeResponseFilterSensitiveLog;
const BatchCreateChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.BatchChannelMemberships && {
        BatchChannelMemberships: (0, exports.BatchChannelMembershipsFilterSensitiveLog)(obj.BatchChannelMemberships),
    }),
});
exports.BatchCreateChannelMembershipResponseFilterSensitiveLog = BatchCreateChannelMembershipResponseFilterSensitiveLog;
const UpdatePhoneNumberRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: smithy_client_1.SENSITIVE_STRING }),
});
exports.UpdatePhoneNumberRequestItemFilterSensitiveLog = UpdatePhoneNumberRequestItemFilterSensitiveLog;
const BatchUpdatePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UpdatePhoneNumberRequestItems && {
        UpdatePhoneNumberRequestItems: obj.UpdatePhoneNumberRequestItems.map((item) => (0, exports.UpdatePhoneNumberRequestItemFilterSensitiveLog)(item)),
    }),
});
exports.BatchUpdatePhoneNumberRequestFilterSensitiveLog = BatchUpdatePhoneNumberRequestFilterSensitiveLog;
const UpdateUserRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaForBusinessMetadata && {
        AlexaForBusinessMetadata: (0, exports.AlexaForBusinessMetadataFilterSensitiveLog)(obj.AlexaForBusinessMetadata),
    }),
});
exports.UpdateUserRequestItemFilterSensitiveLog = UpdateUserRequestItemFilterSensitiveLog;
const BatchUpdateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UpdateUserRequestItems && {
        UpdateUserRequestItems: obj.UpdateUserRequestItems.map((item) => (0, exports.UpdateUserRequestItemFilterSensitiveLog)(item)),
    }),
});
exports.BatchUpdateUserRequestFilterSensitiveLog = BatchUpdateUserRequestFilterSensitiveLog;
const BotFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DisplayName && { DisplayName: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.BotEmail && { BotEmail: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SecurityToken && { SecurityToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.BotFilterSensitiveLog = BotFilterSensitiveLog;
const CandidateAddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetInfo && { streetInfo: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.city && { city: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.state && { state: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.country && { country: smithy_client_1.SENSITIVE_STRING }),
});
exports.CandidateAddressFilterSensitiveLog = CandidateAddressFilterSensitiveLog;
const ChannelFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.CreatedBy && { CreatedBy: (0, exports.IdentityFilterSensitiveLog)(obj.CreatedBy) }),
});
exports.ChannelFilterSensitiveLog = ChannelFilterSensitiveLog;
const ChannelBanFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: (0, exports.IdentityFilterSensitiveLog)(obj.Member) }),
    ...(obj.CreatedBy && { CreatedBy: (0, exports.IdentityFilterSensitiveLog)(obj.CreatedBy) }),
});
exports.ChannelBanFilterSensitiveLog = ChannelBanFilterSensitiveLog;
const ChannelBanSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: (0, exports.IdentityFilterSensitiveLog)(obj.Member) }),
});
exports.ChannelBanSummaryFilterSensitiveLog = ChannelBanSummaryFilterSensitiveLog;
const ChannelMembershipFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InvitedBy && { InvitedBy: (0, exports.IdentityFilterSensitiveLog)(obj.InvitedBy) }),
    ...(obj.Member && { Member: (0, exports.IdentityFilterSensitiveLog)(obj.Member) }),
});
exports.ChannelMembershipFilterSensitiveLog = ChannelMembershipFilterSensitiveLog;
const ChannelSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
});
exports.ChannelSummaryFilterSensitiveLog = ChannelSummaryFilterSensitiveLog;
const ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelSummary && { ChannelSummary: (0, exports.ChannelSummaryFilterSensitiveLog)(obj.ChannelSummary) }),
});
exports.ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog = ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog;
const ChannelMembershipSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: (0, exports.IdentityFilterSensitiveLog)(obj.Member) }),
});
exports.ChannelMembershipSummaryFilterSensitiveLog = ChannelMembershipSummaryFilterSensitiveLog;
const ChannelMessageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Sender && { Sender: (0, exports.IdentityFilterSensitiveLog)(obj.Sender) }),
});
exports.ChannelMessageFilterSensitiveLog = ChannelMessageFilterSensitiveLog;
const ChannelMessageSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Sender && { Sender: (0, exports.IdentityFilterSensitiveLog)(obj.Sender) }),
});
exports.ChannelMessageSummaryFilterSensitiveLog = ChannelMessageSummaryFilterSensitiveLog;
const ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelSummary && { ChannelSummary: (0, exports.ChannelSummaryFilterSensitiveLog)(obj.ChannelSummary) }),
});
exports.ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog = ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog;
const ChannelModeratorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Moderator && { Moderator: (0, exports.IdentityFilterSensitiveLog)(obj.Moderator) }),
    ...(obj.CreatedBy && { CreatedBy: (0, exports.IdentityFilterSensitiveLog)(obj.CreatedBy) }),
});
exports.ChannelModeratorFilterSensitiveLog = ChannelModeratorFilterSensitiveLog;
const ChannelModeratorSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Moderator && { Moderator: (0, exports.IdentityFilterSensitiveLog)(obj.Moderator) }),
});
exports.ChannelModeratorSummaryFilterSensitiveLog = ChannelModeratorSummaryFilterSensitiveLog;
const SelectedVideoStreamsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserIds && { ExternalUserIds: smithy_client_1.SENSITIVE_STRING }),
});
exports.SelectedVideoStreamsFilterSensitiveLog = SelectedVideoStreamsFilterSensitiveLog;
const SourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SelectedVideoStreams && {
        SelectedVideoStreams: (0, exports.SelectedVideoStreamsFilterSensitiveLog)(obj.SelectedVideoStreams),
    }),
});
exports.SourceConfigurationFilterSensitiveLog = SourceConfigurationFilterSensitiveLog;
const ChimeSdkMeetingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceConfiguration && {
        SourceConfiguration: (0, exports.SourceConfigurationFilterSensitiveLog)(obj.SourceConfiguration),
    }),
});
exports.ChimeSdkMeetingConfigurationFilterSensitiveLog = ChimeSdkMeetingConfigurationFilterSensitiveLog;
const CreateAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => (0, exports.TagFilterSensitiveLog)(item)) }),
});
exports.CreateAppInstanceRequestFilterSensitiveLog = CreateAppInstanceRequestFilterSensitiveLog;
const CreateAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: (0, exports.IdentityFilterSensitiveLog)(obj.AppInstanceAdmin) }),
});
exports.CreateAppInstanceAdminResponseFilterSensitiveLog = CreateAppInstanceAdminResponseFilterSensitiveLog;
const CreateAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserId && { AppInstanceUserId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => (0, exports.TagFilterSensitiveLog)(item)) }),
});
exports.CreateAppInstanceUserRequestFilterSensitiveLog = CreateAppInstanceUserRequestFilterSensitiveLog;
const CreateAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => (0, exports.TagFilterSensitiveLog)(item)) }),
});
exports.CreateAttendeeRequestFilterSensitiveLog = CreateAttendeeRequestFilterSensitiveLog;
const CreateAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendee && { Attendee: (0, exports.AttendeeFilterSensitiveLog)(obj.Attendee) }),
});
exports.CreateAttendeeResponseFilterSensitiveLog = CreateAttendeeResponseFilterSensitiveLog;
const CreateBotRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DisplayName && { DisplayName: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateBotRequestFilterSensitiveLog = CreateBotRequestFilterSensitiveLog;
const CreateBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: (0, exports.BotFilterSensitiveLog)(obj.Bot) }),
});
exports.CreateBotResponseFilterSensitiveLog = CreateBotResponseFilterSensitiveLog;
const CreateChannelRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => (0, exports.TagFilterSensitiveLog)(item)) }),
});
exports.CreateChannelRequestFilterSensitiveLog = CreateChannelRequestFilterSensitiveLog;
const CreateChannelBanResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: (0, exports.IdentityFilterSensitiveLog)(obj.Member) }),
});
exports.CreateChannelBanResponseFilterSensitiveLog = CreateChannelBanResponseFilterSensitiveLog;
const CreateChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: (0, exports.IdentityFilterSensitiveLog)(obj.Member) }),
});
exports.CreateChannelMembershipResponseFilterSensitiveLog = CreateChannelMembershipResponseFilterSensitiveLog;
const CreateChannelModeratorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelModerator && { ChannelModerator: (0, exports.IdentityFilterSensitiveLog)(obj.ChannelModerator) }),
});
exports.CreateChannelModeratorResponseFilterSensitiveLog = CreateChannelModeratorResponseFilterSensitiveLog;
const CreateMediaCapturePipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: (0, exports.ChimeSdkMeetingConfigurationFilterSensitiveLog)(obj.ChimeSdkMeetingConfiguration),
    }),
});
exports.CreateMediaCapturePipelineRequestFilterSensitiveLog = CreateMediaCapturePipelineRequestFilterSensitiveLog;
const MediaCapturePipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: (0, exports.ChimeSdkMeetingConfigurationFilterSensitiveLog)(obj.ChimeSdkMeetingConfiguration),
    }),
});
exports.MediaCapturePipelineFilterSensitiveLog = MediaCapturePipelineFilterSensitiveLog;
const CreateMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: (0, exports.MediaCapturePipelineFilterSensitiveLog)(obj.MediaCapturePipeline),
    }),
});
exports.CreateMediaCapturePipelineResponseFilterSensitiveLog = CreateMediaCapturePipelineResponseFilterSensitiveLog;
const MeetingNotificationConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnsTopicArn && { SnsTopicArn: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SqsQueueArn && { SqsQueueArn: smithy_client_1.SENSITIVE_STRING }),
});
exports.MeetingNotificationConfigurationFilterSensitiveLog = MeetingNotificationConfigurationFilterSensitiveLog;
const CreateMeetingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ExternalMeetingId && { ExternalMeetingId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.MeetingHostId && { MeetingHostId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => (0, exports.TagFilterSensitiveLog)(item)) }),
    ...(obj.NotificationsConfiguration && {
        NotificationsConfiguration: (0, exports.MeetingNotificationConfigurationFilterSensitiveLog)(obj.NotificationsConfiguration),
    }),
});
exports.CreateMeetingRequestFilterSensitiveLog = CreateMeetingRequestFilterSensitiveLog;
const MeetingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalMeetingId && { ExternalMeetingId: smithy_client_1.SENSITIVE_STRING }),
});
exports.MeetingFilterSensitiveLog = MeetingFilterSensitiveLog;
const CreateMeetingResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: (0, exports.MeetingFilterSensitiveLog)(obj.Meeting) }),
});
exports.CreateMeetingResponseFilterSensitiveLog = CreateMeetingResponseFilterSensitiveLog;
const CreateMeetingDialOutRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FromPhoneNumber && { FromPhoneNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ToPhoneNumber && { ToPhoneNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.JoinToken && { JoinToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateMeetingDialOutRequestFilterSensitiveLog = CreateMeetingDialOutRequestFilterSensitiveLog;
const CreateMeetingWithAttendeesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ExternalMeetingId && { ExternalMeetingId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.MeetingHostId && { MeetingHostId: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => (0, exports.TagFilterSensitiveLog)(item)) }),
    ...(obj.NotificationsConfiguration && {
        NotificationsConfiguration: (0, exports.MeetingNotificationConfigurationFilterSensitiveLog)(obj.NotificationsConfiguration),
    }),
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => (0, exports.CreateAttendeeRequestItemFilterSensitiveLog)(item)) }),
});
exports.CreateMeetingWithAttendeesRequestFilterSensitiveLog = CreateMeetingWithAttendeesRequestFilterSensitiveLog;
const CreateMeetingWithAttendeesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: (0, exports.MeetingFilterSensitiveLog)(obj.Meeting) }),
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => (0, exports.AttendeeFilterSensitiveLog)(item)) }),
    ...(obj.Errors && { Errors: obj.Errors.map((item) => (0, exports.CreateAttendeeErrorFilterSensitiveLog)(item)) }),
});
exports.CreateMeetingWithAttendeesResponseFilterSensitiveLog = CreateMeetingWithAttendeesResponseFilterSensitiveLog;
const CreatePhoneNumberOrderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreatePhoneNumberOrderRequestFilterSensitiveLog = CreatePhoneNumberOrderRequestFilterSensitiveLog;
const OrderedPhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: smithy_client_1.SENSITIVE_STRING }),
});
exports.OrderedPhoneNumberFilterSensitiveLog = OrderedPhoneNumberFilterSensitiveLog;
const PhoneNumberOrderFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OrderedPhoneNumbers && {
        OrderedPhoneNumbers: obj.OrderedPhoneNumbers.map((item) => (0, exports.OrderedPhoneNumberFilterSensitiveLog)(item)),
    }),
});
exports.PhoneNumberOrderFilterSensitiveLog = PhoneNumberOrderFilterSensitiveLog;
const CreatePhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: (0, exports.PhoneNumberOrderFilterSensitiveLog)(obj.PhoneNumberOrder) }),
});
exports.CreatePhoneNumberOrderResponseFilterSensitiveLog = CreatePhoneNumberOrderResponseFilterSensitiveLog;
const CreateProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ParticipantPhoneNumbers && { ParticipantPhoneNumbers: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateProxySessionRequestFilterSensitiveLog = CreateProxySessionRequestFilterSensitiveLog;
const ParticipantFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ProxyPhoneNumber && { ProxyPhoneNumber: smithy_client_1.SENSITIVE_STRING }),
});
exports.ParticipantFilterSensitiveLog = ParticipantFilterSensitiveLog;
const ProxySessionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Participants && { Participants: obj.Participants.map((item) => (0, exports.ParticipantFilterSensitiveLog)(item)) }),
});
exports.ProxySessionFilterSensitiveLog = ProxySessionFilterSensitiveLog;
const CreateProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: (0, exports.ProxySessionFilterSensitiveLog)(obj.ProxySession) }),
});
exports.CreateProxySessionResponseFilterSensitiveLog = CreateProxySessionResponseFilterSensitiveLog;
const CreateRoomRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateRoomRequestFilterSensitiveLog = CreateRoomRequestFilterSensitiveLog;
const RoomFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: smithy_client_1.SENSITIVE_STRING }),
});
exports.RoomFilterSensitiveLog = RoomFilterSensitiveLog;
const CreateRoomResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Room && { Room: (0, exports.RoomFilterSensitiveLog)(obj.Room) }),
});
exports.CreateRoomResponseFilterSensitiveLog = CreateRoomResponseFilterSensitiveLog;
const MemberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Email && { Email: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.FullName && { FullName: smithy_client_1.SENSITIVE_STRING }),
});
exports.MemberFilterSensitiveLog = MemberFilterSensitiveLog;
const RoomMembershipFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: (0, exports.MemberFilterSensitiveLog)(obj.Member) }),
});
exports.RoomMembershipFilterSensitiveLog = RoomMembershipFilterSensitiveLog;
const CreateRoomMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RoomMembership && { RoomMembership: (0, exports.RoomMembershipFilterSensitiveLog)(obj.RoomMembership) }),
});
exports.CreateRoomMembershipResponseFilterSensitiveLog = CreateRoomMembershipResponseFilterSensitiveLog;
const SipMediaApplicationEndpointFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LambdaArn && { LambdaArn: smithy_client_1.SENSITIVE_STRING }),
});
exports.SipMediaApplicationEndpointFilterSensitiveLog = SipMediaApplicationEndpointFilterSensitiveLog;
const CreateSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => (0, exports.SipMediaApplicationEndpointFilterSensitiveLog)(item)) }),
});
exports.CreateSipMediaApplicationRequestFilterSensitiveLog = CreateSipMediaApplicationRequestFilterSensitiveLog;
const SipMediaApplicationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => (0, exports.SipMediaApplicationEndpointFilterSensitiveLog)(item)) }),
});
exports.SipMediaApplicationFilterSensitiveLog = SipMediaApplicationFilterSensitiveLog;
const CreateSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: (0, exports.SipMediaApplicationFilterSensitiveLog)(obj.SipMediaApplication),
    }),
});
exports.CreateSipMediaApplicationResponseFilterSensitiveLog = CreateSipMediaApplicationResponseFilterSensitiveLog;
const CreateSipMediaApplicationCallRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FromPhoneNumber && { FromPhoneNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.ToPhoneNumber && { ToPhoneNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.SipHeaders && { SipHeaders: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateSipMediaApplicationCallRequestFilterSensitiveLog = CreateSipMediaApplicationCallRequestFilterSensitiveLog;
const CreateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Email && { Email: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateUserRequestFilterSensitiveLog = CreateUserRequestFilterSensitiveLog;
const UserFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PrimaryEmail && { PrimaryEmail: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.PrimaryProvisionedNumber && { PrimaryProvisionedNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.DisplayName && { DisplayName: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.AlexaForBusinessMetadata && {
        AlexaForBusinessMetadata: (0, exports.AlexaForBusinessMetadataFilterSensitiveLog)(obj.AlexaForBusinessMetadata),
    }),
});
exports.UserFilterSensitiveLog = UserFilterSensitiveLog;
const CreateUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.User && { User: (0, exports.UserFilterSensitiveLog)(obj.User) }),
});
exports.CreateUserResponseFilterSensitiveLog = CreateUserResponseFilterSensitiveLog;
const CredentialFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Username && { Username: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Password && { Password: smithy_client_1.SENSITIVE_STRING }),
});
exports.CredentialFilterSensitiveLog = CredentialFilterSensitiveLog;
const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Usernames && { Usernames: smithy_client_1.SENSITIVE_STRING }),
});
exports.DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog;
const DescribeAppInstanceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstance && { AppInstance: (0, exports.AppInstanceFilterSensitiveLog)(obj.AppInstance) }),
});
exports.DescribeAppInstanceResponseFilterSensitiveLog = DescribeAppInstanceResponseFilterSensitiveLog;
const DescribeAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: (0, exports.AppInstanceAdminFilterSensitiveLog)(obj.AppInstanceAdmin) }),
});
exports.DescribeAppInstanceAdminResponseFilterSensitiveLog = DescribeAppInstanceAdminResponseFilterSensitiveLog;
const DescribeAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUser && { AppInstanceUser: (0, exports.AppInstanceUserFilterSensitiveLog)(obj.AppInstanceUser) }),
});
exports.DescribeAppInstanceUserResponseFilterSensitiveLog = DescribeAppInstanceUserResponseFilterSensitiveLog;
const DescribeChannelResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channel && { Channel: (0, exports.ChannelFilterSensitiveLog)(obj.Channel) }),
});
exports.DescribeChannelResponseFilterSensitiveLog = DescribeChannelResponseFilterSensitiveLog;
const DescribeChannelBanResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelBan && { ChannelBan: (0, exports.ChannelBanFilterSensitiveLog)(obj.ChannelBan) }),
});
exports.DescribeChannelBanResponseFilterSensitiveLog = DescribeChannelBanResponseFilterSensitiveLog;
const DescribeChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMembership && { ChannelMembership: (0, exports.ChannelMembershipFilterSensitiveLog)(obj.ChannelMembership) }),
});
exports.DescribeChannelMembershipResponseFilterSensitiveLog = DescribeChannelMembershipResponseFilterSensitiveLog;
const DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMembership && {
        ChannelMembership: (0, exports.ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog)(obj.ChannelMembership),
    }),
});
exports.DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog = DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog;
const DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channel && { Channel: (0, exports.ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog)(obj.Channel) }),
});
exports.DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog = DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog;
const DescribeChannelModeratorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelModerator && { ChannelModerator: (0, exports.ChannelModeratorFilterSensitiveLog)(obj.ChannelModerator) }),
});
exports.DescribeChannelModeratorResponseFilterSensitiveLog = DescribeChannelModeratorResponseFilterSensitiveLog;
const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: smithy_client_1.SENSITIVE_STRING }),
});
exports.DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog = DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog;
const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: smithy_client_1.SENSITIVE_STRING }),
});
exports.DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog = DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog;
const DNISEmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyPhoneNumber && { EmergencyPhoneNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.TestPhoneNumber && { TestPhoneNumber: smithy_client_1.SENSITIVE_STRING }),
});
exports.DNISEmergencyCallingConfigurationFilterSensitiveLog = DNISEmergencyCallingConfigurationFilterSensitiveLog;
const EmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DNIS && { DNIS: obj.DNIS.map((item) => (0, exports.DNISEmergencyCallingConfigurationFilterSensitiveLog)(item)) }),
});
exports.EmergencyCallingConfigurationFilterSensitiveLog = EmergencyCallingConfigurationFilterSensitiveLog;
const EventsConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OutboundEventsHTTPSEndpoint && { OutboundEventsHTTPSEndpoint: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.LambdaFunctionArn && { LambdaFunctionArn: smithy_client_1.SENSITIVE_STRING }),
});
exports.EventsConfigurationFilterSensitiveLog = EventsConfigurationFilterSensitiveLog;
const GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceStreamingConfigurations && {
        AppInstanceStreamingConfigurations: obj.AppInstanceStreamingConfigurations.map((item) => (0, exports.AppInstanceStreamingConfigurationFilterSensitiveLog)(item)),
    }),
});
exports.GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog = GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog;
const GetAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendee && { Attendee: (0, exports.AttendeeFilterSensitiveLog)(obj.Attendee) }),
});
exports.GetAttendeeResponseFilterSensitiveLog = GetAttendeeResponseFilterSensitiveLog;
const GetBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: (0, exports.BotFilterSensitiveLog)(obj.Bot) }),
});
exports.GetBotResponseFilterSensitiveLog = GetBotResponseFilterSensitiveLog;
const GetChannelMessageResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMessage && { ChannelMessage: (0, exports.ChannelMessageFilterSensitiveLog)(obj.ChannelMessage) }),
});
exports.GetChannelMessageResponseFilterSensitiveLog = GetChannelMessageResponseFilterSensitiveLog;
const GetEventsConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EventsConfiguration && {
        EventsConfiguration: (0, exports.EventsConfigurationFilterSensitiveLog)(obj.EventsConfiguration),
    }),
});
exports.GetEventsConfigurationResponseFilterSensitiveLog = GetEventsConfigurationResponseFilterSensitiveLog;
const GetMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: (0, exports.MediaCapturePipelineFilterSensitiveLog)(obj.MediaCapturePipeline),
    }),
});
exports.GetMediaCapturePipelineResponseFilterSensitiveLog = GetMediaCapturePipelineResponseFilterSensitiveLog;
const GetMeetingResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: (0, exports.MeetingFilterSensitiveLog)(obj.Meeting) }),
});
exports.GetMeetingResponseFilterSensitiveLog = GetMeetingResponseFilterSensitiveLog;
const PhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.CallingName && { CallingName: smithy_client_1.SENSITIVE_STRING }),
});
exports.PhoneNumberFilterSensitiveLog = PhoneNumberFilterSensitiveLog;
const GetPhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: (0, exports.PhoneNumberFilterSensitiveLog)(obj.PhoneNumber) }),
});
exports.GetPhoneNumberResponseFilterSensitiveLog = GetPhoneNumberResponseFilterSensitiveLog;
const GetPhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: (0, exports.PhoneNumberOrderFilterSensitiveLog)(obj.PhoneNumberOrder) }),
});
exports.GetPhoneNumberOrderResponseFilterSensitiveLog = GetPhoneNumberOrderResponseFilterSensitiveLog;
const GetPhoneNumberSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: smithy_client_1.SENSITIVE_STRING }),
});
exports.GetPhoneNumberSettingsResponseFilterSensitiveLog = GetPhoneNumberSettingsResponseFilterSensitiveLog;
const GetProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: (0, exports.ProxySessionFilterSensitiveLog)(obj.ProxySession) }),
});
exports.GetProxySessionResponseFilterSensitiveLog = GetProxySessionResponseFilterSensitiveLog;
