"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListChannelModerators = void 0;
const ChimeClient_1 = require("../ChimeClient");
const ListChannelModeratorsCommand_1 = require("../commands/ListChannelModeratorsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListChannelModeratorsCommand_1.ListChannelModeratorsCommand(input), ...args);
};
async function* paginateListChannelModerators(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeClient_1.ChimeClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected Chime | ChimeClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListChannelModerators = paginateListChannelModerators;
