import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { ChimeClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeClient";
import { InviteUsersRequest, InviteUsersResponse } from "../models/models_1";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link InviteUsersCommand}.
 */
export interface InviteUsersCommandInput extends InviteUsersRequest {
}
/**
 * @public
 *
 * The output of {@link InviteUsersCommand}.
 */
export interface InviteUsersCommandOutput extends InviteUsersResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime
 *                 <code>Team</code> account. Only <code>Team</code> account types are currently
 *             supported for this action.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeClient, InviteUsersCommand } from "@aws-sdk/client-chime"; // ES Modules import
 * // const { ChimeClient, InviteUsersCommand } = require("@aws-sdk/client-chime"); // CommonJS import
 * const client = new ChimeClient(config);
 * const input = { // InviteUsersRequest
 *   AccountId: "STRING_VALUE", // required
 *   UserEmailList: [ // UserEmailList // required
 *     "STRING_VALUE",
 *   ],
 *   UserType: "PrivateUser" || "SharedDevice",
 * };
 * const command = new InviteUsersCommand(input);
 * const response = await client.send(command);
 * // { // InviteUsersResponse
 * //   Invites: [ // InviteList
 * //     { // Invite
 * //       InviteId: "STRING_VALUE",
 * //       Status: "Pending" || "Accepted" || "Failed",
 * //       EmailAddress: "STRING_VALUE",
 * //       EmailStatus: "NotSent" || "Sent" || "Failed",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param InviteUsersCommandInput - {@link InviteUsersCommandInput}
 * @returns {@link InviteUsersCommandOutput}
 * @see {@link InviteUsersCommandInput} for command's `input` shape.
 * @see {@link InviteUsersCommandOutput} for command's `response` shape.
 * @see {@link ChimeClientResolvedConfig | config} for ChimeClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>One or more of the resources in the request does not exist in the system.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 * @throws {@link ChimeServiceException}
 * <p>Base exception class for all service exceptions from Chime service.</p>
 *
 */
export declare class InviteUsersCommand extends $Command<InviteUsersCommandInput, InviteUsersCommandOutput, ChimeClientResolvedConfig> {
    readonly input: InviteUsersCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: InviteUsersCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeClientResolvedConfig, options?: __HttpHandlerOptions): Handler<InviteUsersCommandInput, InviteUsersCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
