import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { ChimeClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeClient";
import { ValidateE911AddressRequest, ValidateE911AddressResponse } from "../models/models_1";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ValidateE911AddressCommand}.
 */
export interface ValidateE911AddressCommandInput extends ValidateE911AddressRequest {
}
/**
 * @public
 *
 * The output of {@link ValidateE911AddressCommand}.
 */
export interface ValidateE911AddressCommandOutput extends ValidateE911AddressResponse, __MetadataBearer {
}
/**
 * @public
 * @deprecated
 *
 * <p>Validates an address to be used for 911 calls made with Amazon
 *             Chime Voice Connectors. You can use validated addresses
 *             in a Presence Information Data Format Location Object file that you include in SIP requests.
 *             That helps ensure that addresses are routed to the appropriate Public Safety Answering Point.</p>
 *          <important>
 *             <p>
 *                <b>This API is is no longer supported and will not be updated.</b> We recommend using the latest version, <a href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ValidateE911Address.html">ValidateE911Address</a>, in the Amazon Chime SDK.</p>
 *             <p>Using the latest version requires migrating to a dedicated namespace. For more information, refer to
 *                 <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html">Migrating from the Amazon Chime namespace</a> in the
 *                 <i>Amazon Chime SDK Developer Guide</i>.</p>
 *          </important>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeClient, ValidateE911AddressCommand } from "@aws-sdk/client-chime"; // ES Modules import
 * // const { ChimeClient, ValidateE911AddressCommand } = require("@aws-sdk/client-chime"); // CommonJS import
 * const client = new ChimeClient(config);
 * const input = { // ValidateE911AddressRequest
 *   AwsAccountId: "STRING_VALUE", // required
 *   StreetNumber: "STRING_VALUE", // required
 *   StreetInfo: "STRING_VALUE", // required
 *   City: "STRING_VALUE", // required
 *   State: "STRING_VALUE", // required
 *   Country: "STRING_VALUE", // required
 *   PostalCode: "STRING_VALUE", // required
 * };
 * const command = new ValidateE911AddressCommand(input);
 * const response = await client.send(command);
 * // { // ValidateE911AddressResponse
 * //   ValidationResult: Number("int"),
 * //   AddressExternalId: "STRING_VALUE",
 * //   Address: { // Address
 * //     streetName: "STRING_VALUE",
 * //     streetSuffix: "STRING_VALUE",
 * //     postDirectional: "STRING_VALUE",
 * //     preDirectional: "STRING_VALUE",
 * //     streetNumber: "STRING_VALUE",
 * //     city: "STRING_VALUE",
 * //     state: "STRING_VALUE",
 * //     postalCode: "STRING_VALUE",
 * //     postalCodePlus4: "STRING_VALUE",
 * //     country: "STRING_VALUE",
 * //   },
 * //   CandidateAddressList: [ // CandidateAddressList
 * //     { // CandidateAddress
 * //       streetInfo: "STRING_VALUE",
 * //       streetNumber: "STRING_VALUE",
 * //       city: "STRING_VALUE",
 * //       state: "STRING_VALUE",
 * //       postalCode: "STRING_VALUE",
 * //       postalCodePlus4: "STRING_VALUE",
 * //       country: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param ValidateE911AddressCommandInput - {@link ValidateE911AddressCommandInput}
 * @returns {@link ValidateE911AddressCommandOutput}
 * @see {@link ValidateE911AddressCommandInput} for command's `input` shape.
 * @see {@link ValidateE911AddressCommandOutput} for command's `response` shape.
 * @see {@link ChimeClientResolvedConfig | config} for ChimeClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>One or more of the resources in the request does not exist in the system.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 * @throws {@link ChimeServiceException}
 * <p>Base exception class for all service exceptions from Chime service.</p>
 *
 */
export declare class ValidateE911AddressCommand extends $Command<ValidateE911AddressCommandInput, ValidateE911AddressCommandOutput, ChimeClientResolvedConfig> {
    readonly input: ValidateE911AddressCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: ValidateE911AddressCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ValidateE911AddressCommandInput, ValidateE911AddressCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
