import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  AwsAuthInputConfig,
  AwsAuthResolvedConfig,
} from "@aws-sdk/middleware-signing";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import { Credentials as __Credentials } from "@aws-sdk/types";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandler as __HttpHandler } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  AssociatePhoneNumbersWithVoiceConnectorCommandInput,
  AssociatePhoneNumbersWithVoiceConnectorCommandOutput,
} from "./commands/AssociatePhoneNumbersWithVoiceConnectorCommand";
import {
  AssociatePhoneNumbersWithVoiceConnectorGroupCommandInput,
  AssociatePhoneNumbersWithVoiceConnectorGroupCommandOutput,
} from "./commands/AssociatePhoneNumbersWithVoiceConnectorGroupCommand";
import {
  AssociatePhoneNumberWithUserCommandInput,
  AssociatePhoneNumberWithUserCommandOutput,
} from "./commands/AssociatePhoneNumberWithUserCommand";
import {
  AssociateSigninDelegateGroupsWithAccountCommandInput,
  AssociateSigninDelegateGroupsWithAccountCommandOutput,
} from "./commands/AssociateSigninDelegateGroupsWithAccountCommand";
import {
  BatchCreateAttendeeCommandInput,
  BatchCreateAttendeeCommandOutput,
} from "./commands/BatchCreateAttendeeCommand";
import {
  BatchCreateChannelMembershipCommandInput,
  BatchCreateChannelMembershipCommandOutput,
} from "./commands/BatchCreateChannelMembershipCommand";
import {
  BatchCreateRoomMembershipCommandInput,
  BatchCreateRoomMembershipCommandOutput,
} from "./commands/BatchCreateRoomMembershipCommand";
import {
  BatchDeletePhoneNumberCommandInput,
  BatchDeletePhoneNumberCommandOutput,
} from "./commands/BatchDeletePhoneNumberCommand";
import {
  BatchSuspendUserCommandInput,
  BatchSuspendUserCommandOutput,
} from "./commands/BatchSuspendUserCommand";
import {
  BatchUnsuspendUserCommandInput,
  BatchUnsuspendUserCommandOutput,
} from "./commands/BatchUnsuspendUserCommand";
import {
  BatchUpdatePhoneNumberCommandInput,
  BatchUpdatePhoneNumberCommandOutput,
} from "./commands/BatchUpdatePhoneNumberCommand";
import {
  BatchUpdateUserCommandInput,
  BatchUpdateUserCommandOutput,
} from "./commands/BatchUpdateUserCommand";
import {
  CreateAccountCommandInput,
  CreateAccountCommandOutput,
} from "./commands/CreateAccountCommand";
import {
  CreateAppInstanceAdminCommandInput,
  CreateAppInstanceAdminCommandOutput,
} from "./commands/CreateAppInstanceAdminCommand";
import {
  CreateAppInstanceCommandInput,
  CreateAppInstanceCommandOutput,
} from "./commands/CreateAppInstanceCommand";
import {
  CreateAppInstanceUserCommandInput,
  CreateAppInstanceUserCommandOutput,
} from "./commands/CreateAppInstanceUserCommand";
import {
  CreateAttendeeCommandInput,
  CreateAttendeeCommandOutput,
} from "./commands/CreateAttendeeCommand";
import {
  CreateBotCommandInput,
  CreateBotCommandOutput,
} from "./commands/CreateBotCommand";
import {
  CreateChannelBanCommandInput,
  CreateChannelBanCommandOutput,
} from "./commands/CreateChannelBanCommand";
import {
  CreateChannelCommandInput,
  CreateChannelCommandOutput,
} from "./commands/CreateChannelCommand";
import {
  CreateChannelMembershipCommandInput,
  CreateChannelMembershipCommandOutput,
} from "./commands/CreateChannelMembershipCommand";
import {
  CreateChannelModeratorCommandInput,
  CreateChannelModeratorCommandOutput,
} from "./commands/CreateChannelModeratorCommand";
import {
  CreateMediaCapturePipelineCommandInput,
  CreateMediaCapturePipelineCommandOutput,
} from "./commands/CreateMediaCapturePipelineCommand";
import {
  CreateMeetingCommandInput,
  CreateMeetingCommandOutput,
} from "./commands/CreateMeetingCommand";
import {
  CreateMeetingDialOutCommandInput,
  CreateMeetingDialOutCommandOutput,
} from "./commands/CreateMeetingDialOutCommand";
import {
  CreateMeetingWithAttendeesCommandInput,
  CreateMeetingWithAttendeesCommandOutput,
} from "./commands/CreateMeetingWithAttendeesCommand";
import {
  CreatePhoneNumberOrderCommandInput,
  CreatePhoneNumberOrderCommandOutput,
} from "./commands/CreatePhoneNumberOrderCommand";
import {
  CreateProxySessionCommandInput,
  CreateProxySessionCommandOutput,
} from "./commands/CreateProxySessionCommand";
import {
  CreateRoomCommandInput,
  CreateRoomCommandOutput,
} from "./commands/CreateRoomCommand";
import {
  CreateRoomMembershipCommandInput,
  CreateRoomMembershipCommandOutput,
} from "./commands/CreateRoomMembershipCommand";
import {
  CreateSipMediaApplicationCallCommandInput,
  CreateSipMediaApplicationCallCommandOutput,
} from "./commands/CreateSipMediaApplicationCallCommand";
import {
  CreateSipMediaApplicationCommandInput,
  CreateSipMediaApplicationCommandOutput,
} from "./commands/CreateSipMediaApplicationCommand";
import {
  CreateSipRuleCommandInput,
  CreateSipRuleCommandOutput,
} from "./commands/CreateSipRuleCommand";
import {
  CreateUserCommandInput,
  CreateUserCommandOutput,
} from "./commands/CreateUserCommand";
import {
  CreateVoiceConnectorCommandInput,
  CreateVoiceConnectorCommandOutput,
} from "./commands/CreateVoiceConnectorCommand";
import {
  CreateVoiceConnectorGroupCommandInput,
  CreateVoiceConnectorGroupCommandOutput,
} from "./commands/CreateVoiceConnectorGroupCommand";
import {
  DeleteAccountCommandInput,
  DeleteAccountCommandOutput,
} from "./commands/DeleteAccountCommand";
import {
  DeleteAppInstanceAdminCommandInput,
  DeleteAppInstanceAdminCommandOutput,
} from "./commands/DeleteAppInstanceAdminCommand";
import {
  DeleteAppInstanceCommandInput,
  DeleteAppInstanceCommandOutput,
} from "./commands/DeleteAppInstanceCommand";
import {
  DeleteAppInstanceStreamingConfigurationsCommandInput,
  DeleteAppInstanceStreamingConfigurationsCommandOutput,
} from "./commands/DeleteAppInstanceStreamingConfigurationsCommand";
import {
  DeleteAppInstanceUserCommandInput,
  DeleteAppInstanceUserCommandOutput,
} from "./commands/DeleteAppInstanceUserCommand";
import {
  DeleteAttendeeCommandInput,
  DeleteAttendeeCommandOutput,
} from "./commands/DeleteAttendeeCommand";
import {
  DeleteChannelBanCommandInput,
  DeleteChannelBanCommandOutput,
} from "./commands/DeleteChannelBanCommand";
import {
  DeleteChannelCommandInput,
  DeleteChannelCommandOutput,
} from "./commands/DeleteChannelCommand";
import {
  DeleteChannelMembershipCommandInput,
  DeleteChannelMembershipCommandOutput,
} from "./commands/DeleteChannelMembershipCommand";
import {
  DeleteChannelMessageCommandInput,
  DeleteChannelMessageCommandOutput,
} from "./commands/DeleteChannelMessageCommand";
import {
  DeleteChannelModeratorCommandInput,
  DeleteChannelModeratorCommandOutput,
} from "./commands/DeleteChannelModeratorCommand";
import {
  DeleteEventsConfigurationCommandInput,
  DeleteEventsConfigurationCommandOutput,
} from "./commands/DeleteEventsConfigurationCommand";
import {
  DeleteMediaCapturePipelineCommandInput,
  DeleteMediaCapturePipelineCommandOutput,
} from "./commands/DeleteMediaCapturePipelineCommand";
import {
  DeleteMeetingCommandInput,
  DeleteMeetingCommandOutput,
} from "./commands/DeleteMeetingCommand";
import {
  DeletePhoneNumberCommandInput,
  DeletePhoneNumberCommandOutput,
} from "./commands/DeletePhoneNumberCommand";
import {
  DeleteProxySessionCommandInput,
  DeleteProxySessionCommandOutput,
} from "./commands/DeleteProxySessionCommand";
import {
  DeleteRoomCommandInput,
  DeleteRoomCommandOutput,
} from "./commands/DeleteRoomCommand";
import {
  DeleteRoomMembershipCommandInput,
  DeleteRoomMembershipCommandOutput,
} from "./commands/DeleteRoomMembershipCommand";
import {
  DeleteSipMediaApplicationCommandInput,
  DeleteSipMediaApplicationCommandOutput,
} from "./commands/DeleteSipMediaApplicationCommand";
import {
  DeleteSipRuleCommandInput,
  DeleteSipRuleCommandOutput,
} from "./commands/DeleteSipRuleCommand";
import {
  DeleteVoiceConnectorCommandInput,
  DeleteVoiceConnectorCommandOutput,
} from "./commands/DeleteVoiceConnectorCommand";
import {
  DeleteVoiceConnectorEmergencyCallingConfigurationCommandInput,
  DeleteVoiceConnectorEmergencyCallingConfigurationCommandOutput,
} from "./commands/DeleteVoiceConnectorEmergencyCallingConfigurationCommand";
import {
  DeleteVoiceConnectorGroupCommandInput,
  DeleteVoiceConnectorGroupCommandOutput,
} from "./commands/DeleteVoiceConnectorGroupCommand";
import {
  DeleteVoiceConnectorOriginationCommandInput,
  DeleteVoiceConnectorOriginationCommandOutput,
} from "./commands/DeleteVoiceConnectorOriginationCommand";
import {
  DeleteVoiceConnectorProxyCommandInput,
  DeleteVoiceConnectorProxyCommandOutput,
} from "./commands/DeleteVoiceConnectorProxyCommand";
import {
  DeleteVoiceConnectorStreamingConfigurationCommandInput,
  DeleteVoiceConnectorStreamingConfigurationCommandOutput,
} from "./commands/DeleteVoiceConnectorStreamingConfigurationCommand";
import {
  DeleteVoiceConnectorTerminationCommandInput,
  DeleteVoiceConnectorTerminationCommandOutput,
} from "./commands/DeleteVoiceConnectorTerminationCommand";
import {
  DeleteVoiceConnectorTerminationCredentialsCommandInput,
  DeleteVoiceConnectorTerminationCredentialsCommandOutput,
} from "./commands/DeleteVoiceConnectorTerminationCredentialsCommand";
import {
  DescribeAppInstanceAdminCommandInput,
  DescribeAppInstanceAdminCommandOutput,
} from "./commands/DescribeAppInstanceAdminCommand";
import {
  DescribeAppInstanceCommandInput,
  DescribeAppInstanceCommandOutput,
} from "./commands/DescribeAppInstanceCommand";
import {
  DescribeAppInstanceUserCommandInput,
  DescribeAppInstanceUserCommandOutput,
} from "./commands/DescribeAppInstanceUserCommand";
import {
  DescribeChannelBanCommandInput,
  DescribeChannelBanCommandOutput,
} from "./commands/DescribeChannelBanCommand";
import {
  DescribeChannelCommandInput,
  DescribeChannelCommandOutput,
} from "./commands/DescribeChannelCommand";
import {
  DescribeChannelMembershipCommandInput,
  DescribeChannelMembershipCommandOutput,
} from "./commands/DescribeChannelMembershipCommand";
import {
  DescribeChannelMembershipForAppInstanceUserCommandInput,
  DescribeChannelMembershipForAppInstanceUserCommandOutput,
} from "./commands/DescribeChannelMembershipForAppInstanceUserCommand";
import {
  DescribeChannelModeratedByAppInstanceUserCommandInput,
  DescribeChannelModeratedByAppInstanceUserCommandOutput,
} from "./commands/DescribeChannelModeratedByAppInstanceUserCommand";
import {
  DescribeChannelModeratorCommandInput,
  DescribeChannelModeratorCommandOutput,
} from "./commands/DescribeChannelModeratorCommand";
import {
  DisassociatePhoneNumberFromUserCommandInput,
  DisassociatePhoneNumberFromUserCommandOutput,
} from "./commands/DisassociatePhoneNumberFromUserCommand";
import {
  DisassociatePhoneNumbersFromVoiceConnectorCommandInput,
  DisassociatePhoneNumbersFromVoiceConnectorCommandOutput,
} from "./commands/DisassociatePhoneNumbersFromVoiceConnectorCommand";
import {
  DisassociatePhoneNumbersFromVoiceConnectorGroupCommandInput,
  DisassociatePhoneNumbersFromVoiceConnectorGroupCommandOutput,
} from "./commands/DisassociatePhoneNumbersFromVoiceConnectorGroupCommand";
import {
  DisassociateSigninDelegateGroupsFromAccountCommandInput,
  DisassociateSigninDelegateGroupsFromAccountCommandOutput,
} from "./commands/DisassociateSigninDelegateGroupsFromAccountCommand";
import {
  GetAccountCommandInput,
  GetAccountCommandOutput,
} from "./commands/GetAccountCommand";
import {
  GetAccountSettingsCommandInput,
  GetAccountSettingsCommandOutput,
} from "./commands/GetAccountSettingsCommand";
import {
  GetAppInstanceRetentionSettingsCommandInput,
  GetAppInstanceRetentionSettingsCommandOutput,
} from "./commands/GetAppInstanceRetentionSettingsCommand";
import {
  GetAppInstanceStreamingConfigurationsCommandInput,
  GetAppInstanceStreamingConfigurationsCommandOutput,
} from "./commands/GetAppInstanceStreamingConfigurationsCommand";
import {
  GetAttendeeCommandInput,
  GetAttendeeCommandOutput,
} from "./commands/GetAttendeeCommand";
import {
  GetBotCommandInput,
  GetBotCommandOutput,
} from "./commands/GetBotCommand";
import {
  GetChannelMessageCommandInput,
  GetChannelMessageCommandOutput,
} from "./commands/GetChannelMessageCommand";
import {
  GetEventsConfigurationCommandInput,
  GetEventsConfigurationCommandOutput,
} from "./commands/GetEventsConfigurationCommand";
import {
  GetGlobalSettingsCommandInput,
  GetGlobalSettingsCommandOutput,
} from "./commands/GetGlobalSettingsCommand";
import {
  GetMediaCapturePipelineCommandInput,
  GetMediaCapturePipelineCommandOutput,
} from "./commands/GetMediaCapturePipelineCommand";
import {
  GetMeetingCommandInput,
  GetMeetingCommandOutput,
} from "./commands/GetMeetingCommand";
import {
  GetMessagingSessionEndpointCommandInput,
  GetMessagingSessionEndpointCommandOutput,
} from "./commands/GetMessagingSessionEndpointCommand";
import {
  GetPhoneNumberCommandInput,
  GetPhoneNumberCommandOutput,
} from "./commands/GetPhoneNumberCommand";
import {
  GetPhoneNumberOrderCommandInput,
  GetPhoneNumberOrderCommandOutput,
} from "./commands/GetPhoneNumberOrderCommand";
import {
  GetPhoneNumberSettingsCommandInput,
  GetPhoneNumberSettingsCommandOutput,
} from "./commands/GetPhoneNumberSettingsCommand";
import {
  GetProxySessionCommandInput,
  GetProxySessionCommandOutput,
} from "./commands/GetProxySessionCommand";
import {
  GetRetentionSettingsCommandInput,
  GetRetentionSettingsCommandOutput,
} from "./commands/GetRetentionSettingsCommand";
import {
  GetRoomCommandInput,
  GetRoomCommandOutput,
} from "./commands/GetRoomCommand";
import {
  GetSipMediaApplicationCommandInput,
  GetSipMediaApplicationCommandOutput,
} from "./commands/GetSipMediaApplicationCommand";
import {
  GetSipMediaApplicationLoggingConfigurationCommandInput,
  GetSipMediaApplicationLoggingConfigurationCommandOutput,
} from "./commands/GetSipMediaApplicationLoggingConfigurationCommand";
import {
  GetSipRuleCommandInput,
  GetSipRuleCommandOutput,
} from "./commands/GetSipRuleCommand";
import {
  GetUserCommandInput,
  GetUserCommandOutput,
} from "./commands/GetUserCommand";
import {
  GetUserSettingsCommandInput,
  GetUserSettingsCommandOutput,
} from "./commands/GetUserSettingsCommand";
import {
  GetVoiceConnectorCommandInput,
  GetVoiceConnectorCommandOutput,
} from "./commands/GetVoiceConnectorCommand";
import {
  GetVoiceConnectorEmergencyCallingConfigurationCommandInput,
  GetVoiceConnectorEmergencyCallingConfigurationCommandOutput,
} from "./commands/GetVoiceConnectorEmergencyCallingConfigurationCommand";
import {
  GetVoiceConnectorGroupCommandInput,
  GetVoiceConnectorGroupCommandOutput,
} from "./commands/GetVoiceConnectorGroupCommand";
import {
  GetVoiceConnectorLoggingConfigurationCommandInput,
  GetVoiceConnectorLoggingConfigurationCommandOutput,
} from "./commands/GetVoiceConnectorLoggingConfigurationCommand";
import {
  GetVoiceConnectorOriginationCommandInput,
  GetVoiceConnectorOriginationCommandOutput,
} from "./commands/GetVoiceConnectorOriginationCommand";
import {
  GetVoiceConnectorProxyCommandInput,
  GetVoiceConnectorProxyCommandOutput,
} from "./commands/GetVoiceConnectorProxyCommand";
import {
  GetVoiceConnectorStreamingConfigurationCommandInput,
  GetVoiceConnectorStreamingConfigurationCommandOutput,
} from "./commands/GetVoiceConnectorStreamingConfigurationCommand";
import {
  GetVoiceConnectorTerminationCommandInput,
  GetVoiceConnectorTerminationCommandOutput,
} from "./commands/GetVoiceConnectorTerminationCommand";
import {
  GetVoiceConnectorTerminationHealthCommandInput,
  GetVoiceConnectorTerminationHealthCommandOutput,
} from "./commands/GetVoiceConnectorTerminationHealthCommand";
import {
  InviteUsersCommandInput,
  InviteUsersCommandOutput,
} from "./commands/InviteUsersCommand";
import {
  ListAccountsCommandInput,
  ListAccountsCommandOutput,
} from "./commands/ListAccountsCommand";
import {
  ListAppInstanceAdminsCommandInput,
  ListAppInstanceAdminsCommandOutput,
} from "./commands/ListAppInstanceAdminsCommand";
import {
  ListAppInstancesCommandInput,
  ListAppInstancesCommandOutput,
} from "./commands/ListAppInstancesCommand";
import {
  ListAppInstanceUsersCommandInput,
  ListAppInstanceUsersCommandOutput,
} from "./commands/ListAppInstanceUsersCommand";
import {
  ListAttendeesCommandInput,
  ListAttendeesCommandOutput,
} from "./commands/ListAttendeesCommand";
import {
  ListAttendeeTagsCommandInput,
  ListAttendeeTagsCommandOutput,
} from "./commands/ListAttendeeTagsCommand";
import {
  ListBotsCommandInput,
  ListBotsCommandOutput,
} from "./commands/ListBotsCommand";
import {
  ListChannelBansCommandInput,
  ListChannelBansCommandOutput,
} from "./commands/ListChannelBansCommand";
import {
  ListChannelMembershipsCommandInput,
  ListChannelMembershipsCommandOutput,
} from "./commands/ListChannelMembershipsCommand";
import {
  ListChannelMembershipsForAppInstanceUserCommandInput,
  ListChannelMembershipsForAppInstanceUserCommandOutput,
} from "./commands/ListChannelMembershipsForAppInstanceUserCommand";
import {
  ListChannelMessagesCommandInput,
  ListChannelMessagesCommandOutput,
} from "./commands/ListChannelMessagesCommand";
import {
  ListChannelModeratorsCommandInput,
  ListChannelModeratorsCommandOutput,
} from "./commands/ListChannelModeratorsCommand";
import {
  ListChannelsCommandInput,
  ListChannelsCommandOutput,
} from "./commands/ListChannelsCommand";
import {
  ListChannelsModeratedByAppInstanceUserCommandInput,
  ListChannelsModeratedByAppInstanceUserCommandOutput,
} from "./commands/ListChannelsModeratedByAppInstanceUserCommand";
import {
  ListMediaCapturePipelinesCommandInput,
  ListMediaCapturePipelinesCommandOutput,
} from "./commands/ListMediaCapturePipelinesCommand";
import {
  ListMeetingsCommandInput,
  ListMeetingsCommandOutput,
} from "./commands/ListMeetingsCommand";
import {
  ListMeetingTagsCommandInput,
  ListMeetingTagsCommandOutput,
} from "./commands/ListMeetingTagsCommand";
import {
  ListPhoneNumberOrdersCommandInput,
  ListPhoneNumberOrdersCommandOutput,
} from "./commands/ListPhoneNumberOrdersCommand";
import {
  ListPhoneNumbersCommandInput,
  ListPhoneNumbersCommandOutput,
} from "./commands/ListPhoneNumbersCommand";
import {
  ListProxySessionsCommandInput,
  ListProxySessionsCommandOutput,
} from "./commands/ListProxySessionsCommand";
import {
  ListRoomMembershipsCommandInput,
  ListRoomMembershipsCommandOutput,
} from "./commands/ListRoomMembershipsCommand";
import {
  ListRoomsCommandInput,
  ListRoomsCommandOutput,
} from "./commands/ListRoomsCommand";
import {
  ListSipMediaApplicationsCommandInput,
  ListSipMediaApplicationsCommandOutput,
} from "./commands/ListSipMediaApplicationsCommand";
import {
  ListSipRulesCommandInput,
  ListSipRulesCommandOutput,
} from "./commands/ListSipRulesCommand";
import {
  ListSupportedPhoneNumberCountriesCommandInput,
  ListSupportedPhoneNumberCountriesCommandOutput,
} from "./commands/ListSupportedPhoneNumberCountriesCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ListUsersCommandInput,
  ListUsersCommandOutput,
} from "./commands/ListUsersCommand";
import {
  ListVoiceConnectorGroupsCommandInput,
  ListVoiceConnectorGroupsCommandOutput,
} from "./commands/ListVoiceConnectorGroupsCommand";
import {
  ListVoiceConnectorsCommandInput,
  ListVoiceConnectorsCommandOutput,
} from "./commands/ListVoiceConnectorsCommand";
import {
  ListVoiceConnectorTerminationCredentialsCommandInput,
  ListVoiceConnectorTerminationCredentialsCommandOutput,
} from "./commands/ListVoiceConnectorTerminationCredentialsCommand";
import {
  LogoutUserCommandInput,
  LogoutUserCommandOutput,
} from "./commands/LogoutUserCommand";
import {
  PutAppInstanceRetentionSettingsCommandInput,
  PutAppInstanceRetentionSettingsCommandOutput,
} from "./commands/PutAppInstanceRetentionSettingsCommand";
import {
  PutAppInstanceStreamingConfigurationsCommandInput,
  PutAppInstanceStreamingConfigurationsCommandOutput,
} from "./commands/PutAppInstanceStreamingConfigurationsCommand";
import {
  PutEventsConfigurationCommandInput,
  PutEventsConfigurationCommandOutput,
} from "./commands/PutEventsConfigurationCommand";
import {
  PutRetentionSettingsCommandInput,
  PutRetentionSettingsCommandOutput,
} from "./commands/PutRetentionSettingsCommand";
import {
  PutSipMediaApplicationLoggingConfigurationCommandInput,
  PutSipMediaApplicationLoggingConfigurationCommandOutput,
} from "./commands/PutSipMediaApplicationLoggingConfigurationCommand";
import {
  PutVoiceConnectorEmergencyCallingConfigurationCommandInput,
  PutVoiceConnectorEmergencyCallingConfigurationCommandOutput,
} from "./commands/PutVoiceConnectorEmergencyCallingConfigurationCommand";
import {
  PutVoiceConnectorLoggingConfigurationCommandInput,
  PutVoiceConnectorLoggingConfigurationCommandOutput,
} from "./commands/PutVoiceConnectorLoggingConfigurationCommand";
import {
  PutVoiceConnectorOriginationCommandInput,
  PutVoiceConnectorOriginationCommandOutput,
} from "./commands/PutVoiceConnectorOriginationCommand";
import {
  PutVoiceConnectorProxyCommandInput,
  PutVoiceConnectorProxyCommandOutput,
} from "./commands/PutVoiceConnectorProxyCommand";
import {
  PutVoiceConnectorStreamingConfigurationCommandInput,
  PutVoiceConnectorStreamingConfigurationCommandOutput,
} from "./commands/PutVoiceConnectorStreamingConfigurationCommand";
import {
  PutVoiceConnectorTerminationCommandInput,
  PutVoiceConnectorTerminationCommandOutput,
} from "./commands/PutVoiceConnectorTerminationCommand";
import {
  PutVoiceConnectorTerminationCredentialsCommandInput,
  PutVoiceConnectorTerminationCredentialsCommandOutput,
} from "./commands/PutVoiceConnectorTerminationCredentialsCommand";
import {
  RedactChannelMessageCommandInput,
  RedactChannelMessageCommandOutput,
} from "./commands/RedactChannelMessageCommand";
import {
  RedactConversationMessageCommandInput,
  RedactConversationMessageCommandOutput,
} from "./commands/RedactConversationMessageCommand";
import {
  RedactRoomMessageCommandInput,
  RedactRoomMessageCommandOutput,
} from "./commands/RedactRoomMessageCommand";
import {
  RegenerateSecurityTokenCommandInput,
  RegenerateSecurityTokenCommandOutput,
} from "./commands/RegenerateSecurityTokenCommand";
import {
  ResetPersonalPINCommandInput,
  ResetPersonalPINCommandOutput,
} from "./commands/ResetPersonalPINCommand";
import {
  RestorePhoneNumberCommandInput,
  RestorePhoneNumberCommandOutput,
} from "./commands/RestorePhoneNumberCommand";
import {
  SearchAvailablePhoneNumbersCommandInput,
  SearchAvailablePhoneNumbersCommandOutput,
} from "./commands/SearchAvailablePhoneNumbersCommand";
import {
  SendChannelMessageCommandInput,
  SendChannelMessageCommandOutput,
} from "./commands/SendChannelMessageCommand";
import {
  StartMeetingTranscriptionCommandInput,
  StartMeetingTranscriptionCommandOutput,
} from "./commands/StartMeetingTranscriptionCommand";
import {
  StopMeetingTranscriptionCommandInput,
  StopMeetingTranscriptionCommandOutput,
} from "./commands/StopMeetingTranscriptionCommand";
import {
  TagAttendeeCommandInput,
  TagAttendeeCommandOutput,
} from "./commands/TagAttendeeCommand";
import {
  TagMeetingCommandInput,
  TagMeetingCommandOutput,
} from "./commands/TagMeetingCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagAttendeeCommandInput,
  UntagAttendeeCommandOutput,
} from "./commands/UntagAttendeeCommand";
import {
  UntagMeetingCommandInput,
  UntagMeetingCommandOutput,
} from "./commands/UntagMeetingCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateAccountCommandInput,
  UpdateAccountCommandOutput,
} from "./commands/UpdateAccountCommand";
import {
  UpdateAccountSettingsCommandInput,
  UpdateAccountSettingsCommandOutput,
} from "./commands/UpdateAccountSettingsCommand";
import {
  UpdateAppInstanceCommandInput,
  UpdateAppInstanceCommandOutput,
} from "./commands/UpdateAppInstanceCommand";
import {
  UpdateAppInstanceUserCommandInput,
  UpdateAppInstanceUserCommandOutput,
} from "./commands/UpdateAppInstanceUserCommand";
import {
  UpdateBotCommandInput,
  UpdateBotCommandOutput,
} from "./commands/UpdateBotCommand";
import {
  UpdateChannelCommandInput,
  UpdateChannelCommandOutput,
} from "./commands/UpdateChannelCommand";
import {
  UpdateChannelMessageCommandInput,
  UpdateChannelMessageCommandOutput,
} from "./commands/UpdateChannelMessageCommand";
import {
  UpdateChannelReadMarkerCommandInput,
  UpdateChannelReadMarkerCommandOutput,
} from "./commands/UpdateChannelReadMarkerCommand";
import {
  UpdateGlobalSettingsCommandInput,
  UpdateGlobalSettingsCommandOutput,
} from "./commands/UpdateGlobalSettingsCommand";
import {
  UpdatePhoneNumberCommandInput,
  UpdatePhoneNumberCommandOutput,
} from "./commands/UpdatePhoneNumberCommand";
import {
  UpdatePhoneNumberSettingsCommandInput,
  UpdatePhoneNumberSettingsCommandOutput,
} from "./commands/UpdatePhoneNumberSettingsCommand";
import {
  UpdateProxySessionCommandInput,
  UpdateProxySessionCommandOutput,
} from "./commands/UpdateProxySessionCommand";
import {
  UpdateRoomCommandInput,
  UpdateRoomCommandOutput,
} from "./commands/UpdateRoomCommand";
import {
  UpdateRoomMembershipCommandInput,
  UpdateRoomMembershipCommandOutput,
} from "./commands/UpdateRoomMembershipCommand";
import {
  UpdateSipMediaApplicationCallCommandInput,
  UpdateSipMediaApplicationCallCommandOutput,
} from "./commands/UpdateSipMediaApplicationCallCommand";
import {
  UpdateSipMediaApplicationCommandInput,
  UpdateSipMediaApplicationCommandOutput,
} from "./commands/UpdateSipMediaApplicationCommand";
import {
  UpdateSipRuleCommandInput,
  UpdateSipRuleCommandOutput,
} from "./commands/UpdateSipRuleCommand";
import {
  UpdateUserCommandInput,
  UpdateUserCommandOutput,
} from "./commands/UpdateUserCommand";
import {
  UpdateUserSettingsCommandInput,
  UpdateUserSettingsCommandOutput,
} from "./commands/UpdateUserSettingsCommand";
import {
  UpdateVoiceConnectorCommandInput,
  UpdateVoiceConnectorCommandOutput,
} from "./commands/UpdateVoiceConnectorCommand";
import {
  UpdateVoiceConnectorGroupCommandInput,
  UpdateVoiceConnectorGroupCommandOutput,
} from "./commands/UpdateVoiceConnectorGroupCommand";
import {
  ValidateE911AddressCommandInput,
  ValidateE911AddressCommandOutput,
} from "./commands/ValidateE911AddressCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
export { __Client };
export type ServiceInputTypes =
  | AssociatePhoneNumberWithUserCommandInput
  | AssociatePhoneNumbersWithVoiceConnectorCommandInput
  | AssociatePhoneNumbersWithVoiceConnectorGroupCommandInput
  | AssociateSigninDelegateGroupsWithAccountCommandInput
  | BatchCreateAttendeeCommandInput
  | BatchCreateChannelMembershipCommandInput
  | BatchCreateRoomMembershipCommandInput
  | BatchDeletePhoneNumberCommandInput
  | BatchSuspendUserCommandInput
  | BatchUnsuspendUserCommandInput
  | BatchUpdatePhoneNumberCommandInput
  | BatchUpdateUserCommandInput
  | CreateAccountCommandInput
  | CreateAppInstanceAdminCommandInput
  | CreateAppInstanceCommandInput
  | CreateAppInstanceUserCommandInput
  | CreateAttendeeCommandInput
  | CreateBotCommandInput
  | CreateChannelBanCommandInput
  | CreateChannelCommandInput
  | CreateChannelMembershipCommandInput
  | CreateChannelModeratorCommandInput
  | CreateMediaCapturePipelineCommandInput
  | CreateMeetingCommandInput
  | CreateMeetingDialOutCommandInput
  | CreateMeetingWithAttendeesCommandInput
  | CreatePhoneNumberOrderCommandInput
  | CreateProxySessionCommandInput
  | CreateRoomCommandInput
  | CreateRoomMembershipCommandInput
  | CreateSipMediaApplicationCallCommandInput
  | CreateSipMediaApplicationCommandInput
  | CreateSipRuleCommandInput
  | CreateUserCommandInput
  | CreateVoiceConnectorCommandInput
  | CreateVoiceConnectorGroupCommandInput
  | DeleteAccountCommandInput
  | DeleteAppInstanceAdminCommandInput
  | DeleteAppInstanceCommandInput
  | DeleteAppInstanceStreamingConfigurationsCommandInput
  | DeleteAppInstanceUserCommandInput
  | DeleteAttendeeCommandInput
  | DeleteChannelBanCommandInput
  | DeleteChannelCommandInput
  | DeleteChannelMembershipCommandInput
  | DeleteChannelMessageCommandInput
  | DeleteChannelModeratorCommandInput
  | DeleteEventsConfigurationCommandInput
  | DeleteMediaCapturePipelineCommandInput
  | DeleteMeetingCommandInput
  | DeletePhoneNumberCommandInput
  | DeleteProxySessionCommandInput
  | DeleteRoomCommandInput
  | DeleteRoomMembershipCommandInput
  | DeleteSipMediaApplicationCommandInput
  | DeleteSipRuleCommandInput
  | DeleteVoiceConnectorCommandInput
  | DeleteVoiceConnectorEmergencyCallingConfigurationCommandInput
  | DeleteVoiceConnectorGroupCommandInput
  | DeleteVoiceConnectorOriginationCommandInput
  | DeleteVoiceConnectorProxyCommandInput
  | DeleteVoiceConnectorStreamingConfigurationCommandInput
  | DeleteVoiceConnectorTerminationCommandInput
  | DeleteVoiceConnectorTerminationCredentialsCommandInput
  | DescribeAppInstanceAdminCommandInput
  | DescribeAppInstanceCommandInput
  | DescribeAppInstanceUserCommandInput
  | DescribeChannelBanCommandInput
  | DescribeChannelCommandInput
  | DescribeChannelMembershipCommandInput
  | DescribeChannelMembershipForAppInstanceUserCommandInput
  | DescribeChannelModeratedByAppInstanceUserCommandInput
  | DescribeChannelModeratorCommandInput
  | DisassociatePhoneNumberFromUserCommandInput
  | DisassociatePhoneNumbersFromVoiceConnectorCommandInput
  | DisassociatePhoneNumbersFromVoiceConnectorGroupCommandInput
  | DisassociateSigninDelegateGroupsFromAccountCommandInput
  | GetAccountCommandInput
  | GetAccountSettingsCommandInput
  | GetAppInstanceRetentionSettingsCommandInput
  | GetAppInstanceStreamingConfigurationsCommandInput
  | GetAttendeeCommandInput
  | GetBotCommandInput
  | GetChannelMessageCommandInput
  | GetEventsConfigurationCommandInput
  | GetGlobalSettingsCommandInput
  | GetMediaCapturePipelineCommandInput
  | GetMeetingCommandInput
  | GetMessagingSessionEndpointCommandInput
  | GetPhoneNumberCommandInput
  | GetPhoneNumberOrderCommandInput
  | GetPhoneNumberSettingsCommandInput
  | GetProxySessionCommandInput
  | GetRetentionSettingsCommandInput
  | GetRoomCommandInput
  | GetSipMediaApplicationCommandInput
  | GetSipMediaApplicationLoggingConfigurationCommandInput
  | GetSipRuleCommandInput
  | GetUserCommandInput
  | GetUserSettingsCommandInput
  | GetVoiceConnectorCommandInput
  | GetVoiceConnectorEmergencyCallingConfigurationCommandInput
  | GetVoiceConnectorGroupCommandInput
  | GetVoiceConnectorLoggingConfigurationCommandInput
  | GetVoiceConnectorOriginationCommandInput
  | GetVoiceConnectorProxyCommandInput
  | GetVoiceConnectorStreamingConfigurationCommandInput
  | GetVoiceConnectorTerminationCommandInput
  | GetVoiceConnectorTerminationHealthCommandInput
  | InviteUsersCommandInput
  | ListAccountsCommandInput
  | ListAppInstanceAdminsCommandInput
  | ListAppInstanceUsersCommandInput
  | ListAppInstancesCommandInput
  | ListAttendeeTagsCommandInput
  | ListAttendeesCommandInput
  | ListBotsCommandInput
  | ListChannelBansCommandInput
  | ListChannelMembershipsCommandInput
  | ListChannelMembershipsForAppInstanceUserCommandInput
  | ListChannelMessagesCommandInput
  | ListChannelModeratorsCommandInput
  | ListChannelsCommandInput
  | ListChannelsModeratedByAppInstanceUserCommandInput
  | ListMediaCapturePipelinesCommandInput
  | ListMeetingTagsCommandInput
  | ListMeetingsCommandInput
  | ListPhoneNumberOrdersCommandInput
  | ListPhoneNumbersCommandInput
  | ListProxySessionsCommandInput
  | ListRoomMembershipsCommandInput
  | ListRoomsCommandInput
  | ListSipMediaApplicationsCommandInput
  | ListSipRulesCommandInput
  | ListSupportedPhoneNumberCountriesCommandInput
  | ListTagsForResourceCommandInput
  | ListUsersCommandInput
  | ListVoiceConnectorGroupsCommandInput
  | ListVoiceConnectorTerminationCredentialsCommandInput
  | ListVoiceConnectorsCommandInput
  | LogoutUserCommandInput
  | PutAppInstanceRetentionSettingsCommandInput
  | PutAppInstanceStreamingConfigurationsCommandInput
  | PutEventsConfigurationCommandInput
  | PutRetentionSettingsCommandInput
  | PutSipMediaApplicationLoggingConfigurationCommandInput
  | PutVoiceConnectorEmergencyCallingConfigurationCommandInput
  | PutVoiceConnectorLoggingConfigurationCommandInput
  | PutVoiceConnectorOriginationCommandInput
  | PutVoiceConnectorProxyCommandInput
  | PutVoiceConnectorStreamingConfigurationCommandInput
  | PutVoiceConnectorTerminationCommandInput
  | PutVoiceConnectorTerminationCredentialsCommandInput
  | RedactChannelMessageCommandInput
  | RedactConversationMessageCommandInput
  | RedactRoomMessageCommandInput
  | RegenerateSecurityTokenCommandInput
  | ResetPersonalPINCommandInput
  | RestorePhoneNumberCommandInput
  | SearchAvailablePhoneNumbersCommandInput
  | SendChannelMessageCommandInput
  | StartMeetingTranscriptionCommandInput
  | StopMeetingTranscriptionCommandInput
  | TagAttendeeCommandInput
  | TagMeetingCommandInput
  | TagResourceCommandInput
  | UntagAttendeeCommandInput
  | UntagMeetingCommandInput
  | UntagResourceCommandInput
  | UpdateAccountCommandInput
  | UpdateAccountSettingsCommandInput
  | UpdateAppInstanceCommandInput
  | UpdateAppInstanceUserCommandInput
  | UpdateBotCommandInput
  | UpdateChannelCommandInput
  | UpdateChannelMessageCommandInput
  | UpdateChannelReadMarkerCommandInput
  | UpdateGlobalSettingsCommandInput
  | UpdatePhoneNumberCommandInput
  | UpdatePhoneNumberSettingsCommandInput
  | UpdateProxySessionCommandInput
  | UpdateRoomCommandInput
  | UpdateRoomMembershipCommandInput
  | UpdateSipMediaApplicationCallCommandInput
  | UpdateSipMediaApplicationCommandInput
  | UpdateSipRuleCommandInput
  | UpdateUserCommandInput
  | UpdateUserSettingsCommandInput
  | UpdateVoiceConnectorCommandInput
  | UpdateVoiceConnectorGroupCommandInput
  | ValidateE911AddressCommandInput;
export type ServiceOutputTypes =
  | AssociatePhoneNumberWithUserCommandOutput
  | AssociatePhoneNumbersWithVoiceConnectorCommandOutput
  | AssociatePhoneNumbersWithVoiceConnectorGroupCommandOutput
  | AssociateSigninDelegateGroupsWithAccountCommandOutput
  | BatchCreateAttendeeCommandOutput
  | BatchCreateChannelMembershipCommandOutput
  | BatchCreateRoomMembershipCommandOutput
  | BatchDeletePhoneNumberCommandOutput
  | BatchSuspendUserCommandOutput
  | BatchUnsuspendUserCommandOutput
  | BatchUpdatePhoneNumberCommandOutput
  | BatchUpdateUserCommandOutput
  | CreateAccountCommandOutput
  | CreateAppInstanceAdminCommandOutput
  | CreateAppInstanceCommandOutput
  | CreateAppInstanceUserCommandOutput
  | CreateAttendeeCommandOutput
  | CreateBotCommandOutput
  | CreateChannelBanCommandOutput
  | CreateChannelCommandOutput
  | CreateChannelMembershipCommandOutput
  | CreateChannelModeratorCommandOutput
  | CreateMediaCapturePipelineCommandOutput
  | CreateMeetingCommandOutput
  | CreateMeetingDialOutCommandOutput
  | CreateMeetingWithAttendeesCommandOutput
  | CreatePhoneNumberOrderCommandOutput
  | CreateProxySessionCommandOutput
  | CreateRoomCommandOutput
  | CreateRoomMembershipCommandOutput
  | CreateSipMediaApplicationCallCommandOutput
  | CreateSipMediaApplicationCommandOutput
  | CreateSipRuleCommandOutput
  | CreateUserCommandOutput
  | CreateVoiceConnectorCommandOutput
  | CreateVoiceConnectorGroupCommandOutput
  | DeleteAccountCommandOutput
  | DeleteAppInstanceAdminCommandOutput
  | DeleteAppInstanceCommandOutput
  | DeleteAppInstanceStreamingConfigurationsCommandOutput
  | DeleteAppInstanceUserCommandOutput
  | DeleteAttendeeCommandOutput
  | DeleteChannelBanCommandOutput
  | DeleteChannelCommandOutput
  | DeleteChannelMembershipCommandOutput
  | DeleteChannelMessageCommandOutput
  | DeleteChannelModeratorCommandOutput
  | DeleteEventsConfigurationCommandOutput
  | DeleteMediaCapturePipelineCommandOutput
  | DeleteMeetingCommandOutput
  | DeletePhoneNumberCommandOutput
  | DeleteProxySessionCommandOutput
  | DeleteRoomCommandOutput
  | DeleteRoomMembershipCommandOutput
  | DeleteSipMediaApplicationCommandOutput
  | DeleteSipRuleCommandOutput
  | DeleteVoiceConnectorCommandOutput
  | DeleteVoiceConnectorEmergencyCallingConfigurationCommandOutput
  | DeleteVoiceConnectorGroupCommandOutput
  | DeleteVoiceConnectorOriginationCommandOutput
  | DeleteVoiceConnectorProxyCommandOutput
  | DeleteVoiceConnectorStreamingConfigurationCommandOutput
  | DeleteVoiceConnectorTerminationCommandOutput
  | DeleteVoiceConnectorTerminationCredentialsCommandOutput
  | DescribeAppInstanceAdminCommandOutput
  | DescribeAppInstanceCommandOutput
  | DescribeAppInstanceUserCommandOutput
  | DescribeChannelBanCommandOutput
  | DescribeChannelCommandOutput
  | DescribeChannelMembershipCommandOutput
  | DescribeChannelMembershipForAppInstanceUserCommandOutput
  | DescribeChannelModeratedByAppInstanceUserCommandOutput
  | DescribeChannelModeratorCommandOutput
  | DisassociatePhoneNumberFromUserCommandOutput
  | DisassociatePhoneNumbersFromVoiceConnectorCommandOutput
  | DisassociatePhoneNumbersFromVoiceConnectorGroupCommandOutput
  | DisassociateSigninDelegateGroupsFromAccountCommandOutput
  | GetAccountCommandOutput
  | GetAccountSettingsCommandOutput
  | GetAppInstanceRetentionSettingsCommandOutput
  | GetAppInstanceStreamingConfigurationsCommandOutput
  | GetAttendeeCommandOutput
  | GetBotCommandOutput
  | GetChannelMessageCommandOutput
  | GetEventsConfigurationCommandOutput
  | GetGlobalSettingsCommandOutput
  | GetMediaCapturePipelineCommandOutput
  | GetMeetingCommandOutput
  | GetMessagingSessionEndpointCommandOutput
  | GetPhoneNumberCommandOutput
  | GetPhoneNumberOrderCommandOutput
  | GetPhoneNumberSettingsCommandOutput
  | GetProxySessionCommandOutput
  | GetRetentionSettingsCommandOutput
  | GetRoomCommandOutput
  | GetSipMediaApplicationCommandOutput
  | GetSipMediaApplicationLoggingConfigurationCommandOutput
  | GetSipRuleCommandOutput
  | GetUserCommandOutput
  | GetUserSettingsCommandOutput
  | GetVoiceConnectorCommandOutput
  | GetVoiceConnectorEmergencyCallingConfigurationCommandOutput
  | GetVoiceConnectorGroupCommandOutput
  | GetVoiceConnectorLoggingConfigurationCommandOutput
  | GetVoiceConnectorOriginationCommandOutput
  | GetVoiceConnectorProxyCommandOutput
  | GetVoiceConnectorStreamingConfigurationCommandOutput
  | GetVoiceConnectorTerminationCommandOutput
  | GetVoiceConnectorTerminationHealthCommandOutput
  | InviteUsersCommandOutput
  | ListAccountsCommandOutput
  | ListAppInstanceAdminsCommandOutput
  | ListAppInstanceUsersCommandOutput
  | ListAppInstancesCommandOutput
  | ListAttendeeTagsCommandOutput
  | ListAttendeesCommandOutput
  | ListBotsCommandOutput
  | ListChannelBansCommandOutput
  | ListChannelMembershipsCommandOutput
  | ListChannelMembershipsForAppInstanceUserCommandOutput
  | ListChannelMessagesCommandOutput
  | ListChannelModeratorsCommandOutput
  | ListChannelsCommandOutput
  | ListChannelsModeratedByAppInstanceUserCommandOutput
  | ListMediaCapturePipelinesCommandOutput
  | ListMeetingTagsCommandOutput
  | ListMeetingsCommandOutput
  | ListPhoneNumberOrdersCommandOutput
  | ListPhoneNumbersCommandOutput
  | ListProxySessionsCommandOutput
  | ListRoomMembershipsCommandOutput
  | ListRoomsCommandOutput
  | ListSipMediaApplicationsCommandOutput
  | ListSipRulesCommandOutput
  | ListSupportedPhoneNumberCountriesCommandOutput
  | ListTagsForResourceCommandOutput
  | ListUsersCommandOutput
  | ListVoiceConnectorGroupsCommandOutput
  | ListVoiceConnectorTerminationCredentialsCommandOutput
  | ListVoiceConnectorsCommandOutput
  | LogoutUserCommandOutput
  | PutAppInstanceRetentionSettingsCommandOutput
  | PutAppInstanceStreamingConfigurationsCommandOutput
  | PutEventsConfigurationCommandOutput
  | PutRetentionSettingsCommandOutput
  | PutSipMediaApplicationLoggingConfigurationCommandOutput
  | PutVoiceConnectorEmergencyCallingConfigurationCommandOutput
  | PutVoiceConnectorLoggingConfigurationCommandOutput
  | PutVoiceConnectorOriginationCommandOutput
  | PutVoiceConnectorProxyCommandOutput
  | PutVoiceConnectorStreamingConfigurationCommandOutput
  | PutVoiceConnectorTerminationCommandOutput
  | PutVoiceConnectorTerminationCredentialsCommandOutput
  | RedactChannelMessageCommandOutput
  | RedactConversationMessageCommandOutput
  | RedactRoomMessageCommandOutput
  | RegenerateSecurityTokenCommandOutput
  | ResetPersonalPINCommandOutput
  | RestorePhoneNumberCommandOutput
  | SearchAvailablePhoneNumbersCommandOutput
  | SendChannelMessageCommandOutput
  | StartMeetingTranscriptionCommandOutput
  | StopMeetingTranscriptionCommandOutput
  | TagAttendeeCommandOutput
  | TagMeetingCommandOutput
  | TagResourceCommandOutput
  | UntagAttendeeCommandOutput
  | UntagMeetingCommandOutput
  | UntagResourceCommandOutput
  | UpdateAccountCommandOutput
  | UpdateAccountSettingsCommandOutput
  | UpdateAppInstanceCommandOutput
  | UpdateAppInstanceUserCommandOutput
  | UpdateBotCommandOutput
  | UpdateChannelCommandOutput
  | UpdateChannelMessageCommandOutput
  | UpdateChannelReadMarkerCommandOutput
  | UpdateGlobalSettingsCommandOutput
  | UpdatePhoneNumberCommandOutput
  | UpdatePhoneNumberSettingsCommandOutput
  | UpdateProxySessionCommandOutput
  | UpdateRoomCommandOutput
  | UpdateRoomMembershipCommandOutput
  | UpdateSipMediaApplicationCallCommandOutput
  | UpdateSipMediaApplicationCommandOutput
  | UpdateSipRuleCommandOutput
  | UpdateUserCommandOutput
  | UpdateUserSettingsCommandOutput
  | UpdateVoiceConnectorCommandOutput
  | UpdateVoiceConnectorGroupCommandOutput
  | ValidateE911AddressCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyResolvedConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandler;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  credentialDefaultProvider?: (input: any) => __Provider<__Credentials>;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type ChimeClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  RegionInputConfig &
  EndpointInputConfig<EndpointParameters> &
  RetryInputConfig &
  HostHeaderInputConfig &
  AwsAuthInputConfig &
  UserAgentInputConfig &
  ClientInputEndpointParameters;
export interface ChimeClientConfig extends ChimeClientConfigType {}
export type ChimeClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RegionResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    RetryResolvedConfig &
    HostHeaderResolvedConfig &
    AwsAuthResolvedConfig &
    UserAgentResolvedConfig &
    ClientResolvedEndpointParameters;
export interface ChimeClientResolvedConfig
  extends ChimeClientResolvedConfigType {}
export declare class ChimeClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  ChimeClientResolvedConfig
> {
  readonly config: ChimeClientResolvedConfig;
  constructor(
    ...[configuration]: __CheckOptionalClientConfig<ChimeClientConfig>
  );
  destroy(): void;
}
