import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { ChimeServiceException as __BaseException } from "./ChimeServiceException";
export declare const ErrorCode: {
  readonly AccessDenied: "AccessDenied";
  readonly BadRequest: "BadRequest";
  readonly Conflict: "Conflict";
  readonly Forbidden: "Forbidden";
  readonly NotFound: "NotFound";
  readonly PhoneNumberAssociationsExist: "PhoneNumberAssociationsExist";
  readonly PreconditionFailed: "PreconditionFailed";
  readonly ResourceLimitExceeded: "ResourceLimitExceeded";
  readonly ServiceFailure: "ServiceFailure";
  readonly ServiceUnavailable: "ServiceUnavailable";
  readonly Throttled: "Throttled";
  readonly Throttling: "Throttling";
  readonly Unauthorized: "Unauthorized";
  readonly Unprocessable: "Unprocessable";
  readonly VoiceConnectorGroupAssociationsExist: "VoiceConnectorGroupAssociationsExist";
};
export type ErrorCode = (typeof ErrorCode)[keyof typeof ErrorCode];
export declare class AccessDeniedException extends __BaseException {
  readonly name: "AccessDeniedException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<AccessDeniedException, __BaseException>
  );
}
export declare const AccountStatus: {
  readonly Active: "Active";
  readonly Suspended: "Suspended";
};
export type AccountStatus = (typeof AccountStatus)[keyof typeof AccountStatus];
export declare const AccountType: {
  readonly EnterpriseDirectory: "EnterpriseDirectory";
  readonly EnterpriseLWA: "EnterpriseLWA";
  readonly EnterpriseOIDC: "EnterpriseOIDC";
  readonly Team: "Team";
};
export type AccountType = (typeof AccountType)[keyof typeof AccountType];
export declare const License: {
  readonly Basic: "Basic";
  readonly Plus: "Plus";
  readonly Pro: "Pro";
  readonly ProTrial: "ProTrial";
};
export type License = (typeof License)[keyof typeof License];
export interface SigninDelegateGroup {
  GroupName?: string;
}
export interface Account {
  AwsAccountId: string | undefined;
  AccountId: string | undefined;
  Name: string | undefined;
  AccountType?: AccountType | string;
  CreatedTimestamp?: Date;
  DefaultLicense?: License | string;
  SupportedLicenses?: (License | string)[];
  AccountStatus?: AccountStatus | string;
  SigninDelegateGroups?: SigninDelegateGroup[];
}
export interface AccountSettings {
  DisableRemoteControl?: boolean;
  EnableDialOut?: boolean;
}
export interface Address {
  streetName?: string;
  streetSuffix?: string;
  postDirectional?: string;
  preDirectional?: string;
  streetNumber?: string;
  city?: string;
  state?: string;
  postalCode?: string;
  postalCodePlus4?: string;
  country?: string;
}
export interface AlexaForBusinessMetadata {
  IsAlexaForBusinessEnabled?: boolean;
  AlexaForBusinessRoomArn?: string;
}
export interface AppInstance {
  AppInstanceArn?: string;
  Name?: string;
  Metadata?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
}
export interface Identity {
  Arn?: string;
  Name?: string;
}
export interface AppInstanceAdmin {
  Admin?: Identity;
  AppInstanceArn?: string;
  CreatedTimestamp?: Date;
}
export interface AppInstanceAdminSummary {
  Admin?: Identity;
}
export declare const AppInstanceDataType: {
  readonly Channel: "Channel";
  readonly ChannelMessage: "ChannelMessage";
};
export type AppInstanceDataType =
  (typeof AppInstanceDataType)[keyof typeof AppInstanceDataType];
export interface AppInstanceSummary {
  AppInstanceArn?: string;
  Name?: string;
  Metadata?: string;
}
export interface ChannelRetentionSettings {
  RetentionDays?: number;
}
export interface AppInstanceRetentionSettings {
  ChannelRetentionSettings?: ChannelRetentionSettings;
}
export interface AppInstanceStreamingConfiguration {
  AppInstanceDataType: AppInstanceDataType | string | undefined;
  ResourceArn: string | undefined;
}
export interface AppInstanceUser {
  AppInstanceUserArn?: string;
  Name?: string;
  CreatedTimestamp?: Date;
  Metadata?: string;
  LastUpdatedTimestamp?: Date;
}
export interface AppInstanceUserSummary {
  AppInstanceUserArn?: string;
  Name?: string;
  Metadata?: string;
}
export declare const ChannelMembershipType: {
  readonly DEFAULT: "DEFAULT";
  readonly HIDDEN: "HIDDEN";
};
export type ChannelMembershipType =
  (typeof ChannelMembershipType)[keyof typeof ChannelMembershipType];
export interface AppInstanceUserMembershipSummary {
  Type?: ChannelMembershipType | string;
  ReadMarkerTimestamp?: Date;
}
export declare const AudioMuxType: {
  readonly AudioOnly: "AudioOnly";
  readonly AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo";
};
export type AudioMuxType = (typeof AudioMuxType)[keyof typeof AudioMuxType];
export interface AudioArtifactsConfiguration {
  MuxType: AudioMuxType | string | undefined;
}
export declare const ContentMuxType: {
  readonly ContentOnly: "ContentOnly";
};
export type ContentMuxType =
  (typeof ContentMuxType)[keyof typeof ContentMuxType];
export declare const ArtifactsState: {
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
};
export type ArtifactsState =
  (typeof ArtifactsState)[keyof typeof ArtifactsState];
export interface ContentArtifactsConfiguration {
  State: ArtifactsState | string | undefined;
  MuxType?: ContentMuxType | string;
}
export declare const VideoMuxType: {
  readonly VideoOnly: "VideoOnly";
};
export type VideoMuxType = (typeof VideoMuxType)[keyof typeof VideoMuxType];
export interface VideoArtifactsConfiguration {
  State: ArtifactsState | string | undefined;
  MuxType?: VideoMuxType | string;
}
export interface ArtifactsConfiguration {
  Audio: AudioArtifactsConfiguration | undefined;
  Video: VideoArtifactsConfiguration | undefined;
  Content: ContentArtifactsConfiguration | undefined;
}
export interface AssociatePhoneNumbersWithVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
  ForceAssociate?: boolean;
}
export interface PhoneNumberError {
  PhoneNumberId?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface AssociatePhoneNumbersWithVoiceConnectorResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export declare class BadRequestException extends __BaseException {
  readonly name: "BadRequestException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<BadRequestException, __BaseException>
  );
}
export declare class ForbiddenException extends __BaseException {
  readonly name: "ForbiddenException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export declare class ServiceFailureException extends __BaseException {
  readonly name: "ServiceFailureException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceFailureException, __BaseException>
  );
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export declare class ThrottledClientException extends __BaseException {
  readonly name: "ThrottledClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ThrottledClientException, __BaseException>
  );
}
export declare class UnauthorizedClientException extends __BaseException {
  readonly name: "UnauthorizedClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>
  );
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
  ForceAssociate?: boolean;
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface AssociatePhoneNumberWithUserRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
  E164PhoneNumber: string | undefined;
}
export interface AssociatePhoneNumberWithUserResponse {}
export interface AssociateSigninDelegateGroupsWithAccountRequest {
  AccountId: string | undefined;
  SigninDelegateGroups: SigninDelegateGroup[] | undefined;
}
export interface AssociateSigninDelegateGroupsWithAccountResponse {}
export interface Attendee {
  ExternalUserId?: string;
  AttendeeId?: string;
  JoinToken?: string;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface BatchChannelMemberships {
  InvitedBy?: Identity;
  Type?: ChannelMembershipType | string;
  Members?: Identity[];
  ChannelArn?: string;
}
export interface CreateAttendeeRequestItem {
  ExternalUserId: string | undefined;
  Tags?: Tag[];
}
export interface BatchCreateAttendeeRequest {
  MeetingId: string | undefined;
  Attendees: CreateAttendeeRequestItem[] | undefined;
}
export interface CreateAttendeeError {
  ExternalUserId?: string;
  ErrorCode?: string;
  ErrorMessage?: string;
}
export interface BatchCreateAttendeeResponse {
  Attendees?: Attendee[];
  Errors?: CreateAttendeeError[];
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export interface BatchCreateChannelMembershipRequest {
  ChannelArn: string | undefined;
  Type?: ChannelMembershipType | string;
  MemberArns: string[] | undefined;
  ChimeBearer?: string;
}
export interface BatchCreateChannelMembershipError {
  MemberArn?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface BatchCreateChannelMembershipResponse {
  BatchChannelMemberships?: BatchChannelMemberships;
  Errors?: BatchCreateChannelMembershipError[];
}
export declare const RoomMembershipRole: {
  readonly Administrator: "Administrator";
  readonly Member: "Member";
};
export type RoomMembershipRole =
  (typeof RoomMembershipRole)[keyof typeof RoomMembershipRole];
export interface MembershipItem {
  MemberId?: string;
  Role?: RoomMembershipRole | string;
}
export interface BatchCreateRoomMembershipRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MembershipItemList: MembershipItem[] | undefined;
}
export interface MemberError {
  MemberId?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface BatchCreateRoomMembershipResponse {
  Errors?: MemberError[];
}
export interface BatchDeletePhoneNumberRequest {
  PhoneNumberIds: string[] | undefined;
}
export interface BatchDeletePhoneNumberResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface BatchSuspendUserRequest {
  AccountId: string | undefined;
  UserIdList: string[] | undefined;
}
export interface UserError {
  UserId?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface BatchSuspendUserResponse {
  UserErrors?: UserError[];
}
export interface BatchUnsuspendUserRequest {
  AccountId: string | undefined;
  UserIdList: string[] | undefined;
}
export interface BatchUnsuspendUserResponse {
  UserErrors?: UserError[];
}
export declare const PhoneNumberProductType: {
  readonly BusinessCalling: "BusinessCalling";
  readonly SipMediaApplicationDialIn: "SipMediaApplicationDialIn";
  readonly VoiceConnector: "VoiceConnector";
};
export type PhoneNumberProductType =
  (typeof PhoneNumberProductType)[keyof typeof PhoneNumberProductType];
export interface UpdatePhoneNumberRequestItem {
  PhoneNumberId: string | undefined;
  ProductType?: PhoneNumberProductType | string;
  CallingName?: string;
}
export interface BatchUpdatePhoneNumberRequest {
  UpdatePhoneNumberRequestItems: UpdatePhoneNumberRequestItem[] | undefined;
}
export interface BatchUpdatePhoneNumberResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export declare const UserType: {
  readonly PrivateUser: "PrivateUser";
  readonly SharedDevice: "SharedDevice";
};
export type UserType = (typeof UserType)[keyof typeof UserType];
export interface UpdateUserRequestItem {
  UserId: string | undefined;
  LicenseType?: License | string;
  UserType?: UserType | string;
  AlexaForBusinessMetadata?: AlexaForBusinessMetadata;
}
export interface BatchUpdateUserRequest {
  AccountId: string | undefined;
  UpdateUserRequestItems: UpdateUserRequestItem[] | undefined;
}
export interface BatchUpdateUserResponse {
  UserErrors?: UserError[];
}
export declare const BotType: {
  readonly ChatBot: "ChatBot";
};
export type BotType = (typeof BotType)[keyof typeof BotType];
export interface Bot {
  BotId?: string;
  UserId?: string;
  DisplayName?: string;
  BotType?: BotType | string;
  Disabled?: boolean;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  BotEmail?: string;
  SecurityToken?: string;
}
export interface BusinessCallingSettings {
  CdrBucket?: string;
}
export declare const CallingNameStatus: {
  readonly Unassigned: "Unassigned";
  readonly UpdateFailed: "UpdateFailed";
  readonly UpdateInProgress: "UpdateInProgress";
  readonly UpdateSucceeded: "UpdateSucceeded";
};
export type CallingNameStatus =
  (typeof CallingNameStatus)[keyof typeof CallingNameStatus];
export interface CandidateAddress {
  streetInfo?: string;
  streetNumber?: string;
  city?: string;
  state?: string;
  postalCode?: string;
  postalCodePlus4?: string;
  country?: string;
}
export declare const Capability: {
  readonly SMS: "SMS";
  readonly Voice: "Voice";
};
export type Capability = (typeof Capability)[keyof typeof Capability];
export declare const ChannelMode: {
  readonly RESTRICTED: "RESTRICTED";
  readonly UNRESTRICTED: "UNRESTRICTED";
};
export type ChannelMode = (typeof ChannelMode)[keyof typeof ChannelMode];
export declare const ChannelPrivacy: {
  readonly PRIVATE: "PRIVATE";
  readonly PUBLIC: "PUBLIC";
};
export type ChannelPrivacy =
  (typeof ChannelPrivacy)[keyof typeof ChannelPrivacy];
export interface Channel {
  Name?: string;
  ChannelArn?: string;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  CreatedBy?: Identity;
  CreatedTimestamp?: Date;
  LastMessageTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
}
export interface ChannelBan {
  Member?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  CreatedBy?: Identity;
}
export interface ChannelBanSummary {
  Member?: Identity;
}
export interface ChannelMembership {
  InvitedBy?: Identity;
  Type?: ChannelMembershipType | string;
  Member?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
}
export interface ChannelSummary {
  Name?: string;
  ChannelArn?: string;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  LastMessageTimestamp?: Date;
}
export interface ChannelMembershipForAppInstanceUserSummary {
  ChannelSummary?: ChannelSummary;
  AppInstanceUserMembershipSummary?: AppInstanceUserMembershipSummary;
}
export interface ChannelMembershipSummary {
  Member?: Identity;
}
export declare const ChannelMessagePersistenceType: {
  readonly NON_PERSISTENT: "NON_PERSISTENT";
  readonly PERSISTENT: "PERSISTENT";
};
export type ChannelMessagePersistenceType =
  (typeof ChannelMessagePersistenceType)[keyof typeof ChannelMessagePersistenceType];
export declare const ChannelMessageType: {
  readonly CONTROL: "CONTROL";
  readonly STANDARD: "STANDARD";
};
export type ChannelMessageType =
  (typeof ChannelMessageType)[keyof typeof ChannelMessageType];
export interface ChannelMessage {
  ChannelArn?: string;
  MessageId?: string;
  Content?: string;
  Metadata?: string;
  Type?: ChannelMessageType | string;
  CreatedTimestamp?: Date;
  LastEditedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  Sender?: Identity;
  Redacted?: boolean;
  Persistence?: ChannelMessagePersistenceType | string;
}
export interface ChannelMessageSummary {
  MessageId?: string;
  Content?: string;
  Metadata?: string;
  Type?: ChannelMessageType | string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  LastEditedTimestamp?: Date;
  Sender?: Identity;
  Redacted?: boolean;
}
export interface ChannelModeratedByAppInstanceUserSummary {
  ChannelSummary?: ChannelSummary;
}
export interface ChannelModerator {
  Moderator?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  CreatedBy?: Identity;
}
export interface ChannelModeratorSummary {
  Moderator?: Identity;
}
export interface SelectedVideoStreams {
  AttendeeIds?: string[];
  ExternalUserIds?: string[];
}
export interface SourceConfiguration {
  SelectedVideoStreams?: SelectedVideoStreams;
}
export interface ChimeSdkMeetingConfiguration {
  SourceConfiguration?: SourceConfiguration;
  ArtifactsConfiguration?: ArtifactsConfiguration;
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface ConversationRetentionSettings {
  RetentionDays?: number;
}
export interface CreateAccountRequest {
  Name: string | undefined;
}
export interface CreateAccountResponse {
  Account?: Account;
}
export interface CreateAppInstanceRequest {
  Name: string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface CreateAppInstanceResponse {
  AppInstanceArn?: string;
}
export interface CreateAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface CreateAppInstanceAdminResponse {
  AppInstanceAdmin?: Identity;
  AppInstanceArn?: string;
}
export interface CreateAppInstanceUserRequest {
  AppInstanceArn: string | undefined;
  AppInstanceUserId: string | undefined;
  Name: string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface CreateAppInstanceUserResponse {
  AppInstanceUserArn?: string;
}
export interface CreateAttendeeRequest {
  MeetingId: string | undefined;
  ExternalUserId: string | undefined;
  Tags?: Tag[];
}
export interface CreateAttendeeResponse {
  Attendee?: Attendee;
}
export interface CreateBotRequest {
  AccountId: string | undefined;
  DisplayName: string | undefined;
  Domain?: string;
}
export interface CreateBotResponse {
  Bot?: Bot;
}
export interface CreateChannelRequest {
  AppInstanceArn: string | undefined;
  Name: string | undefined;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
  ChimeBearer?: string;
}
export interface CreateChannelResponse {
  ChannelArn?: string;
}
export interface CreateChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface CreateChannelBanResponse {
  ChannelArn?: string;
  Member?: Identity;
}
export interface CreateChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  Type: ChannelMembershipType | string | undefined;
  ChimeBearer?: string;
}
export interface CreateChannelMembershipResponse {
  ChannelArn?: string;
  Member?: Identity;
}
export interface CreateChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer?: string;
}
export interface CreateChannelModeratorResponse {
  ChannelArn?: string;
  ChannelModerator?: Identity;
}
export declare const MediaPipelineSinkType: {
  readonly S3Bucket: "S3Bucket";
};
export type MediaPipelineSinkType =
  (typeof MediaPipelineSinkType)[keyof typeof MediaPipelineSinkType];
export declare const MediaPipelineSourceType: {
  readonly ChimeSdkMeeting: "ChimeSdkMeeting";
};
export type MediaPipelineSourceType =
  (typeof MediaPipelineSourceType)[keyof typeof MediaPipelineSourceType];
export interface CreateMediaCapturePipelineRequest {
  SourceType: MediaPipelineSourceType | string | undefined;
  SourceArn: string | undefined;
  SinkType: MediaPipelineSinkType | string | undefined;
  SinkArn: string | undefined;
  ClientRequestToken?: string;
  ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
}
export declare const MediaPipelineStatus: {
  readonly Failed: "Failed";
  readonly InProgress: "InProgress";
  readonly Initializing: "Initializing";
  readonly Stopped: "Stopped";
  readonly Stopping: "Stopping";
};
export type MediaPipelineStatus =
  (typeof MediaPipelineStatus)[keyof typeof MediaPipelineStatus];
export interface MediaCapturePipeline {
  MediaPipelineId?: string;
  SourceType?: MediaPipelineSourceType | string;
  SourceArn?: string;
  Status?: MediaPipelineStatus | string;
  SinkType?: MediaPipelineSinkType | string;
  SinkArn?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
}
export interface CreateMediaCapturePipelineResponse {
  MediaCapturePipeline?: MediaCapturePipeline;
}
export interface MeetingNotificationConfiguration {
  SnsTopicArn?: string;
  SqsQueueArn?: string;
}
export interface CreateMeetingRequest {
  ClientRequestToken?: string;
  ExternalMeetingId?: string;
  MeetingHostId?: string;
  MediaRegion?: string;
  Tags?: Tag[];
  NotificationsConfiguration?: MeetingNotificationConfiguration;
}
export interface MediaPlacement {
  AudioHostUrl?: string;
  AudioFallbackUrl?: string;
  ScreenDataUrl?: string;
  ScreenSharingUrl?: string;
  ScreenViewingUrl?: string;
  SignalingUrl?: string;
  TurnControlUrl?: string;
  EventIngestionUrl?: string;
}
export interface Meeting {
  MeetingId?: string;
  ExternalMeetingId?: string;
  MediaPlacement?: MediaPlacement;
  MediaRegion?: string;
}
export interface CreateMeetingResponse {
  Meeting?: Meeting;
}
export interface CreateMeetingDialOutRequest {
  MeetingId: string | undefined;
  FromPhoneNumber: string | undefined;
  ToPhoneNumber: string | undefined;
  JoinToken: string | undefined;
}
export interface CreateMeetingDialOutResponse {
  TransactionId?: string;
}
export interface CreateMeetingWithAttendeesRequest {
  ClientRequestToken?: string;
  ExternalMeetingId?: string;
  MeetingHostId?: string;
  MediaRegion?: string;
  Tags?: Tag[];
  NotificationsConfiguration?: MeetingNotificationConfiguration;
  Attendees?: CreateAttendeeRequestItem[];
}
export interface CreateMeetingWithAttendeesResponse {
  Meeting?: Meeting;
  Attendees?: Attendee[];
  Errors?: CreateAttendeeError[];
}
export interface CreatePhoneNumberOrderRequest {
  ProductType: PhoneNumberProductType | string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export declare const OrderedPhoneNumberStatus: {
  readonly Acquired: "Acquired";
  readonly Failed: "Failed";
  readonly Processing: "Processing";
};
export type OrderedPhoneNumberStatus =
  (typeof OrderedPhoneNumberStatus)[keyof typeof OrderedPhoneNumberStatus];
export interface OrderedPhoneNumber {
  E164PhoneNumber?: string;
  Status?: OrderedPhoneNumberStatus | string;
}
export declare const PhoneNumberOrderStatus: {
  readonly Failed: "Failed";
  readonly Partial: "Partial";
  readonly Processing: "Processing";
  readonly Successful: "Successful";
};
export type PhoneNumberOrderStatus =
  (typeof PhoneNumberOrderStatus)[keyof typeof PhoneNumberOrderStatus];
export interface PhoneNumberOrder {
  PhoneNumberOrderId?: string;
  ProductType?: PhoneNumberProductType | string;
  Status?: PhoneNumberOrderStatus | string;
  OrderedPhoneNumbers?: OrderedPhoneNumber[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreatePhoneNumberOrderResponse {
  PhoneNumberOrder?: PhoneNumberOrder;
}
export declare const GeoMatchLevel: {
  readonly AreaCode: "AreaCode";
  readonly Country: "Country";
};
export type GeoMatchLevel = (typeof GeoMatchLevel)[keyof typeof GeoMatchLevel];
export interface GeoMatchParams {
  Country: string | undefined;
  AreaCode: string | undefined;
}
export declare const NumberSelectionBehavior: {
  readonly AvoidSticky: "AvoidSticky";
  readonly PreferSticky: "PreferSticky";
};
export type NumberSelectionBehavior =
  (typeof NumberSelectionBehavior)[keyof typeof NumberSelectionBehavior];
export interface CreateProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ParticipantPhoneNumbers: string[] | undefined;
  Name?: string;
  ExpiryMinutes?: number;
  Capabilities: (Capability | string)[] | undefined;
  NumberSelectionBehavior?: NumberSelectionBehavior | string;
  GeoMatchLevel?: GeoMatchLevel | string;
  GeoMatchParams?: GeoMatchParams;
}
export interface Participant {
  PhoneNumber?: string;
  ProxyPhoneNumber?: string;
}
export declare const ProxySessionStatus: {
  readonly Closed: "Closed";
  readonly InProgress: "InProgress";
  readonly Open: "Open";
};
export type ProxySessionStatus =
  (typeof ProxySessionStatus)[keyof typeof ProxySessionStatus];
export interface ProxySession {
  VoiceConnectorId?: string;
  ProxySessionId?: string;
  Name?: string;
  Status?: ProxySessionStatus | string;
  ExpiryMinutes?: number;
  Capabilities?: (Capability | string)[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  EndedTimestamp?: Date;
  Participants?: Participant[];
  NumberSelectionBehavior?: NumberSelectionBehavior | string;
  GeoMatchLevel?: GeoMatchLevel | string;
  GeoMatchParams?: GeoMatchParams;
}
export interface CreateProxySessionResponse {
  ProxySession?: ProxySession;
}
export interface CreateRoomRequest {
  AccountId: string | undefined;
  Name: string | undefined;
  ClientRequestToken?: string;
}
export interface Room {
  RoomId?: string;
  Name?: string;
  AccountId?: string;
  CreatedBy?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateRoomResponse {
  Room?: Room;
}
export interface CreateRoomMembershipRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MemberId: string | undefined;
  Role?: RoomMembershipRole | string;
}
export declare const MemberType: {
  readonly Bot: "Bot";
  readonly User: "User";
  readonly Webhook: "Webhook";
};
export type MemberType = (typeof MemberType)[keyof typeof MemberType];
export interface Member {
  MemberId?: string;
  MemberType?: MemberType | string;
  Email?: string;
  FullName?: string;
  AccountId?: string;
}
export interface RoomMembership {
  RoomId?: string;
  Member?: Member;
  Role?: RoomMembershipRole | string;
  InvitedBy?: string;
  UpdatedTimestamp?: Date;
}
export interface CreateRoomMembershipResponse {
  RoomMembership?: RoomMembership;
}
export interface SipMediaApplicationEndpoint {
  LambdaArn?: string;
}
export interface CreateSipMediaApplicationRequest {
  AwsRegion: string | undefined;
  Name: string | undefined;
  Endpoints: SipMediaApplicationEndpoint[] | undefined;
}
export interface SipMediaApplication {
  SipMediaApplicationId?: string;
  AwsRegion?: string;
  Name?: string;
  Endpoints?: SipMediaApplicationEndpoint[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateSipMediaApplicationResponse {
  SipMediaApplication?: SipMediaApplication;
}
export interface CreateSipMediaApplicationCallRequest {
  FromPhoneNumber: string | undefined;
  ToPhoneNumber: string | undefined;
  SipMediaApplicationId: string | undefined;
  SipHeaders?: Record<string, string>;
}
export interface SipMediaApplicationCall {
  TransactionId?: string;
}
export interface CreateSipMediaApplicationCallResponse {
  SipMediaApplicationCall?: SipMediaApplicationCall;
}
export interface SipRuleTargetApplication {
  SipMediaApplicationId?: string;
  Priority?: number;
  AwsRegion?: string;
}
export declare const SipRuleTriggerType: {
  readonly RequestUriHostname: "RequestUriHostname";
  readonly ToPhoneNumber: "ToPhoneNumber";
};
export type SipRuleTriggerType =
  (typeof SipRuleTriggerType)[keyof typeof SipRuleTriggerType];
export interface CreateSipRuleRequest {
  Name: string | undefined;
  TriggerType: SipRuleTriggerType | string | undefined;
  TriggerValue: string | undefined;
  Disabled?: boolean;
  TargetApplications: SipRuleTargetApplication[] | undefined;
}
export interface SipRule {
  SipRuleId?: string;
  Name?: string;
  Disabled?: boolean;
  TriggerType?: SipRuleTriggerType | string;
  TriggerValue?: string;
  TargetApplications?: SipRuleTargetApplication[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateSipRuleResponse {
  SipRule?: SipRule;
}
export interface CreateUserRequest {
  AccountId: string | undefined;
  Username?: string;
  Email?: string;
  UserType?: UserType | string;
}
export declare const InviteStatus: {
  readonly Accepted: "Accepted";
  readonly Failed: "Failed";
  readonly Pending: "Pending";
};
export type InviteStatus = (typeof InviteStatus)[keyof typeof InviteStatus];
export declare const RegistrationStatus: {
  readonly Registered: "Registered";
  readonly Suspended: "Suspended";
  readonly Unregistered: "Unregistered";
};
export type RegistrationStatus =
  (typeof RegistrationStatus)[keyof typeof RegistrationStatus];
export interface User {
  UserId: string | undefined;
  AccountId?: string;
  PrimaryEmail?: string;
  PrimaryProvisionedNumber?: string;
  DisplayName?: string;
  LicenseType?: License | string;
  UserType?: UserType | string;
  UserRegistrationStatus?: RegistrationStatus | string;
  UserInvitationStatus?: InviteStatus | string;
  RegisteredOn?: Date;
  InvitedOn?: Date;
  AlexaForBusinessMetadata?: AlexaForBusinessMetadata;
  PersonalPIN?: string;
}
export interface CreateUserResponse {
  User?: User;
}
export declare const VoiceConnectorAwsRegion: {
  readonly US_EAST_1: "us-east-1";
  readonly US_WEST_2: "us-west-2";
};
export type VoiceConnectorAwsRegion =
  (typeof VoiceConnectorAwsRegion)[keyof typeof VoiceConnectorAwsRegion];
export interface CreateVoiceConnectorRequest {
  Name: string | undefined;
  AwsRegion?: VoiceConnectorAwsRegion | string;
  RequireEncryption: boolean | undefined;
}
export interface VoiceConnector {
  VoiceConnectorId?: string;
  AwsRegion?: VoiceConnectorAwsRegion | string;
  Name?: string;
  OutboundHostName?: string;
  RequireEncryption?: boolean;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  VoiceConnectorArn?: string;
}
export interface CreateVoiceConnectorResponse {
  VoiceConnector?: VoiceConnector;
}
export interface VoiceConnectorItem {
  VoiceConnectorId: string | undefined;
  Priority: number | undefined;
}
export interface CreateVoiceConnectorGroupRequest {
  Name: string | undefined;
  VoiceConnectorItems?: VoiceConnectorItem[];
}
export interface VoiceConnectorGroup {
  VoiceConnectorGroupId?: string;
  Name?: string;
  VoiceConnectorItems?: VoiceConnectorItem[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  VoiceConnectorGroupArn?: string;
}
export interface CreateVoiceConnectorGroupResponse {
  VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface Credential {
  Username?: string;
  Password?: string;
}
export interface DeleteAccountRequest {
  AccountId: string | undefined;
}
export interface DeleteAccountResponse {}
export declare class UnprocessableEntityException extends __BaseException {
  readonly name: "UnprocessableEntityException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnprocessableEntityException, __BaseException>
  );
}
export interface DeleteAppInstanceRequest {
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceStreamingConfigurationsRequest {
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
}
export interface DeleteAttendeeRequest {
  MeetingId: string | undefined;
  AttendeeId: string | undefined;
}
export interface DeleteChannelRequest {
  ChannelArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteEventsConfigurationRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
}
export interface DeleteMediaCapturePipelineRequest {
  MediaPipelineId: string | undefined;
}
export interface DeleteMeetingRequest {
  MeetingId: string | undefined;
}
export interface DeletePhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export interface DeleteProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
}
export interface DeleteRoomRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
}
export interface DeleteRoomMembershipRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MemberId: string | undefined;
}
export interface DeleteSipMediaApplicationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface DeleteSipRuleRequest {
  SipRuleId: string | undefined;
}
export interface DeleteVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
}
export interface DeleteVoiceConnectorOriginationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorProxyRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorStreamingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationCredentialsRequest {
  VoiceConnectorId: string | undefined;
  Usernames: string[] | undefined;
}
export interface DescribeAppInstanceRequest {
  AppInstanceArn: string | undefined;
}
export interface DescribeAppInstanceResponse {
  AppInstance?: AppInstance;
}
export interface DescribeAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface DescribeAppInstanceAdminResponse {
  AppInstanceAdmin?: AppInstanceAdmin;
}
export interface DescribeAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
}
export interface DescribeAppInstanceUserResponse {
  AppInstanceUser?: AppInstanceUser;
}
export interface DescribeChannelRequest {
  ChannelArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelResponse {
  Channel?: Channel;
}
export interface DescribeChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelBanResponse {
  ChannelBan?: ChannelBan;
}
export interface DescribeChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelMembershipResponse {
  ChannelMembership?: ChannelMembership;
}
export interface DescribeChannelMembershipForAppInstanceUserRequest {
  ChannelArn: string | undefined;
  AppInstanceUserArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelMembershipForAppInstanceUserResponse {
  ChannelMembership?: ChannelMembershipForAppInstanceUserSummary;
}
export interface DescribeChannelModeratedByAppInstanceUserRequest {
  ChannelArn: string | undefined;
  AppInstanceUserArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelModeratedByAppInstanceUserResponse {
  Channel?: ChannelModeratedByAppInstanceUserSummary;
}
export interface DescribeChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelModeratorResponse {
  ChannelModerator?: ChannelModerator;
}
export interface DisassociatePhoneNumberFromUserRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
}
export interface DisassociatePhoneNumberFromUserResponse {}
export interface DisassociatePhoneNumbersFromVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface DisassociateSigninDelegateGroupsFromAccountRequest {
  AccountId: string | undefined;
  GroupNames: string[] | undefined;
}
export interface DisassociateSigninDelegateGroupsFromAccountResponse {}
export interface DNISEmergencyCallingConfiguration {
  EmergencyPhoneNumber: string | undefined;
  TestPhoneNumber?: string;
  CallingCountry: string | undefined;
}
export declare const EmailStatus: {
  readonly Failed: "Failed";
  readonly NotSent: "NotSent";
  readonly Sent: "Sent";
};
export type EmailStatus = (typeof EmailStatus)[keyof typeof EmailStatus];
export interface EmergencyCallingConfiguration {
  DNIS?: DNISEmergencyCallingConfiguration[];
}
export declare const TranscribeMedicalContentIdentificationType: {
  readonly PHI: "PHI";
};
export type TranscribeMedicalContentIdentificationType =
  (typeof TranscribeMedicalContentIdentificationType)[keyof typeof TranscribeMedicalContentIdentificationType];
export declare const TranscribeMedicalLanguageCode: {
  readonly EN_US: "en-US";
};
export type TranscribeMedicalLanguageCode =
  (typeof TranscribeMedicalLanguageCode)[keyof typeof TranscribeMedicalLanguageCode];
export declare const TranscribeMedicalRegion: {
  readonly AP_SOUTHEAST_2: "ap-southeast-2";
  readonly AUTO: "auto";
  readonly CA_CENTRAL_1: "ca-central-1";
  readonly EU_WEST_1: "eu-west-1";
  readonly US_EAST_1: "us-east-1";
  readonly US_EAST_2: "us-east-2";
  readonly US_WEST_2: "us-west-2";
};
export type TranscribeMedicalRegion =
  (typeof TranscribeMedicalRegion)[keyof typeof TranscribeMedicalRegion];
export declare const TranscribeMedicalSpecialty: {
  readonly Cardiology: "CARDIOLOGY";
  readonly Neurology: "NEUROLOGY";
  readonly Oncology: "ONCOLOGY";
  readonly PrimaryCare: "PRIMARYCARE";
  readonly Radiology: "RADIOLOGY";
  readonly Urology: "UROLOGY";
};
export type TranscribeMedicalSpecialty =
  (typeof TranscribeMedicalSpecialty)[keyof typeof TranscribeMedicalSpecialty];
export declare const TranscribeMedicalType: {
  readonly Conversation: "CONVERSATION";
  readonly Dictation: "DICTATION";
};
export type TranscribeMedicalType =
  (typeof TranscribeMedicalType)[keyof typeof TranscribeMedicalType];
export interface EngineTranscribeMedicalSettings {
  LanguageCode: TranscribeMedicalLanguageCode | string | undefined;
  Specialty: TranscribeMedicalSpecialty | string | undefined;
  Type: TranscribeMedicalType | string | undefined;
  VocabularyName?: string;
  Region?: TranscribeMedicalRegion | string;
  ContentIdentificationType?:
    | TranscribeMedicalContentIdentificationType
    | string;
}
export declare const TranscribeContentIdentificationType: {
  readonly PII: "PII";
};
export type TranscribeContentIdentificationType =
  (typeof TranscribeContentIdentificationType)[keyof typeof TranscribeContentIdentificationType];
export declare const TranscribeContentRedactionType: {
  readonly PII: "PII";
};
export type TranscribeContentRedactionType =
  (typeof TranscribeContentRedactionType)[keyof typeof TranscribeContentRedactionType];
export declare const TranscribeLanguageCode: {
  readonly DE_DE: "de-DE";
  readonly EN_AU: "en-AU";
  readonly EN_GB: "en-GB";
  readonly EN_US: "en-US";
  readonly ES_US: "es-US";
  readonly FR_CA: "fr-CA";
  readonly FR_FR: "fr-FR";
  readonly HI_IN: "hi-IN";
  readonly IT_IT: "it-IT";
  readonly JA_JP: "ja-JP";
  readonly KO_KR: "ko-KR";
  readonly PT_BR: "pt-BR";
  readonly TH_TH: "th-TH";
  readonly ZH_CN: "zh-CN";
};
export type TranscribeLanguageCode =
  (typeof TranscribeLanguageCode)[keyof typeof TranscribeLanguageCode];
export declare const TranscribePartialResultsStability: {
  readonly HIGH: "high";
  readonly LOW: "low";
  readonly MEDIUM: "medium";
};
export type TranscribePartialResultsStability =
  (typeof TranscribePartialResultsStability)[keyof typeof TranscribePartialResultsStability];
export declare const TranscribeRegion: {
  readonly AP_NORTHEAST_1: "ap-northeast-1";
  readonly AP_NORTHEAST_2: "ap-northeast-2";
  readonly AP_SOUTHEAST_2: "ap-southeast-2";
  readonly AUTO: "auto";
  readonly CA_CENTRAL_1: "ca-central-1";
  readonly EU_CENTRAL_1: "eu-central-1";
  readonly EU_WEST_1: "eu-west-1";
  readonly EU_WEST_2: "eu-west-2";
  readonly SA_EAST_1: "sa-east-1";
  readonly US_EAST_1: "us-east-1";
  readonly US_EAST_2: "us-east-2";
  readonly US_WEST_2: "us-west-2";
};
export type TranscribeRegion =
  (typeof TranscribeRegion)[keyof typeof TranscribeRegion];
export declare const TranscribeVocabularyFilterMethod: {
  readonly Mask: "mask";
  readonly Remove: "remove";
  readonly Tag: "tag";
};
export type TranscribeVocabularyFilterMethod =
  (typeof TranscribeVocabularyFilterMethod)[keyof typeof TranscribeVocabularyFilterMethod];
export interface EngineTranscribeSettings {
  LanguageCode?: TranscribeLanguageCode | string;
  VocabularyFilterMethod?: TranscribeVocabularyFilterMethod | string;
  VocabularyFilterName?: string;
  VocabularyName?: string;
  Region?: TranscribeRegion | string;
  EnablePartialResultsStabilization?: boolean;
  PartialResultsStability?: TranscribePartialResultsStability | string;
  ContentIdentificationType?: TranscribeContentIdentificationType | string;
  ContentRedactionType?: TranscribeContentRedactionType | string;
  PiiEntityTypes?: string;
  LanguageModelName?: string;
  IdentifyLanguage?: boolean;
  LanguageOptions?: string;
  PreferredLanguage?: TranscribeLanguageCode | string;
  VocabularyNames?: string;
  VocabularyFilterNames?: string;
}
export interface EventsConfiguration {
  BotId?: string;
  OutboundEventsHTTPSEndpoint?: string;
  LambdaFunctionArn?: string;
}
export interface GetAccountRequest {
  AccountId: string | undefined;
}
export interface GetAccountResponse {
  Account?: Account;
}
export interface GetAccountSettingsRequest {
  AccountId: string | undefined;
}
export interface GetAccountSettingsResponse {
  AccountSettings?: AccountSettings;
}
export interface GetAppInstanceRetentionSettingsRequest {
  AppInstanceArn: string | undefined;
}
export interface GetAppInstanceRetentionSettingsResponse {
  AppInstanceRetentionSettings?: AppInstanceRetentionSettings;
  InitiateDeletionTimestamp?: Date;
}
export interface GetAppInstanceStreamingConfigurationsRequest {
  AppInstanceArn: string | undefined;
}
export interface GetAppInstanceStreamingConfigurationsResponse {
  AppInstanceStreamingConfigurations?: AppInstanceStreamingConfiguration[];
}
export interface GetAttendeeRequest {
  MeetingId: string | undefined;
  AttendeeId: string | undefined;
}
export interface GetAttendeeResponse {
  Attendee?: Attendee;
}
export interface GetBotRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
}
export interface GetBotResponse {
  Bot?: Bot;
}
export interface GetChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer?: string;
}
export interface GetChannelMessageResponse {
  ChannelMessage?: ChannelMessage;
}
export interface GetEventsConfigurationRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
}
export interface GetEventsConfigurationResponse {
  EventsConfiguration?: EventsConfiguration;
}
export interface VoiceConnectorSettings {
  CdrBucket?: string;
}
export interface GetGlobalSettingsResponse {
  BusinessCalling?: BusinessCallingSettings;
  VoiceConnector?: VoiceConnectorSettings;
}
export interface GetMediaCapturePipelineRequest {
  MediaPipelineId: string | undefined;
}
export interface GetMediaCapturePipelineResponse {
  MediaCapturePipeline?: MediaCapturePipeline;
}
export interface GetMeetingRequest {
  MeetingId: string | undefined;
}
export interface GetMeetingResponse {
  Meeting?: Meeting;
}
export interface GetMessagingSessionEndpointRequest {}
export interface MessagingSessionEndpoint {
  Url?: string;
}
export interface GetMessagingSessionEndpointResponse {
  Endpoint?: MessagingSessionEndpoint;
}
export interface GetPhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export declare const PhoneNumberAssociationName: {
  readonly AccountId: "AccountId";
  readonly SipRuleId: "SipRuleId";
  readonly UserId: "UserId";
  readonly VoiceConnectorGroupId: "VoiceConnectorGroupId";
  readonly VoiceConnectorId: "VoiceConnectorId";
};
export type PhoneNumberAssociationName =
  (typeof PhoneNumberAssociationName)[keyof typeof PhoneNumberAssociationName];
export interface PhoneNumberAssociation {
  Value?: string;
  Name?: PhoneNumberAssociationName | string;
  AssociatedTimestamp?: Date;
}
export interface PhoneNumberCapabilities {
  InboundCall?: boolean;
  OutboundCall?: boolean;
  InboundSMS?: boolean;
  OutboundSMS?: boolean;
  InboundMMS?: boolean;
  OutboundMMS?: boolean;
}
export declare const PhoneNumberStatus: {
  readonly AcquireFailed: "AcquireFailed";
  readonly AcquireInProgress: "AcquireInProgress";
  readonly Assigned: "Assigned";
  readonly DeleteFailed: "DeleteFailed";
  readonly DeleteInProgress: "DeleteInProgress";
  readonly ReleaseFailed: "ReleaseFailed";
  readonly ReleaseInProgress: "ReleaseInProgress";
  readonly Unassigned: "Unassigned";
};
export type PhoneNumberStatus =
  (typeof PhoneNumberStatus)[keyof typeof PhoneNumberStatus];
export declare const PhoneNumberType: {
  readonly Local: "Local";
  readonly TollFree: "TollFree";
};
export type PhoneNumberType =
  (typeof PhoneNumberType)[keyof typeof PhoneNumberType];
export interface PhoneNumber {
  PhoneNumberId?: string;
  E164PhoneNumber?: string;
  Country?: string;
  Type?: PhoneNumberType | string;
  ProductType?: PhoneNumberProductType | string;
  Status?: PhoneNumberStatus | string;
  Capabilities?: PhoneNumberCapabilities;
  Associations?: PhoneNumberAssociation[];
  CallingName?: string;
  CallingNameStatus?: CallingNameStatus | string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  DeletionTimestamp?: Date;
}
export interface GetPhoneNumberResponse {
  PhoneNumber?: PhoneNumber;
}
export interface GetPhoneNumberOrderRequest {
  PhoneNumberOrderId: string | undefined;
}
export interface GetPhoneNumberOrderResponse {
  PhoneNumberOrder?: PhoneNumberOrder;
}
export interface GetPhoneNumberSettingsResponse {
  CallingName?: string;
  CallingNameUpdatedTimestamp?: Date;
}
export interface GetProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
}
export interface GetProxySessionResponse {
  ProxySession?: ProxySession;
}
export interface GetRetentionSettingsRequest {
  AccountId: string | undefined;
}
export declare const AddressFilterSensitiveLog: (obj: Address) => any;
export declare const AlexaForBusinessMetadataFilterSensitiveLog: (
  obj: AlexaForBusinessMetadata
) => any;
export declare const AppInstanceFilterSensitiveLog: (obj: AppInstance) => any;
export declare const IdentityFilterSensitiveLog: (obj: Identity) => any;
export declare const AppInstanceAdminFilterSensitiveLog: (
  obj: AppInstanceAdmin
) => any;
export declare const AppInstanceAdminSummaryFilterSensitiveLog: (
  obj: AppInstanceAdminSummary
) => any;
export declare const AppInstanceSummaryFilterSensitiveLog: (
  obj: AppInstanceSummary
) => any;
export declare const AppInstanceStreamingConfigurationFilterSensitiveLog: (
  obj: AppInstanceStreamingConfiguration
) => any;
export declare const AppInstanceUserFilterSensitiveLog: (
  obj: AppInstanceUser
) => any;
export declare const AppInstanceUserSummaryFilterSensitiveLog: (
  obj: AppInstanceUserSummary
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorRequest
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
) => any;
export declare const AssociatePhoneNumberWithUserRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumberWithUserRequest
) => any;
export declare const AttendeeFilterSensitiveLog: (obj: Attendee) => any;
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const BatchChannelMembershipsFilterSensitiveLog: (
  obj: BatchChannelMemberships
) => any;
export declare const CreateAttendeeRequestItemFilterSensitiveLog: (
  obj: CreateAttendeeRequestItem
) => any;
export declare const BatchCreateAttendeeRequestFilterSensitiveLog: (
  obj: BatchCreateAttendeeRequest
) => any;
export declare const CreateAttendeeErrorFilterSensitiveLog: (
  obj: CreateAttendeeError
) => any;
export declare const BatchCreateAttendeeResponseFilterSensitiveLog: (
  obj: BatchCreateAttendeeResponse
) => any;
export declare const BatchCreateChannelMembershipResponseFilterSensitiveLog: (
  obj: BatchCreateChannelMembershipResponse
) => any;
export declare const UpdatePhoneNumberRequestItemFilterSensitiveLog: (
  obj: UpdatePhoneNumberRequestItem
) => any;
export declare const BatchUpdatePhoneNumberRequestFilterSensitiveLog: (
  obj: BatchUpdatePhoneNumberRequest
) => any;
export declare const UpdateUserRequestItemFilterSensitiveLog: (
  obj: UpdateUserRequestItem
) => any;
export declare const BatchUpdateUserRequestFilterSensitiveLog: (
  obj: BatchUpdateUserRequest
) => any;
export declare const BotFilterSensitiveLog: (obj: Bot) => any;
export declare const CandidateAddressFilterSensitiveLog: (
  obj: CandidateAddress
) => any;
export declare const ChannelFilterSensitiveLog: (obj: Channel) => any;
export declare const ChannelBanFilterSensitiveLog: (obj: ChannelBan) => any;
export declare const ChannelBanSummaryFilterSensitiveLog: (
  obj: ChannelBanSummary
) => any;
export declare const ChannelMembershipFilterSensitiveLog: (
  obj: ChannelMembership
) => any;
export declare const ChannelSummaryFilterSensitiveLog: (
  obj: ChannelSummary
) => any;
export declare const ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog: (
  obj: ChannelMembershipForAppInstanceUserSummary
) => any;
export declare const ChannelMembershipSummaryFilterSensitiveLog: (
  obj: ChannelMembershipSummary
) => any;
export declare const ChannelMessageFilterSensitiveLog: (
  obj: ChannelMessage
) => any;
export declare const ChannelMessageSummaryFilterSensitiveLog: (
  obj: ChannelMessageSummary
) => any;
export declare const ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog: (
  obj: ChannelModeratedByAppInstanceUserSummary
) => any;
export declare const ChannelModeratorFilterSensitiveLog: (
  obj: ChannelModerator
) => any;
export declare const ChannelModeratorSummaryFilterSensitiveLog: (
  obj: ChannelModeratorSummary
) => any;
export declare const SelectedVideoStreamsFilterSensitiveLog: (
  obj: SelectedVideoStreams
) => any;
export declare const SourceConfigurationFilterSensitiveLog: (
  obj: SourceConfiguration
) => any;
export declare const ChimeSdkMeetingConfigurationFilterSensitiveLog: (
  obj: ChimeSdkMeetingConfiguration
) => any;
export declare const CreateAppInstanceRequestFilterSensitiveLog: (
  obj: CreateAppInstanceRequest
) => any;
export declare const CreateAppInstanceAdminResponseFilterSensitiveLog: (
  obj: CreateAppInstanceAdminResponse
) => any;
export declare const CreateAppInstanceUserRequestFilterSensitiveLog: (
  obj: CreateAppInstanceUserRequest
) => any;
export declare const CreateAttendeeRequestFilterSensitiveLog: (
  obj: CreateAttendeeRequest
) => any;
export declare const CreateAttendeeResponseFilterSensitiveLog: (
  obj: CreateAttendeeResponse
) => any;
export declare const CreateBotRequestFilterSensitiveLog: (
  obj: CreateBotRequest
) => any;
export declare const CreateBotResponseFilterSensitiveLog: (
  obj: CreateBotResponse
) => any;
export declare const CreateChannelRequestFilterSensitiveLog: (
  obj: CreateChannelRequest
) => any;
export declare const CreateChannelBanResponseFilterSensitiveLog: (
  obj: CreateChannelBanResponse
) => any;
export declare const CreateChannelMembershipResponseFilterSensitiveLog: (
  obj: CreateChannelMembershipResponse
) => any;
export declare const CreateChannelModeratorResponseFilterSensitiveLog: (
  obj: CreateChannelModeratorResponse
) => any;
export declare const CreateMediaCapturePipelineRequestFilterSensitiveLog: (
  obj: CreateMediaCapturePipelineRequest
) => any;
export declare const MediaCapturePipelineFilterSensitiveLog: (
  obj: MediaCapturePipeline
) => any;
export declare const CreateMediaCapturePipelineResponseFilterSensitiveLog: (
  obj: CreateMediaCapturePipelineResponse
) => any;
export declare const MeetingNotificationConfigurationFilterSensitiveLog: (
  obj: MeetingNotificationConfiguration
) => any;
export declare const CreateMeetingRequestFilterSensitiveLog: (
  obj: CreateMeetingRequest
) => any;
export declare const MeetingFilterSensitiveLog: (obj: Meeting) => any;
export declare const CreateMeetingResponseFilterSensitiveLog: (
  obj: CreateMeetingResponse
) => any;
export declare const CreateMeetingDialOutRequestFilterSensitiveLog: (
  obj: CreateMeetingDialOutRequest
) => any;
export declare const CreateMeetingWithAttendeesRequestFilterSensitiveLog: (
  obj: CreateMeetingWithAttendeesRequest
) => any;
export declare const CreateMeetingWithAttendeesResponseFilterSensitiveLog: (
  obj: CreateMeetingWithAttendeesResponse
) => any;
export declare const CreatePhoneNumberOrderRequestFilterSensitiveLog: (
  obj: CreatePhoneNumberOrderRequest
) => any;
export declare const OrderedPhoneNumberFilterSensitiveLog: (
  obj: OrderedPhoneNumber
) => any;
export declare const PhoneNumberOrderFilterSensitiveLog: (
  obj: PhoneNumberOrder
) => any;
export declare const CreatePhoneNumberOrderResponseFilterSensitiveLog: (
  obj: CreatePhoneNumberOrderResponse
) => any;
export declare const CreateProxySessionRequestFilterSensitiveLog: (
  obj: CreateProxySessionRequest
) => any;
export declare const ParticipantFilterSensitiveLog: (obj: Participant) => any;
export declare const ProxySessionFilterSensitiveLog: (obj: ProxySession) => any;
export declare const CreateProxySessionResponseFilterSensitiveLog: (
  obj: CreateProxySessionResponse
) => any;
export declare const CreateRoomRequestFilterSensitiveLog: (
  obj: CreateRoomRequest
) => any;
export declare const RoomFilterSensitiveLog: (obj: Room) => any;
export declare const CreateRoomResponseFilterSensitiveLog: (
  obj: CreateRoomResponse
) => any;
export declare const MemberFilterSensitiveLog: (obj: Member) => any;
export declare const RoomMembershipFilterSensitiveLog: (
  obj: RoomMembership
) => any;
export declare const CreateRoomMembershipResponseFilterSensitiveLog: (
  obj: CreateRoomMembershipResponse
) => any;
export declare const SipMediaApplicationEndpointFilterSensitiveLog: (
  obj: SipMediaApplicationEndpoint
) => any;
export declare const CreateSipMediaApplicationRequestFilterSensitiveLog: (
  obj: CreateSipMediaApplicationRequest
) => any;
export declare const SipMediaApplicationFilterSensitiveLog: (
  obj: SipMediaApplication
) => any;
export declare const CreateSipMediaApplicationResponseFilterSensitiveLog: (
  obj: CreateSipMediaApplicationResponse
) => any;
export declare const CreateSipMediaApplicationCallRequestFilterSensitiveLog: (
  obj: CreateSipMediaApplicationCallRequest
) => any;
export declare const CreateUserRequestFilterSensitiveLog: (
  obj: CreateUserRequest
) => any;
export declare const UserFilterSensitiveLog: (obj: User) => any;
export declare const CreateUserResponseFilterSensitiveLog: (
  obj: CreateUserResponse
) => any;
export declare const CredentialFilterSensitiveLog: (obj: Credential) => any;
export declare const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorTerminationCredentialsRequest
) => any;
export declare const DescribeAppInstanceResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceResponse
) => any;
export declare const DescribeAppInstanceAdminResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceAdminResponse
) => any;
export declare const DescribeAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceUserResponse
) => any;
export declare const DescribeChannelResponseFilterSensitiveLog: (
  obj: DescribeChannelResponse
) => any;
export declare const DescribeChannelBanResponseFilterSensitiveLog: (
  obj: DescribeChannelBanResponse
) => any;
export declare const DescribeChannelMembershipResponseFilterSensitiveLog: (
  obj: DescribeChannelMembershipResponse
) => any;
export declare const DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeChannelMembershipForAppInstanceUserResponse
) => any;
export declare const DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeChannelModeratedByAppInstanceUserResponse
) => any;
export declare const DescribeChannelModeratorResponseFilterSensitiveLog: (
  obj: DescribeChannelModeratorResponse
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorRequest
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
) => any;
export declare const DNISEmergencyCallingConfigurationFilterSensitiveLog: (
  obj: DNISEmergencyCallingConfiguration
) => any;
export declare const EmergencyCallingConfigurationFilterSensitiveLog: (
  obj: EmergencyCallingConfiguration
) => any;
export declare const EventsConfigurationFilterSensitiveLog: (
  obj: EventsConfiguration
) => any;
export declare const GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog: (
  obj: GetAppInstanceStreamingConfigurationsResponse
) => any;
export declare const GetAttendeeResponseFilterSensitiveLog: (
  obj: GetAttendeeResponse
) => any;
export declare const GetBotResponseFilterSensitiveLog: (
  obj: GetBotResponse
) => any;
export declare const GetChannelMessageResponseFilterSensitiveLog: (
  obj: GetChannelMessageResponse
) => any;
export declare const GetEventsConfigurationResponseFilterSensitiveLog: (
  obj: GetEventsConfigurationResponse
) => any;
export declare const GetMediaCapturePipelineResponseFilterSensitiveLog: (
  obj: GetMediaCapturePipelineResponse
) => any;
export declare const GetMeetingResponseFilterSensitiveLog: (
  obj: GetMeetingResponse
) => any;
export declare const PhoneNumberFilterSensitiveLog: (obj: PhoneNumber) => any;
export declare const GetPhoneNumberResponseFilterSensitiveLog: (
  obj: GetPhoneNumberResponse
) => any;
export declare const GetPhoneNumberOrderResponseFilterSensitiveLog: (
  obj: GetPhoneNumberOrderResponse
) => any;
export declare const GetPhoneNumberSettingsResponseFilterSensitiveLog: (
  obj: GetPhoneNumberSettingsResponse
) => any;
export declare const GetProxySessionResponseFilterSensitiveLog: (
  obj: GetProxySessionResponse
) => any;
