"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsMetadataAlreadyExistsException = exports.OpsItemAlreadyExistsException = exports.OpsItemAccessDeniedException = exports.OpsItemDataType = exports.ResourceLimitExceededException = exports.IdempotentParameterMismatch = exports.MaxDocumentSizeExceeded = exports.InvalidDocumentSchemaVersion = exports.InvalidDocumentContent = exports.DocumentLimitExceeded = exports.DocumentAlreadyExists = exports.DocumentStatus = exports.ReviewStatus = exports.PlatformType = exports.DocumentParameterType = exports.DocumentHashType = exports.DocumentType = exports.DocumentFormat = exports.AttachmentsSourceKey = exports.Fault = exports.UnsupportedPlatformType = exports.InvalidTargetMaps = exports.InvalidTarget = exports.InvalidTag = exports.InvalidSchedule = exports.InvalidOutputLocation = exports.InvalidDocumentVersion = exports.InvalidDocument = exports.AssociationStatusName = exports.AssociationSyncCompliance = exports.AssociationComplianceSeverity = exports.AssociationLimitExceeded = exports.AssociationAlreadyExists = exports.InvalidParameters = exports.DoesNotExistException = exports.InvalidInstanceId = exports.InvalidCommandId = exports.DuplicateInstanceId = exports.OpsItemRelatedItemAlreadyExistsException = exports.OpsItemNotFoundException = exports.OpsItemLimitExceededException = exports.OpsItemInvalidParameterException = exports.AlreadyExistsException = exports.ExternalAlarmState = exports.TooManyUpdates = exports.TooManyTagsError = exports.InvalidResourceType = exports.InvalidResourceId = exports.InternalServerError = exports.ResourceTypeForTagging = void 0;
exports.InstanceInformationFilterKey = exports.UnsupportedOperatingSystem = exports.PatchDeploymentStatus = exports.InvalidPermissionType = exports.DocumentPermissionType = exports.StepExecutionFilterKey = exports.AutomationExecutionNotFoundException = exports.InvalidFilterValue = exports.InvalidFilterKey = exports.ExecutionMode = exports.AutomationType = exports.AutomationSubtype = exports.AutomationExecutionStatus = exports.AutomationExecutionFilterKey = exports.AssociationExecutionTargetsFilterKey = exports.AssociationExecutionDoesNotExist = exports.AssociationFilterOperatorType = exports.AssociationExecutionFilterKey = exports.InvalidAssociationVersion = exports.InvalidNextToken = exports.InvalidFilter = exports.DescribeActivationsFilterKeys = exports.TargetInUseException = exports.ResourcePolicyInvalidParameterException = exports.ResourcePolicyConflictException = exports.ResourceDataSyncNotFoundException = exports.ResourceInUseException = exports.ParameterNotFound = exports.OpsMetadataNotFoundException = exports.InvalidTypeNameException = exports.InvalidOptionException = exports.InvalidInventoryRequestException = exports.InvalidDeleteInventoryParametersException = exports.InventorySchemaDeleteOption = exports.InvalidDocumentOperation = exports.AssociatedInstances = exports.AssociationDoesNotExist = exports.InvalidActivationId = exports.InvalidActivation = exports.ResourceDataSyncInvalidConfigurationException = exports.ResourceDataSyncCountExceededException = exports.ResourceDataSyncAlreadyExistsException = exports.ResourceDataSyncS3Format = exports.PatchAction = exports.OperatingSystem = exports.PatchFilterKey = exports.PatchComplianceLevel = exports.OpsMetadataTooManyUpdatesException = exports.OpsMetadataLimitExceededException = exports.OpsMetadataInvalidArgumentException = void 0;
exports.DescribeMaintenanceWindowTasksResultFilterSensitiveLog = exports.MaintenanceWindowTaskFilterSensitiveLog = exports.MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = exports.DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = exports.MaintenanceWindowTargetFilterSensitiveLog = exports.DescribeMaintenanceWindowsResultFilterSensitiveLog = exports.MaintenanceWindowIdentityFilterSensitiveLog = exports.DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = exports.MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = exports.DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = exports.DescribeInstancePatchStatesResultFilterSensitiveLog = exports.InstancePatchStateFilterSensitiveLog = exports.DescribeAssociationResultFilterSensitiveLog = exports.CreatePatchBaselineRequestFilterSensitiveLog = exports.PatchSourceFilterSensitiveLog = exports.CreateMaintenanceWindowRequestFilterSensitiveLog = exports.CreateAssociationBatchResultFilterSensitiveLog = exports.FailedCreateAssociationFilterSensitiveLog = exports.CreateAssociationBatchRequestFilterSensitiveLog = exports.CreateAssociationBatchRequestEntryFilterSensitiveLog = exports.CreateAssociationResultFilterSensitiveLog = exports.AssociationDescriptionFilterSensitiveLog = exports.CreateAssociationRequestFilterSensitiveLog = exports.OpsItemFilterOperator = exports.OpsItemFilterKey = exports.MaintenanceWindowTaskCutoffBehavior = exports.MaintenanceWindowResourceType = exports.MaintenanceWindowTaskType = exports.MaintenanceWindowExecutionStatus = exports.InvalidDeletionIdException = exports.InventoryDeletionStatus = exports.InstancePatchStateOperatorType = exports.RebootOption = exports.PatchOperationType = exports.PatchComplianceDataState = exports.InvalidInstanceInformationFilterValue = exports.SourceType = exports.ResourceType = exports.PingStatus = void 0;
const smithy_client_1 = require("@smithy/smithy-client");
const SSMServiceException_1 = require("./SSMServiceException");
exports.ResourceTypeForTagging = {
    ASSOCIATION: "Association",
    AUTOMATION: "Automation",
    DOCUMENT: "Document",
    MAINTENANCE_WINDOW: "MaintenanceWindow",
    MANAGED_INSTANCE: "ManagedInstance",
    OPSMETADATA: "OpsMetadata",
    OPS_ITEM: "OpsItem",
    PARAMETER: "Parameter",
    PATCH_BASELINE: "PatchBaseline",
};
class InternalServerError extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InternalServerError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServerError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServerError.prototype);
        this.Message = opts.Message;
    }
}
exports.InternalServerError = InternalServerError;
class InvalidResourceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidResourceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceId.prototype);
    }
}
exports.InvalidResourceId = InvalidResourceId;
class InvalidResourceType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidResourceType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceType.prototype);
    }
}
exports.InvalidResourceType = InvalidResourceType;
class TooManyTagsError extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TooManyTagsError",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyTagsError";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyTagsError.prototype);
    }
}
exports.TooManyTagsError = TooManyTagsError;
class TooManyUpdates extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TooManyUpdates",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyUpdates";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyUpdates.prototype);
        this.Message = opts.Message;
    }
}
exports.TooManyUpdates = TooManyUpdates;
exports.ExternalAlarmState = {
    ALARM: "ALARM",
    UNKNOWN: "UNKNOWN",
};
class AlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.AlreadyExistsException = AlreadyExistsException;
class OpsItemInvalidParameterException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
exports.OpsItemInvalidParameterException = OpsItemInvalidParameterException;
class OpsItemLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemLimitExceededException.prototype);
        this.ResourceTypes = opts.ResourceTypes;
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
exports.OpsItemLimitExceededException = OpsItemLimitExceededException;
class OpsItemNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.OpsItemNotFoundException = OpsItemNotFoundException;
class OpsItemRelatedItemAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.ResourceUri = opts.ResourceUri;
        this.OpsItemId = opts.OpsItemId;
    }
}
exports.OpsItemRelatedItemAlreadyExistsException = OpsItemRelatedItemAlreadyExistsException;
class DuplicateInstanceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DuplicateInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateInstanceId.prototype);
    }
}
exports.DuplicateInstanceId = DuplicateInstanceId;
class InvalidCommandId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidCommandId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidCommandId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidCommandId.prototype);
    }
}
exports.InvalidCommandId = InvalidCommandId;
class InvalidInstanceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceId.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInstanceId = InvalidInstanceId;
class DoesNotExistException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DoesNotExistException.prototype);
        this.Message = opts.Message;
    }
}
exports.DoesNotExistException = DoesNotExistException;
class InvalidParameters extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidParameters",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameters";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameters.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidParameters = InvalidParameters;
class AssociationAlreadyExists extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationAlreadyExists.prototype);
    }
}
exports.AssociationAlreadyExists = AssociationAlreadyExists;
class AssociationLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationLimitExceeded.prototype);
    }
}
exports.AssociationLimitExceeded = AssociationLimitExceeded;
exports.AssociationComplianceSeverity = {
    Critical: "CRITICAL",
    High: "HIGH",
    Low: "LOW",
    Medium: "MEDIUM",
    Unspecified: "UNSPECIFIED",
};
exports.AssociationSyncCompliance = {
    Auto: "AUTO",
    Manual: "MANUAL",
};
exports.AssociationStatusName = {
    Failed: "Failed",
    Pending: "Pending",
    Success: "Success",
};
class InvalidDocument extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocument",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocument";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocument.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocument = InvalidDocument;
class InvalidDocumentVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentVersion = InvalidDocumentVersion;
class InvalidOutputLocation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidOutputLocation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputLocation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputLocation.prototype);
    }
}
exports.InvalidOutputLocation = InvalidOutputLocation;
class InvalidSchedule extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidSchedule",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSchedule";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSchedule.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidSchedule = InvalidSchedule;
class InvalidTag extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTag",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTag";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTag.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTag = InvalidTag;
class InvalidTarget extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTarget",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTarget";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTarget.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTarget = InvalidTarget;
class InvalidTargetMaps extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTargetMaps",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetMaps";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetMaps.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTargetMaps = InvalidTargetMaps;
class UnsupportedPlatformType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedPlatformType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedPlatformType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedPlatformType.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedPlatformType = UnsupportedPlatformType;
exports.Fault = {
    Client: "Client",
    Server: "Server",
    Unknown: "Unknown",
};
exports.AttachmentsSourceKey = {
    AttachmentReference: "AttachmentReference",
    S3FileUrl: "S3FileUrl",
    SourceUrl: "SourceUrl",
};
exports.DocumentFormat = {
    JSON: "JSON",
    TEXT: "TEXT",
    YAML: "YAML",
};
exports.DocumentType = {
    ApplicationConfiguration: "ApplicationConfiguration",
    ApplicationConfigurationSchema: "ApplicationConfigurationSchema",
    Automation: "Automation",
    ChangeCalendar: "ChangeCalendar",
    ChangeTemplate: "Automation.ChangeTemplate",
    CloudFormation: "CloudFormation",
    Command: "Command",
    ConformancePackTemplate: "ConformancePackTemplate",
    DeploymentStrategy: "DeploymentStrategy",
    Package: "Package",
    Policy: "Policy",
    ProblemAnalysis: "ProblemAnalysis",
    ProblemAnalysisTemplate: "ProblemAnalysisTemplate",
    QuickSetup: "QuickSetup",
    Session: "Session",
};
exports.DocumentHashType = {
    SHA1: "Sha1",
    SHA256: "Sha256",
};
exports.DocumentParameterType = {
    String: "String",
    StringList: "StringList",
};
exports.PlatformType = {
    LINUX: "Linux",
    MACOS: "MacOS",
    WINDOWS: "Windows",
};
exports.ReviewStatus = {
    APPROVED: "APPROVED",
    NOT_REVIEWED: "NOT_REVIEWED",
    PENDING: "PENDING",
    REJECTED: "REJECTED",
};
exports.DocumentStatus = {
    Active: "Active",
    Creating: "Creating",
    Deleting: "Deleting",
    Failed: "Failed",
    Updating: "Updating",
};
class DocumentAlreadyExists extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DocumentAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
exports.DocumentAlreadyExists = DocumentAlreadyExists;
class DocumentLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DocumentLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
exports.DocumentLimitExceeded = DocumentLimitExceeded;
class InvalidDocumentContent extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentContent",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentContent";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentContent.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentContent = InvalidDocumentContent;
class InvalidDocumentSchemaVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentSchemaVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentSchemaVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentSchemaVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentSchemaVersion = InvalidDocumentSchemaVersion;
class MaxDocumentSizeExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "MaxDocumentSizeExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "MaxDocumentSizeExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, MaxDocumentSizeExceeded.prototype);
        this.Message = opts.Message;
    }
}
exports.MaxDocumentSizeExceeded = MaxDocumentSizeExceeded;
class IdempotentParameterMismatch extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "IdempotentParameterMismatch",
            $fault: "client",
            ...opts,
        });
        this.name = "IdempotentParameterMismatch";
        this.$fault = "client";
        Object.setPrototypeOf(this, IdempotentParameterMismatch.prototype);
        this.Message = opts.Message;
    }
}
exports.IdempotentParameterMismatch = IdempotentParameterMismatch;
class ResourceLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceLimitExceededException = ResourceLimitExceededException;
exports.OpsItemDataType = {
    SEARCHABLE_STRING: "SearchableString",
    STRING: "String",
};
class OpsItemAccessDeniedException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemAccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAccessDeniedException.prototype);
        this.Message = opts.Message;
    }
}
exports.OpsItemAccessDeniedException = OpsItemAccessDeniedException;
class OpsItemAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.OpsItemId = opts.OpsItemId;
    }
}
exports.OpsItemAlreadyExistsException = OpsItemAlreadyExistsException;
class OpsMetadataAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataAlreadyExistsException.prototype);
    }
}
exports.OpsMetadataAlreadyExistsException = OpsMetadataAlreadyExistsException;
class OpsMetadataInvalidArgumentException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataInvalidArgumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataInvalidArgumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataInvalidArgumentException.prototype);
    }
}
exports.OpsMetadataInvalidArgumentException = OpsMetadataInvalidArgumentException;
class OpsMetadataLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataLimitExceededException.prototype);
    }
}
exports.OpsMetadataLimitExceededException = OpsMetadataLimitExceededException;
class OpsMetadataTooManyUpdatesException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataTooManyUpdatesException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataTooManyUpdatesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataTooManyUpdatesException.prototype);
    }
}
exports.OpsMetadataTooManyUpdatesException = OpsMetadataTooManyUpdatesException;
exports.PatchComplianceLevel = {
    Critical: "CRITICAL",
    High: "HIGH",
    Informational: "INFORMATIONAL",
    Low: "LOW",
    Medium: "MEDIUM",
    Unspecified: "UNSPECIFIED",
};
exports.PatchFilterKey = {
    AdvisoryId: "ADVISORY_ID",
    Arch: "ARCH",
    BugzillaId: "BUGZILLA_ID",
    CVEId: "CVE_ID",
    Classification: "CLASSIFICATION",
    Epoch: "EPOCH",
    MsrcSeverity: "MSRC_SEVERITY",
    Name: "NAME",
    PatchId: "PATCH_ID",
    PatchSet: "PATCH_SET",
    Priority: "PRIORITY",
    Product: "PRODUCT",
    ProductFamily: "PRODUCT_FAMILY",
    Release: "RELEASE",
    Repository: "REPOSITORY",
    Section: "SECTION",
    Security: "SECURITY",
    Severity: "SEVERITY",
    Version: "VERSION",
};
exports.OperatingSystem = {
    AlmaLinux: "ALMA_LINUX",
    AmazonLinux: "AMAZON_LINUX",
    AmazonLinux2: "AMAZON_LINUX_2",
    AmazonLinux2022: "AMAZON_LINUX_2022",
    AmazonLinux2023: "AMAZON_LINUX_2023",
    CentOS: "CENTOS",
    Debian: "DEBIAN",
    MacOS: "MACOS",
    OracleLinux: "ORACLE_LINUX",
    Raspbian: "RASPBIAN",
    RedhatEnterpriseLinux: "REDHAT_ENTERPRISE_LINUX",
    Rocky_Linux: "ROCKY_LINUX",
    Suse: "SUSE",
    Ubuntu: "UBUNTU",
    Windows: "WINDOWS",
};
exports.PatchAction = {
    AllowAsDependency: "ALLOW_AS_DEPENDENCY",
    Block: "BLOCK",
};
exports.ResourceDataSyncS3Format = {
    JSON_SERDE: "JsonSerDe",
};
class ResourceDataSyncAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncAlreadyExistsException.prototype);
        this.SyncName = opts.SyncName;
    }
}
exports.ResourceDataSyncAlreadyExistsException = ResourceDataSyncAlreadyExistsException;
class ResourceDataSyncCountExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncCountExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncCountExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncCountExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncCountExceededException = ResourceDataSyncCountExceededException;
class ResourceDataSyncInvalidConfigurationException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncInvalidConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncInvalidConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncInvalidConfigurationException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncInvalidConfigurationException = ResourceDataSyncInvalidConfigurationException;
class InvalidActivation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidActivation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivation.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidActivation = InvalidActivation;
class InvalidActivationId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidActivationId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivationId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivationId.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidActivationId = InvalidActivationId;
class AssociationDoesNotExist extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
exports.AssociationDoesNotExist = AssociationDoesNotExist;
class AssociatedInstances extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociatedInstances",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociatedInstances";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociatedInstances.prototype);
    }
}
exports.AssociatedInstances = AssociatedInstances;
class InvalidDocumentOperation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentOperation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentOperation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentOperation.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentOperation = InvalidDocumentOperation;
exports.InventorySchemaDeleteOption = {
    DELETE_SCHEMA: "DeleteSchema",
    DISABLE_SCHEMA: "DisableSchema",
};
class InvalidDeleteInventoryParametersException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDeleteInventoryParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeleteInventoryParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeleteInventoryParametersException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDeleteInventoryParametersException = InvalidDeleteInventoryParametersException;
class InvalidInventoryRequestException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInventoryRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryRequestException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInventoryRequestException = InvalidInventoryRequestException;
class InvalidOptionException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidOptionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOptionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOptionException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidOptionException = InvalidOptionException;
class InvalidTypeNameException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTypeNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTypeNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTypeNameException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTypeNameException = InvalidTypeNameException;
class OpsMetadataNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataNotFoundException.prototype);
    }
}
exports.OpsMetadataNotFoundException = OpsMetadataNotFoundException;
class ParameterNotFound extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterNotFound.prototype);
    }
}
exports.ParameterNotFound = ParameterNotFound;
class ResourceInUseException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceInUseException = ResourceInUseException;
class ResourceDataSyncNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncNotFoundException.prototype);
        this.SyncName = opts.SyncName;
        this.SyncType = opts.SyncType;
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncNotFoundException = ResourceDataSyncNotFoundException;
class ResourcePolicyConflictException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourcePolicyConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyConflictException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourcePolicyConflictException = ResourcePolicyConflictException;
class ResourcePolicyInvalidParameterException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourcePolicyInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
exports.ResourcePolicyInvalidParameterException = ResourcePolicyInvalidParameterException;
class TargetInUseException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TargetInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetInUseException.prototype);
        this.Message = opts.Message;
    }
}
exports.TargetInUseException = TargetInUseException;
exports.DescribeActivationsFilterKeys = {
    ACTIVATION_IDS: "ActivationIds",
    DEFAULT_INSTANCE_NAME: "DefaultInstanceName",
    IAM_ROLE: "IamRole",
};
class InvalidFilter extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilter",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilter";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilter.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidFilter = InvalidFilter;
class InvalidNextToken extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidNextToken",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextToken";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextToken.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidNextToken = InvalidNextToken;
class InvalidAssociationVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAssociationVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociationVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociationVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAssociationVersion = InvalidAssociationVersion;
exports.AssociationExecutionFilterKey = {
    CreatedTime: "CreatedTime",
    ExecutionId: "ExecutionId",
    Status: "Status",
};
exports.AssociationFilterOperatorType = {
    Equal: "EQUAL",
    GreaterThan: "GREATER_THAN",
    LessThan: "LESS_THAN",
};
class AssociationExecutionDoesNotExist extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationExecutionDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationExecutionDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationExecutionDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
exports.AssociationExecutionDoesNotExist = AssociationExecutionDoesNotExist;
exports.AssociationExecutionTargetsFilterKey = {
    ResourceId: "ResourceId",
    ResourceType: "ResourceType",
    Status: "Status",
};
exports.AutomationExecutionFilterKey = {
    AUTOMATION_SUBTYPE: "AutomationSubtype",
    AUTOMATION_TYPE: "AutomationType",
    CURRENT_ACTION: "CurrentAction",
    DOCUMENT_NAME_PREFIX: "DocumentNamePrefix",
    EXECUTION_ID: "ExecutionId",
    EXECUTION_STATUS: "ExecutionStatus",
    OPS_ITEM_ID: "OpsItemId",
    PARENT_EXECUTION_ID: "ParentExecutionId",
    START_TIME_AFTER: "StartTimeAfter",
    START_TIME_BEFORE: "StartTimeBefore",
    TAG_KEY: "TagKey",
    TARGET_RESOURCE_GROUP: "TargetResourceGroup",
};
exports.AutomationExecutionStatus = {
    APPROVED: "Approved",
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected",
    COMPLETED_WITH_FAILURE: "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS: "CompletedWithSuccess",
    FAILED: "Failed",
    INPROGRESS: "InProgress",
    PENDING: "Pending",
    PENDING_APPROVAL: "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride",
    REJECTED: "Rejected",
    RUNBOOK_INPROGRESS: "RunbookInProgress",
    SCHEDULED: "Scheduled",
    SUCCESS: "Success",
    TIMEDOUT: "TimedOut",
    WAITING: "Waiting",
};
exports.AutomationSubtype = {
    ChangeRequest: "ChangeRequest",
};
exports.AutomationType = {
    CrossAccount: "CrossAccount",
    Local: "Local",
};
exports.ExecutionMode = {
    Auto: "Auto",
    Interactive: "Interactive",
};
class InvalidFilterKey extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilterKey",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterKey";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterKey.prototype);
    }
}
exports.InvalidFilterKey = InvalidFilterKey;
class InvalidFilterValue extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterValue.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidFilterValue = InvalidFilterValue;
class AutomationExecutionNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationExecutionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationExecutionNotFoundException = AutomationExecutionNotFoundException;
exports.StepExecutionFilterKey = {
    ACTION: "Action",
    START_TIME_AFTER: "StartTimeAfter",
    START_TIME_BEFORE: "StartTimeBefore",
    STEP_EXECUTION_ID: "StepExecutionId",
    STEP_EXECUTION_STATUS: "StepExecutionStatus",
    STEP_NAME: "StepName",
};
exports.DocumentPermissionType = {
    SHARE: "Share",
};
class InvalidPermissionType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidPermissionType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPermissionType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPermissionType.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidPermissionType = InvalidPermissionType;
exports.PatchDeploymentStatus = {
    Approved: "APPROVED",
    ExplicitApproved: "EXPLICIT_APPROVED",
    ExplicitRejected: "EXPLICIT_REJECTED",
    PendingApproval: "PENDING_APPROVAL",
};
class UnsupportedOperatingSystem extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedOperatingSystem",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedOperatingSystem";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedOperatingSystem.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedOperatingSystem = UnsupportedOperatingSystem;
exports.InstanceInformationFilterKey = {
    ACTIVATION_IDS: "ActivationIds",
    AGENT_VERSION: "AgentVersion",
    ASSOCIATION_STATUS: "AssociationStatus",
    IAM_ROLE: "IamRole",
    INSTANCE_IDS: "InstanceIds",
    PING_STATUS: "PingStatus",
    PLATFORM_TYPES: "PlatformTypes",
    RESOURCE_TYPE: "ResourceType",
};
exports.PingStatus = {
    CONNECTION_LOST: "ConnectionLost",
    INACTIVE: "Inactive",
    ONLINE: "Online",
};
exports.ResourceType = {
    DOCUMENT: "Document",
    EC2_INSTANCE: "EC2Instance",
    MANAGED_INSTANCE: "ManagedInstance",
};
exports.SourceType = {
    AWS_EC2_INSTANCE: "AWS::EC2::Instance",
    AWS_IOT_THING: "AWS::IoT::Thing",
    AWS_SSM_MANAGEDINSTANCE: "AWS::SSM::ManagedInstance",
};
class InvalidInstanceInformationFilterValue extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInstanceInformationFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceInformationFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceInformationFilterValue.prototype);
    }
}
exports.InvalidInstanceInformationFilterValue = InvalidInstanceInformationFilterValue;
exports.PatchComplianceDataState = {
    Failed: "FAILED",
    Installed: "INSTALLED",
    InstalledOther: "INSTALLED_OTHER",
    InstalledPendingReboot: "INSTALLED_PENDING_REBOOT",
    InstalledRejected: "INSTALLED_REJECTED",
    Missing: "MISSING",
    NotApplicable: "NOT_APPLICABLE",
};
exports.PatchOperationType = {
    INSTALL: "Install",
    SCAN: "Scan",
};
exports.RebootOption = {
    NO_REBOOT: "NoReboot",
    REBOOT_IF_NEEDED: "RebootIfNeeded",
};
exports.InstancePatchStateOperatorType = {
    EQUAL: "Equal",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
    NOT_EQUAL: "NotEqual",
};
exports.InventoryDeletionStatus = {
    COMPLETE: "Complete",
    IN_PROGRESS: "InProgress",
};
class InvalidDeletionIdException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDeletionIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeletionIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeletionIdException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDeletionIdException = InvalidDeletionIdException;
exports.MaintenanceWindowExecutionStatus = {
    Cancelled: "CANCELLED",
    Cancelling: "CANCELLING",
    Failed: "FAILED",
    InProgress: "IN_PROGRESS",
    Pending: "PENDING",
    SkippedOverlapping: "SKIPPED_OVERLAPPING",
    Success: "SUCCESS",
    TimedOut: "TIMED_OUT",
};
exports.MaintenanceWindowTaskType = {
    Automation: "AUTOMATION",
    Lambda: "LAMBDA",
    RunCommand: "RUN_COMMAND",
    StepFunctions: "STEP_FUNCTIONS",
};
exports.MaintenanceWindowResourceType = {
    Instance: "INSTANCE",
    ResourceGroup: "RESOURCE_GROUP",
};
exports.MaintenanceWindowTaskCutoffBehavior = {
    CancelTask: "CANCEL_TASK",
    ContinueTask: "CONTINUE_TASK",
};
exports.OpsItemFilterKey = {
    ACCOUNT_ID: "AccountId",
    ACTUAL_END_TIME: "ActualEndTime",
    ACTUAL_START_TIME: "ActualStartTime",
    AUTOMATION_ID: "AutomationId",
    CATEGORY: "Category",
    CHANGE_REQUEST_APPROVER_ARN: "ChangeRequestByApproverArn",
    CHANGE_REQUEST_APPROVER_NAME: "ChangeRequestByApproverName",
    CHANGE_REQUEST_REQUESTER_ARN: "ChangeRequestByRequesterArn",
    CHANGE_REQUEST_REQUESTER_NAME: "ChangeRequestByRequesterName",
    CHANGE_REQUEST_TARGETS_RESOURCE_GROUP: "ChangeRequestByTargetsResourceGroup",
    CHANGE_REQUEST_TEMPLATE: "ChangeRequestByTemplate",
    CREATED_BY: "CreatedBy",
    CREATED_TIME: "CreatedTime",
    INSIGHT_TYPE: "InsightByType",
    LAST_MODIFIED_TIME: "LastModifiedTime",
    OPERATIONAL_DATA: "OperationalData",
    OPERATIONAL_DATA_KEY: "OperationalDataKey",
    OPERATIONAL_DATA_VALUE: "OperationalDataValue",
    OPSITEM_ID: "OpsItemId",
    OPSITEM_TYPE: "OpsItemType",
    PLANNED_END_TIME: "PlannedEndTime",
    PLANNED_START_TIME: "PlannedStartTime",
    PRIORITY: "Priority",
    RESOURCE_ID: "ResourceId",
    SEVERITY: "Severity",
    SOURCE: "Source",
    STATUS: "Status",
    TITLE: "Title",
};
exports.OpsItemFilterOperator = {
    CONTAINS: "Contains",
    EQUAL: "Equal",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
};
const CreateAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateAssociationRequestFilterSensitiveLog = CreateAssociationRequestFilterSensitiveLog;
const AssociationDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.AssociationDescriptionFilterSensitiveLog = AssociationDescriptionFilterSensitiveLog;
const CreateAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: (0, exports.AssociationDescriptionFilterSensitiveLog)(obj.AssociationDescription),
    }),
});
exports.CreateAssociationResultFilterSensitiveLog = CreateAssociationResultFilterSensitiveLog;
const CreateAssociationBatchRequestEntryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateAssociationBatchRequestEntryFilterSensitiveLog = CreateAssociationBatchRequestEntryFilterSensitiveLog;
const CreateAssociationBatchRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entries && {
        Entries: obj.Entries.map((item) => (0, exports.CreateAssociationBatchRequestEntryFilterSensitiveLog)(item)),
    }),
});
exports.CreateAssociationBatchRequestFilterSensitiveLog = CreateAssociationBatchRequestFilterSensitiveLog;
const FailedCreateAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entry && { Entry: (0, exports.CreateAssociationBatchRequestEntryFilterSensitiveLog)(obj.Entry) }),
});
exports.FailedCreateAssociationFilterSensitiveLog = FailedCreateAssociationFilterSensitiveLog;
const CreateAssociationBatchResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Successful && { Successful: obj.Successful.map((item) => (0, exports.AssociationDescriptionFilterSensitiveLog)(item)) }),
    ...(obj.Failed && { Failed: obj.Failed.map((item) => (0, exports.FailedCreateAssociationFilterSensitiveLog)(item)) }),
});
exports.CreateAssociationBatchResultFilterSensitiveLog = CreateAssociationBatchResultFilterSensitiveLog;
const CreateMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.CreateMaintenanceWindowRequestFilterSensitiveLog = CreateMaintenanceWindowRequestFilterSensitiveLog;
const PatchSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Configuration && { Configuration: smithy_client_1.SENSITIVE_STRING }),
});
exports.PatchSourceFilterSensitiveLog = PatchSourceFilterSensitiveLog;
const CreatePatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, exports.PatchSourceFilterSensitiveLog)(item)) }),
});
exports.CreatePatchBaselineRequestFilterSensitiveLog = CreatePatchBaselineRequestFilterSensitiveLog;
const DescribeAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: (0, exports.AssociationDescriptionFilterSensitiveLog)(obj.AssociationDescription),
    }),
});
exports.DescribeAssociationResultFilterSensitiveLog = DescribeAssociationResultFilterSensitiveLog;
const InstancePatchStateFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
});
exports.InstancePatchStateFilterSensitiveLog = InstancePatchStateFilterSensitiveLog;
const DescribeInstancePatchStatesResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => (0, exports.InstancePatchStateFilterSensitiveLog)(item)),
    }),
});
exports.DescribeInstancePatchStatesResultFilterSensitiveLog = DescribeInstancePatchStatesResultFilterSensitiveLog;
const DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => (0, exports.InstancePatchStateFilterSensitiveLog)(item)),
    }),
});
exports.DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog;
const MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog;
const DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowExecutionTaskInvocationIdentities && {
        WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map((item) => (0, exports.MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog)(item)),
    }),
});
exports.DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog;
const MaintenanceWindowIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowIdentityFilterSensitiveLog = MaintenanceWindowIdentityFilterSensitiveLog;
const DescribeMaintenanceWindowsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowIdentities && {
        WindowIdentities: obj.WindowIdentities.map((item) => (0, exports.MaintenanceWindowIdentityFilterSensitiveLog)(item)),
    }),
});
exports.DescribeMaintenanceWindowsResultFilterSensitiveLog = DescribeMaintenanceWindowsResultFilterSensitiveLog;
const MaintenanceWindowTargetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowTargetFilterSensitiveLog = MaintenanceWindowTargetFilterSensitiveLog;
const DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Targets && { Targets: obj.Targets.map((item) => (0, exports.MaintenanceWindowTargetFilterSensitiveLog)(item)) }),
});
exports.DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = DescribeMaintenanceWindowTargetsResultFilterSensitiveLog;
const MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Values && { Values: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog;
const MaintenanceWindowTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowTaskFilterSensitiveLog = MaintenanceWindowTaskFilterSensitiveLog;
const DescribeMaintenanceWindowTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tasks && { Tasks: obj.Tasks.map((item) => (0, exports.MaintenanceWindowTaskFilterSensitiveLog)(item)) }),
});
exports.DescribeMaintenanceWindowTasksResultFilterSensitiveLog = DescribeMaintenanceWindowTasksResultFilterSensitiveLog;
