"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidItemContentException = exports.ComplianceTypeCountLimitExceededException = exports.DocumentPermissionLimit = exports.LastResourceDataSyncStatus = exports.OpsItemRelatedItemsFilterOperator = exports.OpsItemRelatedItemsFilterKey = exports.OpsItemEventFilterOperator = exports.OpsItemEventFilterKey = exports.DocumentFilterKey = exports.DocumentReviewCommentType = exports.DocumentMetadataEnum = exports.ComplianceStatus = exports.ComplianceSeverity = exports.ComplianceQueryOperatorType = exports.CommandStatus = exports.CommandPluginStatus = exports.CommandFilterKey = exports.AssociationFilterKey = exports.ParameterVersionLabelLimitExceeded = exports.ServiceSettingNotFound = exports.ParameterVersionNotFound = exports.InvalidKeyId = exports.OpsFilterOperatorType = exports.NotificationType = exports.NotificationEvent = exports.InventoryAttributeDataType = exports.InvalidResultAttributeException = exports.InvalidInventoryGroupException = exports.InvalidAggregatorException = exports.InventoryQueryOperatorType = exports.AttachmentHashType = exports.UnsupportedFeatureRequiredException = exports.ConnectionStatus = exports.InvocationDoesNotExist = exports.InvalidPluginName = exports.CommandInvocationStatus = exports.UnsupportedCalendarException = exports.InvalidDocumentType = exports.CalendarState = exports.OpsItemRelatedItemAssociationNotFoundException = exports.SessionStatus = exports.SessionState = exports.SessionFilterKey = exports.PatchProperty = exports.PatchSet = exports.InvalidFilterOption = exports.ParameterType = exports.ParameterTier = exports.ParametersFilterKey = exports.OpsItemStatus = void 0;
exports.ParameterFilterSensitiveLog = exports.GetMaintenanceWindowTaskResultFilterSensitiveLog = exports.MaintenanceWindowTaskInvocationParametersFilterSensitiveLog = exports.MaintenanceWindowStepFunctionsParametersFilterSensitiveLog = exports.MaintenanceWindowRunCommandParametersFilterSensitiveLog = exports.MaintenanceWindowLambdaParametersFilterSensitiveLog = exports.GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog = exports.GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog = exports.GetMaintenanceWindowResultFilterSensitiveLog = exports.GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog = exports.BaselineOverrideFilterSensitiveLog = exports.AssociationVersionLimitExceeded = exports.StopType = exports.InvalidAutomationStatusUpdateException = exports.TargetNotConnected = exports.AutomationDefinitionNotApprovedException = exports.InvalidAutomationExecutionParametersException = exports.AutomationExecutionLimitExceededException = exports.AutomationDefinitionVersionNotFoundException = exports.AutomationDefinitionNotFoundException = exports.InvalidAssociation = exports.InvalidRole = exports.InvalidOutputFolder = exports.InvalidNotificationConfig = exports.SignalType = exports.InvalidAutomationSignalException = exports.AutomationStepNotFoundException = exports.FeatureNotAvailableException = exports.ResourcePolicyLimitExceededException = exports.UnsupportedParameterType = exports.PoliciesLimitExceededException = exports.ParameterPatternMismatchException = exports.ParameterMaxVersionLimitExceeded = exports.ParameterLimitExceeded = exports.ParameterAlreadyExists = exports.InvalidPolicyTypeException = exports.InvalidPolicyAttributeException = exports.InvalidAllowedPatternException = exports.IncompatiblePolicyException = exports.HierarchyTypeMismatchException = exports.HierarchyLevelLimitExceededException = exports.UnsupportedInventorySchemaVersionException = exports.UnsupportedInventoryItemContextException = exports.SubTypeCountLimitExceededException = exports.ItemContentMismatchException = exports.InvalidInventoryItemContextException = exports.CustomSchemaCountLimitExceededException = exports.TotalSizeLimitExceededException = exports.ComplianceUploadType = exports.ItemSizeLimitExceededException = void 0;
exports.SendCommandResultFilterSensitiveLog = exports.SendCommandRequestFilterSensitiveLog = exports.RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog = exports.RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog = exports.PutParameterRequestFilterSensitiveLog = exports.ListCommandsResultFilterSensitiveLog = exports.CommandFilterSensitiveLog = exports.ListAssociationVersionsResultFilterSensitiveLog = exports.AssociationVersionInfoFilterSensitiveLog = exports.GetPatchBaselineResultFilterSensitiveLog = exports.GetParametersByPathResultFilterSensitiveLog = exports.GetParametersResultFilterSensitiveLog = exports.GetParameterHistoryResultFilterSensitiveLog = exports.ParameterHistoryFilterSensitiveLog = exports.GetParameterResultFilterSensitiveLog = void 0;
const smithy_client_1 = require("@smithy/smithy-client");
const models_0_1 = require("./models_0");
const SSMServiceException_1 = require("./SSMServiceException");
exports.OpsItemStatus = {
    APPROVED: "Approved",
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected",
    CLOSED: "Closed",
    COMPLETED_WITH_FAILURE: "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS: "CompletedWithSuccess",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    OPEN: "Open",
    PENDING: "Pending",
    PENDING_APPROVAL: "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride",
    REJECTED: "Rejected",
    RESOLVED: "Resolved",
    RUNBOOK_IN_PROGRESS: "RunbookInProgress",
    SCHEDULED: "Scheduled",
    TIMED_OUT: "TimedOut",
};
exports.ParametersFilterKey = {
    KEY_ID: "KeyId",
    NAME: "Name",
    TYPE: "Type",
};
exports.ParameterTier = {
    ADVANCED: "Advanced",
    INTELLIGENT_TIERING: "Intelligent-Tiering",
    STANDARD: "Standard",
};
exports.ParameterType = {
    SECURE_STRING: "SecureString",
    STRING: "String",
    STRING_LIST: "StringList",
};
class InvalidFilterOption extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilterOption",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterOption";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterOption.prototype);
    }
}
exports.InvalidFilterOption = InvalidFilterOption;
exports.PatchSet = {
    Application: "APPLICATION",
    Os: "OS",
};
exports.PatchProperty = {
    PatchClassification: "CLASSIFICATION",
    PatchMsrcSeverity: "MSRC_SEVERITY",
    PatchPriority: "PRIORITY",
    PatchProductFamily: "PRODUCT_FAMILY",
    PatchSeverity: "SEVERITY",
    Product: "PRODUCT",
};
exports.SessionFilterKey = {
    INVOKED_AFTER: "InvokedAfter",
    INVOKED_BEFORE: "InvokedBefore",
    OWNER: "Owner",
    SESSION_ID: "SessionId",
    STATUS: "Status",
    TARGET_ID: "Target",
};
exports.SessionState = {
    ACTIVE: "Active",
    HISTORY: "History",
};
exports.SessionStatus = {
    CONNECTED: "Connected",
    CONNECTING: "Connecting",
    DISCONNECTED: "Disconnected",
    FAILED: "Failed",
    TERMINATED: "Terminated",
    TERMINATING: "Terminating",
};
class OpsItemRelatedItemAssociationNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAssociationNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAssociationNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAssociationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.OpsItemRelatedItemAssociationNotFoundException = OpsItemRelatedItemAssociationNotFoundException;
exports.CalendarState = {
    CLOSED: "CLOSED",
    OPEN: "OPEN",
};
class InvalidDocumentType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentType.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentType = InvalidDocumentType;
class UnsupportedCalendarException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedCalendarException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedCalendarException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedCalendarException.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedCalendarException = UnsupportedCalendarException;
exports.CommandInvocationStatus = {
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    DELAYED: "Delayed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
class InvalidPluginName extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidPluginName",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPluginName";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPluginName.prototype);
    }
}
exports.InvalidPluginName = InvalidPluginName;
class InvocationDoesNotExist extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvocationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "InvocationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvocationDoesNotExist.prototype);
    }
}
exports.InvocationDoesNotExist = InvocationDoesNotExist;
exports.ConnectionStatus = {
    CONNECTED: "Connected",
    NOT_CONNECTED: "NotConnected",
};
class UnsupportedFeatureRequiredException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedFeatureRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedFeatureRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedFeatureRequiredException.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedFeatureRequiredException = UnsupportedFeatureRequiredException;
exports.AttachmentHashType = {
    SHA256: "Sha256",
};
exports.InventoryQueryOperatorType = {
    BEGIN_WITH: "BeginWith",
    EQUAL: "Equal",
    EXISTS: "Exists",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
    NOT_EQUAL: "NotEqual",
};
class InvalidAggregatorException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAggregatorException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAggregatorException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAggregatorException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAggregatorException = InvalidAggregatorException;
class InvalidInventoryGroupException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInventoryGroupException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryGroupException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryGroupException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInventoryGroupException = InvalidInventoryGroupException;
class InvalidResultAttributeException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidResultAttributeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResultAttributeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResultAttributeException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidResultAttributeException = InvalidResultAttributeException;
exports.InventoryAttributeDataType = {
    NUMBER: "number",
    STRING: "string",
};
exports.NotificationEvent = {
    ALL: "All",
    CANCELLED: "Cancelled",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
exports.NotificationType = {
    Command: "Command",
    Invocation: "Invocation",
};
exports.OpsFilterOperatorType = {
    BEGIN_WITH: "BeginWith",
    EQUAL: "Equal",
    EXISTS: "Exists",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
    NOT_EQUAL: "NotEqual",
};
class InvalidKeyId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidKeyId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidKeyId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidKeyId.prototype);
    }
}
exports.InvalidKeyId = InvalidKeyId;
class ParameterVersionNotFound extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterVersionNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterVersionNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterVersionNotFound.prototype);
    }
}
exports.ParameterVersionNotFound = ParameterVersionNotFound;
class ServiceSettingNotFound extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ServiceSettingNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ServiceSettingNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ServiceSettingNotFound.prototype);
        this.Message = opts.Message;
    }
}
exports.ServiceSettingNotFound = ServiceSettingNotFound;
class ParameterVersionLabelLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterVersionLabelLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterVersionLabelLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterVersionLabelLimitExceeded.prototype);
    }
}
exports.ParameterVersionLabelLimitExceeded = ParameterVersionLabelLimitExceeded;
exports.AssociationFilterKey = {
    AssociationId: "AssociationId",
    AssociationName: "AssociationName",
    InstanceId: "InstanceId",
    LastExecutedAfter: "LastExecutedAfter",
    LastExecutedBefore: "LastExecutedBefore",
    Name: "Name",
    ResourceGroupName: "ResourceGroupName",
    Status: "AssociationStatusName",
};
exports.CommandFilterKey = {
    DOCUMENT_NAME: "DocumentName",
    EXECUTION_STAGE: "ExecutionStage",
    INVOKED_AFTER: "InvokedAfter",
    INVOKED_BEFORE: "InvokedBefore",
    STATUS: "Status",
};
exports.CommandPluginStatus = {
    CANCELLED: "Cancelled",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
exports.CommandStatus = {
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
exports.ComplianceQueryOperatorType = {
    BeginWith: "BEGIN_WITH",
    Equal: "EQUAL",
    GreaterThan: "GREATER_THAN",
    LessThan: "LESS_THAN",
    NotEqual: "NOT_EQUAL",
};
exports.ComplianceSeverity = {
    Critical: "CRITICAL",
    High: "HIGH",
    Informational: "INFORMATIONAL",
    Low: "LOW",
    Medium: "MEDIUM",
    Unspecified: "UNSPECIFIED",
};
exports.ComplianceStatus = {
    Compliant: "COMPLIANT",
    NonCompliant: "NON_COMPLIANT",
};
exports.DocumentMetadataEnum = {
    DocumentReviews: "DocumentReviews",
};
exports.DocumentReviewCommentType = {
    Comment: "Comment",
};
exports.DocumentFilterKey = {
    DocumentType: "DocumentType",
    Name: "Name",
    Owner: "Owner",
    PlatformTypes: "PlatformTypes",
};
exports.OpsItemEventFilterKey = {
    OPSITEM_ID: "OpsItemId",
};
exports.OpsItemEventFilterOperator = {
    EQUAL: "Equal",
};
exports.OpsItemRelatedItemsFilterKey = {
    ASSOCIATION_ID: "AssociationId",
    RESOURCE_TYPE: "ResourceType",
    RESOURCE_URI: "ResourceUri",
};
exports.OpsItemRelatedItemsFilterOperator = {
    EQUAL: "Equal",
};
exports.LastResourceDataSyncStatus = {
    FAILED: "Failed",
    INPROGRESS: "InProgress",
    SUCCESSFUL: "Successful",
};
class DocumentPermissionLimit extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DocumentPermissionLimit",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentPermissionLimit";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentPermissionLimit.prototype);
        this.Message = opts.Message;
    }
}
exports.DocumentPermissionLimit = DocumentPermissionLimit;
class ComplianceTypeCountLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ComplianceTypeCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ComplianceTypeCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ComplianceTypeCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.ComplianceTypeCountLimitExceededException = ComplianceTypeCountLimitExceededException;
class InvalidItemContentException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidItemContentException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidItemContentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidItemContentException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
exports.InvalidItemContentException = InvalidItemContentException;
class ItemSizeLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ItemSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ItemSizeLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ItemSizeLimitExceededException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
exports.ItemSizeLimitExceededException = ItemSizeLimitExceededException;
exports.ComplianceUploadType = {
    Complete: "COMPLETE",
    Partial: "PARTIAL",
};
class TotalSizeLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TotalSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "TotalSizeLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TotalSizeLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.TotalSizeLimitExceededException = TotalSizeLimitExceededException;
class CustomSchemaCountLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "CustomSchemaCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "CustomSchemaCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CustomSchemaCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.CustomSchemaCountLimitExceededException = CustomSchemaCountLimitExceededException;
class InvalidInventoryItemContextException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInventoryItemContextException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryItemContextException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryItemContextException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInventoryItemContextException = InvalidInventoryItemContextException;
class ItemContentMismatchException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ItemContentMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "ItemContentMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ItemContentMismatchException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
exports.ItemContentMismatchException = ItemContentMismatchException;
class SubTypeCountLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "SubTypeCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "SubTypeCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, SubTypeCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.SubTypeCountLimitExceededException = SubTypeCountLimitExceededException;
class UnsupportedInventoryItemContextException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedInventoryItemContextException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedInventoryItemContextException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedInventoryItemContextException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
exports.UnsupportedInventoryItemContextException = UnsupportedInventoryItemContextException;
class UnsupportedInventorySchemaVersionException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedInventorySchemaVersionException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedInventorySchemaVersionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedInventorySchemaVersionException.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedInventorySchemaVersionException = UnsupportedInventorySchemaVersionException;
class HierarchyLevelLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "HierarchyLevelLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "HierarchyLevelLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, HierarchyLevelLimitExceededException.prototype);
    }
}
exports.HierarchyLevelLimitExceededException = HierarchyLevelLimitExceededException;
class HierarchyTypeMismatchException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "HierarchyTypeMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "HierarchyTypeMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, HierarchyTypeMismatchException.prototype);
    }
}
exports.HierarchyTypeMismatchException = HierarchyTypeMismatchException;
class IncompatiblePolicyException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "IncompatiblePolicyException",
            $fault: "client",
            ...opts,
        });
        this.name = "IncompatiblePolicyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IncompatiblePolicyException.prototype);
    }
}
exports.IncompatiblePolicyException = IncompatiblePolicyException;
class InvalidAllowedPatternException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAllowedPatternException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAllowedPatternException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAllowedPatternException.prototype);
    }
}
exports.InvalidAllowedPatternException = InvalidAllowedPatternException;
class InvalidPolicyAttributeException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidPolicyAttributeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPolicyAttributeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPolicyAttributeException.prototype);
    }
}
exports.InvalidPolicyAttributeException = InvalidPolicyAttributeException;
class InvalidPolicyTypeException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidPolicyTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPolicyTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPolicyTypeException.prototype);
    }
}
exports.InvalidPolicyTypeException = InvalidPolicyTypeException;
class ParameterAlreadyExists extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterAlreadyExists.prototype);
    }
}
exports.ParameterAlreadyExists = ParameterAlreadyExists;
class ParameterLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterLimitExceeded.prototype);
    }
}
exports.ParameterLimitExceeded = ParameterLimitExceeded;
class ParameterMaxVersionLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterMaxVersionLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterMaxVersionLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterMaxVersionLimitExceeded.prototype);
    }
}
exports.ParameterMaxVersionLimitExceeded = ParameterMaxVersionLimitExceeded;
class ParameterPatternMismatchException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterPatternMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterPatternMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterPatternMismatchException.prototype);
    }
}
exports.ParameterPatternMismatchException = ParameterPatternMismatchException;
class PoliciesLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "PoliciesLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "PoliciesLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PoliciesLimitExceededException.prototype);
    }
}
exports.PoliciesLimitExceededException = PoliciesLimitExceededException;
class UnsupportedParameterType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedParameterType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedParameterType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedParameterType.prototype);
    }
}
exports.UnsupportedParameterType = UnsupportedParameterType;
class ResourcePolicyLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourcePolicyLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyLimitExceededException.prototype);
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
exports.ResourcePolicyLimitExceededException = ResourcePolicyLimitExceededException;
class FeatureNotAvailableException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "FeatureNotAvailableException",
            $fault: "client",
            ...opts,
        });
        this.name = "FeatureNotAvailableException";
        this.$fault = "client";
        Object.setPrototypeOf(this, FeatureNotAvailableException.prototype);
        this.Message = opts.Message;
    }
}
exports.FeatureNotAvailableException = FeatureNotAvailableException;
class AutomationStepNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationStepNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationStepNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationStepNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationStepNotFoundException = AutomationStepNotFoundException;
class InvalidAutomationSignalException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAutomationSignalException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationSignalException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationSignalException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAutomationSignalException = InvalidAutomationSignalException;
exports.SignalType = {
    APPROVE: "Approve",
    REJECT: "Reject",
    RESUME: "Resume",
    START_STEP: "StartStep",
    STOP_STEP: "StopStep",
};
class InvalidNotificationConfig extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidNotificationConfig",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNotificationConfig";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNotificationConfig.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidNotificationConfig = InvalidNotificationConfig;
class InvalidOutputFolder extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidOutputFolder",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputFolder";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputFolder.prototype);
    }
}
exports.InvalidOutputFolder = InvalidOutputFolder;
class InvalidRole extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidRole",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRole";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRole.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidRole = InvalidRole;
class InvalidAssociation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAssociation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociation.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAssociation = InvalidAssociation;
class AutomationDefinitionNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationDefinitionNotFoundException = AutomationDefinitionNotFoundException;
class AutomationDefinitionVersionNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionVersionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionVersionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionVersionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationDefinitionVersionNotFoundException = AutomationDefinitionVersionNotFoundException;
class AutomationExecutionLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationExecutionLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationExecutionLimitExceededException = AutomationExecutionLimitExceededException;
class InvalidAutomationExecutionParametersException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAutomationExecutionParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationExecutionParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationExecutionParametersException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAutomationExecutionParametersException = InvalidAutomationExecutionParametersException;
class AutomationDefinitionNotApprovedException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionNotApprovedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionNotApprovedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionNotApprovedException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationDefinitionNotApprovedException = AutomationDefinitionNotApprovedException;
class TargetNotConnected extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TargetNotConnected",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetNotConnected";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetNotConnected.prototype);
        this.Message = opts.Message;
    }
}
exports.TargetNotConnected = TargetNotConnected;
class InvalidAutomationStatusUpdateException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAutomationStatusUpdateException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationStatusUpdateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationStatusUpdateException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAutomationStatusUpdateException = InvalidAutomationStatusUpdateException;
exports.StopType = {
    CANCEL: "Cancel",
    COMPLETE: "Complete",
};
class AssociationVersionLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationVersionLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationVersionLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationVersionLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
exports.AssociationVersionLimitExceeded = AssociationVersionLimitExceeded;
const BaselineOverrideFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, models_0_1.PatchSourceFilterSensitiveLog)(item)) }),
});
exports.BaselineOverrideFilterSensitiveLog = BaselineOverrideFilterSensitiveLog;
const GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
exports.GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog = GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog;
const GetMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.GetMaintenanceWindowResultFilterSensitiveLog = GetMaintenanceWindowResultFilterSensitiveLog;
const GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog = GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog;
const GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
});
exports.GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog = GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog;
const MaintenanceWindowLambdaParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Payload && { Payload: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowLambdaParametersFilterSensitiveLog = MaintenanceWindowLambdaParametersFilterSensitiveLog;
const MaintenanceWindowRunCommandParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowRunCommandParametersFilterSensitiveLog = MaintenanceWindowRunCommandParametersFilterSensitiveLog;
const MaintenanceWindowStepFunctionsParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Input && { Input: smithy_client_1.SENSITIVE_STRING }),
});
exports.MaintenanceWindowStepFunctionsParametersFilterSensitiveLog = MaintenanceWindowStepFunctionsParametersFilterSensitiveLog;
const MaintenanceWindowTaskInvocationParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RunCommand && { RunCommand: (0, exports.MaintenanceWindowRunCommandParametersFilterSensitiveLog)(obj.RunCommand) }),
    ...(obj.StepFunctions && {
        StepFunctions: (0, exports.MaintenanceWindowStepFunctionsParametersFilterSensitiveLog)(obj.StepFunctions),
    }),
    ...(obj.Lambda && { Lambda: (0, exports.MaintenanceWindowLambdaParametersFilterSensitiveLog)(obj.Lambda) }),
});
exports.MaintenanceWindowTaskInvocationParametersFilterSensitiveLog = MaintenanceWindowTaskInvocationParametersFilterSensitiveLog;
const GetMaintenanceWindowTaskResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.TaskInvocationParameters && {
        TaskInvocationParameters: (0, exports.MaintenanceWindowTaskInvocationParametersFilterSensitiveLog)(obj.TaskInvocationParameters),
    }),
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.GetMaintenanceWindowTaskResultFilterSensitiveLog = GetMaintenanceWindowTaskResultFilterSensitiveLog;
const ParameterFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: smithy_client_1.SENSITIVE_STRING }),
});
exports.ParameterFilterSensitiveLog = ParameterFilterSensitiveLog;
const GetParameterResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameter && { Parameter: (0, exports.ParameterFilterSensitiveLog)(obj.Parameter) }),
});
exports.GetParameterResultFilterSensitiveLog = GetParameterResultFilterSensitiveLog;
const ParameterHistoryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: smithy_client_1.SENSITIVE_STRING }),
});
exports.ParameterHistoryFilterSensitiveLog = ParameterHistoryFilterSensitiveLog;
const GetParameterHistoryResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => (0, exports.ParameterHistoryFilterSensitiveLog)(item)) }),
});
exports.GetParameterHistoryResultFilterSensitiveLog = GetParameterHistoryResultFilterSensitiveLog;
const GetParametersResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => (0, exports.ParameterFilterSensitiveLog)(item)) }),
});
exports.GetParametersResultFilterSensitiveLog = GetParametersResultFilterSensitiveLog;
const GetParametersByPathResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => (0, exports.ParameterFilterSensitiveLog)(item)) }),
});
exports.GetParametersByPathResultFilterSensitiveLog = GetParametersByPathResultFilterSensitiveLog;
const GetPatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => (0, models_0_1.PatchSourceFilterSensitiveLog)(item)) }),
});
exports.GetPatchBaselineResultFilterSensitiveLog = GetPatchBaselineResultFilterSensitiveLog;
const AssociationVersionInfoFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.AssociationVersionInfoFilterSensitiveLog = AssociationVersionInfoFilterSensitiveLog;
const ListAssociationVersionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationVersions && {
        AssociationVersions: obj.AssociationVersions.map((item) => (0, exports.AssociationVersionInfoFilterSensitiveLog)(item)),
    }),
});
exports.ListAssociationVersionsResultFilterSensitiveLog = ListAssociationVersionsResultFilterSensitiveLog;
const CommandFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.CommandFilterSensitiveLog = CommandFilterSensitiveLog;
const ListCommandsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Commands && { Commands: obj.Commands.map((item) => (0, exports.CommandFilterSensitiveLog)(item)) }),
});
exports.ListCommandsResultFilterSensitiveLog = ListCommandsResultFilterSensitiveLog;
const PutParameterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: smithy_client_1.SENSITIVE_STRING }),
});
exports.PutParameterRequestFilterSensitiveLog = PutParameterRequestFilterSensitiveLog;
const RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog = RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog;
const RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
    ...(obj.TaskInvocationParameters && {
        TaskInvocationParameters: (0, exports.MaintenanceWindowTaskInvocationParametersFilterSensitiveLog)(obj.TaskInvocationParameters),
    }),
    ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
});
exports.RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog = RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog;
const SendCommandRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
});
exports.SendCommandRequestFilterSensitiveLog = SendCommandRequestFilterSensitiveLog;
const SendCommandResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Command && { Command: (0, exports.CommandFilterSensitiveLog)(obj.Command) }),
});
exports.SendCommandResultFilterSensitiveLog = SendCommandResultFilterSensitiveLog;
