import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import {
  AlarmConfiguration,
  AlarmStateInformation,
  AssociationComplianceSeverity,
  AssociationOverview,
  AssociationSyncCompliance,
  AutomationExecutionStatus,
  AutomationSubtype,
  DocumentFormat,
  DocumentHashType,
  DocumentPermissionType,
  DocumentRequires,
  DocumentStatus,
  DocumentType,
  ExecutionMode,
  InstanceAssociationOutputLocation,
  LoggingInfo,
  MaintenanceWindowExecutionStatus,
  MaintenanceWindowResourceType,
  MaintenanceWindowTaskCutoffBehavior,
  MaintenanceWindowTaskParameterValueExpression,
  MaintenanceWindowTaskType,
  MetadataValue,
  OperatingSystem,
  OpsItemDataValue,
  OpsItemFilterKey,
  OpsItemFilterOperator,
  OpsItemNotification,
  PatchAction,
  PatchComplianceLevel,
  PatchFilterGroup,
  PatchOrchestratorFilter,
  PatchRuleGroup,
  PatchSource,
  PlatformType,
  RelatedOpsItem,
  ResolvedTargets,
  ResourceDataSyncAwsOrganizationsSource,
  ResourceDataSyncS3Destination,
  ResourceTypeForTagging,
  ReviewStatus,
  Runbook,
  StepExecution,
  Tag,
  Target,
  TargetLocation,
} from "./models_0";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export interface OpsItemFilter {
  Key: OpsItemFilterKey | string | undefined;
  Values: string[] | undefined;
  Operator: OpsItemFilterOperator | string | undefined;
}
export interface DescribeOpsItemsRequest {
  OpsItemFilters?: OpsItemFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const OpsItemStatus: {
  readonly APPROVED: "Approved";
  readonly CANCELLED: "Cancelled";
  readonly CANCELLING: "Cancelling";
  readonly CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved";
  readonly CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected";
  readonly CLOSED: "Closed";
  readonly COMPLETED_WITH_FAILURE: "CompletedWithFailure";
  readonly COMPLETED_WITH_SUCCESS: "CompletedWithSuccess";
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly OPEN: "Open";
  readonly PENDING: "Pending";
  readonly PENDING_APPROVAL: "PendingApproval";
  readonly PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride";
  readonly REJECTED: "Rejected";
  readonly RESOLVED: "Resolved";
  readonly RUNBOOK_IN_PROGRESS: "RunbookInProgress";
  readonly SCHEDULED: "Scheduled";
  readonly TIMED_OUT: "TimedOut";
};
export type OpsItemStatus = (typeof OpsItemStatus)[keyof typeof OpsItemStatus];
export interface OpsItemSummary {
  CreatedBy?: string;
  CreatedTime?: Date;
  LastModifiedBy?: string;
  LastModifiedTime?: Date;
  Priority?: number;
  Source?: string;
  Status?: OpsItemStatus | string;
  OpsItemId?: string;
  Title?: string;
  OperationalData?: Record<string, OpsItemDataValue>;
  Category?: string;
  Severity?: string;
  OpsItemType?: string;
  ActualStartTime?: Date;
  ActualEndTime?: Date;
  PlannedStartTime?: Date;
  PlannedEndTime?: Date;
}
export interface DescribeOpsItemsResponse {
  NextToken?: string;
  OpsItemSummaries?: OpsItemSummary[];
}
export declare const ParametersFilterKey: {
  readonly KEY_ID: "KeyId";
  readonly NAME: "Name";
  readonly TYPE: "Type";
};
export type ParametersFilterKey =
  (typeof ParametersFilterKey)[keyof typeof ParametersFilterKey];
export interface ParametersFilter {
  Key: ParametersFilterKey | string | undefined;
  Values: string[] | undefined;
}
export interface ParameterStringFilter {
  Key: string | undefined;
  Option?: string;
  Values?: string[];
}
export interface DescribeParametersRequest {
  Filters?: ParametersFilter[];
  ParameterFilters?: ParameterStringFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ParameterInlinePolicy {
  PolicyText?: string;
  PolicyType?: string;
  PolicyStatus?: string;
}
export declare const ParameterTier: {
  readonly ADVANCED: "Advanced";
  readonly INTELLIGENT_TIERING: "Intelligent-Tiering";
  readonly STANDARD: "Standard";
};
export type ParameterTier = (typeof ParameterTier)[keyof typeof ParameterTier];
export declare const ParameterType: {
  readonly SECURE_STRING: "SecureString";
  readonly STRING: "String";
  readonly STRING_LIST: "StringList";
};
export type ParameterType = (typeof ParameterType)[keyof typeof ParameterType];
export interface ParameterMetadata {
  Name?: string;
  Type?: ParameterType | string;
  KeyId?: string;
  LastModifiedDate?: Date;
  LastModifiedUser?: string;
  Description?: string;
  AllowedPattern?: string;
  Version?: number;
  Tier?: ParameterTier | string;
  Policies?: ParameterInlinePolicy[];
  DataType?: string;
}
export interface DescribeParametersResult {
  Parameters?: ParameterMetadata[];
  NextToken?: string;
}
export declare class InvalidFilterOption extends __BaseException {
  readonly name: "InvalidFilterOption";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidFilterOption, __BaseException>
  );
}
export interface DescribePatchBaselinesRequest {
  Filters?: PatchOrchestratorFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface PatchBaselineIdentity {
  BaselineId?: string;
  BaselineName?: string;
  OperatingSystem?: OperatingSystem | string;
  BaselineDescription?: string;
  DefaultBaseline?: boolean;
}
export interface DescribePatchBaselinesResult {
  BaselineIdentities?: PatchBaselineIdentity[];
  NextToken?: string;
}
export interface DescribePatchGroupsRequest {
  MaxResults?: number;
  Filters?: PatchOrchestratorFilter[];
  NextToken?: string;
}
export interface PatchGroupPatchBaselineMapping {
  PatchGroup?: string;
  BaselineIdentity?: PatchBaselineIdentity;
}
export interface DescribePatchGroupsResult {
  Mappings?: PatchGroupPatchBaselineMapping[];
  NextToken?: string;
}
export interface DescribePatchGroupStateRequest {
  PatchGroup: string | undefined;
}
export interface DescribePatchGroupStateResult {
  Instances?: number;
  InstancesWithInstalledPatches?: number;
  InstancesWithInstalledOtherPatches?: number;
  InstancesWithInstalledPendingRebootPatches?: number;
  InstancesWithInstalledRejectedPatches?: number;
  InstancesWithMissingPatches?: number;
  InstancesWithFailedPatches?: number;
  InstancesWithNotApplicablePatches?: number;
  InstancesWithUnreportedNotApplicablePatches?: number;
  InstancesWithCriticalNonCompliantPatches?: number;
  InstancesWithSecurityNonCompliantPatches?: number;
  InstancesWithOtherNonCompliantPatches?: number;
}
export declare const PatchSet: {
  readonly Application: "APPLICATION";
  readonly Os: "OS";
};
export type PatchSet = (typeof PatchSet)[keyof typeof PatchSet];
export declare const PatchProperty: {
  readonly PatchClassification: "CLASSIFICATION";
  readonly PatchMsrcSeverity: "MSRC_SEVERITY";
  readonly PatchPriority: "PRIORITY";
  readonly PatchProductFamily: "PRODUCT_FAMILY";
  readonly PatchSeverity: "SEVERITY";
  readonly Product: "PRODUCT";
};
export type PatchProperty = (typeof PatchProperty)[keyof typeof PatchProperty];
export interface DescribePatchPropertiesRequest {
  OperatingSystem: OperatingSystem | string | undefined;
  Property: PatchProperty | string | undefined;
  PatchSet?: PatchSet | string;
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribePatchPropertiesResult {
  Properties?: Record<string, string>[];
  NextToken?: string;
}
export declare const SessionFilterKey: {
  readonly INVOKED_AFTER: "InvokedAfter";
  readonly INVOKED_BEFORE: "InvokedBefore";
  readonly OWNER: "Owner";
  readonly SESSION_ID: "SessionId";
  readonly STATUS: "Status";
  readonly TARGET_ID: "Target";
};
export type SessionFilterKey =
  (typeof SessionFilterKey)[keyof typeof SessionFilterKey];
export interface SessionFilter {
  key: SessionFilterKey | string | undefined;
  value: string | undefined;
}
export declare const SessionState: {
  readonly ACTIVE: "Active";
  readonly HISTORY: "History";
};
export type SessionState = (typeof SessionState)[keyof typeof SessionState];
export interface DescribeSessionsRequest {
  State: SessionState | string | undefined;
  MaxResults?: number;
  NextToken?: string;
  Filters?: SessionFilter[];
}
export interface SessionManagerOutputUrl {
  S3OutputUrl?: string;
  CloudWatchOutputUrl?: string;
}
export declare const SessionStatus: {
  readonly CONNECTED: "Connected";
  readonly CONNECTING: "Connecting";
  readonly DISCONNECTED: "Disconnected";
  readonly FAILED: "Failed";
  readonly TERMINATED: "Terminated";
  readonly TERMINATING: "Terminating";
};
export type SessionStatus = (typeof SessionStatus)[keyof typeof SessionStatus];
export interface Session {
  SessionId?: string;
  Target?: string;
  Status?: SessionStatus | string;
  StartDate?: Date;
  EndDate?: Date;
  DocumentName?: string;
  Owner?: string;
  Reason?: string;
  Details?: string;
  OutputUrl?: SessionManagerOutputUrl;
  MaxSessionDuration?: string;
}
export interface DescribeSessionsResponse {
  Sessions?: Session[];
  NextToken?: string;
}
export interface DisassociateOpsItemRelatedItemRequest {
  OpsItemId: string | undefined;
  AssociationId: string | undefined;
}
export interface DisassociateOpsItemRelatedItemResponse {}
export declare class OpsItemRelatedItemAssociationNotFoundException extends __BaseException {
  readonly name: "OpsItemRelatedItemAssociationNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      OpsItemRelatedItemAssociationNotFoundException,
      __BaseException
    >
  );
}
export interface GetAutomationExecutionRequest {
  AutomationExecutionId: string | undefined;
}
export interface ProgressCounters {
  TotalSteps?: number;
  SuccessSteps?: number;
  FailedSteps?: number;
  CancelledSteps?: number;
  TimedOutSteps?: number;
}
export interface AutomationExecution {
  AutomationExecutionId?: string;
  DocumentName?: string;
  DocumentVersion?: string;
  ExecutionStartTime?: Date;
  ExecutionEndTime?: Date;
  AutomationExecutionStatus?: AutomationExecutionStatus | string;
  StepExecutions?: StepExecution[];
  StepExecutionsTruncated?: boolean;
  Parameters?: Record<string, string[]>;
  Outputs?: Record<string, string[]>;
  FailureMessage?: string;
  Mode?: ExecutionMode | string;
  ParentAutomationExecutionId?: string;
  ExecutedBy?: string;
  CurrentStepName?: string;
  CurrentAction?: string;
  TargetParameterName?: string;
  Targets?: Target[];
  TargetMaps?: Record<string, string[]>[];
  ResolvedTargets?: ResolvedTargets;
  MaxConcurrency?: string;
  MaxErrors?: string;
  Target?: string;
  TargetLocations?: TargetLocation[];
  ProgressCounters?: ProgressCounters;
  AlarmConfiguration?: AlarmConfiguration;
  TriggeredAlarms?: AlarmStateInformation[];
  AutomationSubtype?: AutomationSubtype | string;
  ScheduledTime?: Date;
  Runbooks?: Runbook[];
  OpsItemId?: string;
  AssociationId?: string;
  ChangeRequestName?: string;
}
export interface GetAutomationExecutionResult {
  AutomationExecution?: AutomationExecution;
}
export interface GetCalendarStateRequest {
  CalendarNames: string[] | undefined;
  AtTime?: string;
}
export declare const CalendarState: {
  readonly CLOSED: "CLOSED";
  readonly OPEN: "OPEN";
};
export type CalendarState = (typeof CalendarState)[keyof typeof CalendarState];
export interface GetCalendarStateResponse {
  State?: CalendarState | string;
  AtTime?: string;
  NextTransitionTime?: string;
}
export declare class InvalidDocumentType extends __BaseException {
  readonly name: "InvalidDocumentType";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidDocumentType, __BaseException>
  );
}
export declare class UnsupportedCalendarException extends __BaseException {
  readonly name: "UnsupportedCalendarException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnsupportedCalendarException, __BaseException>
  );
}
export interface GetCommandInvocationRequest {
  CommandId: string | undefined;
  InstanceId: string | undefined;
  PluginName?: string;
}
export interface CloudWatchOutputConfig {
  CloudWatchLogGroupName?: string;
  CloudWatchOutputEnabled?: boolean;
}
export declare const CommandInvocationStatus: {
  readonly CANCELLED: "Cancelled";
  readonly CANCELLING: "Cancelling";
  readonly DELAYED: "Delayed";
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly PENDING: "Pending";
  readonly SUCCESS: "Success";
  readonly TIMED_OUT: "TimedOut";
};
export type CommandInvocationStatus =
  (typeof CommandInvocationStatus)[keyof typeof CommandInvocationStatus];
export interface GetCommandInvocationResult {
  CommandId?: string;
  InstanceId?: string;
  Comment?: string;
  DocumentName?: string;
  DocumentVersion?: string;
  PluginName?: string;
  ResponseCode?: number;
  ExecutionStartDateTime?: string;
  ExecutionElapsedTime?: string;
  ExecutionEndDateTime?: string;
  Status?: CommandInvocationStatus | string;
  StatusDetails?: string;
  StandardOutputContent?: string;
  StandardOutputUrl?: string;
  StandardErrorContent?: string;
  StandardErrorUrl?: string;
  CloudWatchOutputConfig?: CloudWatchOutputConfig;
}
export declare class InvalidPluginName extends __BaseException {
  readonly name: "InvalidPluginName";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidPluginName, __BaseException>);
}
export declare class InvocationDoesNotExist extends __BaseException {
  readonly name: "InvocationDoesNotExist";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvocationDoesNotExist, __BaseException>
  );
}
export interface GetConnectionStatusRequest {
  Target: string | undefined;
}
export declare const ConnectionStatus: {
  readonly CONNECTED: "Connected";
  readonly NOT_CONNECTED: "NotConnected";
};
export type ConnectionStatus =
  (typeof ConnectionStatus)[keyof typeof ConnectionStatus];
export interface GetConnectionStatusResponse {
  Target?: string;
  Status?: ConnectionStatus | string;
}
export interface GetDefaultPatchBaselineRequest {
  OperatingSystem?: OperatingSystem | string;
}
export interface GetDefaultPatchBaselineResult {
  BaselineId?: string;
  OperatingSystem?: OperatingSystem | string;
}
export interface BaselineOverride {
  OperatingSystem?: OperatingSystem | string;
  GlobalFilters?: PatchFilterGroup;
  ApprovalRules?: PatchRuleGroup;
  ApprovedPatches?: string[];
  ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
  RejectedPatches?: string[];
  RejectedPatchesAction?: PatchAction | string;
  ApprovedPatchesEnableNonSecurity?: boolean;
  Sources?: PatchSource[];
}
export interface GetDeployablePatchSnapshotForInstanceRequest {
  InstanceId: string | undefined;
  SnapshotId: string | undefined;
  BaselineOverride?: BaselineOverride;
}
export interface GetDeployablePatchSnapshotForInstanceResult {
  InstanceId?: string;
  SnapshotId?: string;
  SnapshotDownloadUrl?: string;
  Product?: string;
}
export declare class UnsupportedFeatureRequiredException extends __BaseException {
  readonly name: "UnsupportedFeatureRequiredException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedFeatureRequiredException,
      __BaseException
    >
  );
}
export interface GetDocumentRequest {
  Name: string | undefined;
  VersionName?: string;
  DocumentVersion?: string;
  DocumentFormat?: DocumentFormat | string;
}
export declare const AttachmentHashType: {
  readonly SHA256: "Sha256";
};
export type AttachmentHashType =
  (typeof AttachmentHashType)[keyof typeof AttachmentHashType];
export interface AttachmentContent {
  Name?: string;
  Size?: number;
  Hash?: string;
  HashType?: AttachmentHashType | string;
  Url?: string;
}
export interface GetDocumentResult {
  Name?: string;
  CreatedDate?: Date;
  DisplayName?: string;
  VersionName?: string;
  DocumentVersion?: string;
  Status?: DocumentStatus | string;
  StatusInformation?: string;
  Content?: string;
  DocumentType?: DocumentType | string;
  DocumentFormat?: DocumentFormat | string;
  Requires?: DocumentRequires[];
  AttachmentsContent?: AttachmentContent[];
  ReviewStatus?: ReviewStatus | string;
}
export declare const InventoryQueryOperatorType: {
  readonly BEGIN_WITH: "BeginWith";
  readonly EQUAL: "Equal";
  readonly EXISTS: "Exists";
  readonly GREATER_THAN: "GreaterThan";
  readonly LESS_THAN: "LessThan";
  readonly NOT_EQUAL: "NotEqual";
};
export type InventoryQueryOperatorType =
  (typeof InventoryQueryOperatorType)[keyof typeof InventoryQueryOperatorType];
export interface InventoryFilter {
  Key: string | undefined;
  Values: string[] | undefined;
  Type?: InventoryQueryOperatorType | string;
}
export interface InventoryGroup {
  Name: string | undefined;
  Filters: InventoryFilter[] | undefined;
}
export interface ResultAttribute {
  TypeName: string | undefined;
}
export interface InventoryResultItem {
  TypeName: string | undefined;
  SchemaVersion: string | undefined;
  CaptureTime?: string;
  ContentHash?: string;
  Content: Record<string, string>[] | undefined;
}
export interface InventoryResultEntity {
  Id?: string;
  Data?: Record<string, InventoryResultItem>;
}
export interface GetInventoryResult {
  Entities?: InventoryResultEntity[];
  NextToken?: string;
}
export declare class InvalidAggregatorException extends __BaseException {
  readonly name: "InvalidAggregatorException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidAggregatorException, __BaseException>
  );
}
export declare class InvalidInventoryGroupException extends __BaseException {
  readonly name: "InvalidInventoryGroupException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidInventoryGroupException, __BaseException>
  );
}
export declare class InvalidResultAttributeException extends __BaseException {
  readonly name: "InvalidResultAttributeException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidResultAttributeException,
      __BaseException
    >
  );
}
export interface GetInventorySchemaRequest {
  TypeName?: string;
  NextToken?: string;
  MaxResults?: number;
  Aggregator?: boolean;
  SubType?: boolean;
}
export declare const InventoryAttributeDataType: {
  readonly NUMBER: "number";
  readonly STRING: "string";
};
export type InventoryAttributeDataType =
  (typeof InventoryAttributeDataType)[keyof typeof InventoryAttributeDataType];
export interface InventoryItemAttribute {
  Name: string | undefined;
  DataType: InventoryAttributeDataType | string | undefined;
}
export interface InventoryItemSchema {
  TypeName: string | undefined;
  Version?: string;
  Attributes: InventoryItemAttribute[] | undefined;
  DisplayName?: string;
}
export interface GetInventorySchemaResult {
  Schemas?: InventoryItemSchema[];
  NextToken?: string;
}
export interface GetMaintenanceWindowRequest {
  WindowId: string | undefined;
}
export interface GetMaintenanceWindowResult {
  WindowId?: string;
  Name?: string;
  Description?: string;
  StartDate?: string;
  EndDate?: string;
  Schedule?: string;
  ScheduleTimezone?: string;
  ScheduleOffset?: number;
  NextExecutionTime?: string;
  Duration?: number;
  Cutoff?: number;
  AllowUnassociatedTargets?: boolean;
  Enabled?: boolean;
  CreatedDate?: Date;
  ModifiedDate?: Date;
}
export interface GetMaintenanceWindowExecutionRequest {
  WindowExecutionId: string | undefined;
}
export interface GetMaintenanceWindowExecutionResult {
  WindowExecutionId?: string;
  TaskIds?: string[];
  Status?: MaintenanceWindowExecutionStatus | string;
  StatusDetails?: string;
  StartTime?: Date;
  EndTime?: Date;
}
export interface GetMaintenanceWindowExecutionTaskRequest {
  WindowExecutionId: string | undefined;
  TaskId: string | undefined;
}
export interface GetMaintenanceWindowExecutionTaskResult {
  WindowExecutionId?: string;
  TaskExecutionId?: string;
  TaskArn?: string;
  ServiceRole?: string;
  Type?: MaintenanceWindowTaskType | string;
  TaskParameters?: Record<
    string,
    MaintenanceWindowTaskParameterValueExpression
  >[];
  Priority?: number;
  MaxConcurrency?: string;
  MaxErrors?: string;
  Status?: MaintenanceWindowExecutionStatus | string;
  StatusDetails?: string;
  StartTime?: Date;
  EndTime?: Date;
  AlarmConfiguration?: AlarmConfiguration;
  TriggeredAlarms?: AlarmStateInformation[];
}
export interface GetMaintenanceWindowExecutionTaskInvocationRequest {
  WindowExecutionId: string | undefined;
  TaskId: string | undefined;
  InvocationId: string | undefined;
}
export interface GetMaintenanceWindowExecutionTaskInvocationResult {
  WindowExecutionId?: string;
  TaskExecutionId?: string;
  InvocationId?: string;
  ExecutionId?: string;
  TaskType?: MaintenanceWindowTaskType | string;
  Parameters?: string;
  Status?: MaintenanceWindowExecutionStatus | string;
  StatusDetails?: string;
  StartTime?: Date;
  EndTime?: Date;
  OwnerInformation?: string;
  WindowTargetId?: string;
}
export interface GetMaintenanceWindowTaskRequest {
  WindowId: string | undefined;
  WindowTaskId: string | undefined;
}
export interface MaintenanceWindowAutomationParameters {
  DocumentVersion?: string;
  Parameters?: Record<string, string[]>;
}
export interface MaintenanceWindowLambdaParameters {
  ClientContext?: string;
  Qualifier?: string;
  Payload?: Uint8Array;
}
export declare const NotificationEvent: {
  readonly ALL: "All";
  readonly CANCELLED: "Cancelled";
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly SUCCESS: "Success";
  readonly TIMED_OUT: "TimedOut";
};
export type NotificationEvent =
  (typeof NotificationEvent)[keyof typeof NotificationEvent];
export declare const NotificationType: {
  readonly Command: "Command";
  readonly Invocation: "Invocation";
};
export type NotificationType =
  (typeof NotificationType)[keyof typeof NotificationType];
export interface NotificationConfig {
  NotificationArn?: string;
  NotificationEvents?: (NotificationEvent | string)[];
  NotificationType?: NotificationType | string;
}
export interface MaintenanceWindowRunCommandParameters {
  Comment?: string;
  CloudWatchOutputConfig?: CloudWatchOutputConfig;
  DocumentHash?: string;
  DocumentHashType?: DocumentHashType | string;
  DocumentVersion?: string;
  NotificationConfig?: NotificationConfig;
  OutputS3BucketName?: string;
  OutputS3KeyPrefix?: string;
  Parameters?: Record<string, string[]>;
  ServiceRoleArn?: string;
  TimeoutSeconds?: number;
}
export interface MaintenanceWindowStepFunctionsParameters {
  Input?: string;
  Name?: string;
}
export interface MaintenanceWindowTaskInvocationParameters {
  RunCommand?: MaintenanceWindowRunCommandParameters;
  Automation?: MaintenanceWindowAutomationParameters;
  StepFunctions?: MaintenanceWindowStepFunctionsParameters;
  Lambda?: MaintenanceWindowLambdaParameters;
}
export interface GetMaintenanceWindowTaskResult {
  WindowId?: string;
  WindowTaskId?: string;
  Targets?: Target[];
  TaskArn?: string;
  ServiceRoleArn?: string;
  TaskType?: MaintenanceWindowTaskType | string;
  TaskParameters?: Record<
    string,
    MaintenanceWindowTaskParameterValueExpression
  >;
  TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
  Priority?: number;
  MaxConcurrency?: string;
  MaxErrors?: string;
  LoggingInfo?: LoggingInfo;
  Name?: string;
  Description?: string;
  CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
  AlarmConfiguration?: AlarmConfiguration;
}
export interface GetOpsItemRequest {
  OpsItemId: string | undefined;
  OpsItemArn?: string;
}
export interface OpsItem {
  CreatedBy?: string;
  OpsItemType?: string;
  CreatedTime?: Date;
  Description?: string;
  LastModifiedBy?: string;
  LastModifiedTime?: Date;
  Notifications?: OpsItemNotification[];
  Priority?: number;
  RelatedOpsItems?: RelatedOpsItem[];
  Status?: OpsItemStatus | string;
  OpsItemId?: string;
  Version?: string;
  Title?: string;
  Source?: string;
  OperationalData?: Record<string, OpsItemDataValue>;
  Category?: string;
  Severity?: string;
  ActualStartTime?: Date;
  ActualEndTime?: Date;
  PlannedStartTime?: Date;
  PlannedEndTime?: Date;
  OpsItemArn?: string;
}
export interface GetOpsItemResponse {
  OpsItem?: OpsItem;
}
export interface GetOpsMetadataRequest {
  OpsMetadataArn: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface GetOpsMetadataResult {
  ResourceId?: string;
  Metadata?: Record<string, MetadataValue>;
  NextToken?: string;
}
export declare const OpsFilterOperatorType: {
  readonly BEGIN_WITH: "BeginWith";
  readonly EQUAL: "Equal";
  readonly EXISTS: "Exists";
  readonly GREATER_THAN: "GreaterThan";
  readonly LESS_THAN: "LessThan";
  readonly NOT_EQUAL: "NotEqual";
};
export type OpsFilterOperatorType =
  (typeof OpsFilterOperatorType)[keyof typeof OpsFilterOperatorType];
export interface OpsFilter {
  Key: string | undefined;
  Values: string[] | undefined;
  Type?: OpsFilterOperatorType | string;
}
export interface OpsResultAttribute {
  TypeName: string | undefined;
}
export interface OpsEntityItem {
  CaptureTime?: string;
  Content?: Record<string, string>[];
}
export interface OpsEntity {
  Id?: string;
  Data?: Record<string, OpsEntityItem>;
}
export interface GetOpsSummaryResult {
  Entities?: OpsEntity[];
  NextToken?: string;
}
export interface GetParameterRequest {
  Name: string | undefined;
  WithDecryption?: boolean;
}
export interface Parameter {
  Name?: string;
  Type?: ParameterType | string;
  Value?: string;
  Version?: number;
  Selector?: string;
  SourceResult?: string;
  LastModifiedDate?: Date;
  ARN?: string;
  DataType?: string;
}
export interface GetParameterResult {
  Parameter?: Parameter;
}
export declare class InvalidKeyId extends __BaseException {
  readonly name: "InvalidKeyId";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidKeyId, __BaseException>);
}
export declare class ParameterVersionNotFound extends __BaseException {
  readonly name: "ParameterVersionNotFound";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ParameterVersionNotFound, __BaseException>
  );
}
export interface GetParameterHistoryRequest {
  Name: string | undefined;
  WithDecryption?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface ParameterHistory {
  Name?: string;
  Type?: ParameterType | string;
  KeyId?: string;
  LastModifiedDate?: Date;
  LastModifiedUser?: string;
  Description?: string;
  Value?: string;
  AllowedPattern?: string;
  Version?: number;
  Labels?: string[];
  Tier?: ParameterTier | string;
  Policies?: ParameterInlinePolicy[];
  DataType?: string;
}
export interface GetParameterHistoryResult {
  Parameters?: ParameterHistory[];
  NextToken?: string;
}
export interface GetParametersRequest {
  Names: string[] | undefined;
  WithDecryption?: boolean;
}
export interface GetParametersResult {
  Parameters?: Parameter[];
  InvalidParameters?: string[];
}
export interface GetParametersByPathRequest {
  Path: string | undefined;
  Recursive?: boolean;
  ParameterFilters?: ParameterStringFilter[];
  WithDecryption?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface GetParametersByPathResult {
  Parameters?: Parameter[];
  NextToken?: string;
}
export interface GetPatchBaselineRequest {
  BaselineId: string | undefined;
}
export interface GetPatchBaselineResult {
  BaselineId?: string;
  Name?: string;
  OperatingSystem?: OperatingSystem | string;
  GlobalFilters?: PatchFilterGroup;
  ApprovalRules?: PatchRuleGroup;
  ApprovedPatches?: string[];
  ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
  ApprovedPatchesEnableNonSecurity?: boolean;
  RejectedPatches?: string[];
  RejectedPatchesAction?: PatchAction | string;
  PatchGroups?: string[];
  CreatedDate?: Date;
  ModifiedDate?: Date;
  Description?: string;
  Sources?: PatchSource[];
}
export interface GetPatchBaselineForPatchGroupRequest {
  PatchGroup: string | undefined;
  OperatingSystem?: OperatingSystem | string;
}
export interface GetPatchBaselineForPatchGroupResult {
  BaselineId?: string;
  PatchGroup?: string;
  OperatingSystem?: OperatingSystem | string;
}
export interface GetResourcePoliciesRequest {
  ResourceArn: string | undefined;
  NextToken?: string;
  MaxResults?: number;
}
export interface GetResourcePoliciesResponseEntry {
  PolicyId?: string;
  PolicyHash?: string;
  Policy?: string;
}
export interface GetResourcePoliciesResponse {
  NextToken?: string;
  Policies?: GetResourcePoliciesResponseEntry[];
}
export interface GetServiceSettingRequest {
  SettingId: string | undefined;
}
export interface ServiceSetting {
  SettingId?: string;
  SettingValue?: string;
  LastModifiedDate?: Date;
  LastModifiedUser?: string;
  ARN?: string;
  Status?: string;
}
export interface GetServiceSettingResult {
  ServiceSetting?: ServiceSetting;
}
export declare class ServiceSettingNotFound extends __BaseException {
  readonly name: "ServiceSettingNotFound";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceSettingNotFound, __BaseException>
  );
}
export interface LabelParameterVersionRequest {
  Name: string | undefined;
  ParameterVersion?: number;
  Labels: string[] | undefined;
}
export interface LabelParameterVersionResult {
  InvalidLabels?: string[];
  ParameterVersion?: number;
}
export declare class ParameterVersionLabelLimitExceeded extends __BaseException {
  readonly name: "ParameterVersionLabelLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ParameterVersionLabelLimitExceeded,
      __BaseException
    >
  );
}
export declare const AssociationFilterKey: {
  readonly AssociationId: "AssociationId";
  readonly AssociationName: "AssociationName";
  readonly InstanceId: "InstanceId";
  readonly LastExecutedAfter: "LastExecutedAfter";
  readonly LastExecutedBefore: "LastExecutedBefore";
  readonly Name: "Name";
  readonly ResourceGroupName: "ResourceGroupName";
  readonly Status: "AssociationStatusName";
};
export type AssociationFilterKey =
  (typeof AssociationFilterKey)[keyof typeof AssociationFilterKey];
export interface AssociationFilter {
  key: AssociationFilterKey | string | undefined;
  value: string | undefined;
}
export interface ListAssociationsRequest {
  AssociationFilterList?: AssociationFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface Association {
  Name?: string;
  InstanceId?: string;
  AssociationId?: string;
  AssociationVersion?: string;
  DocumentVersion?: string;
  Targets?: Target[];
  LastExecutionDate?: Date;
  Overview?: AssociationOverview;
  ScheduleExpression?: string;
  AssociationName?: string;
  ScheduleOffset?: number;
  TargetMaps?: Record<string, string[]>[];
}
export interface ListAssociationsResult {
  Associations?: Association[];
  NextToken?: string;
}
export interface ListAssociationVersionsRequest {
  AssociationId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface AssociationVersionInfo {
  AssociationId?: string;
  AssociationVersion?: string;
  CreatedDate?: Date;
  Name?: string;
  DocumentVersion?: string;
  Parameters?: Record<string, string[]>;
  Targets?: Target[];
  ScheduleExpression?: string;
  OutputLocation?: InstanceAssociationOutputLocation;
  AssociationName?: string;
  MaxErrors?: string;
  MaxConcurrency?: string;
  ComplianceSeverity?: AssociationComplianceSeverity | string;
  SyncCompliance?: AssociationSyncCompliance | string;
  ApplyOnlyAtCronInterval?: boolean;
  CalendarNames?: string[];
  TargetLocations?: TargetLocation[];
  ScheduleOffset?: number;
  TargetMaps?: Record<string, string[]>[];
}
export interface ListAssociationVersionsResult {
  AssociationVersions?: AssociationVersionInfo[];
  NextToken?: string;
}
export declare const CommandFilterKey: {
  readonly DOCUMENT_NAME: "DocumentName";
  readonly EXECUTION_STAGE: "ExecutionStage";
  readonly INVOKED_AFTER: "InvokedAfter";
  readonly INVOKED_BEFORE: "InvokedBefore";
  readonly STATUS: "Status";
};
export type CommandFilterKey =
  (typeof CommandFilterKey)[keyof typeof CommandFilterKey];
export interface CommandFilter {
  key: CommandFilterKey | string | undefined;
  value: string | undefined;
}
export interface ListCommandInvocationsRequest {
  CommandId?: string;
  InstanceId?: string;
  MaxResults?: number;
  NextToken?: string;
  Filters?: CommandFilter[];
  Details?: boolean;
}
export declare const CommandPluginStatus: {
  readonly CANCELLED: "Cancelled";
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly PENDING: "Pending";
  readonly SUCCESS: "Success";
  readonly TIMED_OUT: "TimedOut";
};
export type CommandPluginStatus =
  (typeof CommandPluginStatus)[keyof typeof CommandPluginStatus];
export interface CommandPlugin {
  Name?: string;
  Status?: CommandPluginStatus | string;
  StatusDetails?: string;
  ResponseCode?: number;
  ResponseStartDateTime?: Date;
  ResponseFinishDateTime?: Date;
  Output?: string;
  StandardOutputUrl?: string;
  StandardErrorUrl?: string;
  OutputS3Region?: string;
  OutputS3BucketName?: string;
  OutputS3KeyPrefix?: string;
}
export interface CommandInvocation {
  CommandId?: string;
  InstanceId?: string;
  InstanceName?: string;
  Comment?: string;
  DocumentName?: string;
  DocumentVersion?: string;
  RequestedDateTime?: Date;
  Status?: CommandInvocationStatus | string;
  StatusDetails?: string;
  TraceOutput?: string;
  StandardOutputUrl?: string;
  StandardErrorUrl?: string;
  CommandPlugins?: CommandPlugin[];
  ServiceRole?: string;
  NotificationConfig?: NotificationConfig;
  CloudWatchOutputConfig?: CloudWatchOutputConfig;
}
export interface ListCommandInvocationsResult {
  CommandInvocations?: CommandInvocation[];
  NextToken?: string;
}
export interface ListCommandsRequest {
  CommandId?: string;
  InstanceId?: string;
  MaxResults?: number;
  NextToken?: string;
  Filters?: CommandFilter[];
}
export declare const CommandStatus: {
  readonly CANCELLED: "Cancelled";
  readonly CANCELLING: "Cancelling";
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly PENDING: "Pending";
  readonly SUCCESS: "Success";
  readonly TIMED_OUT: "TimedOut";
};
export type CommandStatus = (typeof CommandStatus)[keyof typeof CommandStatus];
export interface Command {
  CommandId?: string;
  DocumentName?: string;
  DocumentVersion?: string;
  Comment?: string;
  ExpiresAfter?: Date;
  Parameters?: Record<string, string[]>;
  InstanceIds?: string[];
  Targets?: Target[];
  RequestedDateTime?: Date;
  Status?: CommandStatus | string;
  StatusDetails?: string;
  OutputS3Region?: string;
  OutputS3BucketName?: string;
  OutputS3KeyPrefix?: string;
  MaxConcurrency?: string;
  MaxErrors?: string;
  TargetCount?: number;
  CompletedCount?: number;
  ErrorCount?: number;
  DeliveryTimedOutCount?: number;
  ServiceRole?: string;
  NotificationConfig?: NotificationConfig;
  CloudWatchOutputConfig?: CloudWatchOutputConfig;
  TimeoutSeconds?: number;
  AlarmConfiguration?: AlarmConfiguration;
  TriggeredAlarms?: AlarmStateInformation[];
}
export interface ListCommandsResult {
  Commands?: Command[];
  NextToken?: string;
}
export declare const ComplianceQueryOperatorType: {
  readonly BeginWith: "BEGIN_WITH";
  readonly Equal: "EQUAL";
  readonly GreaterThan: "GREATER_THAN";
  readonly LessThan: "LESS_THAN";
  readonly NotEqual: "NOT_EQUAL";
};
export type ComplianceQueryOperatorType =
  (typeof ComplianceQueryOperatorType)[keyof typeof ComplianceQueryOperatorType];
export interface ComplianceStringFilter {
  Key?: string;
  Values?: string[];
  Type?: ComplianceQueryOperatorType | string;
}
export interface ListComplianceItemsRequest {
  Filters?: ComplianceStringFilter[];
  ResourceIds?: string[];
  ResourceTypes?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface ComplianceExecutionSummary {
  ExecutionTime: Date | undefined;
  ExecutionId?: string;
  ExecutionType?: string;
}
export declare const ComplianceSeverity: {
  readonly Critical: "CRITICAL";
  readonly High: "HIGH";
  readonly Informational: "INFORMATIONAL";
  readonly Low: "LOW";
  readonly Medium: "MEDIUM";
  readonly Unspecified: "UNSPECIFIED";
};
export type ComplianceSeverity =
  (typeof ComplianceSeverity)[keyof typeof ComplianceSeverity];
export declare const ComplianceStatus: {
  readonly Compliant: "COMPLIANT";
  readonly NonCompliant: "NON_COMPLIANT";
};
export type ComplianceStatus =
  (typeof ComplianceStatus)[keyof typeof ComplianceStatus];
export interface ComplianceItem {
  ComplianceType?: string;
  ResourceType?: string;
  ResourceId?: string;
  Id?: string;
  Title?: string;
  Status?: ComplianceStatus | string;
  Severity?: ComplianceSeverity | string;
  ExecutionSummary?: ComplianceExecutionSummary;
  Details?: Record<string, string>;
}
export interface ListComplianceItemsResult {
  ComplianceItems?: ComplianceItem[];
  NextToken?: string;
}
export interface ListComplianceSummariesRequest {
  Filters?: ComplianceStringFilter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface SeveritySummary {
  CriticalCount?: number;
  HighCount?: number;
  MediumCount?: number;
  LowCount?: number;
  InformationalCount?: number;
  UnspecifiedCount?: number;
}
export interface CompliantSummary {
  CompliantCount?: number;
  SeveritySummary?: SeveritySummary;
}
export interface NonCompliantSummary {
  NonCompliantCount?: number;
  SeveritySummary?: SeveritySummary;
}
export interface ComplianceSummaryItem {
  ComplianceType?: string;
  CompliantSummary?: CompliantSummary;
  NonCompliantSummary?: NonCompliantSummary;
}
export interface ListComplianceSummariesResult {
  ComplianceSummaryItems?: ComplianceSummaryItem[];
  NextToken?: string;
}
export declare const DocumentMetadataEnum: {
  readonly DocumentReviews: "DocumentReviews";
};
export type DocumentMetadataEnum =
  (typeof DocumentMetadataEnum)[keyof typeof DocumentMetadataEnum];
export interface ListDocumentMetadataHistoryRequest {
  Name: string | undefined;
  DocumentVersion?: string;
  Metadata: DocumentMetadataEnum | string | undefined;
  NextToken?: string;
  MaxResults?: number;
}
export declare const DocumentReviewCommentType: {
  readonly Comment: "Comment";
};
export type DocumentReviewCommentType =
  (typeof DocumentReviewCommentType)[keyof typeof DocumentReviewCommentType];
export interface DocumentReviewCommentSource {
  Type?: DocumentReviewCommentType | string;
  Content?: string;
}
export interface DocumentReviewerResponseSource {
  CreateTime?: Date;
  UpdatedTime?: Date;
  ReviewStatus?: ReviewStatus | string;
  Comment?: DocumentReviewCommentSource[];
  Reviewer?: string;
}
export interface DocumentMetadataResponseInfo {
  ReviewerResponse?: DocumentReviewerResponseSource[];
}
export interface ListDocumentMetadataHistoryResponse {
  Name?: string;
  DocumentVersion?: string;
  Author?: string;
  Metadata?: DocumentMetadataResponseInfo;
  NextToken?: string;
}
export declare const DocumentFilterKey: {
  readonly DocumentType: "DocumentType";
  readonly Name: "Name";
  readonly Owner: "Owner";
  readonly PlatformTypes: "PlatformTypes";
};
export type DocumentFilterKey =
  (typeof DocumentFilterKey)[keyof typeof DocumentFilterKey];
export interface DocumentFilter {
  key: DocumentFilterKey | string | undefined;
  value: string | undefined;
}
export interface DocumentKeyValuesFilter {
  Key?: string;
  Values?: string[];
}
export interface ListDocumentsRequest {
  DocumentFilterList?: DocumentFilter[];
  Filters?: DocumentKeyValuesFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DocumentIdentifier {
  Name?: string;
  CreatedDate?: Date;
  DisplayName?: string;
  Owner?: string;
  VersionName?: string;
  PlatformTypes?: (PlatformType | string)[];
  DocumentVersion?: string;
  DocumentType?: DocumentType | string;
  SchemaVersion?: string;
  DocumentFormat?: DocumentFormat | string;
  TargetType?: string;
  Tags?: Tag[];
  Requires?: DocumentRequires[];
  ReviewStatus?: ReviewStatus | string;
  Author?: string;
}
export interface ListDocumentsResult {
  DocumentIdentifiers?: DocumentIdentifier[];
  NextToken?: string;
}
export interface ListDocumentVersionsRequest {
  Name: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface DocumentVersionInfo {
  Name?: string;
  DisplayName?: string;
  DocumentVersion?: string;
  VersionName?: string;
  CreatedDate?: Date;
  IsDefaultVersion?: boolean;
  DocumentFormat?: DocumentFormat | string;
  Status?: DocumentStatus | string;
  StatusInformation?: string;
  ReviewStatus?: ReviewStatus | string;
}
export interface ListDocumentVersionsResult {
  DocumentVersions?: DocumentVersionInfo[];
  NextToken?: string;
}
export interface ListInventoryEntriesRequest {
  InstanceId: string | undefined;
  TypeName: string | undefined;
  Filters?: InventoryFilter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface ListInventoryEntriesResult {
  TypeName?: string;
  InstanceId?: string;
  SchemaVersion?: string;
  CaptureTime?: string;
  Entries?: Record<string, string>[];
  NextToken?: string;
}
export declare const OpsItemEventFilterKey: {
  readonly OPSITEM_ID: "OpsItemId";
};
export type OpsItemEventFilterKey =
  (typeof OpsItemEventFilterKey)[keyof typeof OpsItemEventFilterKey];
export declare const OpsItemEventFilterOperator: {
  readonly EQUAL: "Equal";
};
export type OpsItemEventFilterOperator =
  (typeof OpsItemEventFilterOperator)[keyof typeof OpsItemEventFilterOperator];
export interface OpsItemEventFilter {
  Key: OpsItemEventFilterKey | string | undefined;
  Values: string[] | undefined;
  Operator: OpsItemEventFilterOperator | string | undefined;
}
export interface ListOpsItemEventsRequest {
  Filters?: OpsItemEventFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface OpsItemIdentity {
  Arn?: string;
}
export interface OpsItemEventSummary {
  OpsItemId?: string;
  EventId?: string;
  Source?: string;
  DetailType?: string;
  Detail?: string;
  CreatedBy?: OpsItemIdentity;
  CreatedTime?: Date;
}
export interface ListOpsItemEventsResponse {
  NextToken?: string;
  Summaries?: OpsItemEventSummary[];
}
export declare const OpsItemRelatedItemsFilterKey: {
  readonly ASSOCIATION_ID: "AssociationId";
  readonly RESOURCE_TYPE: "ResourceType";
  readonly RESOURCE_URI: "ResourceUri";
};
export type OpsItemRelatedItemsFilterKey =
  (typeof OpsItemRelatedItemsFilterKey)[keyof typeof OpsItemRelatedItemsFilterKey];
export declare const OpsItemRelatedItemsFilterOperator: {
  readonly EQUAL: "Equal";
};
export type OpsItemRelatedItemsFilterOperator =
  (typeof OpsItemRelatedItemsFilterOperator)[keyof typeof OpsItemRelatedItemsFilterOperator];
export interface OpsItemRelatedItemsFilter {
  Key: OpsItemRelatedItemsFilterKey | string | undefined;
  Values: string[] | undefined;
  Operator: OpsItemRelatedItemsFilterOperator | string | undefined;
}
export interface ListOpsItemRelatedItemsRequest {
  OpsItemId?: string;
  Filters?: OpsItemRelatedItemsFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface OpsItemRelatedItemSummary {
  OpsItemId?: string;
  AssociationId?: string;
  ResourceType?: string;
  AssociationType?: string;
  ResourceUri?: string;
  CreatedBy?: OpsItemIdentity;
  CreatedTime?: Date;
  LastModifiedBy?: OpsItemIdentity;
  LastModifiedTime?: Date;
}
export interface ListOpsItemRelatedItemsResponse {
  NextToken?: string;
  Summaries?: OpsItemRelatedItemSummary[];
}
export interface OpsMetadataFilter {
  Key: string | undefined;
  Values: string[] | undefined;
}
export interface ListOpsMetadataRequest {
  Filters?: OpsMetadataFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface OpsMetadata {
  ResourceId?: string;
  OpsMetadataArn?: string;
  LastModifiedDate?: Date;
  LastModifiedUser?: string;
  CreationDate?: Date;
}
export interface ListOpsMetadataResult {
  OpsMetadataList?: OpsMetadata[];
  NextToken?: string;
}
export interface ListResourceComplianceSummariesRequest {
  Filters?: ComplianceStringFilter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface ResourceComplianceSummaryItem {
  ComplianceType?: string;
  ResourceType?: string;
  ResourceId?: string;
  Status?: ComplianceStatus | string;
  OverallSeverity?: ComplianceSeverity | string;
  ExecutionSummary?: ComplianceExecutionSummary;
  CompliantSummary?: CompliantSummary;
  NonCompliantSummary?: NonCompliantSummary;
}
export interface ListResourceComplianceSummariesResult {
  ResourceComplianceSummaryItems?: ResourceComplianceSummaryItem[];
  NextToken?: string;
}
export interface ListResourceDataSyncRequest {
  SyncType?: string;
  NextToken?: string;
  MaxResults?: number;
}
export declare const LastResourceDataSyncStatus: {
  readonly FAILED: "Failed";
  readonly INPROGRESS: "InProgress";
  readonly SUCCESSFUL: "Successful";
};
export type LastResourceDataSyncStatus =
  (typeof LastResourceDataSyncStatus)[keyof typeof LastResourceDataSyncStatus];
export interface ResourceDataSyncSourceWithState {
  SourceType?: string;
  AwsOrganizationsSource?: ResourceDataSyncAwsOrganizationsSource;
  SourceRegions?: string[];
  IncludeFutureRegions?: boolean;
  State?: string;
  EnableAllOpsDataSources?: boolean;
}
export interface ResourceDataSyncItem {
  SyncName?: string;
  SyncType?: string;
  SyncSource?: ResourceDataSyncSourceWithState;
  S3Destination?: ResourceDataSyncS3Destination;
  LastSyncTime?: Date;
  LastSuccessfulSyncTime?: Date;
  SyncLastModifiedTime?: Date;
  LastStatus?: LastResourceDataSyncStatus | string;
  SyncCreatedTime?: Date;
  LastSyncStatusMessage?: string;
}
export interface ListResourceDataSyncResult {
  ResourceDataSyncItems?: ResourceDataSyncItem[];
  NextToken?: string;
}
export interface ListTagsForResourceRequest {
  ResourceType: ResourceTypeForTagging | string | undefined;
  ResourceId: string | undefined;
}
export interface ListTagsForResourceResult {
  TagList?: Tag[];
}
export declare class DocumentPermissionLimit extends __BaseException {
  readonly name: "DocumentPermissionLimit";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<DocumentPermissionLimit, __BaseException>
  );
}
export interface ModifyDocumentPermissionRequest {
  Name: string | undefined;
  PermissionType: DocumentPermissionType | string | undefined;
  AccountIdsToAdd?: string[];
  AccountIdsToRemove?: string[];
  SharedDocumentVersion?: string;
}
export interface ModifyDocumentPermissionResponse {}
export declare class ComplianceTypeCountLimitExceededException extends __BaseException {
  readonly name: "ComplianceTypeCountLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ComplianceTypeCountLimitExceededException,
      __BaseException
    >
  );
}
export declare class InvalidItemContentException extends __BaseException {
  readonly name: "InvalidItemContentException";
  readonly $fault: "client";
  TypeName?: string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidItemContentException, __BaseException>
  );
}
export declare class ItemSizeLimitExceededException extends __BaseException {
  readonly name: "ItemSizeLimitExceededException";
  readonly $fault: "client";
  TypeName?: string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ItemSizeLimitExceededException, __BaseException>
  );
}
export interface ComplianceItemEntry {
  Id?: string;
  Title?: string;
  Severity: ComplianceSeverity | string | undefined;
  Status: ComplianceStatus | string | undefined;
  Details?: Record<string, string>;
}
export declare const ComplianceUploadType: {
  readonly Complete: "COMPLETE";
  readonly Partial: "PARTIAL";
};
export type ComplianceUploadType =
  (typeof ComplianceUploadType)[keyof typeof ComplianceUploadType];
export interface PutComplianceItemsRequest {
  ResourceId: string | undefined;
  ResourceType: string | undefined;
  ComplianceType: string | undefined;
  ExecutionSummary: ComplianceExecutionSummary | undefined;
  Items: ComplianceItemEntry[] | undefined;
  ItemContentHash?: string;
  UploadType?: ComplianceUploadType | string;
}
export interface PutComplianceItemsResult {}
export declare class TotalSizeLimitExceededException extends __BaseException {
  readonly name: "TotalSizeLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      TotalSizeLimitExceededException,
      __BaseException
    >
  );
}
export declare class CustomSchemaCountLimitExceededException extends __BaseException {
  readonly name: "CustomSchemaCountLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      CustomSchemaCountLimitExceededException,
      __BaseException
    >
  );
}
export declare class InvalidInventoryItemContextException extends __BaseException {
  readonly name: "InvalidInventoryItemContextException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidInventoryItemContextException,
      __BaseException
    >
  );
}
export declare class ItemContentMismatchException extends __BaseException {
  readonly name: "ItemContentMismatchException";
  readonly $fault: "client";
  TypeName?: string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ItemContentMismatchException, __BaseException>
  );
}
export interface InventoryItem {
  TypeName: string | undefined;
  SchemaVersion: string | undefined;
  CaptureTime: string | undefined;
  ContentHash?: string;
  Content?: Record<string, string>[];
  Context?: Record<string, string>;
}
export interface PutInventoryRequest {
  InstanceId: string | undefined;
  Items: InventoryItem[] | undefined;
}
export interface PutInventoryResult {
  Message?: string;
}
export declare class SubTypeCountLimitExceededException extends __BaseException {
  readonly name: "SubTypeCountLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      SubTypeCountLimitExceededException,
      __BaseException
    >
  );
}
export declare class UnsupportedInventoryItemContextException extends __BaseException {
  readonly name: "UnsupportedInventoryItemContextException";
  readonly $fault: "client";
  TypeName?: string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedInventoryItemContextException,
      __BaseException
    >
  );
}
export declare class UnsupportedInventorySchemaVersionException extends __BaseException {
  readonly name: "UnsupportedInventorySchemaVersionException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedInventorySchemaVersionException,
      __BaseException
    >
  );
}
export declare class HierarchyLevelLimitExceededException extends __BaseException {
  readonly name: "HierarchyLevelLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      HierarchyLevelLimitExceededException,
      __BaseException
    >
  );
}
export declare class HierarchyTypeMismatchException extends __BaseException {
  readonly name: "HierarchyTypeMismatchException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<HierarchyTypeMismatchException, __BaseException>
  );
}
export declare class IncompatiblePolicyException extends __BaseException {
  readonly name: "IncompatiblePolicyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IncompatiblePolicyException, __BaseException>
  );
}
export declare class InvalidAllowedPatternException extends __BaseException {
  readonly name: "InvalidAllowedPatternException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidAllowedPatternException, __BaseException>
  );
}
export declare class InvalidPolicyAttributeException extends __BaseException {
  readonly name: "InvalidPolicyAttributeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidPolicyAttributeException,
      __BaseException
    >
  );
}
export declare class InvalidPolicyTypeException extends __BaseException {
  readonly name: "InvalidPolicyTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidPolicyTypeException, __BaseException>
  );
}
export declare class ParameterAlreadyExists extends __BaseException {
  readonly name: "ParameterAlreadyExists";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ParameterAlreadyExists, __BaseException>
  );
}
export declare class ParameterLimitExceeded extends __BaseException {
  readonly name: "ParameterLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ParameterLimitExceeded, __BaseException>
  );
}
export declare class ParameterMaxVersionLimitExceeded extends __BaseException {
  readonly name: "ParameterMaxVersionLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ParameterMaxVersionLimitExceeded,
      __BaseException
    >
  );
}
export declare class ParameterPatternMismatchException extends __BaseException {
  readonly name: "ParameterPatternMismatchException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ParameterPatternMismatchException,
      __BaseException
    >
  );
}
export declare class PoliciesLimitExceededException extends __BaseException {
  readonly name: "PoliciesLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PoliciesLimitExceededException, __BaseException>
  );
}
export interface PutParameterRequest {
  Name: string | undefined;
  Description?: string;
  Value: string | undefined;
  Type?: ParameterType | string;
  KeyId?: string;
  Overwrite?: boolean;
  AllowedPattern?: string;
  Tags?: Tag[];
  Tier?: ParameterTier | string;
  Policies?: string;
  DataType?: string;
}
export interface PutParameterResult {
  Version?: number;
  Tier?: ParameterTier | string;
}
export declare class UnsupportedParameterType extends __BaseException {
  readonly name: "UnsupportedParameterType";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnsupportedParameterType, __BaseException>
  );
}
export interface PutResourcePolicyRequest {
  ResourceArn: string | undefined;
  Policy: string | undefined;
  PolicyId?: string;
  PolicyHash?: string;
}
export interface PutResourcePolicyResponse {
  PolicyId?: string;
  PolicyHash?: string;
}
export declare class ResourcePolicyLimitExceededException extends __BaseException {
  readonly name: "ResourcePolicyLimitExceededException";
  readonly $fault: "client";
  Limit?: number;
  LimitType?: string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourcePolicyLimitExceededException,
      __BaseException
    >
  );
}
export interface RegisterDefaultPatchBaselineRequest {
  BaselineId: string | undefined;
}
export interface RegisterDefaultPatchBaselineResult {
  BaselineId?: string;
}
export interface RegisterPatchBaselineForPatchGroupRequest {
  BaselineId: string | undefined;
  PatchGroup: string | undefined;
}
export interface RegisterPatchBaselineForPatchGroupResult {
  BaselineId?: string;
  PatchGroup?: string;
}
export interface RegisterTargetWithMaintenanceWindowRequest {
  WindowId: string | undefined;
  ResourceType: MaintenanceWindowResourceType | string | undefined;
  Targets: Target[] | undefined;
  OwnerInformation?: string;
  Name?: string;
  Description?: string;
  ClientToken?: string;
}
export interface RegisterTargetWithMaintenanceWindowResult {
  WindowTargetId?: string;
}
export declare class FeatureNotAvailableException extends __BaseException {
  readonly name: "FeatureNotAvailableException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<FeatureNotAvailableException, __BaseException>
  );
}
export interface RegisterTaskWithMaintenanceWindowRequest {
  WindowId: string | undefined;
  Targets?: Target[];
  TaskArn: string | undefined;
  ServiceRoleArn?: string;
  TaskType: MaintenanceWindowTaskType | string | undefined;
  TaskParameters?: Record<
    string,
    MaintenanceWindowTaskParameterValueExpression
  >;
  TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
  Priority?: number;
  MaxConcurrency?: string;
  MaxErrors?: string;
  LoggingInfo?: LoggingInfo;
  Name?: string;
  Description?: string;
  ClientToken?: string;
  CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
  AlarmConfiguration?: AlarmConfiguration;
}
export interface RegisterTaskWithMaintenanceWindowResult {
  WindowTaskId?: string;
}
export interface RemoveTagsFromResourceRequest {
  ResourceType: ResourceTypeForTagging | string | undefined;
  ResourceId: string | undefined;
  TagKeys: string[] | undefined;
}
export interface RemoveTagsFromResourceResult {}
export interface ResetServiceSettingRequest {
  SettingId: string | undefined;
}
export interface ResetServiceSettingResult {
  ServiceSetting?: ServiceSetting;
}
export interface ResumeSessionRequest {
  SessionId: string | undefined;
}
export interface ResumeSessionResponse {
  SessionId?: string;
  TokenValue?: string;
  StreamUrl?: string;
}
export declare class AutomationStepNotFoundException extends __BaseException {
  readonly name: "AutomationStepNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AutomationStepNotFoundException,
      __BaseException
    >
  );
}
export declare class InvalidAutomationSignalException extends __BaseException {
  readonly name: "InvalidAutomationSignalException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidAutomationSignalException,
      __BaseException
    >
  );
}
export declare const SignalType: {
  readonly APPROVE: "Approve";
  readonly REJECT: "Reject";
  readonly RESUME: "Resume";
  readonly START_STEP: "StartStep";
  readonly STOP_STEP: "StopStep";
};
export type SignalType = (typeof SignalType)[keyof typeof SignalType];
export interface SendAutomationSignalRequest {
  AutomationExecutionId: string | undefined;
  SignalType: SignalType | string | undefined;
  Payload?: Record<string, string[]>;
}
export interface SendAutomationSignalResult {}
export declare class InvalidNotificationConfig extends __BaseException {
  readonly name: "InvalidNotificationConfig";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidNotificationConfig, __BaseException>
  );
}
export declare class InvalidOutputFolder extends __BaseException {
  readonly name: "InvalidOutputFolder";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOutputFolder, __BaseException>
  );
}
export declare class InvalidRole extends __BaseException {
  readonly name: "InvalidRole";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidRole, __BaseException>);
}
export interface SendCommandRequest {
  InstanceIds?: string[];
  Targets?: Target[];
  DocumentName: string | undefined;
  DocumentVersion?: string;
  DocumentHash?: string;
  DocumentHashType?: DocumentHashType | string;
  TimeoutSeconds?: number;
  Comment?: string;
  Parameters?: Record<string, string[]>;
  OutputS3Region?: string;
  OutputS3BucketName?: string;
  OutputS3KeyPrefix?: string;
  MaxConcurrency?: string;
  MaxErrors?: string;
  ServiceRoleArn?: string;
  NotificationConfig?: NotificationConfig;
  CloudWatchOutputConfig?: CloudWatchOutputConfig;
  AlarmConfiguration?: AlarmConfiguration;
}
export interface SendCommandResult {
  Command?: Command;
}
export declare class InvalidAssociation extends __BaseException {
  readonly name: "InvalidAssociation";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidAssociation, __BaseException>);
}
export interface StartAssociationsOnceRequest {
  AssociationIds: string[] | undefined;
}
export interface StartAssociationsOnceResult {}
export declare class AutomationDefinitionNotFoundException extends __BaseException {
  readonly name: "AutomationDefinitionNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AutomationDefinitionNotFoundException,
      __BaseException
    >
  );
}
export declare class AutomationDefinitionVersionNotFoundException extends __BaseException {
  readonly name: "AutomationDefinitionVersionNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AutomationDefinitionVersionNotFoundException,
      __BaseException
    >
  );
}
export declare class AutomationExecutionLimitExceededException extends __BaseException {
  readonly name: "AutomationExecutionLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AutomationExecutionLimitExceededException,
      __BaseException
    >
  );
}
export declare class InvalidAutomationExecutionParametersException extends __BaseException {
  readonly name: "InvalidAutomationExecutionParametersException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidAutomationExecutionParametersException,
      __BaseException
    >
  );
}
export interface StartAutomationExecutionRequest {
  DocumentName: string | undefined;
  DocumentVersion?: string;
  Parameters?: Record<string, string[]>;
  ClientToken?: string;
  Mode?: ExecutionMode | string;
  TargetParameterName?: string;
  Targets?: Target[];
  TargetMaps?: Record<string, string[]>[];
  MaxConcurrency?: string;
  MaxErrors?: string;
  TargetLocations?: TargetLocation[];
  Tags?: Tag[];
  AlarmConfiguration?: AlarmConfiguration;
}
export interface StartAutomationExecutionResult {
  AutomationExecutionId?: string;
}
export declare class AutomationDefinitionNotApprovedException extends __BaseException {
  readonly name: "AutomationDefinitionNotApprovedException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AutomationDefinitionNotApprovedException,
      __BaseException
    >
  );
}
export interface StartChangeRequestExecutionRequest {
  ScheduledTime?: Date;
  DocumentName: string | undefined;
  DocumentVersion?: string;
  Parameters?: Record<string, string[]>;
  ChangeRequestName?: string;
  ClientToken?: string;
  AutoApprove?: boolean;
  Runbooks: Runbook[] | undefined;
  Tags?: Tag[];
  ScheduledEndTime?: Date;
  ChangeDetails?: string;
}
export interface StartChangeRequestExecutionResult {
  AutomationExecutionId?: string;
}
export interface StartSessionRequest {
  Target: string | undefined;
  DocumentName?: string;
  Reason?: string;
  Parameters?: Record<string, string[]>;
}
export interface StartSessionResponse {
  SessionId?: string;
  TokenValue?: string;
  StreamUrl?: string;
}
export declare class TargetNotConnected extends __BaseException {
  readonly name: "TargetNotConnected";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<TargetNotConnected, __BaseException>);
}
export declare class InvalidAutomationStatusUpdateException extends __BaseException {
  readonly name: "InvalidAutomationStatusUpdateException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidAutomationStatusUpdateException,
      __BaseException
    >
  );
}
export declare const StopType: {
  readonly CANCEL: "Cancel";
  readonly COMPLETE: "Complete";
};
export type StopType = (typeof StopType)[keyof typeof StopType];
export interface StopAutomationExecutionRequest {
  AutomationExecutionId: string | undefined;
  Type?: StopType | string;
}
export interface StopAutomationExecutionResult {}
export interface TerminateSessionRequest {
  SessionId: string | undefined;
}
export interface TerminateSessionResponse {
  SessionId?: string;
}
export interface UnlabelParameterVersionRequest {
  Name: string | undefined;
  ParameterVersion: number | undefined;
  Labels: string[] | undefined;
}
export interface UnlabelParameterVersionResult {
  RemovedLabels?: string[];
  InvalidLabels?: string[];
}
export declare class AssociationVersionLimitExceeded extends __BaseException {
  readonly name: "AssociationVersionLimitExceeded";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AssociationVersionLimitExceeded,
      __BaseException
    >
  );
}
export declare const BaselineOverrideFilterSensitiveLog: (
  obj: BaselineOverride
) => any;
export declare const GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog: (
  obj: GetDeployablePatchSnapshotForInstanceRequest
) => any;
export declare const GetMaintenanceWindowResultFilterSensitiveLog: (
  obj: GetMaintenanceWindowResult
) => any;
export declare const GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog: (
  obj: GetMaintenanceWindowExecutionTaskResult
) => any;
export declare const GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog: (
  obj: GetMaintenanceWindowExecutionTaskInvocationResult
) => any;
export declare const MaintenanceWindowLambdaParametersFilterSensitiveLog: (
  obj: MaintenanceWindowLambdaParameters
) => any;
export declare const MaintenanceWindowRunCommandParametersFilterSensitiveLog: (
  obj: MaintenanceWindowRunCommandParameters
) => any;
export declare const MaintenanceWindowStepFunctionsParametersFilterSensitiveLog: (
  obj: MaintenanceWindowStepFunctionsParameters
) => any;
export declare const MaintenanceWindowTaskInvocationParametersFilterSensitiveLog: (
  obj: MaintenanceWindowTaskInvocationParameters
) => any;
export declare const GetMaintenanceWindowTaskResultFilterSensitiveLog: (
  obj: GetMaintenanceWindowTaskResult
) => any;
export declare const ParameterFilterSensitiveLog: (obj: Parameter) => any;
export declare const GetParameterResultFilterSensitiveLog: (
  obj: GetParameterResult
) => any;
export declare const ParameterHistoryFilterSensitiveLog: (
  obj: ParameterHistory
) => any;
export declare const GetParameterHistoryResultFilterSensitiveLog: (
  obj: GetParameterHistoryResult
) => any;
export declare const GetParametersResultFilterSensitiveLog: (
  obj: GetParametersResult
) => any;
export declare const GetParametersByPathResultFilterSensitiveLog: (
  obj: GetParametersByPathResult
) => any;
export declare const GetPatchBaselineResultFilterSensitiveLog: (
  obj: GetPatchBaselineResult
) => any;
export declare const AssociationVersionInfoFilterSensitiveLog: (
  obj: AssociationVersionInfo
) => any;
export declare const ListAssociationVersionsResultFilterSensitiveLog: (
  obj: ListAssociationVersionsResult
) => any;
export declare const CommandFilterSensitiveLog: (obj: Command) => any;
export declare const ListCommandsResultFilterSensitiveLog: (
  obj: ListCommandsResult
) => any;
export declare const PutParameterRequestFilterSensitiveLog: (
  obj: PutParameterRequest
) => any;
export declare const RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog: (
  obj: RegisterTargetWithMaintenanceWindowRequest
) => any;
export declare const RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog: (
  obj: RegisterTaskWithMaintenanceWindowRequest
) => any;
export declare const SendCommandRequestFilterSensitiveLog: (
  obj: SendCommandRequest
) => any;
export declare const SendCommandResultFilterSensitiveLog: (
  obj: SendCommandResult
) => any;
